/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xalan.internal.xsltc.compiler;

import com.sun.org.apache.bcel.internal.generic.ANEWARRAY;
import com.sun.org.apache.bcel.internal.generic.BasicType;
import com.sun.org.apache.bcel.internal.generic.CHECKCAST;
import com.sun.org.apache.bcel.internal.generic.ConstantPoolGen;
import com.sun.org.apache.bcel.internal.generic.DUP_X1;
import com.sun.org.apache.bcel.internal.generic.GETFIELD;
import com.sun.org.apache.bcel.internal.generic.ICONST;
import com.sun.org.apache.bcel.internal.generic.INVOKEINTERFACE;
import com.sun.org.apache.bcel.internal.generic.INVOKESPECIAL;
import com.sun.org.apache.bcel.internal.generic.INVOKEVIRTUAL;
import com.sun.org.apache.bcel.internal.generic.InstructionList;
import com.sun.org.apache.bcel.internal.generic.NEW;
import com.sun.org.apache.bcel.internal.generic.NEWARRAY;
import com.sun.org.apache.bcel.internal.generic.PUSH;
import com.sun.org.apache.xalan.internal.xsltc.compiler.AbsolutePathPattern;
import com.sun.org.apache.xalan.internal.xsltc.compiler.ApplyTemplates;
import com.sun.org.apache.xalan.internal.xsltc.compiler.CallTemplate;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Choose;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Constants;
import com.sun.org.apache.xalan.internal.xsltc.compiler.If;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Number;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Otherwise;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Param;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Parser;
import com.sun.org.apache.xalan.internal.xsltc.compiler.QName;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Stylesheet;
import com.sun.org.apache.xalan.internal.xsltc.compiler.SymbolTable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Template;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Text;
import com.sun.org.apache.xalan.internal.xsltc.compiler.ValueOf;
import com.sun.org.apache.xalan.internal.xsltc.compiler.Variable;
import com.sun.org.apache.xalan.internal.xsltc.compiler.VariableBase;
import com.sun.org.apache.xalan.internal.xsltc.compiler.When;
import com.sun.org.apache.xalan.internal.xsltc.compiler.XSLTC;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ClassGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.ErrorMsg;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.MethodGenerator;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Type;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.TypeCheckError;
import com.sun.org.apache.xalan.internal.xsltc.compiler.util.Util;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.AttributesImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SyntaxTreeNode
implements Constants {
    private Parser _parser;
    protected SyntaxTreeNode _parent;
    private Stylesheet _stylesheet;
    private Template _template;
    private final List<SyntaxTreeNode> _contents = new ArrayList<SyntaxTreeNode>(2);
    protected QName _qname;
    private int _line;
    protected AttributesImpl _attributes = null;
    private Map<String, String> _prefixMapping = null;
    protected static final SyntaxTreeNode Dummy = new AbsolutePathPattern(null);
    protected static final int IndentIncrement = 4;
    private static final char[] _spaces = "                                                       ".toCharArray();

    public SyntaxTreeNode() {
        this._line = 0;
        this._qname = null;
    }

    public SyntaxTreeNode(int line) {
        this._line = line;
        this._qname = null;
    }

    public SyntaxTreeNode(String uri, String prefix, String local) {
        this._line = 0;
        this.setQName(uri, prefix, local);
    }

    protected final void setLineNumber(int line) {
        this._line = line;
    }

    public final int getLineNumber() {
        if (this._line > 0) {
            return this._line;
        }
        SyntaxTreeNode parent = this.getParent();
        return parent != null ? parent.getLineNumber() : 0;
    }

    protected void setQName(QName qname) {
        this._qname = qname;
    }

    protected void setQName(String uri, String prefix, String localname) {
        this._qname = new QName(uri, prefix, localname);
    }

    protected QName getQName() {
        return this._qname;
    }

    protected void setAttributes(AttributesImpl attributes) {
        this._attributes = attributes;
    }

    protected String getAttribute(String qname) {
        if (this._attributes == null) {
            return "";
        }
        String value = this._attributes.getValue(qname);
        return value == null || value.equals("") ? "" : value;
    }

    protected String getAttribute(String prefix, String localName) {
        return this.getAttribute(prefix + ':' + localName);
    }

    protected boolean hasAttribute(String qname) {
        return this._attributes != null && this._attributes.getValue(qname) != null;
    }

    protected void addAttribute(String qname, String value) {
        int index = this._attributes.getIndex(qname);
        if (index != -1) {
            this._attributes.setAttribute(index, "", Util.getLocalName(qname), qname, "CDATA", value);
        } else {
            this._attributes.addAttribute("", Util.getLocalName(qname), qname, "CDATA", value);
        }
    }

    protected Attributes getAttributes() {
        return this._attributes;
    }

    protected void setPrefixMapping(Map<String, String> mapping) {
        this._prefixMapping = mapping;
    }

    protected Map<String, String> getPrefixMapping() {
        return this._prefixMapping;
    }

    protected void addPrefixMapping(String prefix, String uri) {
        if (this._prefixMapping == null) {
            this._prefixMapping = new HashMap<String, String>();
        }
        this._prefixMapping.put(prefix, uri);
    }

    protected String lookupNamespace(String prefix) {
        String uri = null;
        if (this._prefixMapping != null) {
            uri = this._prefixMapping.get(prefix);
        }
        if (uri == null && this._parent != null) {
            uri = this._parent.lookupNamespace(prefix);
            if (prefix == "" && uri == null) {
                uri = "";
            }
        }
        return uri;
    }

    protected String lookupPrefix(String uri) {
        String prefix = null;
        if (this._prefixMapping != null && this._prefixMapping.containsValue(uri)) {
            for (Map.Entry<String, String> entry : this._prefixMapping.entrySet()) {
                prefix = entry.getKey();
                String mapsTo = entry.getValue();
                if (!mapsTo.equals(uri)) continue;
                return prefix;
            }
        } else if (this._parent != null) {
            prefix = this._parent.lookupPrefix(uri);
            if (uri == "" && prefix == null) {
                prefix = "";
            }
        }
        return prefix;
    }

    protected void setParser(Parser parser) {
        this._parser = parser;
    }

    public final Parser getParser() {
        return this._parser;
    }

    protected void setParent(SyntaxTreeNode parent) {
        if (this._parent == null) {
            this._parent = parent;
        }
    }

    protected final SyntaxTreeNode getParent() {
        return this._parent;
    }

    protected final boolean isDummy() {
        return this == Dummy;
    }

    protected int getImportPrecedence() {
        Stylesheet stylesheet = this.getStylesheet();
        if (stylesheet == null) {
            return Integer.MIN_VALUE;
        }
        return stylesheet.getImportPrecedence();
    }

    public Stylesheet getStylesheet() {
        if (this._stylesheet == null) {
            SyntaxTreeNode parent;
            for (parent = this; parent != null; parent = parent.getParent()) {
                if (!(parent instanceof Stylesheet)) continue;
                return (Stylesheet)parent;
            }
            this._stylesheet = (Stylesheet)parent;
        }
        return this._stylesheet;
    }

    protected Template getTemplate() {
        if (this._template == null) {
            SyntaxTreeNode parent;
            for (parent = this; parent != null && !(parent instanceof Template); parent = parent.getParent()) {
            }
            this._template = (Template)parent;
        }
        return this._template;
    }

    protected final XSLTC getXSLTC() {
        return this._parser.getXSLTC();
    }

    protected final SymbolTable getSymbolTable() {
        return this._parser == null ? null : this._parser.getSymbolTable();
    }

    public void parseContents(Parser parser) {
        this.parseChildren(parser);
    }

    protected final void parseChildren(Parser parser) {
        ArrayList<QName> locals = null;
        for (SyntaxTreeNode child : this._contents) {
            parser.getSymbolTable().setCurrentNode(child);
            child.parseContents(parser);
            QName varOrParamName = this.updateScope(parser, child);
            if (varOrParamName == null) continue;
            if (locals == null) {
                locals = new ArrayList<QName>(2);
            }
            locals.add(varOrParamName);
        }
        parser.getSymbolTable().setCurrentNode(this);
        if (locals != null) {
            for (QName varOrParamName : locals) {
                parser.removeVariable(varOrParamName);
            }
        }
    }

    protected QName updateScope(Parser parser, SyntaxTreeNode node) {
        if (node instanceof Variable) {
            Variable var = (Variable)node;
            parser.addVariable(var);
            return var.getName();
        }
        if (node instanceof Param) {
            Param param = (Param)node;
            parser.addParameter(param);
            return param.getName();
        }
        return null;
    }

    public abstract Type typeCheck(SymbolTable var1) throws TypeCheckError;

    protected Type typeCheckContents(SymbolTable stable) throws TypeCheckError {
        for (SyntaxTreeNode item : this._contents) {
            item.typeCheck(stable);
        }
        return Type.Void;
    }

    public abstract void translate(ClassGenerator var1, MethodGenerator var2);

    protected void translateContents(ClassGenerator classGen, MethodGenerator methodGen) {
        int n = this.elementCount();
        for (SyntaxTreeNode item : this._contents) {
            item.translate(classGen, methodGen);
        }
        for (int i = 0; i < n; ++i) {
            if (!(this._contents.get(i) instanceof VariableBase)) continue;
            VariableBase var = (VariableBase)this._contents.get(i);
            var.unmapRegister(methodGen);
        }
    }

    private boolean isSimpleRTF(SyntaxTreeNode node) {
        List<SyntaxTreeNode> contents = node.getContents();
        for (SyntaxTreeNode item : contents) {
            if (this.isTextElement(item, false)) continue;
            return false;
        }
        return true;
    }

    private boolean isAdaptiveRTF(SyntaxTreeNode node) {
        List<SyntaxTreeNode> contents = node.getContents();
        for (SyntaxTreeNode item : contents) {
            if (this.isTextElement(item, true)) continue;
            return false;
        }
        return true;
    }

    private boolean isTextElement(SyntaxTreeNode node, boolean doExtendedCheck) {
        if (node instanceof ValueOf || node instanceof Number || node instanceof Text) {
            return true;
        }
        if (node instanceof If) {
            return doExtendedCheck ? this.isAdaptiveRTF(node) : this.isSimpleRTF(node);
        }
        if (node instanceof Choose) {
            List<SyntaxTreeNode> contents = node.getContents();
            for (SyntaxTreeNode item : contents) {
                if (item instanceof Text || (item instanceof When || item instanceof Otherwise) && (doExtendedCheck && this.isAdaptiveRTF(item) || !doExtendedCheck && this.isSimpleRTF(item))) continue;
                return false;
            }
            return true;
        }
        return doExtendedCheck && (node instanceof CallTemplate || node instanceof ApplyTemplates);
    }

    protected void compileResultTree(ClassGenerator classGen, MethodGenerator methodGen) {
        ConstantPoolGen cpg = classGen.getConstantPool();
        InstructionList il = methodGen.getInstructionList();
        Stylesheet stylesheet = classGen.getStylesheet();
        boolean isSimple = this.isSimpleRTF(this);
        boolean isAdaptive = false;
        if (!isSimple) {
            isAdaptive = this.isAdaptiveRTF(this);
        }
        int rtfType = isSimple ? 0 : (isAdaptive ? 1 : 2);
        il.append(methodGen.loadHandler());
        String DOM_CLASS = classGen.getDOMClass();
        il.append(methodGen.loadDOM());
        int index = cpg.addInterfaceMethodref("com.sun.org.apache.xalan.internal.xsltc.DOM", "getResultTreeFrag", "(IIZ)Lcom/sun/org/apache/xalan/internal/xsltc/DOM;");
        il.append(new PUSH(cpg, 32));
        il.append(new PUSH(cpg, rtfType));
        il.append(new PUSH(cpg, stylesheet.callsNodeset()));
        il.append(new INVOKEINTERFACE(index, 4));
        il.append(DUP);
        index = cpg.addInterfaceMethodref("com.sun.org.apache.xalan.internal.xsltc.DOM", "getOutputDomBuilder", "()Lcom/sun/org/apache/xml/internal/serializer/SerializationHandler;");
        il.append(new INVOKEINTERFACE(index, 1));
        il.append(DUP);
        il.append(methodGen.storeHandler());
        il.append(methodGen.startDocument());
        this.translateContents(classGen, methodGen);
        il.append(methodGen.loadHandler());
        il.append(methodGen.endDocument());
        if (stylesheet.callsNodeset() && !DOM_CLASS.equals("com/sun/org/apache/xalan/internal/xsltc/DOM")) {
            index = cpg.addMethodref("com/sun/org/apache/xalan/internal/xsltc/dom/DOMAdapter", "<init>", "(Lcom/sun/org/apache/xalan/internal/xsltc/DOM;[Ljava/lang/String;[Ljava/lang/String;[I[Ljava/lang/String;)V");
            il.append(new NEW(cpg.addClass("com/sun/org/apache/xalan/internal/xsltc/dom/DOMAdapter")));
            il.append(new DUP_X1());
            il.append(SWAP);
            if (!stylesheet.callsNodeset()) {
                il.append(new ICONST(0));
                il.append(new ANEWARRAY(cpg.addClass("java.lang.String")));
                il.append(DUP);
                il.append(DUP);
                il.append(new ICONST(0));
                il.append(new NEWARRAY(BasicType.INT));
                il.append(SWAP);
                il.append(new INVOKESPECIAL(index));
            } else {
                il.append(ALOAD_0);
                il.append(new GETFIELD(cpg.addFieldref("com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet", "namesArray", "[Ljava/lang/String;")));
                il.append(ALOAD_0);
                il.append(new GETFIELD(cpg.addFieldref("com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet", "urisArray", "[Ljava/lang/String;")));
                il.append(ALOAD_0);
                il.append(new GETFIELD(cpg.addFieldref("com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet", "typesArray", "[I")));
                il.append(ALOAD_0);
                il.append(new GETFIELD(cpg.addFieldref("com.sun.org.apache.xalan.internal.xsltc.runtime.AbstractTranslet", "namespaceArray", "[Ljava/lang/String;")));
                il.append(new INVOKESPECIAL(index));
                il.append(DUP);
                il.append(methodGen.loadDOM());
                il.append(new CHECKCAST(cpg.addClass(classGen.getDOMClass())));
                il.append(SWAP);
                index = cpg.addMethodref("com.sun.org.apache.xalan.internal.xsltc.dom.MultiDOM", "addDOMAdapter", "(Lcom/sun/org/apache/xalan/internal/xsltc/dom/DOMAdapter;)I");
                il.append(new INVOKEVIRTUAL(index));
                il.append(POP);
            }
        }
        il.append(SWAP);
        il.append(methodGen.storeHandler());
    }

    protected boolean contextDependent() {
        return true;
    }

    protected boolean dependentContents() {
        for (SyntaxTreeNode item : this._contents) {
            if (!item.contextDependent()) continue;
            return true;
        }
        return false;
    }

    protected final void addElement(SyntaxTreeNode element) {
        this._contents.add(element);
        element.setParent(this);
    }

    protected final void setFirstElement(SyntaxTreeNode element) {
        this._contents.add(0, element);
        element.setParent(this);
    }

    protected final void removeElement(SyntaxTreeNode element) {
        this._contents.remove(element);
        element.setParent(null);
    }

    protected final List<SyntaxTreeNode> getContents() {
        return this._contents;
    }

    protected final boolean hasContents() {
        return this.elementCount() > 0;
    }

    protected final int elementCount() {
        return this._contents.size();
    }

    protected final Iterator<SyntaxTreeNode> elements() {
        return this._contents.iterator();
    }

    protected final Object elementAt(int pos) {
        return this._contents.get(pos);
    }

    protected final SyntaxTreeNode lastChild() {
        if (this._contents.isEmpty()) {
            return null;
        }
        return this._contents.get(this._contents.size() - 1);
    }

    public void display(int indent) {
        this.displayContents(indent);
    }

    protected void displayContents(int indent) {
        for (SyntaxTreeNode item : this._contents) {
            item.display(indent);
        }
    }

    protected final void indent(int indent) {
        System.out.print(new String(_spaces, 0, indent));
    }

    protected void reportError(SyntaxTreeNode element, Parser parser, String errorCode, String message) {
        ErrorMsg error = new ErrorMsg(errorCode, (Object)message, element);
        parser.reportError(3, error);
    }

    protected void reportWarning(SyntaxTreeNode element, Parser parser, String errorCode, String message) {
        ErrorMsg error = new ErrorMsg(errorCode, (Object)message, element);
        parser.reportError(4, error);
    }
}

