/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils;

import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.List;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class IdResolver {
    private static Logger log = Logger.getLogger(IdResolver.class.getName());
    private static WeakHashMap docMap = new WeakHashMap();
    private static List names;
    private static int namesLength;

    private IdResolver() {
    }

    public static void registerElementById(Element element, String string) {
        Document document = element.getOwnerDocument();
        WeakHashMap<String, WeakReference<Element>> weakHashMap = (WeakHashMap<String, WeakReference<Element>>)docMap.get(document);
        if (weakHashMap == null) {
            weakHashMap = new WeakHashMap<String, WeakReference<Element>>();
            docMap.put(document, weakHashMap);
        }
        weakHashMap.put(string, new WeakReference<Element>(element));
    }

    public static void registerElementById(Element element, Attr attr) {
        IdResolver.registerElementById(element, attr.getNodeValue());
    }

    public static Element getElementById(Document document, String string) {
        Element element = IdResolver.getElementByIdType(document, string);
        if (element != null) {
            log.log(Level.FINE, "I could find an Element using the simple getElementByIdType method: " + element.getTagName());
            return element;
        }
        element = IdResolver.getElementByIdUsingDOM(document, string);
        if (element != null) {
            log.log(Level.FINE, "I could find an Element using the simple getElementByIdUsingDOM method: " + element.getTagName());
            return element;
        }
        element = IdResolver.getElementBySearching(document, string);
        if (element != null) {
            IdResolver.registerElementById(element, string);
            return element;
        }
        return null;
    }

    private static Element getElementByIdUsingDOM(Document document, String string) {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "getElementByIdUsingDOM() Search for ID " + string);
        }
        return document.getElementById(string);
    }

    private static Element getElementByIdType(Document document, String string) {
        WeakReference weakReference;
        WeakHashMap weakHashMap;
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "getElementByIdType() Search for ID " + string);
        }
        if ((weakHashMap = (WeakHashMap)docMap.get(document)) != null && (weakReference = (WeakReference)weakHashMap.get(string)) != null) {
            return (Element)weakReference.get();
        }
        return null;
    }

    private static Element getElementBySearching(Node node, String string) {
        Element[] elementArray = new Element[namesLength + 1];
        IdResolver.getEl(node, string, elementArray);
        for (int i = 0; i < elementArray.length; ++i) {
            if (elementArray[i] == null) continue;
            return elementArray[i];
        }
        return null;
    }

    private static int getEl(Node node, String string, Element[] elementArray) {
        Node node2 = null;
        Node node3 = null;
        while (true) {
            switch (node.getNodeType()) {
                case 9: 
                case 11: {
                    node2 = node.getFirstChild();
                    break;
                }
                case 1: {
                    Element element = (Element)node;
                    if (IdResolver.isElement(element, string, elementArray) == 1) {
                        return 1;
                    }
                    node2 = node.getFirstChild();
                    if (node2 == null) {
                        if (node3 == null) break;
                        node2 = node.getNextSibling();
                        break;
                    }
                    node3 = element;
                }
            }
            while (node2 == null && node3 != null) {
                node2 = node3.getNextSibling();
                if ((node3 = node3.getParentNode()) == null || node3.getNodeType() == 1) continue;
                node3 = null;
            }
            if (node2 == null) {
                return 1;
            }
            node = node2;
            node2 = node.getNextSibling();
        }
    }

    public static int isElement(Element element, String string, Element[] elementArray) {
        if (!element.hasAttributes()) {
            return 0;
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        int n = names.indexOf(element.getNamespaceURI());
        n = n < 0 ? namesLength : n;
        int n2 = namedNodeMap.getLength();
        for (int i = 0; i < n2; ++i) {
            Attr attr = (Attr)namedNodeMap.item(i);
            String string2 = attr.getNamespaceURI();
            int n3 = string2 == null ? n : names.indexOf(attr.getNamespaceURI());
            n3 = n3 < 0 ? namesLength : n3;
            String string3 = attr.getLocalName();
            if (string3.length() > 2) continue;
            String string4 = attr.getNodeValue();
            if (string3.charAt(0) == 'I') {
                char c = string3.charAt(1);
                if (c == 'd' && string4.equals(string)) {
                    elementArray[n3] = element;
                    if (n3 != 0) continue;
                    return 1;
                }
                if (c != 'D' || !string4.endsWith(string)) continue;
                if (n3 != 3) {
                    n3 = namesLength;
                }
                elementArray[n3] = element;
                continue;
            }
            if (!"id".equals(string3) || !string4.equals(string)) continue;
            if (n3 != 2) {
                n3 = namesLength;
            }
            elementArray[n3] = element;
        }
        if (n == 3 && (element.getAttribute("OriginalRequestID").equals(string) || element.getAttribute("RequestID").equals(string) || element.getAttribute("ResponseID").equals(string))) {
            elementArray[3] = element;
        } else if (n == 4 && element.getAttribute("AssertionID").equals(string)) {
            elementArray[4] = element;
        } else if (n == 5 && (element.getAttribute("RequestID").equals(string) || element.getAttribute("ResponseID").equals(string))) {
            elementArray[5] = element;
        }
        return 0;
    }

    static {
        String[] stringArray = new String[]{"http://www.w3.org/2000/09/xmldsig#", "http://www.w3.org/2001/04/xmlenc#", "http://schemas.xmlsoap.org/soap/security/2000-12", "http://www.w3.org/2002/03/xkms#", "urn:oasis:names:tc:SAML:1.0:assertion", "urn:oasis:names:tc:SAML:1.0:protocol"};
        names = Arrays.asList(stringArray);
        namesLength = names.size();
    }
}

