/*
 * Decompiled with CFR 0.152.
 */
package com.sun.org.apache.xml.internal.security.utils.resolver;

import com.sun.org.apache.xml.internal.security.signature.XMLSignatureInput;
import com.sun.org.apache.xml.internal.security.utils.JavaUtils;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverException;
import com.sun.org.apache.xml.internal.security.utils.resolver.ResourceResolverSpi;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverDirectHTTP;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverFragment;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverLocalFilesystem;
import com.sun.org.apache.xml.internal.security.utils.resolver.implementations.ResolverXPointer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Attr;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceResolver {
    private static Logger log = Logger.getLogger(ResourceResolver.class.getName());
    private static List<ResourceResolver> resolverList = new ArrayList<ResourceResolver>();
    private final ResourceResolverSpi resolverSpi;

    public ResourceResolver(ResourceResolverSpi resourceResolverSpi) {
        this.resolverSpi = resourceResolverSpi;
    }

    public static final ResourceResolver getInstance(Attr attr, String string) throws ResourceResolverException {
        return ResourceResolver.getInstance(attr, string, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final ResourceResolver getInstance(Attr attr, String string, boolean bl) throws ResourceResolverException {
        Object[] objectArray = resolverList;
        synchronized (resolverList) {
            Iterator<ResourceResolver> iterator = resolverList.iterator();
            while (iterator.hasNext()) {
                ResourceResolver resourceResolver;
                ResourceResolver resourceResolver2 = resourceResolver = iterator.next();
                if (!resourceResolver.resolverSpi.engineIsThreadSafe()) {
                    try {
                        resourceResolver2 = new ResourceResolver((ResourceResolverSpi)resourceResolver.resolverSpi.getClass().newInstance());
                    }
                    catch (InstantiationException instantiationException) {
                        throw new ResourceResolverException("", instantiationException, attr, string);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        throw new ResourceResolverException("", illegalAccessException, attr, string);
                    }
                }
                if (log.isLoggable(Level.FINE)) {
                    log.log(Level.FINE, "check resolvability by class " + resourceResolver2.getClass().getName());
                }
                resourceResolver2.resolverSpi.secureValidation = bl;
                if (resourceResolver2 == null || !resourceResolver2.canResolve(attr, string)) continue;
                if (bl && (resourceResolver2.resolverSpi instanceof ResolverLocalFilesystem || resourceResolver2.resolverSpi instanceof ResolverDirectHTTP)) {
                    Object[] objectArray2 = new Object[]{resourceResolver2.resolverSpi.getClass().getName()};
                    throw new ResourceResolverException("signature.Reference.ForbiddenResolver", objectArray2, attr, string);
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return resourceResolver2;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            objectArray = new Object[]{attr != null ? attr.getNodeValue() : "null", string};
            throw new ResourceResolverException("utils.resolver.noClass", objectArray, attr, string);
        }
    }

    public static ResourceResolver getInstance(Attr attr, String string, List<ResourceResolver> list) throws ResourceResolverException {
        return ResourceResolver.getInstance(attr, string, list, false);
    }

    public static ResourceResolver getInstance(Attr attr, String string, List<ResourceResolver> list, boolean bl) throws ResourceResolverException {
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "I was asked to create a ResourceResolver and got " + (list == null ? 0 : list.size()));
        }
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                ResourceResolver resourceResolver = list.get(i);
                if (resourceResolver == null) continue;
                if (log.isLoggable(Level.FINE)) {
                    String string2 = resourceResolver.resolverSpi.getClass().getName();
                    log.log(Level.FINE, "check resolvability by class " + string2);
                }
                resourceResolver.resolverSpi.secureValidation = bl;
                if (!resourceResolver.canResolve(attr, string)) continue;
                return resourceResolver;
            }
        }
        return ResourceResolver.getInstance(attr, string, bl);
    }

    public static void register(String string) {
        JavaUtils.checkRegisterPermission();
        try {
            Class<?> clazz = Class.forName(string);
            ResourceResolver.register(clazz, false);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.log(Level.WARNING, "Error loading resolver " + string + " disabling it");
        }
    }

    public static void registerAtStart(String string) {
        JavaUtils.checkRegisterPermission();
        try {
            Class<?> clazz = Class.forName(string);
            ResourceResolver.register(clazz, true);
        }
        catch (ClassNotFoundException classNotFoundException) {
            log.log(Level.WARNING, "Error loading resolver " + string + " disabling it");
        }
    }

    public static void register(Class<? extends ResourceResolverSpi> clazz, boolean bl) {
        JavaUtils.checkRegisterPermission();
        try {
            ResourceResolverSpi resourceResolverSpi = clazz.newInstance();
            ResourceResolver.register(resourceResolverSpi, bl);
        }
        catch (IllegalAccessException illegalAccessException) {
            log.log(Level.WARNING, "Error loading resolver " + clazz + " disabling it");
        }
        catch (InstantiationException instantiationException) {
            log.log(Level.WARNING, "Error loading resolver " + clazz + " disabling it");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void register(ResourceResolverSpi resourceResolverSpi, boolean bl) {
        JavaUtils.checkRegisterPermission();
        List<ResourceResolver> list = resolverList;
        synchronized (list) {
            if (bl) {
                resolverList.add(0, new ResourceResolver(resourceResolverSpi));
            } else {
                resolverList.add(new ResourceResolver(resourceResolverSpi));
            }
        }
        if (log.isLoggable(Level.FINE)) {
            log.log(Level.FINE, "Registered resolver: " + resourceResolverSpi.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDefaultResolvers() {
        List<ResourceResolver> list = resolverList;
        synchronized (list) {
            resolverList.add(new ResourceResolver(new ResolverFragment()));
            resolverList.add(new ResourceResolver(new ResolverLocalFilesystem()));
            resolverList.add(new ResourceResolver(new ResolverXPointer()));
            resolverList.add(new ResourceResolver(new ResolverDirectHTTP()));
        }
    }

    public XMLSignatureInput resolve(Attr attr, String string) throws ResourceResolverException {
        return this.resolverSpi.engineResolve(attr, string);
    }

    public void setProperty(String string, String string2) {
        this.resolverSpi.engineSetProperty(string, string2);
    }

    public String getProperty(String string) {
        return this.resolverSpi.engineGetProperty(string);
    }

    public void addProperties(Map<String, String> map) {
        this.resolverSpi.engineAddProperies(map);
    }

    public String[] getPropertyKeys() {
        return this.resolverSpi.engineGetPropertyKeys();
    }

    public boolean understandsProperty(String string) {
        return this.resolverSpi.understandsProperty(string);
    }

    private boolean canResolve(Attr attr, String string) {
        return this.resolverSpi.engineCanResolve(attr, string);
    }
}

