/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.digest;

import com.sun.security.sasl.digest.SecurityCtx;
import com.sun.security.sasl.util.AbstractSaslImpl;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.KeySpec;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.Mac;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DigestMD5Base
extends AbstractSaslImpl {
    private static final String DI_CLASS_NAME = DigestIntegrity.class.getName();
    private static final String DP_CLASS_NAME = DigestPrivacy.class.getName();
    protected static final int MAX_CHALLENGE_LENGTH = 2048;
    protected static final int MAX_RESPONSE_LENGTH = 4096;
    protected static final int DEFAULT_MAXBUF = 65536;
    protected static final int DES3 = 0;
    protected static final int RC4 = 1;
    protected static final int DES = 2;
    protected static final int RC4_56 = 3;
    protected static final int RC4_40 = 4;
    protected static final String[] CIPHER_TOKENS = new String[]{"3des", "rc4", "des", "rc4-56", "rc4-40"};
    private static final String[] JCE_CIPHER_NAME = new String[]{"DESede/CBC/NoPadding", "RC4", "DES/CBC/NoPadding"};
    protected static final byte DES_3_STRENGTH = 4;
    protected static final byte RC4_STRENGTH = 4;
    protected static final byte DES_STRENGTH = 2;
    protected static final byte RC4_56_STRENGTH = 2;
    protected static final byte RC4_40_STRENGTH = 1;
    protected static final byte UNSET = 0;
    protected static final byte[] CIPHER_MASKS = new byte[]{4, 4, 2, 2, 1};
    private static final String SECURITY_LAYER_MARKER = ":00000000000000000000000000000000";
    protected static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    protected int step;
    protected CallbackHandler cbh;
    protected SecurityCtx secCtx;
    protected byte[] H_A1;
    protected byte[] nonce;
    protected String negotiatedStrength;
    protected String negotiatedCipher;
    protected String negotiatedQop;
    protected String negotiatedRealm;
    protected boolean useUTF8 = false;
    protected String encoding = "8859_1";
    protected String digestUri;
    protected String authzid;
    private static final char[] pem_array = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static final int RAW_NONCE_SIZE = 30;
    private static final int ENCODED_NONCE_SIZE = 40;
    private static final byte[] PARITY_BIT_MASK = new byte[]{-128, 64, 32, 16, 8, 4, 2};
    private static final BigInteger MASK = new BigInteger("7f", 16);

    protected DigestMD5Base(Map<String, ?> map, String string, int n, String string2, CallbackHandler callbackHandler) throws SaslException {
        super(map, string);
        this.step = n;
        this.digestUri = string2;
        this.cbh = callbackHandler;
    }

    public String getMechanismName() {
        return "DIGEST-MD5";
    }

    public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
        if (!this.completed) {
            throw new IllegalStateException("DIGEST-MD5 authentication not completed");
        }
        if (this.secCtx == null) {
            throw new IllegalStateException("Neither integrity nor privacy was negotiated");
        }
        return this.secCtx.unwrap(byArray, n, n2);
    }

    public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
        if (!this.completed) {
            throw new IllegalStateException("DIGEST-MD5 authentication not completed");
        }
        if (this.secCtx == null) {
            throw new IllegalStateException("Neither integrity nor privacy was negotiated");
        }
        return this.secCtx.wrap(byArray, n, n2);
    }

    public void dispose() throws SaslException {
        if (this.secCtx != null) {
            this.secCtx = null;
        }
    }

    @Override
    public Object getNegotiatedProperty(String string) {
        if (this.completed) {
            if (string.equals("javax.security.sasl.strength")) {
                return this.negotiatedStrength;
            }
            return super.getNegotiatedProperty(string);
        }
        throw new IllegalStateException("DIGEST-MD5 authentication not completed");
    }

    protected static final byte[] generateNonce() {
        Random random = new Random();
        byte[] byArray = new byte[30];
        random.nextBytes(byArray);
        byte[] byArray2 = new byte[40];
        int n = 0;
        for (int i = 0; i < byArray.length; i += 3) {
            byte by = byArray[i];
            byte by2 = byArray[i + 1];
            byte by3 = byArray[i + 2];
            byArray2[n++] = (byte)pem_array[by >>> 2 & 0x3F];
            byArray2[n++] = (byte)pem_array[(by << 4 & 0x30) + (by2 >>> 4 & 0xF)];
            byArray2[n++] = (byte)pem_array[(by2 << 2 & 0x3C) + (by3 >>> 6 & 3)];
            byArray2[n++] = (byte)pem_array[by3 & 0x3F];
        }
        return byArray2;
    }

    protected static void writeQuotedStringValue(ByteArrayOutputStream byteArrayOutputStream, byte[] byArray) {
        for (byte by : byArray) {
            if (DigestMD5Base.needEscape((char)by)) {
                byteArrayOutputStream.write(92);
            }
            byteArrayOutputStream.write(by);
        }
    }

    private static boolean needEscape(String string) {
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (!DigestMD5Base.needEscape(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean needEscape(char c) {
        return c == '\"' || c == '\\' || c == '\u007f' || c >= '\u0000' && c <= '\u001f' && c != '\r' && c != '\t' && c != '\n';
    }

    protected static String quotedStringValue(String string) {
        if (DigestMD5Base.needEscape(string)) {
            int n = string.length();
            char[] cArray = new char[n + n];
            int n2 = 0;
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (DigestMD5Base.needEscape(c)) {
                    cArray[n2++] = 92;
                }
                cArray[n2++] = c;
            }
            return new String(cArray, 0, n2);
        }
        return string;
    }

    protected byte[] binaryToHex(byte[] byArray) throws UnsupportedEncodingException {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < byArray.length; ++i) {
            if ((byArray[i] & 0xFF) < 16) {
                stringBuffer.append("0" + Integer.toHexString(byArray[i] & 0xFF));
                continue;
            }
            stringBuffer.append(Integer.toHexString(byArray[i] & 0xFF));
        }
        return stringBuffer.toString().getBytes(this.encoding);
    }

    protected byte[] stringToByte_8859_1(String string) throws SaslException {
        char[] cArray = string.toCharArray();
        try {
            if (this.useUTF8) {
                for (int i = 0; i < cArray.length; ++i) {
                    if (cArray[i] <= '\u00ff') continue;
                    return string.getBytes("UTF8");
                }
            }
            return string.getBytes("8859_1");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new SaslException("cannot encode string in UTF8 or 8859-1 (Latin-1)", unsupportedEncodingException);
        }
    }

    protected static byte[] getPlatformCiphers() {
        byte[] byArray = new byte[CIPHER_TOKENS.length];
        for (int i = 0; i < JCE_CIPHER_NAME.length; ++i) {
            try {
                Cipher.getInstance(JCE_CIPHER_NAME[i]);
                logger.log(Level.FINE, "DIGEST01:Platform supports {0}", JCE_CIPHER_NAME[i]);
                int n = i;
                byArray[n] = (byte)(byArray[n] | CIPHER_MASKS[i]);
                continue;
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                continue;
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
        }
        if (byArray[1] != 0) {
            byArray[3] = (byte)(byArray[3] | CIPHER_MASKS[3]);
            byArray[4] = (byte)(byArray[4] | CIPHER_MASKS[4]);
        }
        return byArray;
    }

    protected byte[] generateResponseValue(String string, String string2, String string3, String string4, String string5, char[] cArray, byte[] byArray, byte[] byArray2, int n, byte[] byArray3) throws NoSuchAlgorithmException, UnsupportedEncodingException, IOException {
        MessageDigest messageDigest = MessageDigest.getInstance("MD5");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write((string + ":" + string2).getBytes(this.encoding));
        if (string3.equals("auth-conf") || string3.equals("auth-int")) {
            logger.log(Level.FINE, "DIGEST04:QOP: {0}", string3);
            byteArrayOutputStream.write(SECURITY_LAYER_MARKER.getBytes(this.encoding));
        }
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DIGEST05:A2: {0}", byteArrayOutputStream.toString());
        }
        messageDigest.update(byteArrayOutputStream.toByteArray());
        byte[] byArray4 = messageDigest.digest();
        byte[] byArray5 = this.binaryToHex(byArray4);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DIGEST06:HEX(H(A2)): {0}", new String(byArray5));
        }
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream();
        byteArrayOutputStream2.write(this.stringToByte_8859_1(string4));
        byteArrayOutputStream2.write(58);
        byteArrayOutputStream2.write(this.stringToByte_8859_1(string5));
        byteArrayOutputStream2.write(58);
        byteArrayOutputStream2.write(this.stringToByte_8859_1(new String(cArray)));
        messageDigest.update(byteArrayOutputStream2.toByteArray());
        byArray4 = messageDigest.digest();
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DIGEST07:H({0}) = {1}", new Object[]{byteArrayOutputStream2.toString(), new String(this.binaryToHex(byArray4))});
        }
        ByteArrayOutputStream byteArrayOutputStream3 = new ByteArrayOutputStream();
        byteArrayOutputStream3.write(byArray4);
        byteArrayOutputStream3.write(58);
        byteArrayOutputStream3.write(byArray);
        byteArrayOutputStream3.write(58);
        byteArrayOutputStream3.write(byArray2);
        if (byArray3 != null) {
            byteArrayOutputStream3.write(58);
            byteArrayOutputStream3.write(byArray3);
        }
        messageDigest.update(byteArrayOutputStream3.toByteArray());
        byArray4 = messageDigest.digest();
        this.H_A1 = byArray4;
        byte[] byArray6 = this.binaryToHex(byArray4);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DIGEST08:H(A1) = {0}", new String(byArray6));
        }
        ByteArrayOutputStream byteArrayOutputStream4 = new ByteArrayOutputStream();
        byteArrayOutputStream4.write(byArray6);
        byteArrayOutputStream4.write(58);
        byteArrayOutputStream4.write(byArray);
        byteArrayOutputStream4.write(58);
        byteArrayOutputStream4.write(DigestMD5Base.nonceCountToHex(n).getBytes(this.encoding));
        byteArrayOutputStream4.write(58);
        byteArrayOutputStream4.write(byArray2);
        byteArrayOutputStream4.write(58);
        byteArrayOutputStream4.write(string3.getBytes(this.encoding));
        byteArrayOutputStream4.write(58);
        byteArrayOutputStream4.write(byArray5);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DIGEST09:KD: {0}", byteArrayOutputStream4.toString());
        }
        messageDigest.update(byteArrayOutputStream4.toByteArray());
        byArray4 = messageDigest.digest();
        byte[] byArray7 = this.binaryToHex(byArray4);
        if (logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, "DIGEST10:response-value: {0}", new String(byArray7));
        }
        return byArray7;
    }

    protected static String nonceCountToHex(int n) {
        String string = Integer.toHexString(n);
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() < 8) {
            for (int i = 0; i < 8 - string.length(); ++i) {
                stringBuffer.append("0");
            }
        }
        return stringBuffer.toString() + string;
    }

    protected static byte[][] parseDirectives(byte[] byArray, String[] stringArray, List<byte[]> list, int n) throws SaslException {
        byte[][] byArrayArray = new byte[stringArray.length][];
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(10);
        ByteArrayOutputStream byteArrayOutputStream2 = new ByteArrayOutputStream(10);
        boolean bl = true;
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = DigestMD5Base.skipLws(byArray, 0);
        while (n2 < byArray.length) {
            byte by = byArray[n2];
            if (bl) {
                if (by == 44) {
                    if (byteArrayOutputStream.size() != 0) {
                        throw new SaslException("Directive key contains a ',':" + byteArrayOutputStream);
                    }
                    n2 = DigestMD5Base.skipLws(byArray, n2 + 1);
                    continue;
                }
                if (by == 61) {
                    if (byteArrayOutputStream.size() == 0) {
                        throw new SaslException("Empty directive key");
                    }
                    bl = false;
                    if ((n2 = DigestMD5Base.skipLws(byArray, n2 + 1)) < byArray.length) {
                        if (byArray[n2] != 34) continue;
                        bl2 = true;
                        ++n2;
                        continue;
                    }
                    throw new SaslException("Valueless directive found: " + byteArrayOutputStream.toString());
                }
                if (DigestMD5Base.isLws(by)) {
                    if ((n2 = DigestMD5Base.skipLws(byArray, n2 + 1)) < byArray.length) {
                        if (byArray[n2] == 61) continue;
                        throw new SaslException("'=' expected after key: " + byteArrayOutputStream.toString());
                    }
                    throw new SaslException("'=' expected after key: " + byteArrayOutputStream.toString());
                }
                byteArrayOutputStream.write(by);
                ++n2;
                continue;
            }
            if (bl2) {
                if (by == 92) {
                    if (++n2 < byArray.length) {
                        byteArrayOutputStream2.write(byArray[n2]);
                        ++n2;
                        continue;
                    }
                    throw new SaslException("Unmatched quote found for directive: " + byteArrayOutputStream.toString() + " with value: " + byteArrayOutputStream2.toString());
                }
                if (by == 34) {
                    ++n2;
                    bl2 = false;
                    bl3 = true;
                    continue;
                }
                byteArrayOutputStream2.write(by);
                ++n2;
                continue;
            }
            if (DigestMD5Base.isLws(by) || by == 44) {
                DigestMD5Base.extractDirective(byteArrayOutputStream.toString(), byteArrayOutputStream2.toByteArray(), stringArray, byArrayArray, list, n);
                byteArrayOutputStream.reset();
                byteArrayOutputStream2.reset();
                bl = true;
                bl3 = false;
                bl2 = false;
                n2 = DigestMD5Base.skipLws(byArray, n2 + 1);
                continue;
            }
            if (bl3) {
                throw new SaslException("Expecting comma or linear whitespace after quoted string: \"" + byteArrayOutputStream2.toString() + "\"");
            }
            byteArrayOutputStream2.write(by);
            ++n2;
        }
        if (bl2) {
            throw new SaslException("Unmatched quote found for directive: " + byteArrayOutputStream.toString() + " with value: " + byteArrayOutputStream2.toString());
        }
        if (byteArrayOutputStream.size() > 0) {
            DigestMD5Base.extractDirective(byteArrayOutputStream.toString(), byteArrayOutputStream2.toByteArray(), stringArray, byArrayArray, list, n);
        }
        return byArrayArray;
    }

    private static boolean isLws(byte by) {
        switch (by) {
            case 9: 
            case 10: 
            case 13: 
            case 32: {
                return true;
            }
        }
        return false;
    }

    private static int skipLws(byte[] byArray, int n) {
        int n2;
        for (n2 = n; n2 < byArray.length; ++n2) {
            if (DigestMD5Base.isLws(byArray[n2])) continue;
            return n2;
        }
        return n2;
    }

    private static void extractDirective(String string, byte[] byArray, String[] stringArray, byte[][] byArray2, List<byte[]> list, int n) throws SaslException {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!string.equalsIgnoreCase(stringArray[i])) continue;
            if (byArray2[i] == null) {
                byArray2[i] = byArray;
                if (!logger.isLoggable(Level.FINE)) break;
                logger.log(Level.FINE, "DIGEST11:Directive {0} = {1}", new Object[]{stringArray[i], new String(byArray2[i])});
                break;
            }
            if (list != null && i == n) {
                if (list.isEmpty()) {
                    list.add(byArray2[i]);
                }
                list.add(byArray);
                break;
            }
            throw new SaslException("DIGEST-MD5: peer sent more than one " + string + " directive: " + new String(byArray));
        }
    }

    private static void setParityBit(byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            int n = 0;
            for (int j = 0; j < PARITY_BIT_MASK.length; ++j) {
                if ((byArray[i] & PARITY_BIT_MASK[j]) != PARITY_BIT_MASK[j]) continue;
                ++n;
            }
            byArray[i] = n & true ? (byte)(byArray[i] & 0xFFFFFFFE) : (byte)(byArray[i] | 1);
        }
    }

    private static byte[] addDesParity(byte[] byArray, int n, int n2) {
        if (n2 != 7) {
            throw new IllegalArgumentException("Invalid length of DES Key Value:" + n2);
        }
        byte[] byArray2 = new byte[7];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        byte[] byArray3 = new byte[8];
        BigInteger bigInteger = new BigInteger(byArray2);
        int n3 = byArray3.length - 1;
        while (n3 >= 0) {
            byArray3[n3] = bigInteger.and(MASK).toByteArray()[0];
            int n4 = n3--;
            byArray3[n4] = (byte)(byArray3[n4] << 1);
            bigInteger = bigInteger.shiftRight(7);
        }
        DigestMD5Base.setParityBit(byArray3);
        return byArray3;
    }

    private static SecretKey makeDesKeys(byte[] byArray, String string) throws NoSuchAlgorithmException, InvalidKeyException, InvalidKeySpecException {
        byte[] byArray2 = DigestMD5Base.addDesParity(byArray, 0, 7);
        KeySpec keySpec = null;
        SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance(string);
        if ("des".equals(string)) {
            keySpec = new DESKeySpec(byArray2, 0);
            if (logger.isLoggable(Level.FINEST)) {
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "makeDesKeys", "DIGEST42:DES key input: ", byArray);
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "makeDesKeys", "DIGEST43:DES key parity-adjusted: ", byArray2);
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "makeDesKeys", "DIGEST44:DES key material: ", keySpec.getKey());
                logger.log(Level.FINEST, "DIGEST45: is parity-adjusted? {0}", DESKeySpec.isParityAdjusted(byArray2, 0));
            }
        } else if ("desede".equals(string)) {
            byte[] byArray3 = DigestMD5Base.addDesParity(byArray, 7, 7);
            byte[] byArray4 = new byte[byArray2.length * 2 + byArray3.length];
            System.arraycopy(byArray2, 0, byArray4, 0, byArray2.length);
            System.arraycopy(byArray3, 0, byArray4, byArray2.length, byArray3.length);
            System.arraycopy(byArray2, 0, byArray4, byArray2.length + byArray3.length, byArray2.length);
            keySpec = new DESedeKeySpec(byArray4, 0);
            if (logger.isLoggable(Level.FINEST)) {
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "makeDesKeys", "DIGEST46:3DES key input: ", byArray);
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "makeDesKeys", "DIGEST47:3DES key ede: ", byArray4);
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "makeDesKeys", "DIGEST48:3DES key material: ", ((DESedeKeySpec)keySpec).getKey());
                logger.log(Level.FINEST, "DIGEST49: is parity-adjusted? ", DESedeKeySpec.isParityAdjusted(byArray4, 0));
            }
        } else {
            throw new IllegalArgumentException("Invalid DES strength:" + string);
        }
        return secretKeyFactory.generateSecret(keySpec);
    }

    final class DigestPrivacy
    extends DigestIntegrity
    implements SecurityCtx {
        private static final String CLIENT_CONF_MAGIC = "Digest H(A1) to client-to-server sealing key magic constant";
        private static final String SVR_CONF_MAGIC = "Digest H(A1) to server-to-client sealing key magic constant";
        private Cipher encCipher;
        private Cipher decCipher;

        DigestPrivacy(boolean bl) throws SaslException {
            super(bl);
            try {
                this.generatePrivacyKeyPair(bl);
            }
            catch (SaslException saslException) {
                throw saslException;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SaslException("DIGEST-MD5: Error encoding string value into UTF-8", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new SaslException("DIGEST-MD5: Error accessing buffers required to generate cipher keys", iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SaslException("DIGEST-MD5: Error creating instance of required cipher or digest", noSuchAlgorithmException);
            }
        }

        private void generatePrivacyKeyPair(boolean bl) throws IOException, UnsupportedEncodingException, NoSuchAlgorithmException, SaslException {
            byte[] byArray;
            byte[] byArray2;
            byte[] byArray3 = CLIENT_CONF_MAGIC.getBytes(DigestMD5Base.this.encoding);
            byte[] byArray4 = SVR_CONF_MAGIC.getBytes(DigestMD5Base.this.encoding);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            int n = DigestMD5Base.this.negotiatedCipher.equals(CIPHER_TOKENS[4]) ? 5 : (DigestMD5Base.this.negotiatedCipher.equals(CIPHER_TOKENS[3]) ? 7 : 16);
            byte[] byArray5 = new byte[n + byArray3.length];
            System.arraycopy(DigestMD5Base.this.H_A1, 0, byArray5, 0, n);
            System.arraycopy(byArray3, 0, byArray5, n, byArray3.length);
            messageDigest.update(byArray5);
            byte[] byArray6 = messageDigest.digest();
            System.arraycopy(byArray4, 0, byArray5, n, byArray4.length);
            messageDigest.update(byArray5);
            byte[] byArray7 = messageDigest.digest();
            if (logger.isLoggable(Level.FINER)) {
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "generatePrivacyKeyPair", "DIGEST24:Kcc: ", byArray6);
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "generatePrivacyKeyPair", "DIGEST25:Kcs: ", byArray7);
            }
            if (bl) {
                byArray2 = byArray6;
                byArray = byArray7;
            } else {
                byArray2 = byArray7;
                byArray = byArray6;
            }
            try {
                if (DigestMD5Base.this.negotiatedCipher.indexOf(CIPHER_TOKENS[1]) > -1) {
                    this.encCipher = Cipher.getInstance("RC4");
                    this.decCipher = Cipher.getInstance("RC4");
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray2, "RC4");
                    SecretKeySpec secretKeySpec2 = new SecretKeySpec(byArray, "RC4");
                    this.encCipher.init(1, secretKeySpec);
                    this.decCipher.init(2, secretKeySpec2);
                } else if (DigestMD5Base.this.negotiatedCipher.equals(CIPHER_TOKENS[2]) || DigestMD5Base.this.negotiatedCipher.equals(CIPHER_TOKENS[0])) {
                    String string;
                    String string2;
                    if (DigestMD5Base.this.negotiatedCipher.equals(CIPHER_TOKENS[2])) {
                        string2 = "DES/CBC/NoPadding";
                        string = "des";
                    } else {
                        string2 = "DESede/CBC/NoPadding";
                        string = "desede";
                    }
                    this.encCipher = Cipher.getInstance(string2);
                    this.decCipher = Cipher.getInstance(string2);
                    SecretKey secretKey = DigestMD5Base.makeDesKeys(byArray2, string);
                    SecretKey secretKey2 = DigestMD5Base.makeDesKeys(byArray, string);
                    IvParameterSpec ivParameterSpec = new IvParameterSpec(byArray2, 8, 8);
                    IvParameterSpec ivParameterSpec2 = new IvParameterSpec(byArray, 8, 8);
                    this.encCipher.init(1, (Key)secretKey, ivParameterSpec);
                    this.decCipher.init(2, (Key)secretKey2, ivParameterSpec2);
                    if (logger.isLoggable(Level.FINER)) {
                        DigestMD5Base.traceOutput(DP_CLASS_NAME, "generatePrivacyKeyPair", "DIGEST26:" + DigestMD5Base.this.negotiatedCipher + " IVcc: ", ivParameterSpec.getIV());
                        DigestMD5Base.traceOutput(DP_CLASS_NAME, "generatePrivacyKeyPair", "DIGEST27:" + DigestMD5Base.this.negotiatedCipher + " IVcs: ", ivParameterSpec2.getIV());
                        DigestMD5Base.traceOutput(DP_CLASS_NAME, "generatePrivacyKeyPair", "DIGEST28:" + DigestMD5Base.this.negotiatedCipher + " encryption key: ", secretKey.getEncoded());
                        DigestMD5Base.traceOutput(DP_CLASS_NAME, "generatePrivacyKeyPair", "DIGEST29:" + DigestMD5Base.this.negotiatedCipher + " decryption key: ", secretKey2.getEncoded());
                    }
                }
            }
            catch (InvalidKeySpecException invalidKeySpecException) {
                throw new SaslException("DIGEST-MD5: Unsupported key specification used.", invalidKeySpecException);
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                throw new SaslException("DIGEST-MD5: Invalid cipher algorithem parameter used to create cipher instance", invalidAlgorithmParameterException);
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                throw new SaslException("DIGEST-MD5: Unsupported padding used for chosen cipher", noSuchPaddingException);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SaslException("DIGEST-MD5: Invalid data used to initialize keys", invalidKeyException);
            }
        }

        public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
            byte[] byArray2;
            byte[] byArray3;
            int n3;
            if (n2 == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            this.incrementSeqNum();
            byte[] byArray4 = this.getHMAC(this.myKi, this.sequenceNum, byArray, n, n2);
            if (logger.isLoggable(Level.FINEST)) {
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "wrap", "DIGEST30:Outgoing: ", byArray, n, n2);
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "wrap", "seqNum: ", this.sequenceNum);
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "wrap", "MAC: ", byArray4);
            }
            if ((n3 = this.encCipher.getBlockSize()) > 1) {
                int n4 = n3 - (n2 + 10) % n3;
                byArray3 = new byte[n4];
                for (int i = 0; i < n4; ++i) {
                    byArray3[i] = (byte)n4;
                }
            } else {
                byArray3 = EMPTY_BYTE_ARRAY;
            }
            byte[] byArray5 = new byte[n2 + byArray3.length + 10];
            System.arraycopy(byArray, n, byArray5, 0, n2);
            System.arraycopy(byArray3, 0, byArray5, n2, byArray3.length);
            System.arraycopy(byArray4, 0, byArray5, n2 + byArray3.length, 10);
            if (logger.isLoggable(Level.FINEST)) {
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "wrap", "DIGEST31:{msg, pad, KicMAC}: ", byArray5);
            }
            try {
                byArray2 = this.encCipher.update(byArray5);
                if (byArray2 == null) {
                    throw new IllegalBlockSizeException("" + byArray5.length);
                }
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new SaslException("DIGEST-MD5: Invalid block size for cipher", illegalBlockSizeException);
            }
            byte[] byArray6 = new byte[byArray2.length + 2 + 4];
            System.arraycopy(byArray2, 0, byArray6, 0, byArray2.length);
            System.arraycopy(this.messageType, 0, byArray6, byArray2.length, 2);
            System.arraycopy(this.sequenceNum, 0, byArray6, byArray2.length + 2, 4);
            if (logger.isLoggable(Level.FINEST)) {
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "wrap", "DIGEST32:Wrapped: ", byArray6);
            }
            return byArray6;
        }

        public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
            byte[] byArray2;
            if (n2 == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            byte[] byArray3 = new byte[n2 - 6];
            byte[] byArray4 = new byte[2];
            byte[] byArray5 = new byte[4];
            System.arraycopy(byArray, n, byArray3, 0, byArray3.length);
            System.arraycopy(byArray, n + byArray3.length, byArray4, 0, 2);
            System.arraycopy(byArray, n + byArray3.length + 2, byArray5, 0, 4);
            if (logger.isLoggable(Level.FINEST)) {
                logger.log(Level.FINEST, "DIGEST33:Expecting sequence num: {0}", new Integer(this.peerSeqNum));
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "unwrap", "DIGEST34:incoming: ", byArray3);
            }
            try {
                byArray2 = this.decCipher.update(byArray3);
                if (byArray2 == null) {
                    throw new IllegalBlockSizeException("" + byArray3.length);
                }
            }
            catch (IllegalBlockSizeException illegalBlockSizeException) {
                throw new SaslException("DIGEST-MD5: Illegal block sizes used with chosen cipher", illegalBlockSizeException);
            }
            byte[] byArray6 = new byte[byArray2.length - 10];
            byte[] byArray7 = new byte[10];
            System.arraycopy(byArray2, 0, byArray6, 0, byArray6.length);
            System.arraycopy(byArray2, byArray6.length, byArray7, 0, 10);
            if (logger.isLoggable(Level.FINEST)) {
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "unwrap", "DIGEST35:Unwrapped (w/padding): ", byArray6);
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "unwrap", "DIGEST36:MAC: ", byArray7);
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "unwrap", "DIGEST37:messageType: ", byArray4);
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "unwrap", "DIGEST38:sequenceNum: ", byArray5);
            }
            int n3 = byArray6.length;
            int n4 = this.decCipher.getBlockSize();
            if (n4 > 1 && (n3 -= byArray6[byArray6.length - 1]) < 0) {
                if (logger.isLoggable(Level.INFO)) {
                    logger.log(Level.INFO, "DIGEST39:Incorrect padding: {0}", new Byte(byArray6[byArray6.length - 1]));
                }
                return EMPTY_BYTE_ARRAY;
            }
            byte[] byArray8 = this.getHMAC(this.peerKi, byArray5, byArray6, 0, n3);
            if (logger.isLoggable(Level.FINEST)) {
                DigestMD5Base.traceOutput(DP_CLASS_NAME, "unwrap", "DIGEST40:KisMAC: ", byArray8);
            }
            if (!Arrays.equals(byArray7, byArray8)) {
                logger.log(Level.INFO, "DIGEST41:Unmatched MACs");
                return EMPTY_BYTE_ARRAY;
            }
            if (this.peerSeqNum != DigestMD5Base.networkByteOrderToInt(byArray5, 0, 4)) {
                throw new SaslException("DIGEST-MD5: Out of order sequencing of messages from server. Got: " + DigestMD5Base.networkByteOrderToInt(byArray5, 0, 4) + " Expected: " + this.peerSeqNum);
            }
            if (!Arrays.equals(this.messageType, byArray4)) {
                throw new SaslException("DIGEST-MD5: invalid message type: " + DigestMD5Base.networkByteOrderToInt(byArray4, 0, 2));
            }
            ++this.peerSeqNum;
            if (n3 == byArray6.length) {
                return byArray6;
            }
            byte[] byArray9 = new byte[n3];
            System.arraycopy(byArray6, 0, byArray9, 0, n3);
            return byArray9;
        }
    }

    class DigestIntegrity
    implements SecurityCtx {
        private static final String CLIENT_INT_MAGIC = "Digest session key to client-to-server signing key magic constant";
        private static final String SVR_INT_MAGIC = "Digest session key to server-to-client signing key magic constant";
        protected byte[] myKi;
        protected byte[] peerKi;
        protected int mySeqNum = 0;
        protected int peerSeqNum = 0;
        protected final byte[] messageType = new byte[2];
        protected final byte[] sequenceNum = new byte[4];

        DigestIntegrity(boolean bl) throws SaslException {
            try {
                this.generateIntegrityKeyPair(bl);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SaslException("DIGEST-MD5: Error encoding strings into UTF-8", unsupportedEncodingException);
            }
            catch (IOException iOException) {
                throw new SaslException("DIGEST-MD5: Error accessing buffers required to create integrity key pairs", iOException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SaslException("DIGEST-MD5: Unsupported digest algorithm used to create integrity key pairs", noSuchAlgorithmException);
            }
            DigestMD5Base.intToNetworkByteOrder(1, this.messageType, 0, 2);
        }

        private void generateIntegrityKeyPair(boolean bl) throws UnsupportedEncodingException, IOException, NoSuchAlgorithmException {
            byte[] byArray = CLIENT_INT_MAGIC.getBytes(DigestMD5Base.this.encoding);
            byte[] byArray2 = SVR_INT_MAGIC.getBytes(DigestMD5Base.this.encoding);
            MessageDigest messageDigest = MessageDigest.getInstance("MD5");
            byte[] byArray3 = new byte[DigestMD5Base.this.H_A1.length + byArray.length];
            System.arraycopy(DigestMD5Base.this.H_A1, 0, byArray3, 0, DigestMD5Base.this.H_A1.length);
            System.arraycopy(byArray, 0, byArray3, DigestMD5Base.this.H_A1.length, byArray.length);
            messageDigest.update(byArray3);
            byte[] byArray4 = messageDigest.digest();
            System.arraycopy(byArray2, 0, byArray3, DigestMD5Base.this.H_A1.length, byArray2.length);
            messageDigest.update(byArray3);
            byte[] byArray5 = messageDigest.digest();
            if (logger.isLoggable(Level.FINER)) {
                DigestMD5Base.traceOutput(DI_CLASS_NAME, "generateIntegrityKeyPair", "DIGEST12:Kic: ", byArray4);
                DigestMD5Base.traceOutput(DI_CLASS_NAME, "generateIntegrityKeyPair", "DIGEST13:Kis: ", byArray5);
            }
            if (bl) {
                this.myKi = byArray4;
                this.peerKi = byArray5;
            } else {
                this.myKi = byArray5;
                this.peerKi = byArray4;
            }
        }

        public byte[] wrap(byte[] byArray, int n, int n2) throws SaslException {
            if (n2 == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            byte[] byArray2 = new byte[n2 + 10 + 2 + 4];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            this.incrementSeqNum();
            byte[] byArray3 = this.getHMAC(this.myKi, this.sequenceNum, byArray, n, n2);
            if (logger.isLoggable(Level.FINEST)) {
                DigestMD5Base.traceOutput(DI_CLASS_NAME, "wrap", "DIGEST14:outgoing: ", byArray, n, n2);
                DigestMD5Base.traceOutput(DI_CLASS_NAME, "wrap", "DIGEST15:seqNum: ", this.sequenceNum);
                DigestMD5Base.traceOutput(DI_CLASS_NAME, "wrap", "DIGEST16:MAC: ", byArray3);
            }
            System.arraycopy(byArray3, 0, byArray2, n2, 10);
            System.arraycopy(this.messageType, 0, byArray2, n2 + 10, 2);
            System.arraycopy(this.sequenceNum, 0, byArray2, n2 + 12, 4);
            if (logger.isLoggable(Level.FINEST)) {
                DigestMD5Base.traceOutput(DI_CLASS_NAME, "wrap", "DIGEST17:wrapped: ", byArray2);
            }
            return byArray2;
        }

        public byte[] unwrap(byte[] byArray, int n, int n2) throws SaslException {
            if (n2 == 0) {
                return EMPTY_BYTE_ARRAY;
            }
            byte[] byArray2 = new byte[10];
            byte[] byArray3 = new byte[n2 - 16];
            byte[] byArray4 = new byte[2];
            byte[] byArray5 = new byte[4];
            System.arraycopy(byArray, n, byArray3, 0, byArray3.length);
            System.arraycopy(byArray, n + byArray3.length, byArray2, 0, 10);
            System.arraycopy(byArray, n + byArray3.length + 10, byArray4, 0, 2);
            System.arraycopy(byArray, n + byArray3.length + 12, byArray5, 0, 4);
            byte[] byArray6 = this.getHMAC(this.peerKi, byArray5, byArray3, 0, byArray3.length);
            if (logger.isLoggable(Level.FINEST)) {
                DigestMD5Base.traceOutput(DI_CLASS_NAME, "unwrap", "DIGEST18:incoming: ", byArray3);
                DigestMD5Base.traceOutput(DI_CLASS_NAME, "unwrap", "DIGEST19:MAC: ", byArray2);
                DigestMD5Base.traceOutput(DI_CLASS_NAME, "unwrap", "DIGEST20:messageType: ", byArray4);
                DigestMD5Base.traceOutput(DI_CLASS_NAME, "unwrap", "DIGEST21:sequenceNum: ", byArray5);
                DigestMD5Base.traceOutput(DI_CLASS_NAME, "unwrap", "DIGEST22:expectedMAC: ", byArray6);
            }
            if (!Arrays.equals(byArray2, byArray6)) {
                logger.log(Level.INFO, "DIGEST23:Unmatched MACs");
                return EMPTY_BYTE_ARRAY;
            }
            if (this.peerSeqNum != DigestMD5Base.networkByteOrderToInt(byArray5, 0, 4)) {
                throw new SaslException("DIGEST-MD5: Out of order sequencing of messages from server. Got: " + DigestMD5Base.networkByteOrderToInt(byArray5, 0, 4) + " Expected: " + this.peerSeqNum);
            }
            if (!Arrays.equals(this.messageType, byArray4)) {
                throw new SaslException("DIGEST-MD5: invalid message type: " + DigestMD5Base.networkByteOrderToInt(byArray4, 0, 2));
            }
            ++this.peerSeqNum;
            return byArray3;
        }

        protected byte[] getHMAC(byte[] byArray, byte[] byArray2, byte[] byArray3, int n, int n2) throws SaslException {
            byte[] byArray4 = new byte[4 + n2];
            System.arraycopy(byArray2, 0, byArray4, 0, 4);
            System.arraycopy(byArray3, n, byArray4, 4, n2);
            try {
                SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "HmacMD5");
                Mac mac = Mac.getInstance("HmacMD5");
                mac.init(secretKeySpec);
                mac.update(byArray4);
                byte[] byArray5 = mac.doFinal();
                byte[] byArray6 = new byte[10];
                System.arraycopy(byArray5, 0, byArray6, 0, 10);
                return byArray6;
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new SaslException("DIGEST-MD5: Invalid bytes used for key of HMAC-MD5 hash.", invalidKeyException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw new SaslException("DIGEST-MD5: Error creating instance of MD5 digest algorithm", noSuchAlgorithmException);
            }
        }

        protected void incrementSeqNum() {
            DigestMD5Base.intToNetworkByteOrder(this.mySeqNum++, this.sequenceNum, 0, 4);
        }
    }
}

