/*
 * Decompiled with CFR 0.152.
 */
package com.sun.security.sasl.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.sasl.SaslException;
import sun.misc.HexDumpEncoder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSaslImpl {
    protected boolean completed = false;
    protected boolean privacy = false;
    protected boolean integrity = false;
    protected byte[] qop;
    protected byte allQop;
    protected byte[] strength;
    protected int sendMaxBufSize = 0;
    protected int recvMaxBufSize = 65536;
    protected int rawSendSize;
    protected String myClassName;
    private static final String SASL_LOGGER_NAME = "javax.security.sasl";
    protected static final String MAX_SEND_BUF = "javax.security.sasl.sendmaxbuffer";
    protected static final Logger logger = Logger.getLogger("javax.security.sasl");
    protected static final byte NO_PROTECTION = 1;
    protected static final byte INTEGRITY_ONLY_PROTECTION = 2;
    protected static final byte PRIVACY_PROTECTION = 4;
    protected static final byte LOW_STRENGTH = 1;
    protected static final byte MEDIUM_STRENGTH = 2;
    protected static final byte HIGH_STRENGTH = 4;
    private static final byte[] DEFAULT_QOP = new byte[]{1};
    private static final String[] QOP_TOKENS = new String[]{"auth-conf", "auth-int", "auth"};
    private static final byte[] QOP_MASKS = new byte[]{4, 2, 1};
    private static final byte[] DEFAULT_STRENGTH = new byte[]{4, 2, 1};
    private static final String[] STRENGTH_TOKENS = new String[]{"low", "medium", "high"};
    private static final byte[] STRENGTH_MASKS = new byte[]{1, 2, 4};

    protected AbstractSaslImpl(Map<String, ?> map, String string) throws SaslException {
        this.myClassName = string;
        if (map != null) {
            int n;
            StringBuffer stringBuffer;
            String string2 = (String)map.get("javax.security.sasl.qop");
            this.qop = AbstractSaslImpl.parseQop(string2);
            logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL01:Preferred qop property: {0}", string2);
            this.allQop = AbstractSaslImpl.combineMasks(this.qop);
            if (logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL02:Preferred qop mask: {0}", new Byte(this.allQop));
                if (this.qop.length > 0) {
                    stringBuffer = new StringBuffer();
                    for (n = 0; n < this.qop.length; ++n) {
                        stringBuffer.append(Byte.toString(this.qop[n]));
                        stringBuffer.append(' ');
                    }
                    logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL03:Preferred qops : {0}", stringBuffer.toString());
                }
            }
            string2 = (String)map.get("javax.security.sasl.strength");
            this.strength = AbstractSaslImpl.parseStrength(string2);
            logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL04:Preferred strength property: {0}", string2);
            if (logger.isLoggable(Level.FINE) && this.strength.length > 0) {
                stringBuffer = new StringBuffer();
                for (n = 0; n < this.strength.length; ++n) {
                    stringBuffer.append(Byte.toString(this.strength[n]));
                    stringBuffer.append(' ');
                }
                logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL05:Cipher strengths: {0}", stringBuffer.toString());
            }
            if ((string2 = (String)map.get("javax.security.sasl.maxbuffer")) != null) {
                try {
                    logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL06:Max receive buffer size: {0}", string2);
                    this.recvMaxBufSize = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SaslException("Property must be string representation of integer: javax.security.sasl.maxbuffer");
                }
            }
            if ((string2 = (String)map.get(MAX_SEND_BUF)) != null) {
                try {
                    logger.logp(Level.FINE, this.myClassName, "constructor", "SASLIMPL07:Max send buffer size: {0}", string2);
                    this.sendMaxBufSize = Integer.parseInt(string2);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new SaslException("Property must be string representation of integer: javax.security.sasl.sendmaxbuffer");
                }
            }
        } else {
            this.qop = DEFAULT_QOP;
            this.allQop = 1;
            this.strength = STRENGTH_MASKS;
        }
    }

    public boolean isComplete() {
        return this.completed;
    }

    public Object getNegotiatedProperty(String string) {
        if (!this.completed) {
            throw new IllegalStateException("SASL authentication not completed");
        }
        if ("javax.security.sasl.qop".equals(string)) {
            if (this.privacy) {
                return "auth-conf";
            }
            if (this.integrity) {
                return "auth-int";
            }
            return "auth";
        }
        if ("javax.security.sasl.maxbuffer".equals(string)) {
            return Integer.toString(this.recvMaxBufSize);
        }
        if ("javax.security.sasl.rawsendsize".equals(string)) {
            return Integer.toString(this.rawSendSize);
        }
        if (MAX_SEND_BUF.equals(string)) {
            return Integer.toString(this.sendMaxBufSize);
        }
        return null;
    }

    protected static final byte combineMasks(byte[] byArray) {
        byte by = 0;
        for (int i = 0; i < byArray.length; ++i) {
            by = (byte)(by | byArray[i]);
        }
        return by;
    }

    protected static final byte findPreferredMask(byte by, byte[] byArray) {
        for (int i = 0; i < byArray.length; ++i) {
            if ((byArray[i] & by) == 0) continue;
            return byArray[i];
        }
        return 0;
    }

    private static final byte[] parseQop(String string) throws SaslException {
        return AbstractSaslImpl.parseQop(string, null, false);
    }

    protected static final byte[] parseQop(String string, String[] stringArray, boolean bl) throws SaslException {
        if (string == null) {
            return DEFAULT_QOP;
        }
        return AbstractSaslImpl.parseProp("javax.security.sasl.qop", string, QOP_TOKENS, QOP_MASKS, stringArray, bl);
    }

    private static final byte[] parseStrength(String string) throws SaslException {
        if (string == null) {
            return DEFAULT_STRENGTH;
        }
        return AbstractSaslImpl.parseProp("javax.security.sasl.strength", string, STRENGTH_TOKENS, STRENGTH_MASKS, null, false);
    }

    private static final byte[] parseProp(String string, String string2, String[] stringArray, byte[] byArray, String[] stringArray2, boolean bl) throws SaslException {
        int n;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ", \t\n");
        byte[] byArray2 = new byte[stringArray.length];
        int n2 = 0;
        while (stringTokenizer.hasMoreTokens() && n2 < byArray2.length) {
            String string3 = stringTokenizer.nextToken();
            boolean bl2 = false;
            for (n = 0; !bl2 && n < stringArray.length; ++n) {
                if (!string3.equalsIgnoreCase(stringArray[n])) continue;
                bl2 = true;
                byArray2[n2++] = byArray[n];
                if (stringArray2 == null) continue;
                stringArray2[n] = string3;
            }
            if (bl2 || bl) continue;
            throw new SaslException("Invalid token in " + string + ": " + string2);
        }
        for (n = n2; n < byArray2.length; ++n) {
            byArray2[n] = 0;
        }
        return byArray2;
    }

    protected static final void traceOutput(String string, String string2, String string3, byte[] byArray) {
        AbstractSaslImpl.traceOutput(string, string2, string3, byArray, 0, byArray.length);
    }

    protected static final void traceOutput(String string, String string2, String string3, byte[] byArray, int n, int n2) {
        try {
            Level level;
            int n3 = n2;
            if (!logger.isLoggable(Level.FINEST)) {
                n2 = Math.min(16, n2);
                level = Level.FINER;
            } else {
                level = Level.FINEST;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n2);
            new HexDumpEncoder().encodeBuffer(new ByteArrayInputStream(byArray, n, n2), (OutputStream)byteArrayOutputStream);
            logger.logp(level, string, string2, "{0} ( {1} ): {2}", new Object[]{string3, new Integer(n3), byteArrayOutputStream.toString()});
        }
        catch (Exception exception) {
            logger.logp(Level.WARNING, string, string2, "SASLIMPL09:Error generating trace output: {0}", exception);
        }
    }

    protected static final int networkByteOrderToInt(byte[] byArray, int n, int n2) {
        if (n2 > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            n3 <<= 8;
            n3 |= byArray[n + i] & 0xFF;
        }
        return n3;
    }

    protected static final void intToNetworkByteOrder(int n, byte[] byArray, int n2, int n3) {
        if (n3 > 4) {
            throw new IllegalArgumentException("Cannot handle more than 4 bytes");
        }
        for (int i = n3 - 1; i >= 0; --i) {
            byArray[n2 + i] = (byte)(n & 0xFF);
            n >>>= 8;
        }
    }
}

