/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.DataBuffer;
import sun.java2d.StateTrackable;

public final class DataBufferFloat
extends DataBuffer {
    float[][] bankdata;
    float[] data;

    public DataBufferFloat(int n) {
        super(StateTrackable.State.STABLE, 4, n);
        this.data = new float[n];
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(int n, int n2) {
        super(StateTrackable.State.STABLE, 4, n, n2);
        this.bankdata = new float[n2][];
        for (int i = 0; i < n2; ++i) {
            this.bankdata[i] = new float[n];
        }
        this.data = this.bankdata[0];
    }

    public DataBufferFloat(float[] fArray, int n) {
        super(StateTrackable.State.UNTRACKABLE, 4, n);
        this.data = fArray;
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(float[] fArray, int n, int n2) {
        super(StateTrackable.State.UNTRACKABLE, 4, n, 1, n2);
        this.data = fArray;
        this.bankdata = new float[1][];
        this.bankdata[0] = this.data;
    }

    public DataBufferFloat(float[][] fArray, int n) {
        super(StateTrackable.State.UNTRACKABLE, 4, n, fArray.length);
        this.bankdata = (float[][])fArray.clone();
        this.data = this.bankdata[0];
    }

    public DataBufferFloat(float[][] fArray, int n, int[] nArray) {
        super(StateTrackable.State.UNTRACKABLE, 4, n, fArray.length, nArray);
        this.bankdata = (float[][])fArray.clone();
        this.data = this.bankdata[0];
    }

    public float[] getData() {
        this.theTrackable.setUntrackable();
        return this.data;
    }

    public float[] getData(int n) {
        this.theTrackable.setUntrackable();
        return this.bankdata[n];
    }

    public float[][] getBankData() {
        this.theTrackable.setUntrackable();
        return (float[][])this.bankdata.clone();
    }

    public int getElem(int n) {
        return (int)this.data[n + this.offset];
    }

    public int getElem(int n, int n2) {
        return (int)this.bankdata[n][n2 + this.offsets[n]];
    }

    public void setElem(int n, int n2) {
        this.data[n + this.offset] = n2;
        this.theTrackable.markDirty();
    }

    public void setElem(int n, int n2, int n3) {
        this.bankdata[n][n2 + this.offsets[n]] = n3;
        this.theTrackable.markDirty();
    }

    public float getElemFloat(int n) {
        return this.data[n + this.offset];
    }

    public float getElemFloat(int n, int n2) {
        return this.bankdata[n][n2 + this.offsets[n]];
    }

    public void setElemFloat(int n, float f) {
        this.data[n + this.offset] = f;
        this.theTrackable.markDirty();
    }

    public void setElemFloat(int n, int n2, float f) {
        this.bankdata[n][n2 + this.offsets[n]] = f;
        this.theTrackable.markDirty();
    }

    public double getElemDouble(int n) {
        return this.data[n + this.offset];
    }

    public double getElemDouble(int n, int n2) {
        return this.bankdata[n][n2 + this.offsets[n]];
    }

    public void setElemDouble(int n, double d) {
        this.data[n + this.offset] = (float)d;
        this.theTrackable.markDirty();
    }

    public void setElemDouble(int n, int n2, double d) {
        this.bankdata[n][n2 + this.offsets[n]] = (float)d;
        this.theTrackable.markDirty();
    }
}

