/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.FilePermission;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;

final class FilePermissionCollection
extends PermissionCollection
implements Serializable {
    private transient List perms = new ArrayList();
    private static final long serialVersionUID = 2202956749081564585L;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("permissions", Vector.class)};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Permission permission) {
        if (!(permission instanceof FilePermission)) {
            throw new IllegalArgumentException("invalid permission: " + permission);
        }
        if (this.isReadOnly()) {
            throw new SecurityException("attempt to add a Permission to a readonly PermissionCollection");
        }
        FilePermissionCollection filePermissionCollection = this;
        synchronized (filePermissionCollection) {
            this.perms.add(permission);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean implies(Permission permission) {
        if (!(permission instanceof FilePermission)) {
            return false;
        }
        FilePermission filePermission = (FilePermission)permission;
        int n = filePermission.getMask();
        int n2 = 0;
        int n3 = n;
        FilePermissionCollection filePermissionCollection = this;
        synchronized (filePermissionCollection) {
            int n4 = this.perms.size();
            for (int i = 0; i < n4; ++i) {
                FilePermission filePermission2 = (FilePermission)this.perms.get(i);
                if ((n3 & filePermission2.getMask()) == 0 || !filePermission2.impliesIgnoreMask(filePermission)) continue;
                if (((n2 |= filePermission2.getMask()) & n) == n) {
                    return true;
                }
                n3 = n ^ n2;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Enumeration elements() {
        FilePermissionCollection filePermissionCollection = this;
        synchronized (filePermissionCollection) {
            return Collections.enumeration(this.perms);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        Vector vector = new Vector(this.perms.size());
        Object object = this;
        synchronized (object) {
            vector.addAll(this.perms);
        }
        object = objectOutputStream.putFields();
        ((ObjectOutputStream.PutField)object).put("permissions", vector);
        objectOutputStream.writeFields();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField getField = objectInputStream.readFields();
        Vector vector = (Vector)getField.get("permissions", null);
        this.perms = new ArrayList(vector.size());
        for (Object e : vector) {
            this.perms.add((Permission)e);
        }
    }
}

