/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import sun.misc.Unsafe;
import sun.misc.VM;
import sun.security.action.GetPropertyAction;

class Bits {
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final ByteOrder byteOrder;
    private static int pageSize;
    private static boolean unaligned;
    private static boolean unalignedKnown;
    private static volatile long maxMemory;
    private static volatile long reservedMemory;
    private static boolean memoryLimitSet;
    static final int JNI_COPY_TO_ARRAY_THRESHOLD = 6;
    static final int JNI_COPY_FROM_ARRAY_THRESHOLD = 6;
    static final long UNSAFE_COPY_THRESHOLD = 0x100000L;

    private Bits() {
    }

    static short swap(short s) {
        return (short)(s << 8 | (char)s >>> 8);
    }

    static char swap(char c) {
        return (char)(c << 8 | c >>> 8);
    }

    static int swap(int n) {
        return n << 24 | (n & 0xFF00) << 8 | (n & 0xFF0000) >>> 8 | n >>> 24;
    }

    static long swap(long l) {
        return (long)Bits.swap((int)l) << 32 | (long)Bits.swap((int)(l >>> 32)) & 0xFFFFFFFFL;
    }

    private static char makeChar(byte by, byte by2) {
        return (char)(by << 8 | by2 & 0xFF);
    }

    static char getCharL(ByteBuffer byteBuffer, int n) {
        return Bits.makeChar(byteBuffer._get(n + 1), byteBuffer._get(n + 0));
    }

    static char getCharL(long l) {
        return Bits.makeChar(Bits._get(l + 1L), Bits._get(l + 0L));
    }

    static char getCharB(ByteBuffer byteBuffer, int n) {
        return Bits.makeChar(byteBuffer._get(n + 0), byteBuffer._get(n + 1));
    }

    static char getCharB(long l) {
        return Bits.makeChar(Bits._get(l + 0L), Bits._get(l + 1L));
    }

    static char getChar(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getCharB(byteBuffer, n) : Bits.getCharL(byteBuffer, n);
    }

    static char getChar(long l, boolean bl) {
        return bl ? Bits.getCharB(l) : Bits.getCharL(l);
    }

    private static byte char1(char c) {
        return (byte)(c >> 8);
    }

    private static byte char0(char c) {
        return (byte)(c >> 0);
    }

    static void putCharL(ByteBuffer byteBuffer, int n, char c) {
        byteBuffer._put(n + 0, Bits.char0(c));
        byteBuffer._put(n + 1, Bits.char1(c));
    }

    static void putCharL(long l, char c) {
        Bits._put(l + 0L, Bits.char0(c));
        Bits._put(l + 1L, Bits.char1(c));
    }

    static void putCharB(ByteBuffer byteBuffer, int n, char c) {
        byteBuffer._put(n + 0, Bits.char1(c));
        byteBuffer._put(n + 1, Bits.char0(c));
    }

    static void putCharB(long l, char c) {
        Bits._put(l + 0L, Bits.char1(c));
        Bits._put(l + 1L, Bits.char0(c));
    }

    static void putChar(ByteBuffer byteBuffer, int n, char c, boolean bl) {
        if (bl) {
            Bits.putCharB(byteBuffer, n, c);
        } else {
            Bits.putCharL(byteBuffer, n, c);
        }
    }

    static void putChar(long l, char c, boolean bl) {
        if (bl) {
            Bits.putCharB(l, c);
        } else {
            Bits.putCharL(l, c);
        }
    }

    private static short makeShort(byte by, byte by2) {
        return (short)(by << 8 | by2 & 0xFF);
    }

    static short getShortL(ByteBuffer byteBuffer, int n) {
        return Bits.makeShort(byteBuffer._get(n + 1), byteBuffer._get(n + 0));
    }

    static short getShortL(long l) {
        return Bits.makeShort(Bits._get(l + 1L), Bits._get(l));
    }

    static short getShortB(ByteBuffer byteBuffer, int n) {
        return Bits.makeShort(byteBuffer._get(n + 0), byteBuffer._get(n + 1));
    }

    static short getShortB(long l) {
        return Bits.makeShort(Bits._get(l), Bits._get(l + 1L));
    }

    static short getShort(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getShortB(byteBuffer, n) : Bits.getShortL(byteBuffer, n);
    }

    static short getShort(long l, boolean bl) {
        return bl ? Bits.getShortB(l) : Bits.getShortL(l);
    }

    private static byte short1(short s) {
        return (byte)(s >> 8);
    }

    private static byte short0(short s) {
        return (byte)(s >> 0);
    }

    static void putShortL(ByteBuffer byteBuffer, int n, short s) {
        byteBuffer._put(n + 0, Bits.short0(s));
        byteBuffer._put(n + 1, Bits.short1(s));
    }

    static void putShortL(long l, short s) {
        Bits._put(l, Bits.short0(s));
        Bits._put(l + 1L, Bits.short1(s));
    }

    static void putShortB(ByteBuffer byteBuffer, int n, short s) {
        byteBuffer._put(n + 0, Bits.short1(s));
        byteBuffer._put(n + 1, Bits.short0(s));
    }

    static void putShortB(long l, short s) {
        Bits._put(l, Bits.short1(s));
        Bits._put(l + 1L, Bits.short0(s));
    }

    static void putShort(ByteBuffer byteBuffer, int n, short s, boolean bl) {
        if (bl) {
            Bits.putShortB(byteBuffer, n, s);
        } else {
            Bits.putShortL(byteBuffer, n, s);
        }
    }

    static void putShort(long l, short s, boolean bl) {
        if (bl) {
            Bits.putShortB(l, s);
        } else {
            Bits.putShortL(l, s);
        }
    }

    private static int makeInt(byte by, byte by2, byte by3, byte by4) {
        return (by & 0xFF) << 24 | (by2 & 0xFF) << 16 | (by3 & 0xFF) << 8 | (by4 & 0xFF) << 0;
    }

    static int getIntL(ByteBuffer byteBuffer, int n) {
        return Bits.makeInt(byteBuffer._get(n + 3), byteBuffer._get(n + 2), byteBuffer._get(n + 1), byteBuffer._get(n + 0));
    }

    static int getIntL(long l) {
        return Bits.makeInt(Bits._get(l + 3L), Bits._get(l + 2L), Bits._get(l + 1L), Bits._get(l + 0L));
    }

    static int getIntB(ByteBuffer byteBuffer, int n) {
        return Bits.makeInt(byteBuffer._get(n + 0), byteBuffer._get(n + 1), byteBuffer._get(n + 2), byteBuffer._get(n + 3));
    }

    static int getIntB(long l) {
        return Bits.makeInt(Bits._get(l + 0L), Bits._get(l + 1L), Bits._get(l + 2L), Bits._get(l + 3L));
    }

    static int getInt(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getIntB(byteBuffer, n) : Bits.getIntL(byteBuffer, n);
    }

    static int getInt(long l, boolean bl) {
        return bl ? Bits.getIntB(l) : Bits.getIntL(l);
    }

    private static byte int3(int n) {
        return (byte)(n >> 24);
    }

    private static byte int2(int n) {
        return (byte)(n >> 16);
    }

    private static byte int1(int n) {
        return (byte)(n >> 8);
    }

    private static byte int0(int n) {
        return (byte)(n >> 0);
    }

    static void putIntL(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer._put(n + 3, Bits.int3(n2));
        byteBuffer._put(n + 2, Bits.int2(n2));
        byteBuffer._put(n + 1, Bits.int1(n2));
        byteBuffer._put(n + 0, Bits.int0(n2));
    }

    static void putIntL(long l, int n) {
        Bits._put(l + 3L, Bits.int3(n));
        Bits._put(l + 2L, Bits.int2(n));
        Bits._put(l + 1L, Bits.int1(n));
        Bits._put(l + 0L, Bits.int0(n));
    }

    static void putIntB(ByteBuffer byteBuffer, int n, int n2) {
        byteBuffer._put(n + 0, Bits.int3(n2));
        byteBuffer._put(n + 1, Bits.int2(n2));
        byteBuffer._put(n + 2, Bits.int1(n2));
        byteBuffer._put(n + 3, Bits.int0(n2));
    }

    static void putIntB(long l, int n) {
        Bits._put(l + 0L, Bits.int3(n));
        Bits._put(l + 1L, Bits.int2(n));
        Bits._put(l + 2L, Bits.int1(n));
        Bits._put(l + 3L, Bits.int0(n));
    }

    static void putInt(ByteBuffer byteBuffer, int n, int n2, boolean bl) {
        if (bl) {
            Bits.putIntB(byteBuffer, n, n2);
        } else {
            Bits.putIntL(byteBuffer, n, n2);
        }
    }

    static void putInt(long l, int n, boolean bl) {
        if (bl) {
            Bits.putIntB(l, n);
        } else {
            Bits.putIntL(l, n);
        }
    }

    private static long makeLong(byte by, byte by2, byte by3, byte by4, byte by5, byte by6, byte by7, byte by8) {
        return ((long)by & 0xFFL) << 56 | ((long)by2 & 0xFFL) << 48 | ((long)by3 & 0xFFL) << 40 | ((long)by4 & 0xFFL) << 32 | ((long)by5 & 0xFFL) << 24 | ((long)by6 & 0xFFL) << 16 | ((long)by7 & 0xFFL) << 8 | ((long)by8 & 0xFFL) << 0;
    }

    static long getLongL(ByteBuffer byteBuffer, int n) {
        return Bits.makeLong(byteBuffer._get(n + 7), byteBuffer._get(n + 6), byteBuffer._get(n + 5), byteBuffer._get(n + 4), byteBuffer._get(n + 3), byteBuffer._get(n + 2), byteBuffer._get(n + 1), byteBuffer._get(n + 0));
    }

    static long getLongL(long l) {
        return Bits.makeLong(Bits._get(l + 7L), Bits._get(l + 6L), Bits._get(l + 5L), Bits._get(l + 4L), Bits._get(l + 3L), Bits._get(l + 2L), Bits._get(l + 1L), Bits._get(l + 0L));
    }

    static long getLongB(ByteBuffer byteBuffer, int n) {
        return Bits.makeLong(byteBuffer._get(n + 0), byteBuffer._get(n + 1), byteBuffer._get(n + 2), byteBuffer._get(n + 3), byteBuffer._get(n + 4), byteBuffer._get(n + 5), byteBuffer._get(n + 6), byteBuffer._get(n + 7));
    }

    static long getLongB(long l) {
        return Bits.makeLong(Bits._get(l + 0L), Bits._get(l + 1L), Bits._get(l + 2L), Bits._get(l + 3L), Bits._get(l + 4L), Bits._get(l + 5L), Bits._get(l + 6L), Bits._get(l + 7L));
    }

    static long getLong(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getLongB(byteBuffer, n) : Bits.getLongL(byteBuffer, n);
    }

    static long getLong(long l, boolean bl) {
        return bl ? Bits.getLongB(l) : Bits.getLongL(l);
    }

    private static byte long7(long l) {
        return (byte)(l >> 56);
    }

    private static byte long6(long l) {
        return (byte)(l >> 48);
    }

    private static byte long5(long l) {
        return (byte)(l >> 40);
    }

    private static byte long4(long l) {
        return (byte)(l >> 32);
    }

    private static byte long3(long l) {
        return (byte)(l >> 24);
    }

    private static byte long2(long l) {
        return (byte)(l >> 16);
    }

    private static byte long1(long l) {
        return (byte)(l >> 8);
    }

    private static byte long0(long l) {
        return (byte)(l >> 0);
    }

    static void putLongL(ByteBuffer byteBuffer, int n, long l) {
        byteBuffer._put(n + 7, Bits.long7(l));
        byteBuffer._put(n + 6, Bits.long6(l));
        byteBuffer._put(n + 5, Bits.long5(l));
        byteBuffer._put(n + 4, Bits.long4(l));
        byteBuffer._put(n + 3, Bits.long3(l));
        byteBuffer._put(n + 2, Bits.long2(l));
        byteBuffer._put(n + 1, Bits.long1(l));
        byteBuffer._put(n + 0, Bits.long0(l));
    }

    static void putLongL(long l, long l2) {
        Bits._put(l + 7L, Bits.long7(l2));
        Bits._put(l + 6L, Bits.long6(l2));
        Bits._put(l + 5L, Bits.long5(l2));
        Bits._put(l + 4L, Bits.long4(l2));
        Bits._put(l + 3L, Bits.long3(l2));
        Bits._put(l + 2L, Bits.long2(l2));
        Bits._put(l + 1L, Bits.long1(l2));
        Bits._put(l + 0L, Bits.long0(l2));
    }

    static void putLongB(ByteBuffer byteBuffer, int n, long l) {
        byteBuffer._put(n + 0, Bits.long7(l));
        byteBuffer._put(n + 1, Bits.long6(l));
        byteBuffer._put(n + 2, Bits.long5(l));
        byteBuffer._put(n + 3, Bits.long4(l));
        byteBuffer._put(n + 4, Bits.long3(l));
        byteBuffer._put(n + 5, Bits.long2(l));
        byteBuffer._put(n + 6, Bits.long1(l));
        byteBuffer._put(n + 7, Bits.long0(l));
    }

    static void putLongB(long l, long l2) {
        Bits._put(l + 0L, Bits.long7(l2));
        Bits._put(l + 1L, Bits.long6(l2));
        Bits._put(l + 2L, Bits.long5(l2));
        Bits._put(l + 3L, Bits.long4(l2));
        Bits._put(l + 4L, Bits.long3(l2));
        Bits._put(l + 5L, Bits.long2(l2));
        Bits._put(l + 6L, Bits.long1(l2));
        Bits._put(l + 7L, Bits.long0(l2));
    }

    static void putLong(ByteBuffer byteBuffer, int n, long l, boolean bl) {
        if (bl) {
            Bits.putLongB(byteBuffer, n, l);
        } else {
            Bits.putLongL(byteBuffer, n, l);
        }
    }

    static void putLong(long l, long l2, boolean bl) {
        if (bl) {
            Bits.putLongB(l, l2);
        } else {
            Bits.putLongL(l, l2);
        }
    }

    static float getFloatL(ByteBuffer byteBuffer, int n) {
        return Float.intBitsToFloat(Bits.getIntL(byteBuffer, n));
    }

    static float getFloatL(long l) {
        return Float.intBitsToFloat(Bits.getIntL(l));
    }

    static float getFloatB(ByteBuffer byteBuffer, int n) {
        return Float.intBitsToFloat(Bits.getIntB(byteBuffer, n));
    }

    static float getFloatB(long l) {
        return Float.intBitsToFloat(Bits.getIntB(l));
    }

    static float getFloat(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getFloatB(byteBuffer, n) : Bits.getFloatL(byteBuffer, n);
    }

    static float getFloat(long l, boolean bl) {
        return bl ? Bits.getFloatB(l) : Bits.getFloatL(l);
    }

    static void putFloatL(ByteBuffer byteBuffer, int n, float f) {
        Bits.putIntL(byteBuffer, n, Float.floatToRawIntBits(f));
    }

    static void putFloatL(long l, float f) {
        Bits.putIntL(l, Float.floatToRawIntBits(f));
    }

    static void putFloatB(ByteBuffer byteBuffer, int n, float f) {
        Bits.putIntB(byteBuffer, n, Float.floatToRawIntBits(f));
    }

    static void putFloatB(long l, float f) {
        Bits.putIntB(l, Float.floatToRawIntBits(f));
    }

    static void putFloat(ByteBuffer byteBuffer, int n, float f, boolean bl) {
        if (bl) {
            Bits.putFloatB(byteBuffer, n, f);
        } else {
            Bits.putFloatL(byteBuffer, n, f);
        }
    }

    static void putFloat(long l, float f, boolean bl) {
        if (bl) {
            Bits.putFloatB(l, f);
        } else {
            Bits.putFloatL(l, f);
        }
    }

    static double getDoubleL(ByteBuffer byteBuffer, int n) {
        return Double.longBitsToDouble(Bits.getLongL(byteBuffer, n));
    }

    static double getDoubleL(long l) {
        return Double.longBitsToDouble(Bits.getLongL(l));
    }

    static double getDoubleB(ByteBuffer byteBuffer, int n) {
        return Double.longBitsToDouble(Bits.getLongB(byteBuffer, n));
    }

    static double getDoubleB(long l) {
        return Double.longBitsToDouble(Bits.getLongB(l));
    }

    static double getDouble(ByteBuffer byteBuffer, int n, boolean bl) {
        return bl ? Bits.getDoubleB(byteBuffer, n) : Bits.getDoubleL(byteBuffer, n);
    }

    static double getDouble(long l, boolean bl) {
        return bl ? Bits.getDoubleB(l) : Bits.getDoubleL(l);
    }

    static void putDoubleL(ByteBuffer byteBuffer, int n, double d) {
        Bits.putLongL(byteBuffer, n, Double.doubleToRawLongBits(d));
    }

    static void putDoubleL(long l, double d) {
        Bits.putLongL(l, Double.doubleToRawLongBits(d));
    }

    static void putDoubleB(ByteBuffer byteBuffer, int n, double d) {
        Bits.putLongB(byteBuffer, n, Double.doubleToRawLongBits(d));
    }

    static void putDoubleB(long l, double d) {
        Bits.putLongB(l, Double.doubleToRawLongBits(d));
    }

    static void putDouble(ByteBuffer byteBuffer, int n, double d, boolean bl) {
        if (bl) {
            Bits.putDoubleB(byteBuffer, n, d);
        } else {
            Bits.putDoubleL(byteBuffer, n, d);
        }
    }

    static void putDouble(long l, double d, boolean bl) {
        if (bl) {
            Bits.putDoubleB(l, d);
        } else {
            Bits.putDoubleL(l, d);
        }
    }

    private static byte _get(long l) {
        return unsafe.getByte(l);
    }

    private static void _put(long l, byte by) {
        unsafe.putByte(l, by);
    }

    static Unsafe unsafe() {
        return unsafe;
    }

    static ByteOrder byteOrder() {
        if (byteOrder == null) {
            throw new Error("Unknown byte order");
        }
        return byteOrder;
    }

    static int pageSize() {
        if (pageSize == -1) {
            pageSize = Bits.unsafe().pageSize();
        }
        return pageSize;
    }

    static boolean unaligned() {
        if (unalignedKnown) {
            return unaligned;
        }
        String string = AccessController.doPrivileged(new GetPropertyAction("os.arch"));
        unaligned = string.equals("i386") || string.equals("x86") || string.equals("amd64");
        unalignedKnown = true;
        return unaligned;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void reserveMemory(long l) {
        Class<Bits> clazz = Bits.class;
        synchronized (Bits.class) {
            if (!memoryLimitSet && VM.isBooted()) {
                maxMemory = VM.maxDirectMemory();
                memoryLimitSet = true;
            }
            if (l <= maxMemory - reservedMemory) {
                reservedMemory += l;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
            // ** MonitorExit[var2_1] (shouldn't be in output)
            System.gc();
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            clazz = Bits.class;
            synchronized (Bits.class) {
                if (reservedMemory + l > maxMemory) {
                    throw new OutOfMemoryError("Direct buffer memory");
                }
                reservedMemory += l;
                // ** MonitorExit[var2_1] (shouldn't be in output)
                return;
            }
        }
    }

    static synchronized void unreserveMemory(long l) {
        if (reservedMemory > 0L) assert ((reservedMemory -= l) > -1L);
    }

    static void copyFromArray(Object object, long l, long l2, long l3, long l4) {
        long l5 = l + l2;
        while (l4 > 0L) {
            long l6 = l4 > 0x100000L ? 0x100000L : l4;
            unsafe.copyMemory(object, l5, null, l3, l6);
            l4 -= l6;
            l5 += l6;
            l3 += l6;
        }
    }

    static void copyToArray(long l, Object object, long l2, long l3, long l4) {
        long l5 = l2 + l3;
        while (l4 > 0L) {
            long l6 = l4 > 0x100000L ? 0x100000L : l4;
            unsafe.copyMemory(null, l, object, l5, l6);
            l4 -= l6;
            l += l6;
            l5 += l6;
        }
    }

    static void copyFromCharArray(Object object, long l, long l2, long l3) {
        Bits.copyFromShortArray(object, l, l2, l3);
    }

    static void copyToCharArray(long l, Object object, long l2, long l3) {
        Bits.copyToShortArray(l, object, l2, l3);
    }

    static native void copyFromShortArray(Object var0, long var1, long var3, long var5);

    static native void copyToShortArray(long var0, Object var2, long var3, long var5);

    static native void copyFromIntArray(Object var0, long var1, long var3, long var5);

    static native void copyToIntArray(long var0, Object var2, long var3, long var5);

    static native void copyFromLongArray(Object var0, long var1, long var3, long var5);

    static native void copyToLongArray(long var0, Object var2, long var3, long var5);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        long l = unsafe.allocateMemory(8L);
        try {
            unsafe.putLong(l, 72623859790382856L);
            byte by = unsafe.getByte(l);
            switch (by) {
                case 1: {
                    byteOrder = ByteOrder.BIG_ENDIAN;
                    break;
                }
                case 8: {
                    byteOrder = ByteOrder.LITTLE_ENDIAN;
                    break;
                }
                default: {
                    assert (false);
                    byteOrder = null;
                }
            }
            Object var4_2 = null;
            unsafe.freeMemory(l);
        }
        catch (Throwable throwable) {
            Object var4_3 = null;
            unsafe.freeMemory(l);
            throw throwable;
        }
        pageSize = -1;
        unalignedKnown = false;
        maxMemory = VM.maxDirectMemory();
        reservedMemory = 0L;
        memoryLimitSet = false;
    }
}

