/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.AccessControlException;
import java.security.AccessController;
import java.security.AllPermission;
import java.security.DomainCombiner;
import java.security.Permission;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import sun.security.util.Debug;
import sun.security.util.SecurityConstants;

public final class AccessControlContext {
    private ProtectionDomain[] context;
    private boolean isPrivileged;
    private boolean isAuthorized = false;
    private AccessControlContext privilegedContext;
    private DomainCombiner combiner = null;
    private Permission[] permissions;
    private AccessControlContext parent;
    private boolean isWrapped;
    private boolean isLimited;
    private ProtectionDomain[] limitedContext;
    private static boolean debugInit = false;
    private static Debug debug = null;

    static Debug getDebug() {
        if (debugInit) {
            return debug;
        }
        if (Policy.isSet()) {
            debug = Debug.getInstance("access");
            debugInit = true;
        }
        return debug;
    }

    public AccessControlContext(ProtectionDomain[] protectionDomainArray) {
        if (protectionDomainArray.length == 0) {
            this.context = null;
        } else if (protectionDomainArray.length == 1) {
            this.context = protectionDomainArray[0] != null ? (ProtectionDomain[])protectionDomainArray.clone() : null;
        } else {
            ArrayList<ProtectionDomain> arrayList = new ArrayList<ProtectionDomain>(protectionDomainArray.length);
            for (int i = 0; i < protectionDomainArray.length; ++i) {
                if (protectionDomainArray[i] == null || arrayList.contains(protectionDomainArray[i])) continue;
                arrayList.add(protectionDomainArray[i]);
            }
            this.context = new ProtectionDomain[arrayList.size()];
            this.context = arrayList.toArray(this.context);
        }
    }

    public AccessControlContext(AccessControlContext accessControlContext, DomainCombiner domainCombiner) {
        this(accessControlContext, domainCombiner, false);
    }

    AccessControlContext(AccessControlContext accessControlContext, DomainCombiner domainCombiner, boolean bl) {
        if (!bl) {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(SecurityConstants.CREATE_ACC_PERMISSION);
                this.isAuthorized = true;
            }
        } else {
            this.isAuthorized = true;
        }
        this.context = accessControlContext.context;
        this.combiner = domainCombiner;
    }

    AccessControlContext(ProtectionDomain protectionDomain, DomainCombiner domainCombiner, AccessControlContext accessControlContext, AccessControlContext accessControlContext2, Permission[] permissionArray) {
        ProtectionDomain[] protectionDomainArray = null;
        if (protectionDomain != null) {
            protectionDomainArray = new ProtectionDomain[]{protectionDomain};
        }
        this.context = accessControlContext2 != null ? (domainCombiner != null ? domainCombiner.combine(protectionDomainArray, accessControlContext2.context) : AccessControlContext.combine(protectionDomainArray, accessControlContext2.context)) : (domainCombiner != null ? domainCombiner.combine(protectionDomainArray, null) : AccessControlContext.combine(protectionDomainArray, null));
        this.combiner = domainCombiner;
        Permission[] permissionArray2 = null;
        if (permissionArray != null) {
            permissionArray2 = new Permission[permissionArray.length];
            for (int i = 0; i < permissionArray.length; ++i) {
                if (permissionArray[i] == null) {
                    throw new NullPointerException("permission can't be null");
                }
                if (permissionArray[i].getClass() == AllPermission.class) {
                    accessControlContext = null;
                }
                permissionArray2[i] = permissionArray[i];
            }
        }
        if (accessControlContext != null) {
            this.limitedContext = AccessControlContext.combine(accessControlContext.context, accessControlContext.limitedContext);
            this.isLimited = true;
            this.isWrapped = true;
            this.permissions = permissionArray2;
            this.parent = accessControlContext;
            this.privilegedContext = accessControlContext2;
        }
        this.isAuthorized = true;
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, boolean bl) {
        this.context = protectionDomainArray;
        this.isPrivileged = bl;
        this.isAuthorized = true;
    }

    AccessControlContext(ProtectionDomain[] protectionDomainArray, AccessControlContext accessControlContext) {
        this.context = protectionDomainArray;
        this.privilegedContext = accessControlContext;
        this.isPrivileged = true;
    }

    ProtectionDomain[] getContext() {
        return this.context;
    }

    boolean isPrivileged() {
        return this.isPrivileged;
    }

    DomainCombiner getAssignedCombiner() {
        AccessControlContext accessControlContext = this.isPrivileged ? this.privilegedContext : AccessController.getInheritedAccessControlContext();
        if (accessControlContext != null) {
            return accessControlContext.combiner;
        }
        return null;
    }

    public DomainCombiner getDomainCombiner() {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkPermission(SecurityConstants.GET_COMBINER_PERMISSION);
        }
        return this.getCombiner();
    }

    DomainCombiner getCombiner() {
        return this.combiner;
    }

    boolean isAuthorized() {
        return this.isAuthorized;
    }

    public void checkPermission(Permission permission) throws AccessControlException {
        int n;
        boolean bl = false;
        if (permission == null) {
            throw new NullPointerException("permission can't be null");
        }
        if (AccessControlContext.getDebug() != null) {
            boolean bl2 = bl = !Debug.isOn("codebase=");
            if (!bl) {
                for (n = 0; this.context != null && n < this.context.length; ++n) {
                    if (this.context[n].getCodeSource() == null || this.context[n].getCodeSource().getLocation() == null || !Debug.isOn("codebase=" + this.context[n].getCodeSource().getLocation().toString())) continue;
                    bl = true;
                    break;
                }
            }
            if ((bl &= !Debug.isOn("permission=") || Debug.isOn("permission=" + permission.getClass().getCanonicalName())) && Debug.isOn("stack")) {
                Thread.dumpStack();
            }
            if (bl && Debug.isOn("domain")) {
                if (this.context == null) {
                    debug.println("domain (context is null)");
                } else {
                    for (n = 0; n < this.context.length; ++n) {
                        debug.println("domain " + n + " " + this.context[n]);
                    }
                }
            }
        }
        if (this.context == null) {
            this.checkPermission2(permission);
            return;
        }
        for (n = 0; n < this.context.length; ++n) {
            if (this.context[n] == null || this.context[n].implies(permission)) continue;
            if (bl) {
                debug.println("access denied " + permission);
            }
            if (Debug.isOn("failure") && debug != null) {
                if (!bl) {
                    debug.println("access denied " + permission);
                }
                Thread.dumpStack();
                final ProtectionDomain protectionDomain = this.context[n];
                final Debug debug = AccessControlContext.debug;
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        debug.println("domain that failed " + protectionDomain);
                        return null;
                    }
                });
            }
            throw new AccessControlException("access denied " + permission, permission);
        }
        if (bl) {
            debug.println("access allowed " + permission);
        }
        this.checkPermission2(permission);
    }

    private void checkPermission2(Permission permission) {
        if (!this.isLimited) {
            return;
        }
        if (this.privilegedContext != null) {
            this.privilegedContext.checkPermission2(permission);
        }
        if (this.isWrapped) {
            return;
        }
        if (this.permissions != null) {
            Class<?> clazz = permission.getClass();
            for (int i = 0; i < this.permissions.length; ++i) {
                Permission permission2 = this.permissions[i];
                if (!permission2.getClass().equals(clazz) || !permission2.implies(permission)) continue;
                return;
            }
        }
        if (this.parent != null) {
            if (this.permissions == null) {
                this.parent.checkPermission2(permission);
            } else {
                this.parent.checkPermission(permission);
            }
        }
    }

    AccessControlContext optimize() {
        ProtectionDomain[] protectionDomainArray;
        boolean bl;
        AccessControlContext accessControlContext;
        DomainCombiner domainCombiner = null;
        AccessControlContext accessControlContext2 = null;
        Permission[] permissionArray = null;
        if (this.isPrivileged) {
            accessControlContext = this.privilegedContext;
            if (accessControlContext != null && accessControlContext.isWrapped) {
                permissionArray = accessControlContext.permissions;
                accessControlContext2 = accessControlContext.parent;
            }
        } else {
            accessControlContext = AccessController.getInheritedAccessControlContext();
            if (accessControlContext != null && accessControlContext.isLimited) {
                accessControlContext2 = accessControlContext;
            }
        }
        boolean bl2 = this.context == null;
        boolean bl3 = accessControlContext == null || accessControlContext.context == null;
        ProtectionDomain[] protectionDomainArray2 = bl3 ? null : accessControlContext.context;
        boolean bl4 = bl = (accessControlContext == null || !accessControlContext.isWrapped) && accessControlContext2 == null;
        if (accessControlContext != null && accessControlContext.combiner != null) {
            if (AccessControlContext.getDebug() != null) {
                debug.println("AccessControlContext invoking the Combiner");
            }
            domainCombiner = accessControlContext.combiner;
            protectionDomainArray = domainCombiner.combine(this.context, protectionDomainArray2);
        } else {
            if (bl2) {
                if (bl3) {
                    this.calculateFields(accessControlContext, accessControlContext2, permissionArray);
                    return this;
                }
                if (bl) {
                    return accessControlContext;
                }
            } else if (protectionDomainArray2 != null && bl && this.context.length == 1 && this.context[0] == protectionDomainArray2[0]) {
                return accessControlContext;
            }
            protectionDomainArray = AccessControlContext.combine(this.context, protectionDomainArray2);
            if (bl && !bl3 && protectionDomainArray == protectionDomainArray2) {
                return accessControlContext;
            }
            if (bl3 && protectionDomainArray == this.context) {
                this.calculateFields(accessControlContext, accessControlContext2, permissionArray);
                return this;
            }
        }
        this.context = protectionDomainArray;
        this.combiner = domainCombiner;
        this.isPrivileged = false;
        this.calculateFields(accessControlContext, accessControlContext2, permissionArray);
        return this;
    }

    private static ProtectionDomain[] combine(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        int n;
        boolean bl = protectionDomainArray == null;
        boolean bl2 = protectionDomainArray2 == null;
        int n2 = n = bl ? 0 : protectionDomainArray.length;
        if (bl2 && n <= 2) {
            return protectionDomainArray;
        }
        int n3 = bl2 ? 0 : protectionDomainArray2.length;
        ProtectionDomain[] protectionDomainArray3 = new ProtectionDomain[n + n3];
        if (!bl2) {
            System.arraycopy(protectionDomainArray2, 0, protectionDomainArray3, 0, n3);
        }
        block0: for (int i = 0; i < n; ++i) {
            ProtectionDomain protectionDomain = protectionDomainArray[i];
            if (protectionDomain == null) continue;
            for (int j = 0; j < n3; ++j) {
                if (protectionDomain == protectionDomainArray3[j]) continue block0;
            }
            protectionDomainArray3[n3++] = protectionDomain;
        }
        if (n3 != protectionDomainArray3.length) {
            if (!bl2 && n3 == protectionDomainArray2.length) {
                return protectionDomainArray2;
            }
            if (bl2 && n3 == n) {
                return protectionDomainArray;
            }
            ProtectionDomain[] protectionDomainArray4 = new ProtectionDomain[n3];
            System.arraycopy(protectionDomainArray3, 0, protectionDomainArray4, 0, n3);
            protectionDomainArray3 = protectionDomainArray4;
        }
        return protectionDomainArray3;
    }

    private void calculateFields(AccessControlContext accessControlContext, AccessControlContext accessControlContext2, Permission[] permissionArray) {
        ProtectionDomain[] protectionDomainArray = null;
        ProtectionDomain[] protectionDomainArray2 = null;
        protectionDomainArray = accessControlContext2 != null ? accessControlContext2.limitedContext : null;
        ProtectionDomain[] protectionDomainArray3 = AccessControlContext.combine(protectionDomainArray, protectionDomainArray2 = accessControlContext != null ? accessControlContext.limitedContext : null);
        if (!(protectionDomainArray3 == null || this.context != null && AccessControlContext.containsAllPDs(protectionDomainArray3, this.context))) {
            this.limitedContext = protectionDomainArray3;
            this.permissions = permissionArray;
            this.parent = accessControlContext2;
            this.isLimited = true;
        }
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof AccessControlContext)) {
            return false;
        }
        AccessControlContext accessControlContext = (AccessControlContext)object;
        if (!this.equalContext(accessControlContext)) {
            return false;
        }
        return this.equalLimitedContext(accessControlContext);
    }

    private boolean equalContext(AccessControlContext accessControlContext) {
        if (!this.equalPDs(this.context, accessControlContext.context)) {
            return false;
        }
        if (this.combiner == null && accessControlContext.combiner != null) {
            return false;
        }
        return this.combiner == null || this.combiner.equals(accessControlContext.combiner);
    }

    private boolean equalPDs(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        if (protectionDomainArray == null) {
            return protectionDomainArray2 == null;
        }
        if (protectionDomainArray2 == null) {
            return false;
        }
        return AccessControlContext.containsAllPDs(protectionDomainArray, protectionDomainArray2) && AccessControlContext.containsAllPDs(protectionDomainArray2, protectionDomainArray);
    }

    private boolean equalLimitedContext(AccessControlContext accessControlContext) {
        if (accessControlContext == null) {
            return false;
        }
        if (!this.isLimited && !accessControlContext.isLimited) {
            return true;
        }
        if (!this.isLimited || !accessControlContext.isLimited) {
            return false;
        }
        if (this.isWrapped && !accessControlContext.isWrapped || !this.isWrapped && accessControlContext.isWrapped) {
            return false;
        }
        if (this.permissions == null && accessControlContext.permissions != null) {
            return false;
        }
        if (this.permissions != null && accessControlContext.permissions == null) {
            return false;
        }
        if (!this.containsAllLimits(accessControlContext) || !accessControlContext.containsAllLimits(this)) {
            return false;
        }
        AccessControlContext accessControlContext2 = AccessControlContext.getNextPC(this);
        AccessControlContext accessControlContext3 = AccessControlContext.getNextPC(accessControlContext);
        if (accessControlContext2 == null && accessControlContext3 != null && accessControlContext3.isLimited) {
            return false;
        }
        if (accessControlContext2 != null && !accessControlContext2.equalLimitedContext(accessControlContext3)) {
            return false;
        }
        if (this.parent == null && accessControlContext.parent != null) {
            return false;
        }
        return this.parent == null || this.parent.equals(accessControlContext.parent);
    }

    private static AccessControlContext getNextPC(AccessControlContext accessControlContext) {
        while (accessControlContext != null && accessControlContext.privilegedContext != null) {
            accessControlContext = accessControlContext.privilegedContext;
            if (accessControlContext.isWrapped) continue;
            return accessControlContext;
        }
        return null;
    }

    private static boolean containsAllPDs(ProtectionDomain[] protectionDomainArray, ProtectionDomain[] protectionDomainArray2) {
        boolean bl = false;
        for (int i = 0; i < protectionDomainArray.length; ++i) {
            bl = false;
            ProtectionDomain protectionDomain = protectionDomainArray[i];
            if (protectionDomain == null) {
                for (int j = 0; j < protectionDomainArray2.length && !bl; ++j) {
                    bl = protectionDomainArray2[j] == null;
                }
            } else {
                Class<?> clazz = protectionDomain.getClass();
                for (int j = 0; j < protectionDomainArray2.length && !bl; ++j) {
                    ProtectionDomain protectionDomain2 = protectionDomainArray2[j];
                    bl = protectionDomain2 != null && clazz == protectionDomain2.getClass() && protectionDomain.equals(protectionDomain2);
                }
            }
            if (bl) continue;
            return false;
        }
        return bl;
    }

    private boolean containsAllLimits(AccessControlContext accessControlContext) {
        boolean bl = false;
        if (this.permissions == null && accessControlContext.permissions == null) {
            return true;
        }
        for (int i = 0; i < this.permissions.length; ++i) {
            Permission permission = this.permissions[i];
            Class<?> clazz = permission.getClass();
            bl = false;
            for (int j = 0; j < accessControlContext.permissions.length && !bl; ++j) {
                Permission permission2 = accessControlContext.permissions[j];
                bl = clazz.equals(permission2.getClass()) && permission.equals(permission2);
            }
            if (bl) continue;
            return false;
        }
        return bl;
    }

    public int hashCode() {
        int n = 0;
        if (this.context == null) {
            return n;
        }
        for (int i = 0; i < this.context.length; ++i) {
            if (this.context[i] == null) continue;
            n ^= this.context[i].hashCode();
        }
        return n;
    }
}

