/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import sun.security.util.Debug;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Provider
extends Properties {
    static final long serialVersionUID = -4298000515446427739L;
    private static final Debug debug = Debug.getInstance("provider", "Provider");
    private String name;
    private String info;
    private double version;
    private transient Set<Map.Entry<Object, Object>> entrySet = null;
    private transient int entrySetCallCount = 0;
    private transient boolean initialized;
    private transient boolean legacyChanged;
    private transient boolean servicesChanged;
    private transient Map<String, String> legacyStrings;
    private transient Map<ServiceKey, Service> serviceMap;
    private transient Map<ServiceKey, Service> legacyMap;
    private transient Set<Service> serviceSet;
    private static final String ALIAS_PREFIX = "Alg.Alias.";
    private static final String ALIAS_PREFIX_LOWER = "alg.alias.";
    private static final int ALIAS_LENGTH = "Alg.Alias.".length();
    private static volatile ServiceKey previousKey = new ServiceKey("", "", false);
    private static final Map<String, EngineDescription> knownEngines = new HashMap<String, EngineDescription>();

    protected Provider(String string, double d, String string2) {
        this.name = string;
        this.version = d;
        this.info = string2;
        this.putId();
        this.initialized = true;
    }

    public String getName() {
        return this.name;
    }

    public double getVersion() {
        return this.version;
    }

    public String getInfo() {
        return this.info;
    }

    @Override
    public String toString() {
        return this.name + " version " + this.version;
    }

    @Override
    public synchronized void clear() {
        this.check("clearProviderProperties." + this.name);
        if (debug != null) {
            debug.println("Remove " + this.name + " provider properties");
        }
        this.implClear();
    }

    @Override
    public synchronized void load(InputStream inputStream) throws IOException {
        this.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Load " + this.name + " provider properties");
        }
        Properties properties = new Properties();
        properties.load(inputStream);
        this.implPutAll(properties);
    }

    @Override
    public synchronized void putAll(Map<?, ?> map) {
        this.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Put all " + this.name + " provider properties");
        }
        this.implPutAll(map);
    }

    @Override
    public synchronized Set<Map.Entry<Object, Object>> entrySet() {
        this.checkInitialized();
        if (this.entrySet == null) {
            if (this.entrySetCallCount++ == 0) {
                this.entrySet = Collections.unmodifiableMap(this).entrySet();
            } else {
                return super.entrySet();
            }
        }
        if (this.entrySetCallCount != 2) {
            throw new RuntimeException("Internal error.");
        }
        return this.entrySet;
    }

    @Override
    public Set<Object> keySet() {
        this.checkInitialized();
        return Collections.unmodifiableSet(super.keySet());
    }

    @Override
    public Collection<Object> values() {
        this.checkInitialized();
        return Collections.unmodifiableCollection(super.values());
    }

    @Override
    public synchronized Object put(Object object, Object object2) {
        this.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Set " + this.name + " provider property [" + object + "/" + object2 + "]");
        }
        return this.implPut(object, object2);
    }

    @Override
    public synchronized Object remove(Object object) {
        this.check("removeProviderProperty." + this.name);
        if (debug != null) {
            debug.println("Remove " + this.name + " provider property " + object);
        }
        return this.implRemove(object);
    }

    @Override
    public Object get(Object object) {
        this.checkInitialized();
        return super.get(object);
    }

    @Override
    public Enumeration<Object> keys() {
        this.checkInitialized();
        return super.keys();
    }

    @Override
    public Enumeration<Object> elements() {
        this.checkInitialized();
        return super.elements();
    }

    @Override
    public String getProperty(String string) {
        this.checkInitialized();
        return super.getProperty(string);
    }

    private void checkInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException();
        }
    }

    private void check(String string) {
        this.checkInitialized();
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkSecurityAccess(string);
        }
    }

    private void putId() {
        super.put("Provider.id name", String.valueOf(this.name));
        super.put("Provider.id version", String.valueOf(this.version));
        super.put("Provider.id info", String.valueOf(this.info));
        super.put("Provider.id className", this.getClass().getName());
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : super.entrySet()) {
            hashMap.put(entry.getKey(), entry.getValue());
        }
        this.defaults = null;
        objectInputStream.defaultReadObject();
        this.implClear();
        this.initialized = true;
        this.putAll((Map<?, ?>)hashMap);
    }

    private void implPutAll(Map<?, ?> map) {
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            this.implPut(entry.getKey(), entry.getValue());
        }
    }

    private Object implRemove(Object object) {
        if (object instanceof String) {
            String string = (String)object;
            if (string.startsWith("Provider.")) {
                return null;
            }
            this.legacyChanged = true;
            if (this.legacyStrings == null) {
                this.legacyStrings = new LinkedHashMap<String, String>();
            }
            this.legacyStrings.remove(string);
        }
        return super.remove(object);
    }

    private Object implPut(Object object, Object object2) {
        if (object instanceof String && object2 instanceof String) {
            String string = (String)object;
            if (string.startsWith("Provider.")) {
                return null;
            }
            this.legacyChanged = true;
            if (this.legacyStrings == null) {
                this.legacyStrings = new LinkedHashMap<String, String>();
            }
            this.legacyStrings.put(string, (String)object2);
        }
        return super.put(object, object2);
    }

    private void implClear() {
        if (this.legacyStrings != null) {
            this.legacyStrings.clear();
        }
        if (this.legacyMap != null) {
            this.legacyMap.clear();
        }
        if (this.serviceMap != null) {
            this.serviceMap.clear();
        }
        this.legacyChanged = false;
        this.servicesChanged = false;
        this.serviceSet = null;
        super.clear();
        this.putId();
    }

    private void ensureLegacyParsed() {
        if (!this.legacyChanged || this.legacyStrings == null) {
            return;
        }
        this.serviceSet = null;
        if (this.legacyMap == null) {
            this.legacyMap = new LinkedHashMap<ServiceKey, Service>();
        } else {
            this.legacyMap.clear();
        }
        for (Map.Entry<String, String> entry : this.legacyStrings.entrySet()) {
            this.parseLegacyPut(entry.getKey(), entry.getValue());
        }
        this.removeInvalidServices(this.legacyMap);
        this.legacyChanged = false;
    }

    private void removeInvalidServices(Map<ServiceKey, Service> map) {
        Iterator<Map.Entry<ServiceKey, Service>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Service service = iterator.next().getValue();
            if (service.isValid()) continue;
            iterator.remove();
        }
    }

    private String[] getTypeAndAlgorithm(String string) {
        int n = string.indexOf(".");
        if (n < 1) {
            if (debug != null) {
                debug.println("Ignoring invalid entry in provider " + this.name + ":" + string);
            }
            return null;
        }
        String string2 = string.substring(0, n);
        String string3 = string.substring(n + 1);
        return new String[]{string2, string3};
    }

    private void parseLegacyPut(String string, String string2) {
        if (string.toLowerCase(Locale.ENGLISH).startsWith(ALIAS_PREFIX_LOWER)) {
            String string3 = string2;
            String string4 = string.substring(ALIAS_LENGTH);
            String[] stringArray = this.getTypeAndAlgorithm(string4);
            if (stringArray == null) {
                return;
            }
            String string5 = Provider.getEngineName(stringArray[0]);
            String string6 = stringArray[1].intern();
            ServiceKey serviceKey = new ServiceKey(string5, string3, true);
            Service service = this.legacyMap.get(serviceKey);
            if (service == null) {
                service = new Service(this);
                service.type = string5;
                service.algorithm = string3;
                this.legacyMap.put(serviceKey, service);
            }
            this.legacyMap.put(new ServiceKey(string5, string6, true), service);
            service.addAlias(string6);
        } else {
            String[] stringArray = this.getTypeAndAlgorithm(string);
            if (stringArray == null) {
                return;
            }
            int n = stringArray[1].indexOf(32);
            if (n == -1) {
                String string7 = Provider.getEngineName(stringArray[0]);
                String string8 = stringArray[1].intern();
                String string9 = string2;
                ServiceKey serviceKey = new ServiceKey(string7, string8, true);
                Service service = this.legacyMap.get(serviceKey);
                if (service == null) {
                    service = new Service(this);
                    service.type = string7;
                    service.algorithm = string8;
                    this.legacyMap.put(serviceKey, service);
                }
                service.className = string9;
            } else {
                String string10 = string2;
                String string11 = Provider.getEngineName(stringArray[0]);
                String string12 = stringArray[1];
                String string13 = string12.substring(0, n).intern();
                String string14 = string12.substring(n + 1);
                while (string14.startsWith(" ")) {
                    string14 = string14.substring(1);
                }
                string14 = string14.intern();
                ServiceKey serviceKey = new ServiceKey(string11, string13, true);
                Service service = this.legacyMap.get(serviceKey);
                if (service == null) {
                    service = new Service(this);
                    service.type = string11;
                    service.algorithm = string13;
                    this.legacyMap.put(serviceKey, service);
                }
                service.addAttribute(string14, string10);
            }
        }
    }

    public synchronized Service getService(String string, String string2) {
        Service service;
        this.checkInitialized();
        ServiceKey serviceKey = previousKey;
        if (!serviceKey.matches(string, string2)) {
            previousKey = serviceKey = new ServiceKey(string, string2, false);
        }
        if (this.serviceMap != null && (service = this.serviceMap.get(serviceKey)) != null) {
            return service;
        }
        this.ensureLegacyParsed();
        return this.legacyMap != null ? this.legacyMap.get(serviceKey) : null;
    }

    public synchronized Set<Service> getServices() {
        this.checkInitialized();
        if (this.legacyChanged || this.servicesChanged) {
            this.serviceSet = null;
        }
        if (this.serviceSet == null) {
            this.ensureLegacyParsed();
            LinkedHashSet<Service> linkedHashSet = new LinkedHashSet<Service>();
            if (this.serviceMap != null) {
                linkedHashSet.addAll(this.serviceMap.values());
            }
            if (this.legacyMap != null) {
                linkedHashSet.addAll(this.legacyMap.values());
            }
            this.serviceSet = Collections.unmodifiableSet(linkedHashSet);
            this.servicesChanged = false;
        }
        return this.serviceSet;
    }

    protected synchronized void putService(Service service) {
        this.check("putProviderProperty." + this.name);
        if (debug != null) {
            debug.println(this.name + ".putService(): " + service);
        }
        if (service == null) {
            throw new NullPointerException();
        }
        if (service.getProvider() != this) {
            throw new IllegalArgumentException("service.getProvider() must match this Provider object");
        }
        if (this.serviceMap == null) {
            this.serviceMap = new LinkedHashMap<ServiceKey, Service>();
        }
        this.servicesChanged = true;
        String string = service.getType();
        String string2 = service.getAlgorithm();
        ServiceKey serviceKey = new ServiceKey(string, string2, true);
        this.implRemoveService(this.serviceMap.get(serviceKey));
        this.serviceMap.put(serviceKey, service);
        for (String string3 : service.getAliases()) {
            this.serviceMap.put(new ServiceKey(string, string3, true), service);
        }
        this.putPropertyStrings(service);
    }

    private void putPropertyStrings(Service service) {
        String string = service.getType();
        String string2 = service.getAlgorithm();
        super.put(string + "." + string2, service.getClassName());
        for (String object : service.getAliases()) {
            super.put(ALIAS_PREFIX + string + "." + object, string2);
        }
        for (Map.Entry entry : service.attributes.entrySet()) {
            String string3 = string + "." + string2 + " " + entry.getKey();
            super.put(string3, entry.getValue());
        }
    }

    private void removePropertyStrings(Service service) {
        String string = service.getType();
        String string2 = service.getAlgorithm();
        super.remove(string + "." + string2);
        for (String object : service.getAliases()) {
            super.remove(ALIAS_PREFIX + string + "." + object);
        }
        for (Map.Entry entry : service.attributes.entrySet()) {
            String string3 = string + "." + string2 + " " + entry.getKey();
            super.remove(string3);
        }
    }

    protected synchronized void removeService(Service service) {
        this.check("removeProviderProperty." + this.name);
        if (debug != null) {
            debug.println(this.name + ".removeService(): " + service);
        }
        if (service == null) {
            throw new NullPointerException();
        }
        this.implRemoveService(service);
    }

    private void implRemoveService(Service service) {
        String string;
        if (service == null || this.serviceMap == null) {
            return;
        }
        String string2 = service.getType();
        ServiceKey serviceKey = new ServiceKey(string2, string = service.getAlgorithm(), false);
        Service service2 = this.serviceMap.get(serviceKey);
        if (service != service2) {
            return;
        }
        this.servicesChanged = true;
        this.serviceMap.remove(serviceKey);
        for (String string3 : service.getAliases()) {
            this.serviceMap.remove(new ServiceKey(string2, string3, false));
        }
        this.removePropertyStrings(service);
    }

    private static void addEngine(String string, boolean bl, String string2) {
        EngineDescription engineDescription = new EngineDescription(string, bl, string2);
        knownEngines.put(string.toLowerCase(Locale.ENGLISH), engineDescription);
        knownEngines.put(string, engineDescription);
    }

    private static String getEngineName(String string) {
        EngineDescription engineDescription = knownEngines.get(string);
        if (engineDescription == null) {
            engineDescription = knownEngines.get(string.toLowerCase(Locale.ENGLISH));
        }
        return engineDescription == null ? string : engineDescription.name;
    }

    static {
        Provider.addEngine("AlgorithmParameterGenerator", false, null);
        Provider.addEngine("AlgorithmParameters", false, null);
        Provider.addEngine("KeyFactory", false, null);
        Provider.addEngine("KeyPairGenerator", false, null);
        Provider.addEngine("KeyStore", false, null);
        Provider.addEngine("MessageDigest", false, null);
        Provider.addEngine("SecureRandom", false, null);
        Provider.addEngine("Signature", true, null);
        Provider.addEngine("CertificateFactory", false, null);
        Provider.addEngine("CertPathBuilder", false, null);
        Provider.addEngine("CertPathValidator", false, null);
        Provider.addEngine("CertStore", false, "java.security.cert.CertStoreParameters");
        Provider.addEngine("Cipher", true, null);
        Provider.addEngine("ExemptionMechanism", false, null);
        Provider.addEngine("Mac", true, null);
        Provider.addEngine("KeyAgreement", true, null);
        Provider.addEngine("KeyGenerator", false, null);
        Provider.addEngine("SecretKeyFactory", false, null);
        Provider.addEngine("KeyManagerFactory", false, null);
        Provider.addEngine("SSLContext", false, null);
        Provider.addEngine("TrustManagerFactory", false, null);
        Provider.addEngine("GssApiMechanism", false, null);
        Provider.addEngine("SaslClientFactory", false, null);
        Provider.addEngine("SaslServerFactory", false, null);
        Provider.addEngine("Policy", false, "java.security.Policy$Parameters");
        Provider.addEngine("Configuration", false, "javax.security.auth.login.Configuration$Parameters");
        Provider.addEngine("XMLSignatureFactory", false, null);
        Provider.addEngine("KeyInfoFactory", false, null);
        Provider.addEngine("TransformService", false, null);
        Provider.addEngine("TerminalFactory", false, "java.lang.Object");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Service {
        private String type;
        private String algorithm;
        private String className;
        private final Provider provider;
        private List<String> aliases;
        private Map<UString, String> attributes;
        private volatile Reference<Class<?>> classRef;
        private volatile Boolean hasKeyAttributes;
        private String[] supportedFormats;
        private Class[] supportedClasses;
        private boolean registered;
        private static final Class<?>[] CLASS0 = new Class[0];

        private Service(Provider provider) {
            this.provider = provider;
            this.aliases = Collections.emptyList();
            this.attributes = Collections.emptyMap();
        }

        private boolean isValid() {
            return this.type != null && this.algorithm != null && this.className != null;
        }

        private void addAlias(String string) {
            if (this.aliases.isEmpty()) {
                this.aliases = new ArrayList<String>(2);
            }
            this.aliases.add(string);
        }

        void addAttribute(String string, String string2) {
            if (this.attributes.isEmpty()) {
                this.attributes = new HashMap<UString, String>(8);
            }
            this.attributes.put(new UString(string), string2);
        }

        public Service(Provider provider, String string, String string2, String string3, List<String> list, Map<String, String> map) {
            if (provider == null || string == null || string2 == null || string3 == null) {
                throw new NullPointerException();
            }
            this.provider = provider;
            this.type = Provider.getEngineName(string);
            this.algorithm = string2;
            this.className = string3;
            this.aliases = list == null ? Collections.emptyList() : new ArrayList<String>(list);
            if (map == null) {
                this.attributes = Collections.emptyMap();
            } else {
                this.attributes = new HashMap<UString, String>();
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.attributes.put(new UString(entry.getKey()), entry.getValue());
                }
            }
        }

        public final String getType() {
            return this.type;
        }

        public final String getAlgorithm() {
            return this.algorithm;
        }

        public final Provider getProvider() {
            return this.provider;
        }

        public final String getClassName() {
            return this.className;
        }

        private final List<String> getAliases() {
            return this.aliases;
        }

        public final String getAttribute(String string) {
            if (string == null) {
                throw new NullPointerException();
            }
            return this.attributes.get(new UString(string));
        }

        public Object newInstance(Object object) throws NoSuchAlgorithmException {
            if (!this.registered) {
                if (this.provider.getService(this.type, this.algorithm) != this) {
                    throw new NoSuchAlgorithmException("Service not registered with Provider " + this.provider.getName() + ": " + this);
                }
                this.registered = true;
            }
            try {
                Class<?> clazz;
                EngineDescription engineDescription = (EngineDescription)knownEngines.get(this.type);
                if (engineDescription == null) {
                    return this.newInstanceGeneric(object);
                }
                if (engineDescription.constructorParameterClassName == null) {
                    if (object != null) {
                        throw new InvalidParameterException("constructorParameter not used with " + this.type + " engines");
                    }
                    Class<?> clazz2 = this.getImplClass();
                    Class[] classArray = new Class[]{};
                    Constructor<?> constructor = clazz2.getConstructor(classArray);
                    return constructor.newInstance(new Object[0]);
                }
                Class<?> clazz3 = engineDescription.getConstructorParameterClass();
                if (object != null && !clazz3.isAssignableFrom(clazz = object.getClass())) {
                    throw new InvalidParameterException("constructorParameter must be instanceof " + engineDescription.constructorParameterClassName.replace('$', '.') + " for engine type " + this.type);
                }
                clazz = this.getImplClass();
                Constructor<?> constructor = clazz.getConstructor(clazz3);
                return constructor.newInstance(object);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw noSuchAlgorithmException;
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new NoSuchAlgorithmException("Error constructing implementation (algorithm: " + this.algorithm + ", provider: " + this.provider.getName() + ", class: " + this.className + ")", invocationTargetException.getCause());
            }
            catch (Exception exception) {
                throw new NoSuchAlgorithmException("Error constructing implementation (algorithm: " + this.algorithm + ", provider: " + this.provider.getName() + ", class: " + this.className + ")", exception);
            }
        }

        private Class<?> getImplClass() throws NoSuchAlgorithmException {
            try {
                Class<?> clazz;
                Reference<Class<?>> reference = this.classRef;
                Class<?> clazz2 = clazz = reference == null ? null : reference.get();
                if (clazz == null) {
                    ClassLoader classLoader = this.provider.getClass().getClassLoader();
                    clazz = classLoader == null ? Class.forName(this.className) : classLoader.loadClass(this.className);
                    if (!Modifier.isPublic(clazz.getModifiers())) {
                        throw new NoSuchAlgorithmException("class configured for " + this.type + " (provider: " + this.provider.getName() + ") is not public.");
                    }
                    this.classRef = new WeakReference(clazz);
                }
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoSuchAlgorithmException("class configured for " + this.type + "(provider: " + this.provider.getName() + ") cannot be found.", classNotFoundException);
            }
        }

        private Object newInstanceGeneric(Object object) throws Exception {
            Constructor<?>[] constructorArray;
            Class<?> clazz = this.getImplClass();
            if (object == null) {
                try {
                    Class[] classArray = new Class[]{};
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    return constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new NoSuchAlgorithmException("No public no-arg constructor found in class " + this.className);
                }
            }
            Class<?> clazz2 = object.getClass();
            for (Constructor<?> constructor : constructorArray = clazz.getConstructors()) {
                Class<?>[] classArray = constructor.getParameterTypes();
                if (classArray.length != 1 || !classArray[0].isAssignableFrom(clazz2)) continue;
                return constructor.newInstance(object);
            }
            throw new NoSuchAlgorithmException("No public constructor matching " + clazz2.getName() + " found in class " + this.className);
        }

        public boolean supportsParameter(Object object) {
            EngineDescription engineDescription = (EngineDescription)knownEngines.get(this.type);
            if (engineDescription == null) {
                return true;
            }
            if (!engineDescription.supportsParameter) {
                throw new InvalidParameterException("supportsParameter() not used with " + this.type + " engines");
            }
            if (object != null && !(object instanceof Key)) {
                throw new InvalidParameterException("Parameter must be instanceof Key for engine " + this.type);
            }
            if (!this.hasKeyAttributes()) {
                return true;
            }
            if (object == null) {
                return false;
            }
            Key key = (Key)object;
            if (this.supportsKeyFormat(key)) {
                return true;
            }
            return this.supportsKeyClass(key);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean hasKeyAttributes() {
            Boolean bl = this.hasKeyAttributes;
            if (bl == null) {
                Service service = this;
                synchronized (service) {
                    String string = this.getAttribute("SupportedKeyFormats");
                    if (string != null) {
                        this.supportedFormats = string.split("\\|");
                    }
                    if ((string = this.getAttribute("SupportedKeyClasses")) != null) {
                        String[] stringArray = string.split("\\|");
                        ArrayList arrayList = new ArrayList(stringArray.length);
                        for (String string2 : stringArray) {
                            Class<?> clazz = this.getKeyClass(string2);
                            if (clazz == null) continue;
                            arrayList.add(clazz);
                        }
                        this.supportedClasses = arrayList.toArray(CLASS0);
                    }
                    boolean bl2 = this.supportedFormats != null || this.supportedClasses != null;
                    this.hasKeyAttributes = bl = Boolean.valueOf(bl2);
                }
            }
            return bl;
        }

        private Class<?> getKeyClass(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                try {
                    ClassLoader classLoader = this.provider.getClass().getClassLoader();
                    if (classLoader != null) {
                        return classLoader.loadClass(string);
                    }
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    // empty catch block
                }
                return null;
            }
        }

        private boolean supportsKeyFormat(Key key) {
            if (this.supportedFormats == null) {
                return false;
            }
            String string = key.getFormat();
            if (string == null) {
                return false;
            }
            for (String string2 : this.supportedFormats) {
                if (!string2.equals(string)) continue;
                return true;
            }
            return false;
        }

        private boolean supportsKeyClass(Key key) {
            if (this.supportedClasses == null) {
                return false;
            }
            Class<?> clazz = key.getClass();
            for (Class clazz2 : this.supportedClasses) {
                if (!clazz2.isAssignableFrom(clazz)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            String string = this.aliases.isEmpty() ? "" : "\r\n  aliases: " + this.aliases.toString();
            String string2 = this.attributes.isEmpty() ? "" : "\r\n  attributes: " + this.attributes.toString();
            return this.provider.getName() + ": " + this.type + "." + this.algorithm + " -> " + this.className + string + string2 + "\r\n";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EngineDescription {
        final String name;
        final boolean supportsParameter;
        final String constructorParameterClassName;
        private volatile Class<?> constructorParameterClass;

        EngineDescription(String string, boolean bl, String string2) {
            this.name = string;
            this.supportsParameter = bl;
            this.constructorParameterClassName = string2;
        }

        Class<?> getConstructorParameterClass() throws ClassNotFoundException {
            Class<?> clazz = this.constructorParameterClass;
            if (clazz == null) {
                this.constructorParameterClass = clazz = Class.forName(this.constructorParameterClassName);
            }
            return clazz;
        }
    }

    private static class UString {
        final String string;
        final String lowerString;

        UString(String string) {
            this.string = string;
            this.lowerString = string.toLowerCase(Locale.ENGLISH);
        }

        public int hashCode() {
            return this.lowerString.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof UString)) {
                return false;
            }
            UString uString = (UString)object;
            return this.lowerString.equals(uString.lowerString);
        }

        public String toString() {
            return this.string;
        }
    }

    private static class ServiceKey {
        private final String type;
        private final String algorithm;
        private final String originalAlgorithm;

        private ServiceKey(String string, String string2, boolean bl) {
            this.type = string;
            this.originalAlgorithm = string2;
            string2 = string2.toUpperCase(Locale.ENGLISH);
            this.algorithm = bl ? string2.intern() : string2;
        }

        public int hashCode() {
            return this.type.hashCode() + this.algorithm.hashCode();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof ServiceKey)) {
                return false;
            }
            ServiceKey serviceKey = (ServiceKey)object;
            return this.type.equals(serviceKey.type) && this.algorithm.equals(serviceKey.algorithm);
        }

        boolean matches(String string, String string2) {
            return this.type == string && this.originalAlgorithm == string2;
        }
    }
}

