/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeType;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.OpenDataException;
import javax.management.openmbean.OpenType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompositeDataSupport
implements CompositeData,
Serializable {
    static final long serialVersionUID = 8003518976613702244L;
    private SortedMap<String, Object> contents = new TreeMap<String, Object>();
    private CompositeType compositeType;

    public CompositeDataSupport(CompositeType compositeType, String[] stringArray, Object[] objectArray) throws OpenDataException {
        int n;
        if (compositeType == null) {
            throw new IllegalArgumentException("Argument compositeType cannot be null.");
        }
        Set<String> set = compositeType.keySet();
        CompositeDataSupport.checkForNullElement(stringArray, "itemNames");
        CompositeDataSupport.checkForEmptyString(stringArray, "itemNames");
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("Argument itemValues[] cannot be null or empty.");
        }
        if (stringArray.length != objectArray.length) {
            throw new IllegalArgumentException("Array arguments itemNames[] and itemValues[] should be of same length (got " + stringArray.length + " and " + objectArray.length + ").");
        }
        if (stringArray.length != set.size()) {
            throw new OpenDataException("The size of array arguments itemNames[] and itemValues[] should be equal to the number of items defined in argument compositeType (found " + stringArray.length + " elements in itemNames[] and itemValues[]," + " expecting " + set.size() + " elements according to compositeType.");
        }
        if (!Arrays.asList(stringArray).containsAll(set)) {
            throw new OpenDataException("Argument itemNames[] does not contain all names defined in the compositeType of this instance.");
        }
        for (n = 0; n < objectArray.length; ++n) {
            OpenType<?> openType = compositeType.getType(stringArray[n]);
            if (objectArray[n] == null || openType.isValue(objectArray[n])) continue;
            throw new OpenDataException("Argument's element itemValues[" + n + "]=\"" + objectArray[n] + "\" is not a valid value for" + " this item (itemName=" + stringArray[n] + ",itemType=" + openType + ").");
        }
        this.compositeType = compositeType;
        for (n = 0; n < stringArray.length; ++n) {
            this.contents.put(stringArray[n], objectArray[n]);
        }
    }

    public CompositeDataSupport(CompositeType compositeType, Map<String, ?> map) throws OpenDataException {
        this(compositeType, map == null ? null : map.keySet().toArray(new String[map.size()]), map == null ? null : map.values().toArray());
    }

    private static void checkForNullElement(Object[] objectArray, String string) {
        if (objectArray == null || objectArray.length == 0) {
            throw new IllegalArgumentException("Argument " + string + "[] cannot be null or empty.");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            throw new IllegalArgumentException("Argument's element " + string + "[" + i + "] cannot be null.");
        }
    }

    private static void checkForEmptyString(String[] stringArray, String string) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].trim().equals("")) continue;
            throw new IllegalArgumentException("Argument's element " + string + "[" + i + "] cannot be an empty string.");
        }
    }

    @Override
    public CompositeType getCompositeType() {
        return this.compositeType;
    }

    @Override
    public Object get(String string) {
        if (string == null || string.trim().equals("")) {
            throw new IllegalArgumentException("Argument key cannot be a null or empty String.");
        }
        if (!this.contents.containsKey(string.trim())) {
            throw new InvalidKeyException("Argument key=\"" + string.trim() + "\" is not an existing item name for this CompositeData instance.");
        }
        return this.contents.get(string.trim());
    }

    @Override
    public Object[] getAll(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return new Object[0];
        }
        Object[] objectArray = new Object[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            objectArray[i] = this.get(stringArray[i]);
        }
        return objectArray;
    }

    @Override
    public boolean containsKey(String string) {
        if (string == null || string.trim().equals("")) {
            return false;
        }
        return this.contents.containsKey(string);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.contents.containsValue(object);
    }

    @Override
    public Collection<?> values() {
        return Collections.unmodifiableCollection(this.contents.values());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof CompositeData)) {
            return false;
        }
        CompositeData compositeData = (CompositeData)object;
        if (!this.getCompositeType().equals(compositeData.getCompositeType())) {
            return false;
        }
        if (this.contents.size() != compositeData.values().size()) {
            return false;
        }
        for (Map.Entry<String, Object> entry : this.contents.entrySet()) {
            Object object2;
            Object object3 = entry.getValue();
            if (object3 == (object2 = compositeData.get(entry.getKey()))) continue;
            if (object3 == null) {
                return false;
            }
            boolean bl = object3.getClass().isArray() ? Arrays.deepEquals(new Object[]{object3}, new Object[]{object2}) : object3.equals(object2);
            if (bl) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = this.compositeType.hashCode();
        for (Object object : this.contents.values()) {
            if (object instanceof Object[]) {
                n += Arrays.deepHashCode((Object[])object);
                continue;
            }
            if (object instanceof byte[]) {
                n += Arrays.hashCode((byte[])object);
                continue;
            }
            if (object instanceof short[]) {
                n += Arrays.hashCode((short[])object);
                continue;
            }
            if (object instanceof int[]) {
                n += Arrays.hashCode((int[])object);
                continue;
            }
            if (object instanceof long[]) {
                n += Arrays.hashCode((long[])object);
                continue;
            }
            if (object instanceof char[]) {
                n += Arrays.hashCode((char[])object);
                continue;
            }
            if (object instanceof float[]) {
                n += Arrays.hashCode((float[])object);
                continue;
            }
            if (object instanceof double[]) {
                n += Arrays.hashCode((double[])object);
                continue;
            }
            if (object instanceof boolean[]) {
                n += Arrays.hashCode((boolean[])object);
                continue;
            }
            if (object == null) continue;
            n += object.hashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(compositeType=" + this.compositeType.toString() + ",contents=" + this.contents.toString() + ")";
    }
}

