/*
 * Decompiled with CFR 0.152.
 */
package javax.management.openmbean;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.InvalidKeyException;
import javax.management.openmbean.InvalidOpenTypeException;
import javax.management.openmbean.KeyAlreadyExistsException;
import javax.management.openmbean.OpenType;
import javax.management.openmbean.TabularData;
import javax.management.openmbean.TabularType;
import sun.misc.SharedSecrets;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TabularDataSupport
implements TabularData,
Map<Object, Object>,
Cloneable,
Serializable {
    static final long serialVersionUID = 5720150593236309827L;
    private Map<Object, CompositeData> dataMap;
    private TabularType tabularType;
    private transient String[] indexNamesArray;

    public TabularDataSupport(TabularType tabularType) {
        this(tabularType, 101, 0.75f);
    }

    public TabularDataSupport(TabularType tabularType, int n, float f) {
        if (tabularType == null) {
            throw new IllegalArgumentException("Argument tabularType cannot be null.");
        }
        this.tabularType = tabularType;
        List<String> list = tabularType.getIndexNames();
        this.indexNamesArray = list.toArray(new String[list.size()]);
        this.dataMap = new HashMap<Object, CompositeData>(n, f);
    }

    @Override
    public TabularType getTabularType() {
        return this.tabularType;
    }

    @Override
    public Object[] calculateIndex(CompositeData compositeData) {
        this.checkValueType(compositeData);
        return this.internalCalculateIndex(compositeData).toArray();
    }

    @Override
    public boolean containsKey(Object object) {
        Object[] objectArray;
        try {
            objectArray = (Object[])object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        return this.containsKey(objectArray);
    }

    @Override
    public boolean containsKey(Object[] objectArray) {
        return objectArray == null ? false : this.dataMap.containsKey(Arrays.asList(objectArray));
    }

    @Override
    public boolean containsValue(CompositeData compositeData) {
        return this.dataMap.containsValue(compositeData);
    }

    @Override
    public boolean containsValue(Object object) {
        return this.dataMap.containsValue(object);
    }

    @Override
    public Object get(Object object) {
        return this.get((Object[])object);
    }

    @Override
    public CompositeData get(Object[] objectArray) {
        this.checkKeyType(objectArray);
        return this.dataMap.get(Arrays.asList(objectArray));
    }

    @Override
    public Object put(Object object, Object object2) {
        this.internalPut((CompositeData)object2);
        return object2;
    }

    @Override
    public void put(CompositeData compositeData) {
        this.internalPut(compositeData);
    }

    private CompositeData internalPut(CompositeData compositeData) {
        List<?> list = this.checkValueAndIndex(compositeData);
        return this.dataMap.put(list, compositeData);
    }

    @Override
    public Object remove(Object object) {
        return this.remove((Object[])object);
    }

    @Override
    public CompositeData remove(Object[] objectArray) {
        this.checkKeyType(objectArray);
        return this.dataMap.remove(Arrays.asList(objectArray));
    }

    @Override
    public void putAll(Map<?, ?> map) {
        CompositeData[] compositeDataArray;
        if (map == null || map.size() == 0) {
            return;
        }
        try {
            compositeDataArray = map.values().toArray(new CompositeData[map.size()]);
        }
        catch (ArrayStoreException arrayStoreException) {
            throw new ClassCastException("Map argument t contains values which are not instances of <tt>CompositeData</tt>");
        }
        this.putAll(compositeDataArray);
    }

    @Override
    public void putAll(CompositeData[] compositeDataArray) {
        int n;
        if (compositeDataArray == null || compositeDataArray.length == 0) {
            return;
        }
        ArrayList arrayList = new ArrayList(compositeDataArray.length + 1);
        for (n = 0; n < compositeDataArray.length; ++n) {
            List<?> list = this.checkValueAndIndex(compositeDataArray[n]);
            if (arrayList.contains(list)) {
                throw new KeyAlreadyExistsException("Argument elements values[" + n + "] and values[" + arrayList.indexOf(list) + "] have the same indexes, " + "calculated according to this TabularData instance's tabularType.");
            }
            arrayList.add(list);
        }
        for (n = 0; n < compositeDataArray.length; ++n) {
            this.dataMap.put(arrayList.get(n), compositeDataArray[n]);
        }
    }

    @Override
    public void clear() {
        this.dataMap.clear();
    }

    @Override
    public int size() {
        return this.dataMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<Object> keySet() {
        return this.dataMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.dataMap.values();
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        return this.dataMap.entrySet();
    }

    public Object clone() {
        try {
            TabularDataSupport tabularDataSupport = (TabularDataSupport)super.clone();
            tabularDataSupport.dataMap = new HashMap<Object, CompositeData>(tabularDataSupport.dataMap);
            return tabularDataSupport;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError(cloneNotSupportedException.toString());
        }
    }

    @Override
    public boolean equals(Object object) {
        TabularData tabularData;
        if (object == null) {
            return false;
        }
        try {
            tabularData = (TabularData)object;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        if (!this.getTabularType().equals(tabularData.getTabularType())) {
            return false;
        }
        if (this.size() != tabularData.size()) {
            return false;
        }
        for (CompositeData compositeData : this.values()) {
            if (tabularData.containsValue(compositeData)) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int n = 0;
        n += this.tabularType.hashCode();
        Iterator<Object> iterator = this.values().iterator();
        while (iterator.hasNext()) {
            n += ((Object)((CompositeData)iterator.next())).hashCode();
        }
        return n;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(tabularType=" + this.tabularType.toString() + ",contents=" + this.dataMap.toString() + ")";
    }

    private List<?> internalCalculateIndex(CompositeData compositeData) {
        return Collections.unmodifiableList(Arrays.asList(compositeData.getAll(this.indexNamesArray)));
    }

    private void checkKeyType(Object[] objectArray) {
        if (objectArray == null || objectArray.length == 0) {
            throw new NullPointerException("Argument key cannot be null or empty.");
        }
        if (objectArray.length != this.indexNamesArray.length) {
            throw new InvalidKeyException("Argument key's length=" + objectArray.length + " is different from the number of item values, which is " + this.indexNamesArray.length + ", specified for the indexing rows in this TabularData instance.");
        }
        for (int i = 0; i < objectArray.length; ++i) {
            OpenType<?> openType = this.tabularType.getRowType().getType(this.indexNamesArray[i]);
            if (objectArray[i] == null || openType.isValue(objectArray[i])) continue;
            throw new InvalidKeyException("Argument element key[" + i + "] is not a value for the open type expected for " + "this element of the index, whose name is \"" + this.indexNamesArray[i] + "\" and whose open type is " + openType);
        }
    }

    private void checkValueType(CompositeData compositeData) {
        if (compositeData == null) {
            throw new NullPointerException("Argument value cannot be null.");
        }
        if (!this.tabularType.getRowType().isValue(compositeData)) {
            throw new InvalidOpenTypeException("Argument value's composite type [" + compositeData.getCompositeType() + "] is not assignable to " + "this TabularData instance's row type [" + this.tabularType.getRowType() + "].");
        }
    }

    private List<?> checkValueAndIndex(CompositeData compositeData) {
        this.checkValueType(compositeData);
        List<?> list = this.internalCalculateIndex(compositeData);
        if (this.dataMap.containsKey(list)) {
            throw new KeyAlreadyExistsException("Argument value's index, calculated according to this TabularData instance's tabularType, already refers to a value in this table.");
        }
        return list;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        List<String> list = this.tabularType.getIndexNames();
        int n = list.size();
        SharedSecrets.getJavaOISAccess().checkArray(objectInputStream, String[].class, n);
        this.indexNamesArray = list.toArray(new String[n]);
    }
}

