/*
 * Decompiled with CFR 0.152.
 */
package javax.management.remote.rmi;

import com.sun.jmx.remote.internal.RMIExporter;
import com.sun.jmx.remote.util.EnvHelp;
import java.io.IOException;
import java.io.ObjectStreamClass;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.RemoteObject;
import java.rmi.server.UnicastRemoteObject;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.remote.rmi.RMIConnection;
import javax.management.remote.rmi.RMIConnectionImpl;
import javax.management.remote.rmi.RMIServer;
import javax.management.remote.rmi.RMIServerImpl;
import javax.security.auth.Subject;
import sun.reflect.misc.ReflectUtil;
import sun.rmi.server.DeserializationChecker;
import sun.rmi.server.UnicastServerRef;
import sun.rmi.server.UnicastServerRef2;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RMIJRMPServerImpl
extends RMIServerImpl {
    private final ExportedWrapper exportedWrapper;
    private final int port;
    private final RMIClientSocketFactory csf;
    private final RMIServerSocketFactory ssf;
    private final Map<String, ?> env;

    public RMIJRMPServerImpl(int n, RMIClientSocketFactory rMIClientSocketFactory, RMIServerSocketFactory rMIServerSocketFactory, Map<String, ?> map) throws IOException {
        super(map);
        if (n < 0) {
            throw new IllegalArgumentException("Negative port: " + n);
        }
        this.port = n;
        this.csf = rMIClientSocketFactory;
        this.ssf = rMIServerSocketFactory;
        this.env = map == null ? Collections.emptyMap() : map;
        String[] stringArray = (String[])this.env.get("jmx.remote.rmi.server.credential.types");
        ArrayList<String> arrayList = null;
        if (stringArray != null) {
            arrayList = new ArrayList<String>();
            for (String string : stringArray) {
                if (string == null) {
                    throw new IllegalArgumentException("A credential type is null.");
                }
                ReflectUtil.checkPackageAccess(string);
                arrayList.add(string);
            }
        }
        this.exportedWrapper = arrayList != null ? new ExportedWrapper(this, arrayList) : null;
    }

    @Override
    protected void export() throws IOException {
        if (this.exportedWrapper != null) {
            this.export(this.exportedWrapper);
        } else {
            this.export(this);
        }
    }

    private void export(Remote remote) throws RemoteException {
        RMIExporter rMIExporter = (RMIExporter)this.env.get("com.sun.jmx.remote.rmi.exporter");
        boolean bl = EnvHelp.isServerDaemon(this.env);
        if (bl && rMIExporter != null) {
            throw new IllegalArgumentException("If jmx.remote.x.daemon is specified as true, com.sun.jmx.remote.rmi.exporter cannot be used to specify an exporter!");
        }
        if (bl) {
            if (this.csf == null && this.ssf == null) {
                new UnicastServerRef(this.port).exportObject(remote, null, true);
            } else {
                new UnicastServerRef2(this.port, this.csf, this.ssf).exportObject(remote, null, true);
            }
        } else if (rMIExporter != null) {
            rMIExporter.exportObject(remote, this.port, this.csf, this.ssf);
        } else {
            UnicastRemoteObject.exportObject(remote, this.port, this.csf, this.ssf);
        }
    }

    private void unexport(Remote remote, boolean bl) throws NoSuchObjectException {
        RMIExporter rMIExporter = (RMIExporter)this.env.get("com.sun.jmx.remote.rmi.exporter");
        if (rMIExporter == null) {
            UnicastRemoteObject.unexportObject(remote, bl);
        } else {
            rMIExporter.unexportObject(remote, bl);
        }
    }

    @Override
    protected String getProtocol() {
        return "rmi";
    }

    @Override
    public Remote toStub() throws IOException {
        if (this.exportedWrapper != null) {
            return RemoteObject.toStub(this.exportedWrapper);
        }
        return RemoteObject.toStub(this);
    }

    @Override
    protected RMIConnection makeClient(String string, Subject subject) throws IOException {
        if (string == null) {
            throw new NullPointerException("Null connectionId");
        }
        RMIConnectionImpl rMIConnectionImpl = new RMIConnectionImpl(this, string, this.getDefaultClassLoader(), subject, this.env);
        this.export(rMIConnectionImpl);
        return rMIConnectionImpl;
    }

    @Override
    protected void closeClient(RMIConnection rMIConnection) throws IOException {
        this.unexport(rMIConnection, true);
    }

    @Override
    protected void closeServer() throws IOException {
        if (this.exportedWrapper != null) {
            this.unexport(this.exportedWrapper, true);
        } else {
            this.unexport(this, true);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class ExportedWrapper
    implements RMIServer,
    DeserializationChecker {
        private final RMIServer impl;
        private final List<String> allowedTypes;

        private ExportedWrapper(RMIServer rMIServer, List<String> list) {
            this.impl = rMIServer;
            this.allowedTypes = list;
        }

        @Override
        public String getVersion() throws RemoteException {
            return this.impl.getVersion();
        }

        @Override
        public RMIConnection newClient(Object object) throws IOException {
            return this.impl.newClient(object);
        }

        @Override
        public void check(Method method, ObjectStreamClass objectStreamClass, int n, int n2) {
            String string = objectStreamClass.getName();
            if (!this.allowedTypes.contains(string)) {
                throw new ClassCastException("Unsupported type: " + string);
            }
        }

        @Override
        public void checkProxyClass(Method method, String[] stringArray, int n, int n2) {
            if (stringArray != null && stringArray.length > 0) {
                for (String string : stringArray) {
                    if (this.allowedTypes.contains(string)) continue;
                    throw new ClassCastException("Unsupported type: " + string);
                }
            }
        }

        @Override
        public void end(int n) {
        }
    }
}

