/*
 * Decompiled with CFR 0.152.
 */
package javax.rmi.ssl;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.server.RMIServerSocketFactory;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;

public class SslRMIServerSocketFactory
implements RMIServerSocketFactory {
    private static SSLSocketFactory defaultSSLSocketFactory = null;
    private final String[] enabledCipherSuites;
    private final String[] enabledProtocols;
    private final boolean needClientAuth;
    private List<String> enabledCipherSuitesList;
    private List<String> enabledProtocolsList;

    public SslRMIServerSocketFactory() {
        this(null, null, false);
    }

    public SslRMIServerSocketFactory(String[] stringArray, String[] stringArray2, boolean bl) throws IllegalArgumentException {
        this.enabledCipherSuites = stringArray == null ? null : (String[])stringArray.clone();
        this.enabledProtocols = stringArray2 == null ? null : (String[])stringArray2.clone();
        this.needClientAuth = bl;
        SSLSocketFactory sSLSocketFactory = SslRMIServerSocketFactory.getDefaultSSLSocketFactory();
        SSLSocket sSLSocket = null;
        if (this.enabledCipherSuites != null || this.enabledProtocols != null) {
            try {
                sSLSocket = (SSLSocket)sSLSocketFactory.createSocket();
            }
            catch (Exception exception) {
                throw (IllegalArgumentException)new IllegalArgumentException("Unable to check if the cipher suites and protocols to enable are supported").initCause(exception);
            }
        }
        if (this.enabledCipherSuites != null) {
            sSLSocket.setEnabledCipherSuites(this.enabledCipherSuites);
            this.enabledCipherSuitesList = Arrays.asList(this.enabledCipherSuites);
        }
        if (this.enabledProtocols != null) {
            sSLSocket.setEnabledProtocols(this.enabledProtocols);
            this.enabledProtocolsList = Arrays.asList(this.enabledProtocols);
        }
    }

    public final String[] getEnabledCipherSuites() {
        return this.enabledCipherSuites == null ? null : (String[])this.enabledCipherSuites.clone();
    }

    public final String[] getEnabledProtocols() {
        return this.enabledProtocols == null ? null : (String[])this.enabledProtocols.clone();
    }

    public final boolean getNeedClientAuth() {
        return this.needClientAuth;
    }

    public ServerSocket createServerSocket(int n) throws IOException {
        final SSLSocketFactory sSLSocketFactory = SslRMIServerSocketFactory.getDefaultSSLSocketFactory();
        return new ServerSocket(n){

            public Socket accept() throws IOException {
                Socket socket = super.accept();
                SSLSocket sSLSocket = (SSLSocket)sSLSocketFactory.createSocket(socket, socket.getInetAddress().getHostName(), socket.getPort(), true);
                sSLSocket.setUseClientMode(false);
                if (SslRMIServerSocketFactory.this.enabledCipherSuites != null) {
                    sSLSocket.setEnabledCipherSuites(SslRMIServerSocketFactory.this.enabledCipherSuites);
                }
                if (SslRMIServerSocketFactory.this.enabledProtocols != null) {
                    sSLSocket.setEnabledProtocols(SslRMIServerSocketFactory.this.enabledProtocols);
                }
                sSLSocket.setNeedClientAuth(SslRMIServerSocketFactory.this.needClientAuth);
                return sSLSocket;
            }
        };
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (!(object instanceof SslRMIServerSocketFactory)) {
            return false;
        }
        SslRMIServerSocketFactory sslRMIServerSocketFactory = (SslRMIServerSocketFactory)object;
        return this.getClass().equals(sslRMIServerSocketFactory.getClass()) && this.checkParameters(sslRMIServerSocketFactory);
    }

    private boolean checkParameters(SslRMIServerSocketFactory sslRMIServerSocketFactory) {
        List<String> list;
        if (this.needClientAuth != sslRMIServerSocketFactory.needClientAuth) {
            return false;
        }
        if (this.enabledCipherSuites == null && sslRMIServerSocketFactory.enabledCipherSuites != null || this.enabledCipherSuites != null && sslRMIServerSocketFactory.enabledCipherSuites == null) {
            return false;
        }
        if (this.enabledCipherSuites != null && sslRMIServerSocketFactory.enabledCipherSuites != null && !((Object)this.enabledCipherSuitesList).equals(list = Arrays.asList(sslRMIServerSocketFactory.enabledCipherSuites))) {
            return false;
        }
        if (this.enabledProtocols == null && sslRMIServerSocketFactory.enabledProtocols != null || this.enabledProtocols != null && sslRMIServerSocketFactory.enabledProtocols == null) {
            return false;
        }
        return this.enabledProtocols == null || sslRMIServerSocketFactory.enabledProtocols == null || ((Object)this.enabledProtocolsList).equals(list = Arrays.asList(sslRMIServerSocketFactory.enabledProtocols));
    }

    public int hashCode() {
        return this.getClass().hashCode() + (this.needClientAuth ? Boolean.TRUE.hashCode() : Boolean.FALSE.hashCode()) + (this.enabledCipherSuites == null ? 0 : ((Object)this.enabledCipherSuitesList).hashCode()) + (this.enabledProtocols == null ? 0 : ((Object)this.enabledProtocolsList).hashCode());
    }

    private static synchronized SSLSocketFactory getDefaultSSLSocketFactory() {
        if (defaultSSLSocketFactory == null) {
            defaultSSLSocketFactory = (SSLSocketFactory)SSLSocketFactory.getDefault();
        }
        return defaultSSLSocketFactory;
    }
}

