/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleComponent;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleIcon;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.DefaultSingleSelectionModel;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.SingleSelectionModel;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.TabbedPaneUI;
import javax.swing.plaf.UIResource;
import sun.swing.SwingUtilities2;

public class JTabbedPane
extends JComponent
implements Serializable,
Accessible,
SwingConstants {
    public static final int WRAP_TAB_LAYOUT = 0;
    public static final int SCROLL_TAB_LAYOUT = 1;
    private static final String uiClassID = "TabbedPaneUI";
    protected int tabPlacement = 1;
    private int tabLayoutPolicy;
    protected SingleSelectionModel model;
    private boolean haveRegistered;
    protected ChangeListener changeListener = null;
    private final List<Page> pages;
    private Component visComp = null;
    protected transient ChangeEvent changeEvent = null;

    public JTabbedPane() {
        this(1, 0);
    }

    public JTabbedPane(int n) {
        this(n, 0);
    }

    public JTabbedPane(int n, int n2) {
        this.setTabPlacement(n);
        this.setTabLayoutPolicy(n2);
        this.pages = new ArrayList<Page>(1);
        this.setModel(new DefaultSingleSelectionModel());
        this.updateUI();
    }

    public TabbedPaneUI getUI() {
        return (TabbedPaneUI)this.ui;
    }

    public void setUI(TabbedPaneUI tabbedPaneUI) {
        super.setUI(tabbedPaneUI);
        for (int i = 0; i < this.getTabCount(); ++i) {
            Icon icon = this.pages.get((int)i).disabledIcon;
            if (!(icon instanceof UIResource)) continue;
            this.setDisabledIconAt(i, null);
        }
    }

    public void updateUI() {
        this.setUI((TabbedPaneUI)UIManager.getUI(this));
    }

    public String getUIClassID() {
        return uiClassID;
    }

    protected ChangeListener createChangeListener() {
        return new ModelListener();
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.listenerList.add(ChangeListener.class, changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.listenerList.remove(ChangeListener.class, changeListener);
    }

    public ChangeListener[] getChangeListeners() {
        return (ChangeListener[])this.listenerList.getListeners(ChangeListener.class);
    }

    protected void fireStateChanged() {
        int n;
        Object[] objectArray;
        int n2 = this.getSelectedIndex();
        if (n2 < 0) {
            if (this.visComp != null && this.visComp.isVisible()) {
                this.visComp.setVisible(false);
            }
            this.visComp = null;
        } else {
            objectArray = this.getComponentAt(n2);
            if (objectArray != null && objectArray != this.visComp) {
                n = 0;
                if (this.visComp != null) {
                    int n3 = n = SwingUtilities.findFocusOwner(this.visComp) != null ? 1 : 0;
                    if (this.visComp.isVisible()) {
                        this.visComp.setVisible(false);
                    }
                }
                if (!objectArray.isVisible()) {
                    objectArray.setVisible(true);
                }
                if (n != 0) {
                    SwingUtilities2.tabbedPaneChangeFocusTo((Component)objectArray);
                }
                this.visComp = objectArray;
            }
        }
        objectArray = this.listenerList.getListenerList();
        for (n = objectArray.length - 2; n >= 0; n -= 2) {
            if (objectArray[n] != ChangeListener.class) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)objectArray[n + 1]).stateChanged(this.changeEvent);
        }
    }

    public SingleSelectionModel getModel() {
        return this.model;
    }

    public void setModel(SingleSelectionModel singleSelectionModel) {
        SingleSelectionModel singleSelectionModel2 = this.getModel();
        if (singleSelectionModel2 != null) {
            singleSelectionModel2.removeChangeListener(this.changeListener);
            this.changeListener = null;
        }
        this.model = singleSelectionModel;
        if (singleSelectionModel != null) {
            this.changeListener = this.createChangeListener();
            singleSelectionModel.addChangeListener(this.changeListener);
        }
        this.firePropertyChange("model", singleSelectionModel2, singleSelectionModel);
        this.repaint();
    }

    public int getTabPlacement() {
        return this.tabPlacement;
    }

    public void setTabPlacement(int n) {
        if (n != 1 && n != 2 && n != 3 && n != 4) {
            throw new IllegalArgumentException("illegal tab placement: must be TOP, BOTTOM, LEFT, or RIGHT");
        }
        if (this.tabPlacement != n) {
            int n2 = this.tabPlacement;
            this.tabPlacement = n;
            this.firePropertyChange("tabPlacement", n2, n);
            this.revalidate();
            this.repaint();
        }
    }

    public int getTabLayoutPolicy() {
        return this.tabLayoutPolicy;
    }

    public void setTabLayoutPolicy(int n) {
        if (n != 0 && n != 1) {
            throw new IllegalArgumentException("illegal tab layout policy: must be WRAP_TAB_LAYOUT or SCROLL_TAB_LAYOUT");
        }
        if (this.tabLayoutPolicy != n) {
            int n2 = this.tabLayoutPolicy;
            this.tabLayoutPolicy = n;
            this.firePropertyChange("tabLayoutPolicy", n2, n);
            this.revalidate();
            this.repaint();
        }
    }

    public int getSelectedIndex() {
        return this.model.getSelectedIndex();
    }

    public void setSelectedIndex(int n) {
        if (n != -1) {
            this.checkIndex(n);
        }
        this.setSelectedIndexImpl(n, true);
    }

    private void setSelectedIndexImpl(int n, boolean bl) {
        int n2 = this.model.getSelectedIndex();
        Page page = null;
        Page page2 = null;
        String string = null;
        boolean bl2 = bl = bl && n2 != n;
        if (bl) {
            if (this.accessibleContext != null) {
                string = this.accessibleContext.getAccessibleName();
            }
            if (n2 >= 0) {
                page = this.pages.get(n2);
            }
            if (n >= 0) {
                page2 = this.pages.get(n);
            }
        }
        this.model.setSelectedIndex(n);
        if (bl) {
            this.changeAccessibleSelection(page, string, page2);
        }
    }

    private void changeAccessibleSelection(Page page, String string, Page page2) {
        if (this.accessibleContext == null) {
            return;
        }
        if (page != null) {
            page.firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
        }
        if (page2 != null) {
            page2.firePropertyChange("AccessibleState", null, AccessibleState.SELECTED);
        }
        this.accessibleContext.firePropertyChange("AccessibleName", string, this.accessibleContext.getAccessibleName());
    }

    public Component getSelectedComponent() {
        int n = this.getSelectedIndex();
        if (n == -1) {
            return null;
        }
        return this.getComponentAt(n);
    }

    public void setSelectedComponent(Component component) {
        int n = this.indexOfComponent(component);
        if (n == -1) {
            throw new IllegalArgumentException("component not found in tabbed pane");
        }
        this.setSelectedIndex(n);
    }

    public void insertTab(String string, Icon icon, Component component, String string2, int n) {
        int n2 = n;
        int n3 = this.indexOfComponent(component);
        if (component != null && n3 != -1) {
            this.removeTabAt(n3);
            if (n2 > n3) {
                --n2;
            }
        }
        int n4 = this.getSelectedIndex();
        this.pages.add(n2, new Page(this, string != null ? string : "", icon, null, component, string2));
        if (component != null) {
            this.addImpl(component, null, -1);
            component.setVisible(false);
        } else {
            this.firePropertyChange("indexForNullComponent", -1, n);
        }
        if (this.pages.size() == 1) {
            this.setSelectedIndex(0);
        }
        if (n4 >= n2) {
            this.setSelectedIndexImpl(n4 + 1, false);
        }
        if (!this.haveRegistered && string2 != null) {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.haveRegistered = true;
        }
        if (this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", null, component);
        }
        this.revalidate();
        this.repaint();
    }

    public void addTab(String string, Icon icon, Component component, String string2) {
        this.insertTab(string, icon, component, string2, this.pages.size());
    }

    public void addTab(String string, Icon icon, Component component) {
        this.insertTab(string, icon, component, null, this.pages.size());
    }

    public void addTab(String string, Component component) {
        this.insertTab(string, null, component, null, this.pages.size());
    }

    public Component add(Component component) {
        if (!(component instanceof UIResource)) {
            this.addTab(component.getName(), component);
        } else {
            super.add(component);
        }
        return component;
    }

    public Component add(String string, Component component) {
        if (!(component instanceof UIResource)) {
            this.addTab(string, component);
        } else {
            super.add(string, component);
        }
        return component;
    }

    public Component add(Component component, int n) {
        if (!(component instanceof UIResource)) {
            this.insertTab(component.getName(), null, component, null, n == -1 ? this.getTabCount() : n);
        } else {
            super.add(component, n);
        }
        return component;
    }

    public void add(Component component, Object object) {
        if (!(component instanceof UIResource)) {
            if (object instanceof String) {
                this.addTab((String)object, component);
            } else if (object instanceof Icon) {
                this.addTab(null, (Icon)object, component);
            } else {
                this.add(component);
            }
        } else {
            super.add(component, object);
        }
    }

    public void add(Component component, Object object, int n) {
        if (!(component instanceof UIResource)) {
            Icon icon = object instanceof Icon ? (Icon)object : null;
            String string = object instanceof String ? (String)object : null;
            this.insertTab(string, icon, component, null, n == -1 ? this.getTabCount() : n);
        } else {
            super.add(component, object, n);
        }
    }

    public void removeTabAt(int n) {
        Component[] componentArray;
        this.checkIndex(n);
        Component component = this.getComponentAt(n);
        boolean bl = false;
        int n2 = this.getSelectedIndex();
        String string = null;
        if (component == this.visComp) {
            bl = SwingUtilities.findFocusOwner(this.visComp) != null;
            this.visComp = null;
        }
        if (this.accessibleContext != null) {
            if (n == n2) {
                this.pages.get(n).firePropertyChange("AccessibleState", AccessibleState.SELECTED, null);
                string = this.accessibleContext.getAccessibleName();
            }
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", component, null);
        }
        this.setTabComponentAt(n, null);
        this.pages.remove(n);
        this.putClientProperty("__index_to_remove__", new Integer(n));
        if (n2 > n) {
            this.setSelectedIndexImpl(n2 - 1, false);
        } else if (n2 >= this.getTabCount()) {
            this.setSelectedIndexImpl(n2 - 1, false);
            componentArray = n2 != 0 ? this.pages.get(n2 - 1) : null;
            this.changeAccessibleSelection(null, string, (Page)componentArray);
        } else if (n == n2) {
            this.fireStateChanged();
            this.changeAccessibleSelection(null, string, this.pages.get(n));
        }
        if (component != null) {
            componentArray = this.getComponents();
            int n3 = componentArray.length;
            while (--n3 >= 0) {
                if (componentArray[n3] != component) continue;
                super.remove(n3);
                component.setVisible(true);
                break;
            }
        }
        if (bl) {
            SwingUtilities2.tabbedPaneChangeFocusTo(this.getSelectedComponent());
        }
        this.revalidate();
        this.repaint();
    }

    public void remove(Component component) {
        int n = this.indexOfComponent(component);
        if (n != -1) {
            this.removeTabAt(n);
        } else {
            Component[] componentArray = this.getComponents();
            for (int i = 0; i < componentArray.length; ++i) {
                if (component != componentArray[i]) continue;
                super.remove(i);
                break;
            }
        }
    }

    public void remove(int n) {
        this.removeTabAt(n);
    }

    public void removeAll() {
        this.setSelectedIndexImpl(-1, true);
        int n = this.getTabCount();
        while (n-- > 0) {
            this.removeTabAt(n);
        }
    }

    public int getTabCount() {
        return this.pages.size();
    }

    public int getTabRunCount() {
        if (this.ui != null) {
            return ((TabbedPaneUI)this.ui).getTabRunCount(this);
        }
        return 0;
    }

    public String getTitleAt(int n) {
        return this.pages.get((int)n).title;
    }

    public Icon getIconAt(int n) {
        return this.pages.get((int)n).icon;
    }

    public Icon getDisabledIconAt(int n) {
        Page page = this.pages.get(n);
        if (page.disabledIcon == null) {
            page.disabledIcon = UIManager.getLookAndFeel().getDisabledIcon(this, page.icon);
        }
        return page.disabledIcon;
    }

    public String getToolTipTextAt(int n) {
        return this.pages.get((int)n).tip;
    }

    public Color getBackgroundAt(int n) {
        return this.pages.get(n).getBackground();
    }

    public Color getForegroundAt(int n) {
        return this.pages.get(n).getForeground();
    }

    public boolean isEnabledAt(int n) {
        return this.pages.get(n).isEnabled();
    }

    public Component getComponentAt(int n) {
        return this.pages.get((int)n).component;
    }

    public int getMnemonicAt(int n) {
        this.checkIndex(n);
        Page page = this.pages.get(n);
        return page.getMnemonic();
    }

    public int getDisplayedMnemonicIndexAt(int n) {
        this.checkIndex(n);
        Page page = this.pages.get(n);
        return page.getDisplayedMnemonicIndex();
    }

    public Rectangle getBoundsAt(int n) {
        this.checkIndex(n);
        if (this.ui != null) {
            return ((TabbedPaneUI)this.ui).getTabBounds(this, n);
        }
        return null;
    }

    public void setTitleAt(int n, String string) {
        Page page = this.pages.get(n);
        String string2 = page.title;
        page.title = string;
        if (string2 != string) {
            this.firePropertyChange("indexForTitle", -1, n);
        }
        page.updateDisplayedMnemonicIndex();
        if (string2 != string && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        if (string == null || string2 == null || !string.equals(string2)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setIconAt(int n, Icon icon) {
        Page page = this.pages.get(n);
        Icon icon2 = page.icon;
        if (icon != icon2) {
            page.icon = icon;
            if (page.disabledIcon instanceof UIResource) {
                page.disabledIcon = null;
            }
            if (this.accessibleContext != null) {
                this.accessibleContext.firePropertyChange("AccessibleVisibleData", icon2, icon);
            }
            this.revalidate();
            this.repaint();
        }
    }

    public void setDisabledIconAt(int n, Icon icon) {
        Icon icon2 = this.pages.get((int)n).disabledIcon;
        this.pages.get((int)n).disabledIcon = icon;
        if (icon != icon2 && !this.isEnabledAt(n)) {
            this.revalidate();
            this.repaint();
        }
    }

    public void setToolTipTextAt(int n, String string) {
        String string2 = this.pages.get((int)n).tip;
        this.pages.get((int)n).tip = string;
        if (string2 != string && this.accessibleContext != null) {
            this.accessibleContext.firePropertyChange("AccessibleVisibleData", string2, string);
        }
        if (!this.haveRegistered && string != null) {
            ToolTipManager.sharedInstance().registerComponent(this);
            this.haveRegistered = true;
        }
    }

    public void setBackgroundAt(int n, Color color) {
        Rectangle rectangle;
        Color color2 = this.pages.get((int)n).background;
        this.pages.get(n).setBackground(color);
        if (!(color != null && color2 != null && color.equals(color2) || (rectangle = this.getBoundsAt(n)) == null)) {
            this.repaint(rectangle);
        }
    }

    public void setForegroundAt(int n, Color color) {
        Rectangle rectangle;
        Color color2 = this.pages.get((int)n).foreground;
        this.pages.get(n).setForeground(color);
        if (!(color != null && color2 != null && color.equals(color2) || (rectangle = this.getBoundsAt(n)) == null)) {
            this.repaint(rectangle);
        }
    }

    public void setEnabledAt(int n, boolean bl) {
        boolean bl2 = this.pages.get(n).isEnabled();
        this.pages.get(n).setEnabled(bl);
        if (bl != bl2) {
            this.revalidate();
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setComponentAt(int n, Component component) {
        Page page = this.pages.get(n);
        if (component != page.component) {
            boolean bl;
            boolean bl2 = false;
            if (page.component != null) {
                bl2 = SwingUtilities.findFocusOwner(page.component) != null;
                Object object = this.getTreeLock();
                synchronized (object) {
                    int n2 = this.getComponentCount();
                    Component[] componentArray = this.getComponents();
                    for (int i = 0; i < n2; ++i) {
                        if (componentArray[i] != page.component) continue;
                        super.remove(i);
                    }
                }
            }
            page.component = component;
            boolean bl3 = bl = this.getSelectedIndex() == n;
            if (bl) {
                this.visComp = component;
            }
            if (component != null) {
                component.setVisible(bl);
                this.addImpl(component, null, -1);
                if (bl2) {
                    SwingUtilities2.tabbedPaneChangeFocusTo(component);
                }
            } else {
                this.repaint();
            }
            this.revalidate();
        }
    }

    public void setDisplayedMnemonicIndexAt(int n, int n2) {
        this.checkIndex(n);
        Page page = this.pages.get(n);
        page.setDisplayedMnemonicIndex(n2);
    }

    public void setMnemonicAt(int n, int n2) {
        this.checkIndex(n);
        Page page = this.pages.get(n);
        page.setMnemonic(n2);
        this.firePropertyChange("mnemonicAt", null, null);
    }

    public int indexOfTab(String string) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            if (!this.getTitleAt(i).equals(string == null ? "" : string)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfTab(Icon icon) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Icon icon2 = this.getIconAt(i);
            if ((icon2 == null || !icon2.equals(icon)) && (icon2 != null || icon2 != icon)) continue;
            return i;
        }
        return -1;
    }

    public int indexOfComponent(Component component) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component component2 = this.getComponentAt(i);
            if ((component2 == null || !component2.equals(component)) && (component2 != null || component2 != component)) continue;
            return i;
        }
        return -1;
    }

    public int indexAtLocation(int n, int n2) {
        if (this.ui != null) {
            return ((TabbedPaneUI)this.ui).tabForCoordinate(this, n, n2);
        }
        return -1;
    }

    public String getToolTipText(MouseEvent mouseEvent) {
        int n;
        if (this.ui != null && (n = ((TabbedPaneUI)this.ui).tabForCoordinate(this, mouseEvent.getX(), mouseEvent.getY())) != -1) {
            return this.pages.get((int)n).tip;
        }
        return super.getToolTipText(mouseEvent);
    }

    private void checkIndex(int n) {
        if (n < 0 || n >= this.pages.size()) {
            throw new IndexOutOfBoundsException("Index: " + n + ", Tab count: " + this.pages.size());
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        if (this.getUIClassID().equals(uiClassID)) {
            byte by = JComponent.getWriteObjCounter(this);
            by = (byte)(by - 1);
            JComponent.setWriteObjCounter(this, by);
            if (by == 0 && this.ui != null) {
                this.ui.installUI(this);
            }
        }
    }

    void compWriteObjectNotify() {
        super.compWriteObjectNotify();
        if (this.getToolTipText() == null && this.haveRegistered) {
            ToolTipManager.sharedInstance().unregisterComponent(this);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        if (this.ui != null && this.getUIClassID().equals(uiClassID)) {
            this.ui.installUI(this);
        }
        if (this.getToolTipText() == null && this.haveRegistered) {
            ToolTipManager.sharedInstance().registerComponent(this);
        }
    }

    protected String paramString() {
        String string = this.tabPlacement == 1 ? "TOP" : (this.tabPlacement == 3 ? "BOTTOM" : (this.tabPlacement == 2 ? "LEFT" : (this.tabPlacement == 4 ? "RIGHT" : "")));
        String string2 = this.haveRegistered ? "true" : "false";
        return super.paramString() + ",haveRegistered=" + string2 + ",tabPlacement=" + string;
    }

    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new AccessibleJTabbedPane();
            int n = this.getTabCount();
            for (int i = 0; i < n; ++i) {
                this.pages.get(i).initAccessibleContext();
            }
        }
        return this.accessibleContext;
    }

    public void setTabComponentAt(int n, Component component) {
        if (component != null && this.indexOfComponent(component) != -1) {
            throw new IllegalArgumentException("Component is already added to this JTabbedPane");
        }
        Component component2 = this.getTabComponentAt(n);
        if (component != component2) {
            int n2 = this.indexOfTabComponent(component);
            if (n2 != -1) {
                this.setTabComponentAt(n2, null);
            }
            this.pages.get((int)n).tabComponent = component;
            this.firePropertyChange("indexForTabComponent", -1, n);
        }
    }

    public Component getTabComponentAt(int n) {
        return this.pages.get((int)n).tabComponent;
    }

    public int indexOfTabComponent(Component component) {
        for (int i = 0; i < this.getTabCount(); ++i) {
            Component component2 = this.getTabComponentAt(i);
            if (component2 != component) continue;
            return i;
        }
        return -1;
    }

    private class Page
    extends AccessibleContext
    implements Serializable,
    Accessible,
    AccessibleComponent {
        String title;
        Color background;
        Color foreground;
        Icon icon;
        Icon disabledIcon;
        JTabbedPane parent;
        Component component;
        String tip;
        boolean enabled = true;
        boolean needsUIUpdate;
        int mnemonic = -1;
        int mnemonicIndex = -1;
        Component tabComponent;

        Page(JTabbedPane jTabbedPane2, String string, Icon icon, Icon icon2, Component component, String string2) {
            this.title = string;
            this.icon = icon;
            this.disabledIcon = icon2;
            this.parent = jTabbedPane2;
            this.setAccessibleParent(jTabbedPane2);
            this.component = component;
            this.tip = string2;
            this.initAccessibleContext();
        }

        void initAccessibleContext() {
            AccessibleContext accessibleContext;
            if (JTabbedPane.this.accessibleContext != null && this.component instanceof Accessible && (accessibleContext = this.component.getAccessibleContext()) != null) {
                accessibleContext.setAccessibleParent(this);
            }
        }

        void setMnemonic(int n) {
            this.mnemonic = n;
            this.updateDisplayedMnemonicIndex();
        }

        int getMnemonic() {
            return this.mnemonic;
        }

        void setDisplayedMnemonicIndex(int n) {
            if (this.mnemonicIndex != n) {
                if (n != -1 && (this.title == null || n < 0 || n >= this.title.length())) {
                    throw new IllegalArgumentException("Invalid mnemonic index: " + n);
                }
                this.mnemonicIndex = n;
                JTabbedPane.this.firePropertyChange("displayedMnemonicIndexAt", null, null);
            }
        }

        int getDisplayedMnemonicIndex() {
            return this.mnemonicIndex;
        }

        void updateDisplayedMnemonicIndex() {
            this.setDisplayedMnemonicIndex(SwingUtilities.findDisplayedMnemonicIndex(this.title, this.mnemonic));
        }

        public AccessibleContext getAccessibleContext() {
            return this;
        }

        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            if (this.title != null) {
                return this.title;
            }
            return null;
        }

        public String getAccessibleDescription() {
            if (this.accessibleDescription != null) {
                return this.accessibleDescription;
            }
            if (this.tip != null) {
                return this.tip;
            }
            return null;
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB;
        }

        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet accessibleStateSet = this.parent.getAccessibleContext().getAccessibleStateSet();
            accessibleStateSet.add(AccessibleState.SELECTABLE);
            int n = this.parent.indexOfTab(this.title);
            if (n == this.parent.getSelectedIndex()) {
                accessibleStateSet.add(AccessibleState.SELECTED);
            }
            return accessibleStateSet;
        }

        public int getAccessibleIndexInParent() {
            return this.parent.indexOfTab(this.title);
        }

        public int getAccessibleChildrenCount() {
            if (this.component instanceof Accessible) {
                return 1;
            }
            return 0;
        }

        public Accessible getAccessibleChild(int n) {
            if (this.component instanceof Accessible) {
                return (Accessible)((Object)this.component);
            }
            return null;
        }

        public Locale getLocale() {
            return this.parent.getLocale();
        }

        public AccessibleComponent getAccessibleComponent() {
            return this;
        }

        public Color getBackground() {
            return this.background != null ? this.background : this.parent.getBackground();
        }

        public void setBackground(Color color) {
            this.background = color;
        }

        public Color getForeground() {
            return this.foreground != null ? this.foreground : this.parent.getForeground();
        }

        public void setForeground(Color color) {
            this.foreground = color;
        }

        public Cursor getCursor() {
            return this.parent.getCursor();
        }

        public void setCursor(Cursor cursor) {
            this.parent.setCursor(cursor);
        }

        public Font getFont() {
            return this.parent.getFont();
        }

        public void setFont(Font font) {
            this.parent.setFont(font);
        }

        public FontMetrics getFontMetrics(Font font) {
            return this.parent.getFontMetrics(font);
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean bl) {
            this.enabled = bl;
        }

        public boolean isVisible() {
            return this.parent.isVisible();
        }

        public void setVisible(boolean bl) {
            this.parent.setVisible(bl);
        }

        public boolean isShowing() {
            return this.parent.isShowing();
        }

        public boolean contains(Point point) {
            Rectangle rectangle = this.getBounds();
            return rectangle.contains(point);
        }

        public Point getLocationOnScreen() {
            Point point = this.parent.getLocationOnScreen();
            Point point2 = this.getLocation();
            point2.translate(point.x, point.y);
            return point2;
        }

        public Point getLocation() {
            Rectangle rectangle = this.getBounds();
            return new Point(rectangle.x, rectangle.y);
        }

        public void setLocation(Point point) {
        }

        public Rectangle getBounds() {
            return this.parent.getUI().getTabBounds(this.parent, this.parent.indexOfTab(this.title));
        }

        public void setBounds(Rectangle rectangle) {
        }

        public Dimension getSize() {
            Rectangle rectangle = this.getBounds();
            return new Dimension(rectangle.width, rectangle.height);
        }

        public void setSize(Dimension dimension) {
        }

        public Accessible getAccessibleAt(Point point) {
            if (this.component instanceof Accessible) {
                return (Accessible)((Object)this.component);
            }
            return null;
        }

        public boolean isFocusTraversable() {
            return false;
        }

        public void requestFocus() {
        }

        public void addFocusListener(FocusListener focusListener) {
        }

        public void removeFocusListener(FocusListener focusListener) {
        }

        public AccessibleIcon[] getAccessibleIcon() {
            AccessibleIcon[] accessibleIconArray;
            AccessibleIcon accessibleIcon = null;
            if (this.enabled && this.icon instanceof ImageIcon) {
                accessibleIconArray = ((ImageIcon)this.icon).getAccessibleContext();
                accessibleIcon = (AccessibleIcon)accessibleIconArray;
            } else if (!this.enabled && this.disabledIcon instanceof ImageIcon) {
                accessibleIconArray = ((ImageIcon)this.disabledIcon).getAccessibleContext();
                accessibleIcon = (AccessibleIcon)accessibleIconArray;
            }
            if (accessibleIcon != null) {
                accessibleIconArray = new AccessibleIcon[]{accessibleIcon};
                return accessibleIconArray;
            }
            return null;
        }
    }

    protected class AccessibleJTabbedPane
    extends JComponent.AccessibleJComponent
    implements AccessibleSelection,
    ChangeListener {
        public String getAccessibleName() {
            if (this.accessibleName != null) {
                return this.accessibleName;
            }
            String string = (String)JTabbedPane.this.getClientProperty("AccessibleName");
            if (string != null) {
                return string;
            }
            int n = JTabbedPane.this.getSelectedIndex();
            if (n >= 0) {
                return ((Page)JTabbedPane.this.pages.get(n)).getAccessibleName();
            }
            return super.getAccessibleName();
        }

        public AccessibleJTabbedPane() {
            super(JTabbedPane.this);
            JTabbedPane.this.model.addChangeListener(this);
        }

        public void stateChanged(ChangeEvent changeEvent) {
            Object object = changeEvent.getSource();
            this.firePropertyChange("AccessibleSelection", null, object);
        }

        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.PAGE_TAB_LIST;
        }

        public int getAccessibleChildrenCount() {
            return JTabbedPane.this.getTabCount();
        }

        public Accessible getAccessibleChild(int n) {
            if (n < 0 || n >= JTabbedPane.this.getTabCount()) {
                return null;
            }
            return (Accessible)JTabbedPane.this.pages.get(n);
        }

        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        public Accessible getAccessibleAt(Point point) {
            int n = ((TabbedPaneUI)JTabbedPane.this.ui).tabForCoordinate(JTabbedPane.this, point.x, point.y);
            if (n == -1) {
                n = JTabbedPane.this.getSelectedIndex();
            }
            return this.getAccessibleChild(n);
        }

        public int getAccessibleSelectionCount() {
            return 1;
        }

        public Accessible getAccessibleSelection(int n) {
            int n2 = JTabbedPane.this.getSelectedIndex();
            if (n2 == -1) {
                return null;
            }
            return (Accessible)JTabbedPane.this.pages.get(n2);
        }

        public boolean isAccessibleChildSelected(int n) {
            return n == JTabbedPane.this.getSelectedIndex();
        }

        public void addAccessibleSelection(int n) {
            JTabbedPane.this.setSelectedIndex(n);
        }

        public void removeAccessibleSelection(int n) {
        }

        public void clearAccessibleSelection() {
        }

        public void selectAllAccessibleSelection() {
        }
    }

    protected class ModelListener
    implements ChangeListener,
    Serializable {
        protected ModelListener() {
        }

        public void stateChanged(ChangeEvent changeEvent) {
            JTabbedPane.this.fireStateChanged();
        }
    }
}

