/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.Window;
import java.awt.event.KeyEvent;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.JMenuBar;
import javax.swing.KeyStroke;
import sun.awt.AWTAccessor;
import sun.awt.EmbeddedFrame;

class KeyboardManager {
    static KeyboardManager currentManager = new KeyboardManager();
    Hashtable<Container, Hashtable> containerMap = new Hashtable();
    Hashtable<ComponentKeyStrokePair, Container> componentKeyStrokeMap = new Hashtable();

    KeyboardManager() {
    }

    public static KeyboardManager getCurrentManager() {
        return currentManager;
    }

    public static void setCurrentManager(KeyboardManager keyboardManager) {
        currentManager = keyboardManager;
    }

    public void registerKeyStroke(KeyStroke keyStroke, JComponent jComponent) {
        Object v;
        Container container = KeyboardManager.getTopAncestor(jComponent);
        if (container == null) {
            return;
        }
        Hashtable hashtable = this.containerMap.get(container);
        if (hashtable == null) {
            hashtable = this.registerNewTopContainer(container);
        }
        if ((v = hashtable.get(keyStroke)) == null) {
            hashtable.put(keyStroke, jComponent);
        } else if (v instanceof Vector) {
            Vector vector = (Vector)v;
            if (!vector.contains(jComponent)) {
                vector.addElement(jComponent);
            }
        } else if (v instanceof JComponent) {
            if (v != jComponent) {
                Vector<JComponent> vector = new Vector<JComponent>();
                vector.addElement((JComponent)v);
                vector.addElement(jComponent);
                hashtable.put(keyStroke, vector);
            }
        } else {
            System.out.println("Unexpected condition in registerKeyStroke");
            Thread.dumpStack();
        }
        this.componentKeyStrokeMap.put(new ComponentKeyStrokePair(jComponent, keyStroke), container);
        if (container instanceof EmbeddedFrame) {
            ((EmbeddedFrame)container).registerAccelerator(keyStroke);
        }
    }

    private static Container getTopAncestor(JComponent jComponent) {
        for (Container container = jComponent.getParent(); container != null; container = container.getParent()) {
            if ((!(container instanceof Window) || !((Window)container).isFocusableWindow()) && !(container instanceof Applet) && !(container instanceof JInternalFrame)) continue;
            return container;
        }
        return null;
    }

    public void unregisterKeyStroke(KeyStroke keyStroke, JComponent jComponent) {
        ComponentKeyStrokePair componentKeyStrokePair = new ComponentKeyStrokePair(jComponent, keyStroke);
        Container container = this.componentKeyStrokeMap.get(componentKeyStrokePair);
        if (container == null) {
            return;
        }
        Hashtable hashtable = this.containerMap.get(container);
        if (hashtable == null) {
            Thread.dumpStack();
            return;
        }
        Object v = hashtable.get(keyStroke);
        if (v == null) {
            Thread.dumpStack();
            return;
        }
        if (v instanceof JComponent && v == jComponent) {
            hashtable.remove(keyStroke);
        } else if (v instanceof Vector) {
            Vector vector = (Vector)v;
            vector.removeElement(jComponent);
            if (vector.isEmpty()) {
                hashtable.remove(keyStroke);
            }
        }
        if (hashtable.isEmpty()) {
            this.containerMap.remove(container);
        }
        this.componentKeyStrokeMap.remove(componentKeyStrokePair);
        if (container instanceof EmbeddedFrame) {
            ((EmbeddedFrame)container).unregisterAccelerator(keyStroke);
        }
    }

    public boolean fireKeyboardAction(KeyEvent keyEvent, boolean bl, Container container) {
        Object object;
        Vector vector;
        KeyStroke keyStroke;
        if (keyEvent.isConsumed()) {
            System.out.println("Aquired pre-used event!");
            Thread.dumpStack();
        }
        KeyStroke keyStroke2 = null;
        if (keyEvent.getID() == 400) {
            keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyChar());
        } else {
            int n = AWTAccessor.getKeyEventAccessor().getExtendedKeyCode(keyEvent);
            if (keyEvent.getKeyCode() != n) {
                keyStroke2 = KeyStroke.getKeyStroke(n, keyEvent.getModifiers(), !bl);
            }
            keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers(), !bl);
        }
        Hashtable hashtable = this.containerMap.get(container);
        if (hashtable != null) {
            vector = null;
            if (keyStroke2 != null && (vector = (Vector)hashtable.get(keyStroke2)) != null) {
                keyStroke = keyStroke2;
            }
            if (vector == null) {
                vector = (Vector)hashtable.get(keyStroke);
            }
            if (vector != null) {
                if (vector instanceof JComponent) {
                    object = (JComponent)((Object)vector);
                    if (((Component)object).isShowing() && ((Component)object).isEnabled()) {
                        this.fireBinding((JComponent)object, keyStroke, keyEvent, bl);
                    }
                } else if (vector instanceof Vector) {
                    object = vector;
                    for (int i = ((Vector)object).size() - 1; i >= 0; --i) {
                        JComponent jComponent = (JComponent)((Vector)object).elementAt(i);
                        if (!jComponent.isShowing() || !jComponent.isEnabled()) continue;
                        this.fireBinding(jComponent, keyStroke, keyEvent, bl);
                        if (!keyEvent.isConsumed()) continue;
                        return true;
                    }
                } else {
                    System.out.println("Unexpected condition in fireKeyboardAction " + vector);
                    Thread.dumpStack();
                }
            }
        }
        if (keyEvent.isConsumed()) {
            return true;
        }
        if (hashtable != null && (vector = (Vector)hashtable.get(JMenuBar.class)) != null) {
            object = vector.elements();
            while (object.hasMoreElements()) {
                JMenuBar jMenuBar = (JMenuBar)object.nextElement();
                if (!jMenuBar.isShowing() || !jMenuBar.isEnabled()) continue;
                if (!keyStroke.equals(keyStroke2)) {
                    this.fireBinding(jMenuBar, keyStroke2, keyEvent, bl);
                }
                if (keyStroke.equals(keyStroke2) || !keyEvent.isConsumed()) {
                    this.fireBinding(jMenuBar, keyStroke, keyEvent, bl);
                }
                if (!keyEvent.isConsumed()) continue;
                return true;
            }
        }
        return keyEvent.isConsumed();
    }

    void fireBinding(JComponent jComponent, KeyStroke keyStroke, KeyEvent keyEvent, boolean bl) {
        if (jComponent.processKeyBinding(keyStroke, keyEvent, 2, bl)) {
            keyEvent.consume();
        }
    }

    public void registerMenuBar(JMenuBar jMenuBar) {
        Vector<JMenuBar> vector;
        Container container = KeyboardManager.getTopAncestor(jMenuBar);
        if (container == null) {
            return;
        }
        Hashtable hashtable = this.containerMap.get(container);
        if (hashtable == null) {
            hashtable = this.registerNewTopContainer(container);
        }
        if ((vector = (Vector<JMenuBar>)hashtable.get(JMenuBar.class)) == null) {
            vector = new Vector<JMenuBar>();
            hashtable.put(JMenuBar.class, vector);
        }
        if (!vector.contains(jMenuBar)) {
            vector.addElement(jMenuBar);
        }
    }

    public void unregisterMenuBar(JMenuBar jMenuBar) {
        Vector vector;
        Container container = KeyboardManager.getTopAncestor(jMenuBar);
        if (container == null) {
            return;
        }
        Hashtable hashtable = this.containerMap.get(container);
        if (hashtable != null && (vector = (Vector)hashtable.get(JMenuBar.class)) != null) {
            vector.removeElement(jMenuBar);
            if (vector.isEmpty()) {
                hashtable.remove(JMenuBar.class);
                if (hashtable.isEmpty()) {
                    this.containerMap.remove(container);
                }
            }
        }
    }

    protected Hashtable registerNewTopContainer(Container container) {
        Hashtable hashtable = new Hashtable();
        this.containerMap.put(container, hashtable);
        return hashtable;
    }

    class ComponentKeyStrokePair {
        Object component;
        Object keyStroke;

        public ComponentKeyStrokePair(Object object, Object object2) {
            this.component = object;
            this.keyStroke = object2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof ComponentKeyStrokePair)) {
                return false;
            }
            ComponentKeyStrokePair componentKeyStrokePair = (ComponentKeyStrokePair)object;
            return this.component.equals(componentKeyStrokePair.component) && this.keyStroke.equals(componentKeyStrokePair.keyStroke);
        }

        public int hashCode() {
            return this.component.hashCode() * this.keyStroke.hashCode();
        }
    }
}

