/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.Window;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import sun.awt.ModalExclude;
import sun.awt.SunToolkit;

public class Popup {
    private Component component;

    protected Popup(Component component, Component component2, int n, int n2) {
        this();
        if (component2 == null) {
            throw new IllegalArgumentException("Contents must be non-null");
        }
        this.reset(component, component2, n, n2);
    }

    protected Popup() {
    }

    public void show() {
        Component component = this.getComponent();
        if (component != null) {
            component.show();
        }
    }

    public void hide() {
        Component component = this.getComponent();
        if (component instanceof JWindow) {
            component.hide();
            ((JWindow)component).getContentPane().removeAll();
        }
        this.dispose();
    }

    void dispose() {
        Component component = this.getComponent();
        Window window = SwingUtilities.getWindowAncestor(component);
        if (component instanceof JWindow) {
            ((Window)component).dispose();
            component = null;
        }
        if (window instanceof DefaultFrame) {
            window.dispose();
        }
    }

    void reset(Component component, Component component2, int n, int n2) {
        Component component3;
        if (this.getComponent() == null) {
            this.component = this.createComponent(component);
        }
        if ((component3 = this.getComponent()) instanceof JWindow) {
            JWindow jWindow = (JWindow)this.getComponent();
            jWindow.setLocation(n, n2);
            jWindow.getContentPane().add(component2, "Center");
            component2.invalidate();
            if (jWindow.isVisible()) {
                this.pack();
            }
        }
    }

    void pack() {
        Component component = this.getComponent();
        if (component instanceof Window) {
            ((Window)component).pack();
        }
    }

    private Window getParentWindow(Component component) {
        Window window = null;
        if (component instanceof Window) {
            window = (Window)component;
        } else if (component != null) {
            window = SwingUtilities.getWindowAncestor(component);
        }
        if (window == null) {
            window = new DefaultFrame();
        }
        return window;
    }

    Component createComponent(Component component) {
        if (GraphicsEnvironment.isHeadless()) {
            return null;
        }
        return new HeavyWeightWindow(this.getParentWindow(component));
    }

    Component getComponent() {
        return this.component;
    }

    static class DefaultFrame
    extends Frame {
        DefaultFrame() {
        }
    }

    static class HeavyWeightWindow
    extends JWindow
    implements ModalExclude {
        HeavyWeightWindow(Window window) {
            super(window);
            this.setFocusableWindowState(false);
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (toolkit instanceof SunToolkit) {
                ((SunToolkit)toolkit).setOverrideRedirect(this);
            }
            this.getRootPane().setUseTrueDoubleBuffering(false);
            try {
                this.setAlwaysOnTop(true);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }

        public void update(Graphics graphics) {
            this.paint(graphics);
        }

        public void show() {
            this.pack();
            if (this.getWidth() > 0 && this.getHeight() > 0) {
                super.show();
            }
        }
    }
}

