/*
 * Decompiled with CFR 0.152.
 */
package javax.swing;

import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceContext;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.TooManyListenersException;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.Scrollable;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.EventListenerList;
import javax.swing.plaf.UIResource;
import javax.swing.text.JTextComponent;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.misc.JavaSecurityAccess;
import sun.misc.SharedSecrets;
import sun.reflect.misc.MethodUtil;
import sun.swing.AccessibleMethod;
import sun.swing.SwingUtilities2;
import sun.swing.UIAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransferHandler
implements Serializable {
    public static final int NONE = 0;
    public static final int COPY = 1;
    public static final int MOVE = 2;
    public static final int COPY_OR_MOVE = 3;
    public static final int LINK = 0x40000000;
    private String propertyName;
    private static SwingDragGestureRecognizer recognizer = null;
    static final Action cutAction = new TransferAction("cut");
    static final Action copyAction = new TransferAction("copy");
    static final Action pasteAction = new TransferAction("paste");

    public static Action getCutAction() {
        return cutAction;
    }

    public static Action getCopyAction() {
        return copyAction;
    }

    public static Action getPasteAction() {
        return pasteAction;
    }

    public TransferHandler(String string) {
        this.propertyName = string;
    }

    protected TransferHandler() {
        this(null);
    }

    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        int n2 = this.getSourceActions(jComponent);
        if (!(inputEvent instanceof MouseEvent) || n != 1 && n != 2 && n != 0x40000000 || (n2 & n) == 0) {
            n = 0;
        }
        if (n != 0 && !GraphicsEnvironment.isHeadless()) {
            if (recognizer == null) {
                recognizer = new SwingDragGestureRecognizer(new DragHandler());
            }
            recognizer.gestured(jComponent, (MouseEvent)inputEvent, n2, n);
        } else {
            this.exportDone(jComponent, null, 0);
        }
    }

    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) throws IllegalStateException {
        Transferable transferable;
        if ((n == 1 || n == 2) && (this.getSourceActions(jComponent) & n) != 0 && (transferable = this.createTransferable(jComponent)) != null) {
            try {
                clipboard.setContents(transferable, null);
                this.exportDone(jComponent, transferable, n);
                return;
            }
            catch (IllegalStateException illegalStateException) {
                this.exportDone(jComponent, transferable, 0);
                throw illegalStateException;
            }
        }
        this.exportDone(jComponent, null, 0);
    }

    public boolean importData(TransferSupport transferSupport) {
        return transferSupport.getComponent() instanceof JComponent ? this.importData((JComponent)transferSupport.getComponent(), transferSupport.getTransferable()) : false;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                return false;
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                return false;
            }
            DataFlavor dataFlavor = this.getPropertyDataFlavor(classArray[0], transferable.getTransferDataFlavors());
            if (dataFlavor != null) {
                try {
                    Object object = transferable.getTransferData(dataFlavor);
                    Object[] objectArray = new Object[]{object};
                    MethodUtil.invoke(method, jComponent, objectArray);
                    return true;
                }
                catch (Exception exception) {
                    System.err.println("Invocation failed");
                }
            }
        }
        return false;
    }

    public boolean canImport(TransferSupport transferSupport) {
        return transferSupport.getComponent() instanceof JComponent ? this.canImport((JComponent)transferSupport.getComponent(), transferSupport.getDataFlavors()) : false;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            Method method = propertyDescriptor.getWriteMethod();
            if (method == null) {
                return false;
            }
            Class<?>[] classArray = method.getParameterTypes();
            if (classArray.length != 1) {
                return false;
            }
            DataFlavor dataFlavor = this.getPropertyDataFlavor(classArray[0], dataFlavorArray);
            if (dataFlavor != null) {
                return true;
            }
        }
        return false;
    }

    public int getSourceActions(JComponent jComponent) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            return 1;
        }
        return 0;
    }

    public Icon getVisualRepresentation(Transferable transferable) {
        return null;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        PropertyDescriptor propertyDescriptor = this.getPropertyDescriptor(jComponent);
        if (propertyDescriptor != null) {
            return new PropertyTransferable(propertyDescriptor, jComponent);
        }
        return null;
    }

    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
    }

    private PropertyDescriptor getPropertyDescriptor(JComponent jComponent) {
        BeanInfo beanInfo;
        if (this.propertyName == null) {
            return null;
        }
        Class<?> clazz = jComponent.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(clazz);
        }
        catch (IntrospectionException introspectionException) {
            return null;
        }
        PropertyDescriptor[] propertyDescriptorArray = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < propertyDescriptorArray.length; ++i) {
            Class<?>[] classArray;
            Method method;
            if (!this.propertyName.equals(propertyDescriptorArray[i].getName()) || (method = propertyDescriptorArray[i].getReadMethod()) == null || (classArray = method.getParameterTypes()) != null && classArray.length != 0) continue;
            return propertyDescriptorArray[i];
        }
        return null;
    }

    private DataFlavor getPropertyDataFlavor(Class<?> clazz, DataFlavor[] dataFlavorArray) {
        for (int i = 0; i < dataFlavorArray.length; ++i) {
            DataFlavor dataFlavor = dataFlavorArray[i];
            if (!"application".equals(dataFlavor.getPrimaryType()) || !"x-java-jvm-local-objectref".equals(dataFlavor.getSubType()) || !clazz.isAssignableFrom(dataFlavor.getRepresentationClass())) continue;
            return dataFlavor;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DropTargetListener getDropTargetListener() {
        Class<DropHandler> clazz = DropHandler.class;
        synchronized (DropHandler.class) {
            DropHandler dropHandler = (DropHandler)AppContext.getAppContext().get(DropHandler.class);
            if (dropHandler == null) {
                dropHandler = new DropHandler();
                AppContext.getAppContext().put(DropHandler.class, dropHandler);
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return dropHandler;
        }
    }

    static class TransferAction
    extends UIAction
    implements UIResource {
        private static final JavaSecurityAccess javaSecurityAccess = SharedSecrets.getJavaSecurityAccess();
        private static Object SandboxClipboardKey = new Object();

        TransferAction(String string) {
            super(string);
        }

        public boolean isEnabled(Object object) {
            return !(object instanceof JComponent) || ((JComponent)object).getTransferHandler() != null;
        }

        public void actionPerformed(final ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            final PrivilegedAction<Void> privilegedAction = new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    TransferAction.this.actionPerformedImpl(actionEvent);
                    return null;
                }
            };
            AccessControlContext accessControlContext = AccessController.getContext();
            AccessControlContext accessControlContext2 = AWTAccessor.getComponentAccessor().getAccessControlContext((Component)object);
            final AccessControlContext accessControlContext3 = AWTAccessor.getAWTEventAccessor().getAccessControlContext(actionEvent);
            if (accessControlContext2 == null) {
                javaSecurityAccess.doIntersectionPrivilege(privilegedAction, accessControlContext, accessControlContext3);
            } else {
                javaSecurityAccess.doIntersectionPrivilege(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        javaSecurityAccess.doIntersectionPrivilege(privilegedAction, accessControlContext3);
                        return null;
                    }
                }, accessControlContext, accessControlContext2);
            }
        }

        private void actionPerformedImpl(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object instanceof JComponent) {
                JComponent jComponent = (JComponent)object;
                TransferHandler transferHandler = jComponent.getTransferHandler();
                Clipboard clipboard = this.getClipboard(jComponent);
                String string = (String)this.getValue("Name");
                Transferable transferable = null;
                try {
                    if (clipboard != null && transferHandler != null && string != null) {
                        if ("cut".equals(string)) {
                            transferHandler.exportToClipboard(jComponent, clipboard, 2);
                        } else if ("copy".equals(string)) {
                            transferHandler.exportToClipboard(jComponent, clipboard, 1);
                        } else if ("paste".equals(string)) {
                            transferable = clipboard.getContents(null);
                        }
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    UIManager.getLookAndFeel().provideErrorFeedback(jComponent);
                    return;
                }
                if (transferable != null) {
                    transferHandler.importData(new TransferSupport((Component)jComponent, transferable));
                }
            }
        }

        private Clipboard getClipboard(JComponent jComponent) {
            if (SwingUtilities2.canAccessSystemClipboard()) {
                return jComponent.getToolkit().getSystemClipboard();
            }
            Clipboard clipboard = (Clipboard)AppContext.getAppContext().get(SandboxClipboardKey);
            if (clipboard == null) {
                clipboard = new Clipboard("Sandboxed Component Clipboard");
                AppContext.getAppContext().put(SandboxClipboardKey, clipboard);
            }
            return clipboard;
        }
    }

    private static class SwingDragGestureRecognizer
    extends DragGestureRecognizer {
        SwingDragGestureRecognizer(DragGestureListener dragGestureListener) {
            super(DragSource.getDefaultDragSource(), null, 0, dragGestureListener);
        }

        void gestured(JComponent jComponent, MouseEvent mouseEvent, int n, int n2) {
            this.setComponent(jComponent);
            this.setSourceActions(n);
            this.appendEvent(mouseEvent);
            this.fireDragGestureRecognized(n2, mouseEvent.getPoint());
        }

        protected void registerListeners() {
        }

        protected void unregisterListeners() {
        }
    }

    private static class DragHandler
    implements DragGestureListener,
    DragSourceListener {
        private boolean scrolls;

        private DragHandler() {
        }

        public void dragGestureRecognized(DragGestureEvent dragGestureEvent) {
            JComponent jComponent = (JComponent)dragGestureEvent.getComponent();
            TransferHandler transferHandler = jComponent.getTransferHandler();
            Transferable transferable = transferHandler.createTransferable(jComponent);
            if (transferable != null) {
                this.scrolls = jComponent.getAutoscrolls();
                jComponent.setAutoscrolls(false);
                try {
                    dragGestureEvent.startDrag(null, transferable, this);
                    return;
                }
                catch (RuntimeException runtimeException) {
                    jComponent.setAutoscrolls(this.scrolls);
                }
            }
            transferHandler.exportDone(jComponent, transferable, 0);
        }

        public void dragEnter(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragOver(DragSourceDragEvent dragSourceDragEvent) {
        }

        public void dragExit(DragSourceEvent dragSourceEvent) {
        }

        public void dragDropEnd(DragSourceDropEvent dragSourceDropEvent) {
            DragSourceContext dragSourceContext = dragSourceDropEvent.getDragSourceContext();
            JComponent jComponent = (JComponent)dragSourceContext.getComponent();
            if (dragSourceDropEvent.getDropSuccess()) {
                jComponent.getTransferHandler().exportDone(jComponent, dragSourceContext.getTransferable(), dragSourceDropEvent.getDropAction());
            } else {
                jComponent.getTransferHandler().exportDone(jComponent, dragSourceContext.getTransferable(), 0);
            }
            jComponent.setAutoscrolls(this.scrolls);
        }

        public void dropActionChanged(DragSourceDragEvent dragSourceDragEvent) {
        }
    }

    private static class DropHandler
    implements DropTargetListener,
    Serializable,
    ActionListener {
        private Timer timer;
        private Point lastPosition;
        private Rectangle outer = new Rectangle();
        private Rectangle inner = new Rectangle();
        private int hysteresis = 10;
        private Component component;
        private Object state;
        private TransferSupport support = new TransferSupport(null, null);
        private static final int AUTOSCROLL_INSET = 10;

        private DropHandler() {
        }

        private void updateAutoscrollRegion(JComponent jComponent) {
            Rectangle rectangle = jComponent.getVisibleRect();
            this.outer.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            Insets insets = new Insets(0, 0, 0, 0);
            if (jComponent instanceof Scrollable) {
                int n = 20;
                if (rectangle.width >= n) {
                    insets.right = 10;
                    insets.left = 10;
                }
                if (rectangle.height >= n) {
                    insets.bottom = 10;
                    insets.top = 10;
                }
            }
            this.inner.setBounds(rectangle.x + insets.left, rectangle.y + insets.top, rectangle.width - (insets.left + insets.right), rectangle.height - (insets.top + insets.bottom));
        }

        private void autoscroll(JComponent jComponent, Point point) {
            if (jComponent instanceof Scrollable) {
                Rectangle rectangle;
                int n;
                Scrollable scrollable = (Scrollable)((Object)jComponent);
                if (point.y < this.inner.y) {
                    n = scrollable.getScrollableUnitIncrement(this.outer, 1, -1);
                    rectangle = new Rectangle(this.inner.x, this.outer.y - n, this.inner.width, n);
                    jComponent.scrollRectToVisible(rectangle);
                } else if (point.y > this.inner.y + this.inner.height) {
                    n = scrollable.getScrollableUnitIncrement(this.outer, 1, 1);
                    rectangle = new Rectangle(this.inner.x, this.outer.y + this.outer.height, this.inner.width, n);
                    jComponent.scrollRectToVisible(rectangle);
                }
                if (point.x < this.inner.x) {
                    n = scrollable.getScrollableUnitIncrement(this.outer, 0, -1);
                    rectangle = new Rectangle(this.outer.x - n, this.inner.y, n, this.inner.height);
                    jComponent.scrollRectToVisible(rectangle);
                } else if (point.x > this.inner.x + this.inner.width) {
                    n = scrollable.getScrollableUnitIncrement(this.outer, 0, 1);
                    rectangle = new Rectangle(this.outer.x + this.outer.width, this.inner.y, n, this.inner.height);
                    jComponent.scrollRectToVisible(rectangle);
                }
            }
        }

        private void initPropertiesIfNecessary() {
            if (this.timer == null) {
                Toolkit toolkit = Toolkit.getDefaultToolkit();
                Integer n = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.interval");
                this.timer = new Timer(n == null ? 100 : n, this);
                n = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.initialDelay");
                this.timer.setInitialDelay(n == null ? 100 : n);
                n = (Integer)toolkit.getDesktopProperty("DnD.Autoscroll.cursorHysteresis");
                if (n != null) {
                    this.hysteresis = n;
                }
            }
        }

        public void actionPerformed(ActionEvent actionEvent) {
            this.updateAutoscrollRegion((JComponent)this.component);
            if (this.outer.contains(this.lastPosition) && !this.inner.contains(this.lastPosition)) {
                this.autoscroll((JComponent)this.component, this.lastPosition);
            }
        }

        private void setComponentDropLocation(TransferSupport transferSupport, boolean bl) {
            DropLocation dropLocation;
            DropLocation dropLocation2 = dropLocation = transferSupport == null ? null : transferSupport.getDropLocation();
            if (this.component instanceof JTextComponent) {
                try {
                    AccessibleMethod accessibleMethod = new AccessibleMethod(JTextComponent.class, "setDropLocation", DropLocation.class, Object.class, Boolean.TYPE);
                    this.state = accessibleMethod.invokeNoChecked(this.component, dropLocation, this.state, bl);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new AssertionError((Object)"Couldn't locate method JTextComponet.setDropLocation");
                }
            } else if (this.component instanceof JComponent) {
                this.state = ((JComponent)this.component).setDropLocation(dropLocation, this.state, bl);
            }
        }

        private void handleDrag(DropTargetDragEvent dropTargetDragEvent) {
            TransferHandler transferHandler = ((HasGetTransferHandler)((Object)this.component)).getTransferHandler();
            if (transferHandler == null) {
                dropTargetDragEvent.rejectDrag();
                this.setComponentDropLocation(null, false);
                return;
            }
            this.support.setDNDVariables(this.component, dropTargetDragEvent);
            boolean bl = transferHandler.canImport(this.support);
            if (bl) {
                dropTargetDragEvent.acceptDrag(this.support.getDropAction());
            } else {
                dropTargetDragEvent.rejectDrag();
            }
            boolean bl2 = this.support.showDropLocationIsSet ? this.support.showDropLocation : bl;
            this.setComponentDropLocation(bl2 ? this.support : null, false);
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            this.state = null;
            this.component = dropTargetDragEvent.getDropTargetContext().getComponent();
            this.handleDrag(dropTargetDragEvent);
            if (this.component instanceof JComponent) {
                this.lastPosition = dropTargetDragEvent.getLocation();
                this.updateAutoscrollRegion((JComponent)this.component);
                this.initPropertiesIfNecessary();
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            this.handleDrag(dropTargetDragEvent);
            if (!(this.component instanceof JComponent)) {
                return;
            }
            Point point = dropTargetDragEvent.getLocation();
            if (Math.abs(point.x - this.lastPosition.x) > this.hysteresis || Math.abs(point.y - this.lastPosition.y) > this.hysteresis) {
                if (this.timer.isRunning()) {
                    this.timer.stop();
                }
            } else if (!this.timer.isRunning()) {
                this.timer.start();
            }
            this.lastPosition = point;
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            this.cleanup(false);
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            TransferHandler transferHandler = ((HasGetTransferHandler)((Object)this.component)).getTransferHandler();
            if (transferHandler == null) {
                dropTargetDropEvent.rejectDrop();
                this.cleanup(false);
                return;
            }
            this.support.setDNDVariables(this.component, dropTargetDropEvent);
            boolean bl = transferHandler.canImport(this.support);
            if (bl) {
                boolean bl2;
                dropTargetDropEvent.acceptDrop(this.support.getDropAction());
                boolean bl3 = this.support.showDropLocationIsSet ? this.support.showDropLocation : bl;
                this.setComponentDropLocation(bl3 ? this.support : null, false);
                try {
                    bl2 = transferHandler.importData(this.support);
                }
                catch (RuntimeException runtimeException) {
                    bl2 = false;
                }
                dropTargetDropEvent.dropComplete(bl2);
                this.cleanup(bl2);
            } else {
                dropTargetDropEvent.rejectDrop();
                this.cleanup(false);
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            if (this.component == null) {
                return;
            }
            this.handleDrag(dropTargetDragEvent);
        }

        private void cleanup(boolean bl) {
            this.setComponentDropLocation(null, bl);
            if (this.component instanceof JComponent) {
                ((JComponent)this.component).dndDone();
            }
            if (this.timer != null) {
                this.timer.stop();
            }
            this.state = null;
            this.component = null;
            this.lastPosition = null;
        }
    }

    static class SwingDropTarget
    extends DropTarget
    implements UIResource {
        private EventListenerList listenerList;

        SwingDropTarget(Component component) {
            super(component, 0x40000003, null);
            try {
                super.addDropTargetListener(TransferHandler.getDropTargetListener());
            }
            catch (TooManyListenersException tooManyListenersException) {
                // empty catch block
            }
        }

        public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
            if (this.listenerList == null) {
                this.listenerList = new EventListenerList();
            }
            this.listenerList.add(DropTargetListener.class, dropTargetListener);
        }

        public void removeDropTargetListener(DropTargetListener dropTargetListener) {
            if (this.listenerList != null) {
                this.listenerList.remove(DropTargetListener.class, dropTargetListener);
            }
        }

        public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
            super.dragEnter(dropTargetDragEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != DropTargetListener.class) continue;
                    ((DropTargetListener)objectArray[i + 1]).dragEnter(dropTargetDragEvent);
                }
            }
        }

        public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
            super.dragOver(dropTargetDragEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != DropTargetListener.class) continue;
                    ((DropTargetListener)objectArray[i + 1]).dragOver(dropTargetDragEvent);
                }
            }
        }

        public void dragExit(DropTargetEvent dropTargetEvent) {
            super.dragExit(dropTargetEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != DropTargetListener.class) continue;
                    ((DropTargetListener)objectArray[i + 1]).dragExit(dropTargetEvent);
                }
            }
        }

        public void drop(DropTargetDropEvent dropTargetDropEvent) {
            super.drop(dropTargetDropEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != DropTargetListener.class) continue;
                    ((DropTargetListener)objectArray[i + 1]).drop(dropTargetDropEvent);
                }
            }
        }

        public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
            super.dropActionChanged(dropTargetDragEvent);
            if (this.listenerList != null) {
                Object[] objectArray = this.listenerList.getListenerList();
                for (int i = objectArray.length - 2; i >= 0; i -= 2) {
                    if (objectArray[i] != DropTargetListener.class) continue;
                    ((DropTargetListener)objectArray[i + 1]).dropActionChanged(dropTargetDragEvent);
                }
            }
        }
    }

    static class PropertyTransferable
    implements Transferable {
        JComponent component;
        PropertyDescriptor property;

        PropertyTransferable(PropertyDescriptor propertyDescriptor, JComponent jComponent) {
            this.property = propertyDescriptor;
            this.component = jComponent;
        }

        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] dataFlavorArray = new DataFlavor[1];
            Class<?> clazz = this.property.getPropertyType();
            String string = "application/x-java-jvm-local-objectref;class=" + clazz.getName();
            try {
                dataFlavorArray[0] = new DataFlavor(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                dataFlavorArray = new DataFlavor[]{};
            }
            return dataFlavorArray;
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            Class<?> clazz = this.property.getPropertyType();
            return "application".equals(dataFlavor.getPrimaryType()) && "x-java-jvm-local-objectref".equals(dataFlavor.getSubType()) && dataFlavor.getRepresentationClass().isAssignableFrom(clazz);
        }

        public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
            if (!this.isDataFlavorSupported(dataFlavor)) {
                throw new UnsupportedFlavorException(dataFlavor);
            }
            Method method = this.property.getReadMethod();
            Object object = null;
            try {
                object = MethodUtil.invoke(method, this.component, null);
            }
            catch (Exception exception) {
                throw new IOException("Property read failed: " + this.property.getName());
            }
            return object;
        }
    }

    public static final class TransferSupport {
        private boolean isDrop;
        private Component component;
        private boolean showDropLocationIsSet;
        private boolean showDropLocation;
        private int dropAction = -1;
        private Object source;
        private DropLocation dropLocation;

        private TransferSupport(Component component, DropTargetEvent dropTargetEvent) {
            this.isDrop = true;
            this.setDNDVariables(component, dropTargetEvent);
        }

        public TransferSupport(Component component, Transferable transferable) {
            if (component == null) {
                throw new NullPointerException("component is null");
            }
            if (transferable == null) {
                throw new NullPointerException("transferable is null");
            }
            this.isDrop = false;
            this.component = component;
            this.source = transferable;
        }

        private void setDNDVariables(Component component, DropTargetEvent dropTargetEvent) {
            Point point;
            assert (this.isDrop);
            this.component = component;
            this.source = dropTargetEvent;
            this.dropLocation = null;
            this.dropAction = -1;
            this.showDropLocationIsSet = false;
            if (this.source == null) {
                return;
            }
            assert (this.source instanceof DropTargetDragEvent || this.source instanceof DropTargetDropEvent);
            Point point2 = point = this.source instanceof DropTargetDragEvent ? ((DropTargetDragEvent)this.source).getLocation() : ((DropTargetDropEvent)this.source).getLocation();
            if (component instanceof JTextComponent) {
                try {
                    AccessibleMethod accessibleMethod = new AccessibleMethod(JTextComponent.class, "dropLocationForPoint", Point.class);
                    this.dropLocation = (DropLocation)accessibleMethod.invokeNoChecked(component, point);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    throw new AssertionError((Object)"Couldn't locate method JTextComponent.dropLocationForPoint");
                }
            } else if (component instanceof JComponent) {
                this.dropLocation = ((JComponent)component).dropLocationForPoint(point);
            }
        }

        public boolean isDrop() {
            return this.isDrop;
        }

        public Component getComponent() {
            return this.component;
        }

        private void assureIsDrop() {
            if (!this.isDrop) {
                throw new IllegalStateException("Not a drop");
            }
        }

        public DropLocation getDropLocation() {
            this.assureIsDrop();
            if (this.dropLocation == null) {
                Point point = this.source instanceof DropTargetDragEvent ? ((DropTargetDragEvent)this.source).getLocation() : ((DropTargetDropEvent)this.source).getLocation();
                this.dropLocation = new DropLocation(point);
            }
            return this.dropLocation;
        }

        public void setShowDropLocation(boolean bl) {
            this.assureIsDrop();
            this.showDropLocation = bl;
            this.showDropLocationIsSet = true;
        }

        public void setDropAction(int n) {
            this.assureIsDrop();
            int n2 = n & this.getSourceDropActions();
            if (n2 != 1 && n2 != 2 && n2 != 0x40000000) {
                throw new IllegalArgumentException("unsupported drop action: " + n);
            }
            this.dropAction = n;
        }

        public int getDropAction() {
            return this.dropAction == -1 ? this.getUserDropAction() : this.dropAction;
        }

        public int getUserDropAction() {
            this.assureIsDrop();
            return this.source instanceof DropTargetDragEvent ? ((DropTargetDragEvent)this.source).getDropAction() : ((DropTargetDropEvent)this.source).getDropAction();
        }

        public int getSourceDropActions() {
            this.assureIsDrop();
            return this.source instanceof DropTargetDragEvent ? ((DropTargetDragEvent)this.source).getSourceActions() : ((DropTargetDropEvent)this.source).getSourceActions();
        }

        public DataFlavor[] getDataFlavors() {
            if (this.isDrop) {
                if (this.source instanceof DropTargetDragEvent) {
                    return ((DropTargetDragEvent)this.source).getCurrentDataFlavors();
                }
                return ((DropTargetDropEvent)this.source).getCurrentDataFlavors();
            }
            return ((Transferable)this.source).getTransferDataFlavors();
        }

        public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
            if (this.isDrop) {
                if (this.source instanceof DropTargetDragEvent) {
                    return ((DropTargetDragEvent)this.source).isDataFlavorSupported(dataFlavor);
                }
                return ((DropTargetDropEvent)this.source).isDataFlavorSupported(dataFlavor);
            }
            return ((Transferable)this.source).isDataFlavorSupported(dataFlavor);
        }

        public Transferable getTransferable() {
            if (this.isDrop) {
                if (this.source instanceof DropTargetDragEvent) {
                    return ((DropTargetDragEvent)this.source).getTransferable();
                }
                return ((DropTargetDropEvent)this.source).getTransferable();
            }
            return (Transferable)this.source;
        }
    }

    public static class DropLocation {
        private final Point dropPoint;

        protected DropLocation(Point point) {
            if (point == null) {
                throw new IllegalArgumentException("Point cannot be null");
            }
            this.dropPoint = new Point(point);
        }

        public final Point getDropPoint() {
            return new Point(this.dropPoint);
        }

        public String toString() {
            return this.getClass().getName() + "[dropPoint=" + this.dropPoint + "]";
        }
    }

    static interface HasGetTransferHandler {
        public TransferHandler getTransferHandler();
    }
}

