/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.KeyboardFocusManager;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.ActionMap;
import javax.swing.ComponentInputMap;
import javax.swing.InputMap;
import javax.swing.JApplet;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.MenuElement;
import javax.swing.MenuSelectionManager;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PopupMenuUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.BasicMenuItemUI;
import javax.swing.plaf.basic.DefaultMenuLayout;
import javax.swing.plaf.basic.LazyActionMap;
import sun.awt.AppContext;
import sun.awt.SunToolkit;
import sun.awt.UngrabEvent;
import sun.swing.UIAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicPopupMenuUI
extends PopupMenuUI {
    static final Object MOUSE_GRABBER_KEY = new Object();
    static final Object MENU_KEYBOARD_HELPER_KEY = new Object();
    protected JPopupMenu popupMenu = null;
    private transient PopupMenuListener popupMenuListener = null;
    private MenuKeyListener menuKeyListener = null;
    private static boolean checkedUnpostPopup;
    private static boolean unpostPopup;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicPopupMenuUI();
    }

    public BasicPopupMenuUI() {
        BasicLookAndFeel.needsEventHelper = true;
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (lookAndFeel instanceof BasicLookAndFeel) {
            ((BasicLookAndFeel)lookAndFeel).installAWTEventListener();
        }
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.popupMenu = (JPopupMenu)jComponent;
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
    }

    public void installDefaults() {
        if (this.popupMenu.getLayout() == null || this.popupMenu.getLayout() instanceof UIResource) {
            this.popupMenu.setLayout(new DefaultMenuLayout(this.popupMenu, 1));
        }
        LookAndFeel.installProperty(this.popupMenu, "opaque", Boolean.TRUE);
        LookAndFeel.installBorder(this.popupMenu, "PopupMenu.border");
        LookAndFeel.installColorsAndFont(this.popupMenu, "PopupMenu.background", "PopupMenu.foreground", "PopupMenu.font");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void installListeners() {
        ChangeListener changeListener;
        if (this.popupMenuListener == null) {
            this.popupMenuListener = new BasicPopupMenuListener();
        }
        this.popupMenu.addPopupMenuListener(this.popupMenuListener);
        if (this.menuKeyListener == null) {
            this.menuKeyListener = new BasicMenuKeyListener();
        }
        this.popupMenu.addMenuKeyListener(this.menuKeyListener);
        AppContext appContext = AppContext.getAppContext();
        Object object = MOUSE_GRABBER_KEY;
        synchronized (object) {
            changeListener = (MouseGrabber)appContext.get(MOUSE_GRABBER_KEY);
            if (changeListener == null) {
                changeListener = new MouseGrabber();
                appContext.put(MOUSE_GRABBER_KEY, changeListener);
            }
        }
        object = MENU_KEYBOARD_HELPER_KEY;
        synchronized (object) {
            changeListener = (MenuKeyboardHelper)appContext.get(MENU_KEYBOARD_HELPER_KEY);
            if (changeListener == null) {
                changeListener = new MenuKeyboardHelper();
                appContext.put(MENU_KEYBOARD_HELPER_KEY, changeListener);
                MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
                menuSelectionManager.addChangeListener(changeListener);
            }
        }
    }

    protected void installKeyboardActions() {
    }

    static InputMap getInputMap(JPopupMenu jPopupMenu, JComponent jComponent) {
        ComponentInputMap componentInputMap = null;
        Object[] objectArray = (Object[])UIManager.get("PopupMenu.selectedWindowInputMapBindings");
        if (objectArray != null) {
            Object[] objectArray2;
            componentInputMap = LookAndFeel.makeComponentInputMap(jComponent, objectArray);
            if (!jPopupMenu.getComponentOrientation().isLeftToRight() && (objectArray2 = (Object[])UIManager.get("PopupMenu.selectedWindowInputMapBindings.RightToLeft")) != null) {
                ComponentInputMap componentInputMap2 = LookAndFeel.makeComponentInputMap(jComponent, objectArray2);
                ((InputMap)componentInputMap2).setParent(componentInputMap);
                componentInputMap = componentInputMap2;
            }
        }
        return componentInputMap;
    }

    static ActionMap getActionMap() {
        return LazyActionMap.getActionMap(BasicPopupMenuUI.class, "PopupMenu.actionMap");
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("cancel"));
        lazyActionMap.put(new Actions("selectNext"));
        lazyActionMap.put(new Actions("selectPrevious"));
        lazyActionMap.put(new Actions("selectParent"));
        lazyActionMap.put(new Actions("selectChild"));
        lazyActionMap.put(new Actions("return"));
        BasicLookAndFeel.installAudioActionMap(lazyActionMap);
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.popupMenu = null;
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.popupMenu);
    }

    protected void uninstallListeners() {
        if (this.popupMenuListener != null) {
            this.popupMenu.removePopupMenuListener(this.popupMenuListener);
        }
        if (this.menuKeyListener != null) {
            this.popupMenu.removeMenuKeyListener(this.menuKeyListener);
        }
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.popupMenu, null);
        SwingUtilities.replaceUIInputMap(this.popupMenu, 2, null);
    }

    static MenuElement getFirstPopup() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        MenuElement menuElement = null;
        for (int i = 0; menuElement == null && i < menuElementArray.length; ++i) {
            if (!(menuElementArray[i] instanceof JPopupMenu)) continue;
            menuElement = menuElementArray[i];
        }
        return menuElement;
    }

    static JPopupMenu getLastPopup() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        JPopupMenu jPopupMenu = null;
        for (int i = menuElementArray.length - 1; jPopupMenu == null && i >= 0; --i) {
            if (!(menuElementArray[i] instanceof JPopupMenu)) continue;
            jPopupMenu = (JPopupMenu)menuElementArray[i];
        }
        return jPopupMenu;
    }

    static List<JPopupMenu> getPopups() {
        MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
        MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
        ArrayList<JPopupMenu> arrayList = new ArrayList<JPopupMenu>(menuElementArray.length);
        for (MenuElement menuElement : menuElementArray) {
            if (!(menuElement instanceof JPopupMenu)) continue;
            arrayList.add((JPopupMenu)menuElement);
        }
        return arrayList;
    }

    @Override
    public boolean isPopupTrigger(MouseEvent mouseEvent) {
        return mouseEvent.getID() == 502 && (mouseEvent.getModifiers() & 4) != 0;
    }

    private static boolean checkInvokerEqual(MenuElement menuElement, MenuElement menuElement2) {
        Component component = menuElement.getComponent();
        Component component2 = menuElement2.getComponent();
        if (component instanceof JPopupMenu) {
            component = ((JPopupMenu)component).getInvoker();
        }
        if (component2 instanceof JPopupMenu) {
            component2 = ((JPopupMenu)component2).getInvoker();
        }
        return component == component2;
    }

    private static MenuElement nextEnabledChild(MenuElement[] menuElementArray, int n, int n2) {
        for (int i = n; i <= n2; ++i) {
            Component component;
            if (menuElementArray[i] == null || (component = menuElementArray[i].getComponent()) == null || !component.isEnabled() && !UIManager.getBoolean("MenuItem.disabledAreNavigable") || !component.isVisible()) continue;
            return menuElementArray[i];
        }
        return null;
    }

    private static MenuElement previousEnabledChild(MenuElement[] menuElementArray, int n, int n2) {
        for (int i = n; i >= n2; --i) {
            Component component;
            if (menuElementArray[i] == null || (component = menuElementArray[i].getComponent()) == null || !component.isEnabled() && !UIManager.getBoolean("MenuItem.disabledAreNavigable") || !component.isVisible()) continue;
            return menuElementArray[i];
        }
        return null;
    }

    static MenuElement findEnabledChild(MenuElement[] menuElementArray, int n, boolean bl) {
        MenuElement menuElement;
        if (bl) {
            menuElement = BasicPopupMenuUI.nextEnabledChild(menuElementArray, n + 1, menuElementArray.length - 1);
            if (menuElement == null) {
                menuElement = BasicPopupMenuUI.nextEnabledChild(menuElementArray, 0, n - 1);
            }
        } else {
            menuElement = BasicPopupMenuUI.previousEnabledChild(menuElementArray, n - 1, 0);
            if (menuElement == null) {
                menuElement = BasicPopupMenuUI.previousEnabledChild(menuElementArray, menuElementArray.length - 1, n + 1);
            }
        }
        return menuElement;
    }

    static MenuElement findEnabledChild(MenuElement[] menuElementArray, MenuElement menuElement, boolean bl) {
        for (int i = 0; i < menuElementArray.length; ++i) {
            if (menuElementArray[i] != menuElement) continue;
            return BasicPopupMenuUI.findEnabledChild(menuElementArray, i, bl);
        }
        return null;
    }

    static class MenuKeyboardHelper
    implements ChangeListener,
    KeyListener {
        private Component lastFocused = null;
        private MenuElement[] lastPathSelected = new MenuElement[0];
        private JPopupMenu lastPopup;
        private JRootPane invokerRootPane;
        private ActionMap menuActionMap = BasicPopupMenuUI.getActionMap();
        private InputMap menuInputMap;
        private boolean focusTraversalKeysEnabled;
        private boolean receivedKeyPressed = false;
        private FocusListener rootPaneFocusListener = new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                Component component = focusEvent.getOppositeComponent();
                if (component != null) {
                    MenuKeyboardHelper.this.lastFocused = component;
                }
                focusEvent.getComponent().removeFocusListener(this);
            }
        };

        MenuKeyboardHelper() {
        }

        void removeItems() {
            if (this.lastFocused != null) {
                Window window;
                if (!this.lastFocused.requestFocusInWindow() && (window = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusedWindow()) != null && "###focusableSwingPopup###".equals(window.getName())) {
                    this.lastFocused.requestFocus();
                }
                this.lastFocused = null;
            }
            if (this.invokerRootPane != null) {
                this.invokerRootPane.removeKeyListener(this);
                this.invokerRootPane.setFocusTraversalKeysEnabled(this.focusTraversalKeysEnabled);
                this.removeUIInputMap(this.invokerRootPane, this.menuInputMap);
                this.removeUIActionMap(this.invokerRootPane, this.menuActionMap);
                this.invokerRootPane = null;
            }
            this.receivedKeyPressed = false;
        }

        JPopupMenu getActivePopup(MenuElement[] menuElementArray) {
            for (int i = menuElementArray.length - 1; i >= 0; --i) {
                MenuElement menuElement = menuElementArray[i];
                if (!(menuElement instanceof JPopupMenu)) continue;
                return (JPopupMenu)menuElement;
            }
            return null;
        }

        void addUIInputMap(JComponent jComponent, InputMap inputMap) {
            InputMap inputMap2;
            InputMap inputMap3 = null;
            for (inputMap2 = jComponent.getInputMap(2); inputMap2 != null && !(inputMap2 instanceof UIResource); inputMap2 = inputMap2.getParent()) {
                inputMap3 = inputMap2;
            }
            if (inputMap3 == null) {
                jComponent.setInputMap(2, inputMap);
            } else {
                inputMap3.setParent(inputMap);
            }
            inputMap.setParent(inputMap2);
        }

        void addUIActionMap(JComponent jComponent, ActionMap actionMap) {
            ActionMap actionMap2;
            ActionMap actionMap3 = null;
            for (actionMap2 = jComponent.getActionMap(); actionMap2 != null && !(actionMap2 instanceof UIResource); actionMap2 = actionMap2.getParent()) {
                actionMap3 = actionMap2;
            }
            if (actionMap3 == null) {
                jComponent.setActionMap(actionMap);
            } else {
                actionMap3.setParent(actionMap);
            }
            actionMap.setParent(actionMap2);
        }

        void removeUIInputMap(JComponent jComponent, InputMap inputMap) {
            InputMap inputMap2 = null;
            for (InputMap inputMap3 = jComponent.getInputMap(2); inputMap3 != null; inputMap3 = inputMap3.getParent()) {
                if (inputMap3 == inputMap) {
                    if (inputMap2 == null) {
                        jComponent.setInputMap(2, inputMap.getParent());
                        break;
                    }
                    inputMap2.setParent(inputMap.getParent());
                    break;
                }
                inputMap2 = inputMap3;
            }
        }

        void removeUIActionMap(JComponent jComponent, ActionMap actionMap) {
            ActionMap actionMap2 = null;
            for (ActionMap actionMap3 = jComponent.getActionMap(); actionMap3 != null; actionMap3 = actionMap3.getParent()) {
                if (actionMap3 == actionMap) {
                    if (actionMap2 == null) {
                        jComponent.setActionMap(actionMap.getParent());
                        break;
                    }
                    actionMap2.setParent(actionMap.getParent());
                    break;
                }
                actionMap2 = actionMap3;
            }
        }

        /*
         * WARNING - void declaration
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void stateChanged(ChangeEvent changeEvent) {
            if (!(UIManager.getLookAndFeel() instanceof BasicLookAndFeel)) {
                this.uninstall();
                return;
            }
            MenuSelectionManager menuSelectionManager = (MenuSelectionManager)changeEvent.getSource();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            JPopupMenu jPopupMenu = this.getActivePopup(menuElementArray);
            if (jPopupMenu != null && !jPopupMenu.isFocusable()) {
                return;
            }
            if (this.lastPathSelected.length != 0 && menuElementArray.length != 0 && !BasicPopupMenuUI.checkInvokerEqual(menuElementArray[0], this.lastPathSelected[0])) {
                this.removeItems();
                this.lastPathSelected = new MenuElement[0];
            }
            if (this.lastPathSelected.length == 0 && menuElementArray.length > 0) {
                void var5_10;
                if (jPopupMenu == null) {
                    if (menuElementArray.length != 2 || !(menuElementArray[0] instanceof JMenuBar) || !(menuElementArray[1] instanceof JMenu)) return;
                    JComponent jComponent = (JComponent)((Object)menuElementArray[1]);
                    jPopupMenu = ((JMenu)jComponent).getPopupMenu();
                } else {
                    Component component = jPopupMenu.getInvoker();
                    if (component instanceof JFrame) {
                        JRootPane jRootPane = ((JFrame)component).getRootPane();
                    } else if (component instanceof JDialog) {
                        JRootPane jRootPane = ((JDialog)component).getRootPane();
                    } else if (component instanceof JApplet) {
                        JRootPane jRootPane = ((JApplet)component).getRootPane();
                    } else {
                        while (!(component instanceof JComponent)) {
                            if (component == null) {
                                return;
                            }
                            component = component.getParent();
                        }
                        JComponent jComponent = (JComponent)component;
                    }
                }
                this.lastFocused = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
                this.invokerRootPane = SwingUtilities.getRootPane((Component)var5_10);
                if (this.invokerRootPane != null) {
                    this.invokerRootPane.addFocusListener(this.rootPaneFocusListener);
                    this.invokerRootPane.requestFocus(true);
                    this.invokerRootPane.addKeyListener(this);
                    this.focusTraversalKeysEnabled = this.invokerRootPane.getFocusTraversalKeysEnabled();
                    this.invokerRootPane.setFocusTraversalKeysEnabled(false);
                    this.menuInputMap = BasicPopupMenuUI.getInputMap(jPopupMenu, this.invokerRootPane);
                    this.addUIInputMap(this.invokerRootPane, this.menuInputMap);
                    this.addUIActionMap(this.invokerRootPane, this.menuActionMap);
                }
            } else if (this.lastPathSelected.length != 0 && menuElementArray.length == 0) {
                this.removeItems();
            } else if (jPopupMenu != this.lastPopup) {
                this.receivedKeyPressed = false;
            }
            this.lastPathSelected = menuElementArray;
            this.lastPopup = jPopupMenu;
        }

        public void keyPressed(KeyEvent keyEvent) {
            this.receivedKeyPressed = true;
            MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (this.receivedKeyPressed) {
                this.receivedKeyPressed = false;
                MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
            }
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (this.receivedKeyPressed) {
                MenuSelectionManager.defaultManager().processKeyEvent(keyEvent);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void uninstall() {
            Object object = MENU_KEYBOARD_HELPER_KEY;
            synchronized (object) {
                MenuSelectionManager.defaultManager().removeChangeListener(this);
                AppContext.getAppContext().remove(MENU_KEYBOARD_HELPER_KEY);
            }
        }
    }

    static class MouseGrabber
    implements ChangeListener,
    AWTEventListener,
    ComponentListener,
    WindowListener {
        Window grabbedWindow;
        MenuElement[] lastPathSelected;

        public MouseGrabber() {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            menuSelectionManager.addChangeListener(this);
            this.lastPathSelected = menuSelectionManager.getSelectedPath();
            if (this.lastPathSelected.length != 0) {
                this.grabWindow(this.lastPathSelected);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void uninstall() {
            Object object = MOUSE_GRABBER_KEY;
            synchronized (object) {
                MenuSelectionManager.defaultManager().removeChangeListener(this);
                this.ungrabWindow();
                AppContext.getAppContext().remove(MOUSE_GRABBER_KEY);
            }
        }

        void grabWindow(MenuElement[] menuElementArray) {
            final Toolkit toolkit = Toolkit.getDefaultToolkit();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    toolkit.addAWTEventListener(MouseGrabber.this, -2147352464L);
                    return null;
                }
            });
            Component component = menuElementArray[0].getComponent();
            if (component instanceof JPopupMenu) {
                component = ((JPopupMenu)component).getInvoker();
            }
            Window window = this.grabbedWindow = component instanceof Window ? (Window)component : SwingUtilities.getWindowAncestor(component);
            if (this.grabbedWindow != null) {
                if (toolkit instanceof SunToolkit) {
                    ((SunToolkit)toolkit).grab(this.grabbedWindow);
                } else {
                    this.grabbedWindow.addComponentListener(this);
                    this.grabbedWindow.addWindowListener(this);
                }
            }
        }

        void ungrabWindow() {
            final Toolkit toolkit = Toolkit.getDefaultToolkit();
            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    toolkit.removeAWTEventListener(MouseGrabber.this);
                    return null;
                }
            });
            this.realUngrabWindow();
        }

        void realUngrabWindow() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            if (this.grabbedWindow != null) {
                if (toolkit instanceof SunToolkit) {
                    ((SunToolkit)toolkit).ungrab(this.grabbedWindow);
                } else {
                    this.grabbedWindow.removeComponentListener(this);
                    this.grabbedWindow.removeWindowListener(this);
                }
                this.grabbedWindow = null;
            }
        }

        public void stateChanged(ChangeEvent changeEvent) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (this.lastPathSelected.length == 0 && menuElementArray.length != 0) {
                this.grabWindow(menuElementArray);
            }
            if (this.lastPathSelected.length != 0 && menuElementArray.length == 0) {
                this.ungrabWindow();
            }
            this.lastPathSelected = menuElementArray;
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent instanceof UngrabEvent) {
                this.cancelPopupMenu();
                return;
            }
            if (!(aWTEvent instanceof MouseEvent)) {
                return;
            }
            MouseEvent mouseEvent = (MouseEvent)aWTEvent;
            Component component = mouseEvent.getComponent();
            switch (mouseEvent.getID()) {
                case 501: {
                    if (this.isInPopup(component) || component instanceof JMenu && ((JMenu)component).isSelected()) {
                        return;
                    }
                    if (component instanceof JComponent && ((JComponent)component).getClientProperty("doNotCancelPopup") == BasicComboBoxUI.HIDE_POPUP_KEY) break;
                    this.cancelPopupMenu();
                    boolean bl = UIManager.getBoolean("PopupMenu.consumeEventOnClose");
                    if (!bl || component instanceof MenuElement) break;
                    mouseEvent.consume();
                    break;
                }
                case 502: {
                    if (!(component instanceof MenuElement) && this.isInPopup(component) || !(component instanceof JMenu) && component instanceof JMenuItem) break;
                    MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
                    break;
                }
                case 506: {
                    if (!(component instanceof MenuElement) && this.isInPopup(component)) break;
                    MenuSelectionManager.defaultManager().processMouseEvent(mouseEvent);
                    break;
                }
                case 507: {
                    if (this.isInPopup(component)) {
                        return;
                    }
                    this.cancelPopupMenu();
                }
            }
        }

        boolean isInPopup(Component component) {
            for (Component component2 = component; component2 != null && !(component2 instanceof Applet) && !(component2 instanceof Window); component2 = component2.getParent()) {
                if (!(component2 instanceof JPopupMenu)) continue;
                return true;
            }
            return false;
        }

        void cancelPopupMenu() {
            try {
                List<JPopupMenu> list = BasicPopupMenuUI.getPopups();
                for (JPopupMenu jPopupMenu : list) {
                    jPopupMenu.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
                }
                MenuSelectionManager.defaultManager().clearSelectedPath();
            }
            catch (RuntimeException runtimeException) {
                this.realUngrabWindow();
                throw runtimeException;
            }
            catch (Error error) {
                this.realUngrabWindow();
                throw error;
            }
        }

        public void componentResized(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentMoved(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentShown(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void componentHidden(ComponentEvent componentEvent) {
            this.cancelPopupMenu();
        }

        public void windowClosing(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowClosed(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowIconified(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowDeactivated(WindowEvent windowEvent) {
            this.cancelPopupMenu();
        }

        public void windowOpened(WindowEvent windowEvent) {
        }

        public void windowDeiconified(WindowEvent windowEvent) {
        }

        public void windowActivated(WindowEvent windowEvent) {
        }
    }

    private static class Actions
    extends UIAction {
        private static final String CANCEL = "cancel";
        private static final String SELECT_NEXT = "selectNext";
        private static final String SELECT_PREVIOUS = "selectPrevious";
        private static final String SELECT_PARENT = "selectParent";
        private static final String SELECT_CHILD = "selectChild";
        private static final String RETURN = "return";
        private static final boolean FORWARD = true;
        private static final boolean BACKWARD = false;
        private static final boolean PARENT = false;
        private static final boolean CHILD = true;

        Actions(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            if (string == CANCEL) {
                this.cancel();
            } else if (string == SELECT_NEXT) {
                this.selectItem(true);
            } else if (string == SELECT_PREVIOUS) {
                this.selectItem(false);
            } else if (string == SELECT_PARENT) {
                this.selectParentChild(false);
            } else if (string == SELECT_CHILD) {
                this.selectParentChild(true);
            } else if (string == RETURN) {
                this.doReturn();
            }
        }

        private void doReturn() {
            KeyboardFocusManager keyboardFocusManager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            Component component = keyboardFocusManager.getFocusOwner();
            if (component != null && !(component instanceof JRootPane)) {
                return;
            }
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length > 0) {
                MenuElement menuElement = menuElementArray[menuElementArray.length - 1];
                if (menuElement instanceof JMenu) {
                    MenuElement[] menuElementArray2 = new MenuElement[menuElementArray.length + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, menuElementArray.length);
                    menuElementArray2[menuElementArray.length] = ((JMenu)menuElement).getPopupMenu();
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                } else if (menuElement instanceof JMenuItem) {
                    JMenuItem jMenuItem = (JMenuItem)menuElement;
                    if (jMenuItem.getUI() instanceof BasicMenuItemUI) {
                        ((BasicMenuItemUI)jMenuItem.getUI()).doClick(menuSelectionManager);
                    } else {
                        menuSelectionManager.clearSelectedPath();
                        jMenuItem.doClick(0);
                    }
                }
            }
        }

        private void selectParentChild(boolean bl) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            int n = menuElementArray.length;
            if (!bl) {
                int n2 = n - 1;
                if (n > 2 && (menuElementArray[n2] instanceof JPopupMenu || menuElementArray[--n2] instanceof JPopupMenu) && !((JMenu)menuElementArray[n2 - 1]).isTopLevelMenu()) {
                    MenuElement[] menuElementArray2 = new MenuElement[n2];
                    System.arraycopy(menuElementArray, 0, menuElementArray2, 0, n2);
                    menuSelectionManager.setSelectedPath(menuElementArray2);
                    return;
                }
            } else if (n > 0 && menuElementArray[n - 1] instanceof JMenu && !((JMenu)menuElementArray[n - 1]).isTopLevelMenu()) {
                MenuElement[] menuElementArray3;
                JMenu jMenu = (JMenu)menuElementArray[n - 1];
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                MenuElement[] menuElementArray4 = jPopupMenu.getSubElements();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(menuElementArray4, -1, true);
                if (menuElement == null) {
                    menuElementArray3 = new MenuElement[n + 1];
                } else {
                    menuElementArray3 = new MenuElement[n + 2];
                    menuElementArray3[n + 1] = menuElement;
                }
                System.arraycopy(menuElementArray, 0, menuElementArray3, 0, n);
                menuElementArray3[n] = jPopupMenu;
                menuSelectionManager.setSelectedPath(menuElementArray3);
                return;
            }
            if (n > 1 && menuElementArray[0] instanceof JMenuBar) {
                MenuElement menuElement = menuElementArray[1];
                MenuElement menuElement2 = BasicPopupMenuUI.findEnabledChild(menuElementArray[0].getSubElements(), menuElement, bl);
                if (menuElement2 != null && menuElement2 != menuElement) {
                    MenuElement[] menuElementArray5 = n == 2 ? new MenuElement[]{menuElementArray[0], menuElement2} : new MenuElement[]{menuElementArray[0], menuElement2, ((JMenu)menuElement2).getPopupMenu()};
                    menuSelectionManager.setSelectedPath(menuElementArray5);
                }
            }
        }

        private void selectItem(boolean bl) {
            MenuSelectionManager menuSelectionManager = MenuSelectionManager.defaultManager();
            MenuElement[] menuElementArray = menuSelectionManager.getSelectedPath();
            if (menuElementArray.length == 0) {
                return;
            }
            int n = menuElementArray.length;
            if (n == 1 && menuElementArray[0] instanceof JPopupMenu) {
                JPopupMenu jPopupMenu = (JPopupMenu)menuElementArray[0];
                MenuElement[] menuElementArray2 = new MenuElement[]{jPopupMenu, BasicPopupMenuUI.findEnabledChild(jPopupMenu.getSubElements(), -1, bl)};
                menuSelectionManager.setSelectedPath(menuElementArray2);
            } else if (n == 2 && menuElementArray[0] instanceof JMenuBar && menuElementArray[1] instanceof JMenu) {
                MenuElement[] menuElementArray3;
                JPopupMenu jPopupMenu = ((JMenu)menuElementArray[1]).getPopupMenu();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(jPopupMenu.getSubElements(), -1, true);
                if (menuElement != null) {
                    menuElementArray3 = new MenuElement[4];
                    menuElementArray3[3] = menuElement;
                } else {
                    menuElementArray3 = new MenuElement[3];
                }
                System.arraycopy(menuElementArray, 0, menuElementArray3, 0, 2);
                menuElementArray3[2] = jPopupMenu;
                menuSelectionManager.setSelectedPath(menuElementArray3);
            } else if (menuElementArray[n - 1] instanceof JPopupMenu && menuElementArray[n - 2] instanceof JMenu) {
                JMenu jMenu = (JMenu)menuElementArray[n - 2];
                JPopupMenu jPopupMenu = jMenu.getPopupMenu();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(jPopupMenu.getSubElements(), -1, bl);
                if (menuElement != null) {
                    MenuElement[] menuElementArray4 = new MenuElement[n + 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray4, 0, n);
                    menuElementArray4[n] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray4);
                } else if (n > 2 && menuElementArray[n - 3] instanceof JPopupMenu && (menuElement = BasicPopupMenuUI.findEnabledChild((jPopupMenu = (JPopupMenu)menuElementArray[n - 3]).getSubElements(), jMenu, bl)) != null && menuElement != jMenu) {
                    MenuElement[] menuElementArray5 = new MenuElement[n - 1];
                    System.arraycopy(menuElementArray, 0, menuElementArray5, 0, n - 2);
                    menuElementArray5[n - 2] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray5);
                }
            } else {
                MenuElement[] menuElementArray6 = menuElementArray[n - 2].getSubElements();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(menuElementArray6, menuElementArray[n - 1], bl);
                if (menuElement == null) {
                    menuElement = BasicPopupMenuUI.findEnabledChild(menuElementArray6, -1, bl);
                }
                if (menuElement != null) {
                    menuElementArray[n - 1] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                }
            }
        }

        private void cancel() {
            String string;
            JPopupMenu jPopupMenu = BasicPopupMenuUI.getLastPopup();
            if (jPopupMenu != null) {
                jPopupMenu.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
            }
            if ("hideMenuTree".equals(string = UIManager.getString("Menu.cancelMode"))) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
            } else {
                this.shortenSelectedPath();
            }
        }

        private void shortenSelectedPath() {
            MenuElement[] menuElementArray;
            MenuElement[] menuElementArray2 = MenuSelectionManager.defaultManager().getSelectedPath();
            if (menuElementArray2.length <= 2) {
                MenuSelectionManager.defaultManager().clearSelectedPath();
                return;
            }
            int n = 2;
            MenuElement menuElement = menuElementArray2[menuElementArray2.length - 1];
            JPopupMenu jPopupMenu = BasicPopupMenuUI.getLastPopup();
            if (menuElement == jPopupMenu && (menuElementArray = menuElementArray2[menuElementArray2.length - 2]) instanceof JMenu) {
                JMenu jMenu = (JMenu)menuElementArray;
                n = jMenu.isEnabled() && jPopupMenu.getComponentCount() > 0 ? 1 : 3;
            }
            if (menuElementArray2.length - n <= 2 && !UIManager.getBoolean("Menu.preserveTopLevelSelection")) {
                n = menuElementArray2.length;
            }
            menuElementArray = new MenuElement[menuElementArray2.length - n];
            System.arraycopy(menuElementArray2, 0, menuElementArray, 0, menuElementArray2.length - n);
            MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
        }
    }

    private class BasicMenuKeyListener
    implements MenuKeyListener {
        MenuElement menuToOpen = null;

        private BasicMenuKeyListener() {
        }

        public void menuKeyTyped(MenuKeyEvent menuKeyEvent) {
            if (this.menuToOpen != null) {
                JPopupMenu jPopupMenu = ((JMenu)this.menuToOpen).getPopupMenu();
                MenuElement menuElement = BasicPopupMenuUI.findEnabledChild(jPopupMenu.getSubElements(), -1, true);
                ArrayList<MenuElement> arrayList = new ArrayList<MenuElement>(Arrays.asList(menuKeyEvent.getPath()));
                arrayList.add(this.menuToOpen);
                arrayList.add(jPopupMenu);
                if (menuElement != null) {
                    arrayList.add(menuElement);
                }
                MenuElement[] menuElementArray = new MenuElement[]{};
                menuElementArray = arrayList.toArray(menuElementArray);
                MenuSelectionManager.defaultManager().setSelectedPath(menuElementArray);
                menuKeyEvent.consume();
            }
            this.menuToOpen = null;
        }

        public void menuKeyPressed(MenuKeyEvent menuKeyEvent) {
            MenuElement[] menuElementArray;
            char c = menuKeyEvent.getKeyChar();
            if (!Character.isLetterOrDigit(c)) {
                return;
            }
            MenuSelectionManager menuSelectionManager = menuKeyEvent.getMenuSelectionManager();
            MenuElement[] menuElementArray2 = menuKeyEvent.getPath();
            MenuElement[] menuElementArray3 = BasicPopupMenuUI.this.popupMenu.getSubElements();
            int n = -1;
            int n2 = 0;
            int n3 = -1;
            int[] nArray = null;
            for (int i = 0; i < menuElementArray3.length; ++i) {
                if (!(menuElementArray3[i] instanceof JMenuItem)) continue;
                menuElementArray = (MenuElement[])menuElementArray3[i];
                int n4 = menuElementArray.getMnemonic();
                if (menuElementArray.isEnabled() && menuElementArray.isVisible() && this.lower(c) == this.lower(n4)) {
                    if (n2 == 0) {
                        n3 = i;
                        ++n2;
                    } else {
                        if (nArray == null) {
                            nArray = new int[menuElementArray3.length];
                            nArray[0] = n3;
                        }
                        nArray[n2++] = i;
                    }
                }
                if (!menuElementArray.isArmed()) continue;
                n = n2 - 1;
            }
            if (n2 != 0) {
                if (n2 == 1) {
                    JMenuItem jMenuItem = (JMenuItem)menuElementArray3[n3];
                    if (jMenuItem instanceof JMenu) {
                        this.menuToOpen = jMenuItem;
                    } else if (jMenuItem.isEnabled()) {
                        menuSelectionManager.clearSelectedPath();
                        jMenuItem.doClick();
                    }
                    menuKeyEvent.consume();
                } else {
                    MenuElement menuElement = menuElementArray3[nArray[(n + 1) % n2]];
                    menuElementArray = new MenuElement[menuElementArray2.length + 1];
                    System.arraycopy(menuElementArray2, 0, menuElementArray, 0, menuElementArray2.length);
                    menuElementArray[menuElementArray2.length] = menuElement;
                    menuSelectionManager.setSelectedPath(menuElementArray);
                    menuKeyEvent.consume();
                }
            }
        }

        public void menuKeyReleased(MenuKeyEvent menuKeyEvent) {
        }

        private char lower(char c) {
            return Character.toLowerCase(c);
        }

        private char lower(int n) {
            return Character.toLowerCase((char)n);
        }
    }

    private class BasicPopupMenuListener
    implements PopupMenuListener {
        private BasicPopupMenuListener() {
        }

        public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        }

        public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            BasicLookAndFeel.playSound((JPopupMenu)popupMenuEvent.getSource(), "PopupMenu.popupSound");
        }
    }
}

