/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import java.util.Hashtable;
import javax.swing.AbstractButton;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.LookAndFeel;
import javax.swing.RootPaneContainer;
import javax.swing.SwingConstants;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.ToolBarUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicBorders;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.plaf.basic.BasicLookAndFeel;
import javax.swing.plaf.basic.LazyActionMap;
import sun.swing.DefaultLookup;
import sun.swing.UIAction;

public class BasicToolBarUI
extends ToolBarUI
implements SwingConstants {
    protected JToolBar toolBar;
    private boolean floating;
    private int floatingX;
    private int floatingY;
    private JFrame floatingFrame;
    private RootPaneContainer floatingToolBar;
    protected DragWindow dragWindow;
    private Container dockingSource;
    private int dockingSensitivity = 0;
    protected int focusedCompIndex = -1;
    protected Color dockingColor = null;
    protected Color floatingColor = null;
    protected Color dockingBorderColor = null;
    protected Color floatingBorderColor = null;
    protected MouseInputListener dockingListener;
    protected PropertyChangeListener propertyListener;
    protected ContainerListener toolBarContListener;
    protected FocusListener toolBarFocusListener;
    private Handler handler;
    protected String constraintBeforeFloating = "North";
    private static String IS_ROLLOVER = "JToolBar.isRollover";
    private static Border rolloverBorder;
    private static Border nonRolloverBorder;
    private static Border nonRolloverToggleBorder;
    private boolean rolloverBorders = false;
    private HashMap<AbstractButton, Border> borderTable = new HashMap();
    private Hashtable<AbstractButton, Boolean> rolloverTable = new Hashtable();
    @Deprecated
    protected KeyStroke upKey;
    @Deprecated
    protected KeyStroke downKey;
    @Deprecated
    protected KeyStroke leftKey;
    @Deprecated
    protected KeyStroke rightKey;
    private static String FOCUSED_COMP_INDEX;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicToolBarUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.toolBar = (JToolBar)jComponent;
        this.installDefaults();
        this.installComponents();
        this.installListeners();
        this.installKeyboardActions();
        this.dockingSensitivity = 0;
        this.floating = false;
        this.floatingY = 0;
        this.floatingX = 0;
        this.floatingToolBar = null;
        this.setOrientation(this.toolBar.getOrientation());
        LookAndFeel.installProperty(jComponent, "opaque", Boolean.TRUE);
        if (jComponent.getClientProperty(FOCUSED_COMP_INDEX) != null) {
            this.focusedCompIndex = (Integer)jComponent.getClientProperty(FOCUSED_COMP_INDEX);
        }
    }

    @Override
    public void uninstallUI(JComponent jComponent) {
        this.uninstallDefaults();
        this.uninstallComponents();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        if (this.isFloating()) {
            this.setFloating(false, null);
        }
        this.floatingToolBar = null;
        this.dragWindow = null;
        this.dockingSource = null;
        jComponent.putClientProperty(FOCUSED_COMP_INDEX, new Integer(this.focusedCompIndex));
    }

    protected void installDefaults() {
        Object object;
        LookAndFeel.installBorder(this.toolBar, "ToolBar.border");
        LookAndFeel.installColorsAndFont(this.toolBar, "ToolBar.background", "ToolBar.foreground", "ToolBar.font");
        if (this.dockingColor == null || this.dockingColor instanceof UIResource) {
            this.dockingColor = UIManager.getColor("ToolBar.dockingBackground");
        }
        if (this.floatingColor == null || this.floatingColor instanceof UIResource) {
            this.floatingColor = UIManager.getColor("ToolBar.floatingBackground");
        }
        if (this.dockingBorderColor == null || this.dockingBorderColor instanceof UIResource) {
            this.dockingBorderColor = UIManager.getColor("ToolBar.dockingForeground");
        }
        if (this.floatingBorderColor == null || this.floatingBorderColor instanceof UIResource) {
            this.floatingBorderColor = UIManager.getColor("ToolBar.floatingForeground");
        }
        if ((object = this.toolBar.getClientProperty(IS_ROLLOVER)) == null) {
            object = UIManager.get("ToolBar.isRollover");
        }
        if (object != null) {
            this.rolloverBorders = (Boolean)object;
        }
        if (rolloverBorder == null) {
            rolloverBorder = this.createRolloverBorder();
        }
        if (nonRolloverBorder == null) {
            nonRolloverBorder = this.createNonRolloverBorder();
        }
        if (nonRolloverToggleBorder == null) {
            nonRolloverToggleBorder = this.createNonRolloverToggleBorder();
        }
        this.setRolloverBorders(this.isRolloverBorders());
    }

    protected void uninstallDefaults() {
        LookAndFeel.uninstallBorder(this.toolBar);
        this.dockingColor = null;
        this.floatingColor = null;
        this.dockingBorderColor = null;
        this.floatingBorderColor = null;
        this.installNormalBorders(this.toolBar);
        rolloverBorder = null;
        nonRolloverBorder = null;
        nonRolloverToggleBorder = null;
    }

    protected void installComponents() {
    }

    protected void uninstallComponents() {
    }

    protected void installListeners() {
        this.dockingListener = this.createDockingListener();
        if (this.dockingListener != null) {
            this.toolBar.addMouseMotionListener(this.dockingListener);
            this.toolBar.addMouseListener(this.dockingListener);
        }
        this.propertyListener = this.createPropertyListener();
        if (this.propertyListener != null) {
            this.toolBar.addPropertyChangeListener(this.propertyListener);
        }
        this.toolBarContListener = this.createToolBarContListener();
        if (this.toolBarContListener != null) {
            this.toolBar.addContainerListener(this.toolBarContListener);
        }
        this.toolBarFocusListener = this.createToolBarFocusListener();
        if (this.toolBarFocusListener != null) {
            Component[] componentArray;
            for (Component component : componentArray = this.toolBar.getComponents()) {
                component.addFocusListener(this.toolBarFocusListener);
            }
        }
    }

    protected void uninstallListeners() {
        if (this.dockingListener != null) {
            this.toolBar.removeMouseMotionListener(this.dockingListener);
            this.toolBar.removeMouseListener(this.dockingListener);
            this.dockingListener = null;
        }
        if (this.propertyListener != null) {
            this.toolBar.removePropertyChangeListener(this.propertyListener);
            this.propertyListener = null;
        }
        if (this.toolBarContListener != null) {
            this.toolBar.removeContainerListener(this.toolBarContListener);
            this.toolBarContListener = null;
        }
        if (this.toolBarFocusListener != null) {
            Component[] componentArray;
            for (Component component : componentArray = this.toolBar.getComponents()) {
                component.removeFocusListener(this.toolBarFocusListener);
            }
            this.toolBarFocusListener = null;
        }
        this.handler = null;
    }

    protected void installKeyboardActions() {
        InputMap inputMap = this.getInputMap(1);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, inputMap);
        LazyActionMap.installLazyActionMap(this.toolBar, BasicToolBarUI.class, "ToolBar.actionMap");
    }

    InputMap getInputMap(int n) {
        if (n == 1) {
            return (InputMap)DefaultLookup.get(this.toolBar, this, "ToolBar.ancestorInputMap");
        }
        return null;
    }

    static void loadActionMap(LazyActionMap lazyActionMap) {
        lazyActionMap.put(new Actions("navigateRight"));
        lazyActionMap.put(new Actions("navigateLeft"));
        lazyActionMap.put(new Actions("navigateUp"));
        lazyActionMap.put(new Actions("navigateDown"));
    }

    protected void uninstallKeyboardActions() {
        SwingUtilities.replaceUIActionMap(this.toolBar, null);
        SwingUtilities.replaceUIInputMap(this.toolBar, 1, null);
    }

    protected void navigateFocusedComp(int n) {
        int n2 = this.toolBar.getComponentCount();
        block0 : switch (n) {
            case 3: 
            case 5: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n2) break;
                int n3 = this.focusedCompIndex + 1;
                while (n3 != this.focusedCompIndex) {
                    Component component;
                    if (n3 >= n2) {
                        n3 = 0;
                    }
                    if ((component = this.toolBar.getComponentAtIndex(n3++)) == null || !component.isFocusTraversable() || !component.isEnabled()) continue;
                    component.requestFocus();
                    break block0;
                }
                break;
            }
            case 1: 
            case 7: {
                if (this.focusedCompIndex < 0 || this.focusedCompIndex >= n2) break;
                int n4 = this.focusedCompIndex - 1;
                while (n4 != this.focusedCompIndex) {
                    Component component;
                    if (n4 < 0) {
                        n4 = n2 - 1;
                    }
                    if ((component = this.toolBar.getComponentAtIndex(n4--)) == null || !component.isFocusTraversable() || !component.isEnabled()) continue;
                    component.requestFocus();
                    break block0;
                }
                break;
            }
        }
    }

    protected Border createRolloverBorder() {
        Object object = UIManager.get("ToolBar.rolloverBorder");
        if (object != null) {
            return (Border)object;
        }
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new BasicBorders.RolloverButtonBorder(uIDefaults.getColor("controlShadow"), uIDefaults.getColor("controlDkShadow"), uIDefaults.getColor("controlHighlight"), uIDefaults.getColor("controlLtHighlight")), new BasicBorders.RolloverMarginBorder());
    }

    protected Border createNonRolloverBorder() {
        Object object = UIManager.get("ToolBar.nonrolloverBorder");
        if (object != null) {
            return (Border)object;
        }
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new BasicBorders.ButtonBorder(uIDefaults.getColor("Button.shadow"), uIDefaults.getColor("Button.darkShadow"), uIDefaults.getColor("Button.light"), uIDefaults.getColor("Button.highlight")), new BasicBorders.RolloverMarginBorder());
    }

    private Border createNonRolloverToggleBorder() {
        UIDefaults uIDefaults = UIManager.getLookAndFeelDefaults();
        return new CompoundBorder(new BasicBorders.RadioButtonBorder(uIDefaults.getColor("ToggleButton.shadow"), uIDefaults.getColor("ToggleButton.darkShadow"), uIDefaults.getColor("ToggleButton.light"), uIDefaults.getColor("ToggleButton.highlight")), new BasicBorders.RolloverMarginBorder());
    }

    protected JFrame createFloatingFrame(JToolBar jToolBar) {
        Window window = SwingUtilities.getWindowAncestor(jToolBar);
        JFrame jFrame = new JFrame(jToolBar.getName(), window != null ? window.getGraphicsConfiguration() : null){

            @Override
            protected JRootPane createRootPane() {
                JRootPane jRootPane = new JRootPane(){
                    private boolean packing = false;

                    @Override
                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                jRootPane.setOpaque(true);
                return jRootPane;
            }
        };
        jFrame.getRootPane().setName("ToolBar.FloatingFrame");
        jFrame.setResizable(false);
        WindowListener windowListener = this.createFrameListener();
        jFrame.addWindowListener(windowListener);
        return jFrame;
    }

    protected RootPaneContainer createFloatingWindow(JToolBar jToolBar) {
        Window window = SwingUtilities.getWindowAncestor(jToolBar);
        class ToolBarDialog
        extends JDialog {
            public ToolBarDialog(Frame frame, String string, boolean bl) {
                super(frame, string, bl);
            }

            public ToolBarDialog(Dialog dialog, String string, boolean bl) {
                super(dialog, string, bl);
            }

            @Override
            protected JRootPane createRootPane() {
                JRootPane jRootPane = new JRootPane(){
                    private boolean packing = false;

                    @Override
                    public void validate() {
                        super.validate();
                        if (!this.packing) {
                            this.packing = true;
                            this.pack();
                            this.packing = false;
                        }
                    }
                };
                jRootPane.setOpaque(true);
                return jRootPane;
            }
        }
        ToolBarDialog toolBarDialog = window instanceof Frame ? new ToolBarDialog((Frame)window, jToolBar.getName(), false) : (window instanceof Dialog ? new ToolBarDialog((Dialog)window, jToolBar.getName(), false) : new ToolBarDialog((Frame)null, jToolBar.getName(), false));
        toolBarDialog.getRootPane().setName("ToolBar.FloatingWindow");
        toolBarDialog.setTitle(jToolBar.getName());
        toolBarDialog.setResizable(false);
        WindowListener windowListener = this.createFrameListener();
        toolBarDialog.addWindowListener(windowListener);
        return toolBarDialog;
    }

    protected DragWindow createDragWindow(JToolBar jToolBar) {
        Container container;
        Window window = null;
        if (this.toolBar != null) {
            for (container = this.toolBar.getParent(); container != null && !(container instanceof Window); container = container.getParent()) {
            }
            if (container != null && container instanceof Window) {
                window = (Window)container;
            }
        }
        if (this.floatingToolBar == null) {
            this.floatingToolBar = this.createFloatingWindow(this.toolBar);
        }
        if (this.floatingToolBar instanceof Window) {
            window = (Window)((Object)this.floatingToolBar);
        }
        container = new DragWindow(window);
        return container;
    }

    public boolean isRolloverBorders() {
        return this.rolloverBorders;
    }

    public void setRolloverBorders(boolean bl) {
        this.rolloverBorders = bl;
        if (this.rolloverBorders) {
            this.installRolloverBorders(this.toolBar);
        } else {
            this.installNonRolloverBorders(this.toolBar);
        }
    }

    protected void installRolloverBorders(JComponent jComponent) {
        Component[] componentArray;
        for (Component component : componentArray = jComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).updateUI();
            this.setBorderToRollover(component);
        }
    }

    protected void installNonRolloverBorders(JComponent jComponent) {
        Component[] componentArray;
        for (Component component : componentArray = jComponent.getComponents()) {
            if (!(component instanceof JComponent)) continue;
            ((JComponent)component).updateUI();
            this.setBorderToNonRollover(component);
        }
    }

    protected void installNormalBorders(JComponent jComponent) {
        Component[] componentArray;
        for (Component component : componentArray = jComponent.getComponents()) {
            this.setBorderToNormal(component);
        }
    }

    protected void setBorderToRollover(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Border border = this.borderTable.get(abstractButton);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(abstractButton, abstractButton.getBorder());
            }
            if (abstractButton.getBorder() instanceof UIResource) {
                abstractButton.setBorder(this.getRolloverBorder(abstractButton));
            }
            this.rolloverTable.put(abstractButton, abstractButton.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            abstractButton.setRolloverEnabled(true);
        }
    }

    protected Border getRolloverBorder(AbstractButton abstractButton) {
        return rolloverBorder;
    }

    protected void setBorderToNonRollover(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Border border = this.borderTable.get(abstractButton);
            if (border == null || border instanceof UIResource) {
                this.borderTable.put(abstractButton, abstractButton.getBorder());
            }
            if (abstractButton.getBorder() instanceof UIResource) {
                abstractButton.setBorder(this.getNonRolloverBorder(abstractButton));
            }
            this.rolloverTable.put(abstractButton, abstractButton.isRolloverEnabled() ? Boolean.TRUE : Boolean.FALSE);
            abstractButton.setRolloverEnabled(false);
        }
    }

    protected Border getNonRolloverBorder(AbstractButton abstractButton) {
        if (abstractButton instanceof JToggleButton) {
            return nonRolloverToggleBorder;
        }
        return nonRolloverBorder;
    }

    protected void setBorderToNormal(Component component) {
        if (component instanceof AbstractButton) {
            AbstractButton abstractButton = (AbstractButton)component;
            Border border = this.borderTable.remove(abstractButton);
            abstractButton.setBorder(border);
            Boolean bl = this.rolloverTable.remove(abstractButton);
            if (bl != null) {
                abstractButton.setRolloverEnabled(bl);
            }
        }
    }

    public void setFloatingLocation(int n, int n2) {
        this.floatingX = n;
        this.floatingY = n2;
    }

    public boolean isFloating() {
        return this.floating;
    }

    public void setFloating(boolean bl, Point point) {
        if (this.toolBar.isFloatable()) {
            Object object;
            boolean bl2 = false;
            Window window = SwingUtilities.getWindowAncestor(this.toolBar);
            if (window != null) {
                bl2 = window.isVisible();
            }
            if (this.dragWindow != null) {
                this.dragWindow.setVisible(false);
            }
            this.floating = bl;
            if (this.floatingToolBar == null) {
                this.floatingToolBar = this.createFloatingWindow(this.toolBar);
            }
            if (bl) {
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                    this.dockingSource.remove(this.toolBar);
                }
                this.constraintBeforeFloating = this.calculateConstraint();
                if (this.propertyListener != null) {
                    UIManager.addPropertyChangeListener(this.propertyListener);
                }
                this.floatingToolBar.getContentPane().add((Component)this.toolBar, "Center");
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).pack();
                    ((Window)((Object)this.floatingToolBar)).setLocation(this.floatingX, this.floatingY);
                    if (bl2) {
                        ((Window)((Object)this.floatingToolBar)).show();
                    } else {
                        window.addWindowListener(new WindowAdapter(){

                            @Override
                            public void windowOpened(WindowEvent windowEvent) {
                                ((Window)((Object)BasicToolBarUI.this.floatingToolBar)).show();
                            }
                        });
                    }
                }
            } else {
                if (this.floatingToolBar == null) {
                    this.floatingToolBar = this.createFloatingWindow(this.toolBar);
                }
                if (this.floatingToolBar instanceof Window) {
                    ((Window)((Object)this.floatingToolBar)).setVisible(false);
                }
                this.floatingToolBar.getContentPane().remove(this.toolBar);
                object = this.getDockingConstraint(this.dockingSource, point);
                if (object == null) {
                    object = "North";
                }
                int n = this.mapConstraintToOrientation((String)object);
                this.setOrientation(n);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                if (this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(this.propertyListener);
                }
                this.dockingSource.add((String)object, this.toolBar);
            }
            this.dockingSource.invalidate();
            object = this.dockingSource.getParent();
            if (object != null) {
                ((Container)object).validate();
            }
            this.dockingSource.repaint();
        }
    }

    private int mapConstraintToOrientation(String string) {
        int n = this.toolBar.getOrientation();
        if (string != null) {
            if (string.equals("East") || string.equals("West")) {
                n = 1;
            } else if (string.equals("North") || string.equals("South")) {
                n = 0;
            }
        }
        return n;
    }

    public void setOrientation(int n) {
        this.toolBar.setOrientation(n);
        if (this.dragWindow != null) {
            this.dragWindow.setOrientation(n);
        }
    }

    public Color getDockingColor() {
        return this.dockingColor;
    }

    public void setDockingColor(Color color) {
        this.dockingColor = color;
    }

    public Color getFloatingColor() {
        return this.floatingColor;
    }

    public void setFloatingColor(Color color) {
        this.floatingColor = color;
    }

    private boolean isBlocked(Component component, Object object) {
        Container container;
        LayoutManager layoutManager;
        if (component instanceof Container && (layoutManager = (container = (Container)component).getLayout()) instanceof BorderLayout) {
            BorderLayout borderLayout = (BorderLayout)layoutManager;
            Component component2 = borderLayout.getLayoutComponent(container, object);
            return component2 != null && component2 != this.toolBar;
        }
        return false;
    }

    public boolean canDock(Component component, Point point) {
        return point != null && this.getDockingConstraint(component, point) != null;
    }

    private String calculateConstraint() {
        String string = null;
        LayoutManager layoutManager = this.dockingSource.getLayout();
        if (layoutManager instanceof BorderLayout) {
            string = (String)((BorderLayout)layoutManager).getConstraints(this.toolBar);
        }
        return string != null ? string : this.constraintBeforeFloating;
    }

    private String getDockingConstraint(Component component, Point point) {
        if (point == null) {
            return this.constraintBeforeFloating;
        }
        if (component.contains(point)) {
            int n = this.dockingSensitivity = this.toolBar.getOrientation() == 0 ? this.toolBar.getSize().height : this.toolBar.getSize().width;
            if (point.y < this.dockingSensitivity && !this.isBlocked(component, "North")) {
                return "North";
            }
            if (point.x >= component.getWidth() - this.dockingSensitivity && !this.isBlocked(component, "East")) {
                return "East";
            }
            if (point.x < this.dockingSensitivity && !this.isBlocked(component, "West")) {
                return "West";
            }
            if (point.y >= component.getHeight() - this.dockingSensitivity && !this.isBlocked(component, "South")) {
                return "South";
            }
        }
        return null;
    }

    protected void dragTo(Point point, Point point2) {
        if (this.toolBar.isFloatable()) {
            try {
                Object object;
                Cloneable cloneable;
                Point point3;
                if (this.dragWindow == null) {
                    this.dragWindow = this.createDragWindow(this.toolBar);
                }
                if ((point3 = this.dragWindow.getOffset()) == null) {
                    cloneable = this.toolBar.getPreferredSize();
                    point3 = new Point(cloneable.width / 2, cloneable.height / 2);
                    this.dragWindow.setOffset(point3);
                }
                cloneable = new Point(point2.x + point.x, point2.y + point.y);
                Point point4 = new Point(((Point)cloneable).x - point3.x, ((Point)cloneable).y - point3.y);
                if (this.dockingSource == null) {
                    this.dockingSource = this.toolBar.getParent();
                }
                this.constraintBeforeFloating = this.calculateConstraint();
                Point point5 = this.dockingSource.getLocationOnScreen();
                Point point6 = new Point(((Point)cloneable).x - point5.x, ((Point)cloneable).y - point5.y);
                if (this.canDock(this.dockingSource, point6)) {
                    this.dragWindow.setBackground(this.getDockingColor());
                    object = this.getDockingConstraint(this.dockingSource, point6);
                    int n = this.mapConstraintToOrientation((String)object);
                    this.dragWindow.setOrientation(n);
                    this.dragWindow.setBorderColor(this.dockingBorderColor);
                } else {
                    this.dragWindow.setBackground(this.getFloatingColor());
                    this.dragWindow.setBorderColor(this.floatingBorderColor);
                    this.dragWindow.setOrientation(this.toolBar.getOrientation());
                }
                this.dragWindow.setLocation(point4.x, point4.y);
                if (!this.dragWindow.isVisible()) {
                    object = this.toolBar.getPreferredSize();
                    this.dragWindow.setSize(((Dimension)object).width, ((Dimension)object).height);
                    this.dragWindow.show();
                }
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    protected void floatAt(Point point, Point point2) {
        if (this.toolBar.isFloatable()) {
            try {
                Point point3 = this.dragWindow.getOffset();
                if (point3 == null) {
                    point3 = point;
                    this.dragWindow.setOffset(point3);
                }
                Point point4 = new Point(point2.x + point.x, point2.y + point.y);
                this.setFloatingLocation(point4.x - point3.x, point4.y - point3.y);
                if (this.dockingSource != null) {
                    Point point5 = this.dockingSource.getLocationOnScreen();
                    Point point6 = new Point(point4.x - point5.x, point4.y - point5.y);
                    if (this.canDock(this.dockingSource, point6)) {
                        this.setFloating(false, point6);
                    } else {
                        this.setFloating(true, null);
                    }
                } else {
                    this.setFloating(true, null);
                }
                this.dragWindow.setOffset(null);
            }
            catch (IllegalComponentStateException illegalComponentStateException) {
                // empty catch block
            }
        }
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected ContainerListener createToolBarContListener() {
        return this.getHandler();
    }

    protected FocusListener createToolBarFocusListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createPropertyListener() {
        return this.getHandler();
    }

    protected MouseInputListener createDockingListener() {
        this.getHandler().tb = this.toolBar;
        return this.getHandler();
    }

    protected WindowListener createFrameListener() {
        return new FrameListener();
    }

    protected void paintDragWindow(Graphics graphics) {
        graphics.setColor(this.dragWindow.getBackground());
        int n = this.dragWindow.getWidth();
        int n2 = this.dragWindow.getHeight();
        graphics.fillRect(0, 0, n, n2);
        graphics.setColor(this.dragWindow.getBorderColor());
        graphics.drawRect(0, 0, n - 1, n2 - 1);
    }

    static {
        FOCUSED_COMP_INDEX = "JToolBar.focusedCompIndex";
    }

    protected class DragWindow
    extends Window {
        Color borderColor;
        int orientation;
        Point offset;

        DragWindow(Window window) {
            super(window);
            this.borderColor = Color.gray;
            this.orientation = BasicToolBarUI.this.toolBar.getOrientation();
        }

        public int getOrientation() {
            return this.orientation;
        }

        public void setOrientation(int n) {
            if (this.isShowing()) {
                if (n == this.orientation) {
                    return;
                }
                this.orientation = n;
                Dimension dimension = this.getSize();
                this.setSize(new Dimension(dimension.height, dimension.width));
                if (this.offset != null) {
                    if (BasicGraphicsUtils.isLeftToRight(BasicToolBarUI.this.toolBar)) {
                        this.setOffset(new Point(this.offset.y, this.offset.x));
                    } else if (n == 0) {
                        this.setOffset(new Point(dimension.height - this.offset.y, this.offset.x));
                    } else {
                        this.setOffset(new Point(this.offset.y, dimension.width - this.offset.x));
                    }
                }
                this.repaint();
            }
        }

        public Point getOffset() {
            return this.offset;
        }

        public void setOffset(Point point) {
            this.offset = point;
        }

        public void setBorderColor(Color color) {
            if (this.borderColor == color) {
                return;
            }
            this.borderColor = color;
            this.repaint();
        }

        public Color getBorderColor() {
            return this.borderColor;
        }

        @Override
        public void paint(Graphics graphics) {
            BasicToolBarUI.this.paintDragWindow(graphics);
            super.paint(graphics);
        }

        @Override
        public Insets getInsets() {
            return new Insets(1, 1, 1, 1);
        }
    }

    public class DockingListener
    implements MouseInputListener {
        protected JToolBar toolBar;
        protected boolean isDragging = false;
        protected Point origin = null;

        public DockingListener(JToolBar jToolBar) {
            this.toolBar = jToolBar;
            ((BasicToolBarUI)BasicToolBarUI.this).getHandler().tb = jToolBar;
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
            BasicToolBarUI.this.getHandler().mouseClicked(mouseEvent);
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            ((BasicToolBarUI)BasicToolBarUI.this).getHandler().tb = this.toolBar;
            BasicToolBarUI.this.getHandler().mousePressed(mouseEvent);
            this.isDragging = ((BasicToolBarUI)BasicToolBarUI.this).getHandler().isDragging;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            ((BasicToolBarUI)BasicToolBarUI.this).getHandler().tb = this.toolBar;
            ((BasicToolBarUI)BasicToolBarUI.this).getHandler().isDragging = this.isDragging;
            ((BasicToolBarUI)BasicToolBarUI.this).getHandler().origin = this.origin;
            BasicToolBarUI.this.getHandler().mouseReleased(mouseEvent);
            this.isDragging = ((BasicToolBarUI)BasicToolBarUI.this).getHandler().isDragging;
            this.origin = ((BasicToolBarUI)BasicToolBarUI.this).getHandler().origin;
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
            BasicToolBarUI.this.getHandler().mouseEntered(mouseEvent);
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
            BasicToolBarUI.this.getHandler().mouseExited(mouseEvent);
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            ((BasicToolBarUI)BasicToolBarUI.this).getHandler().tb = this.toolBar;
            ((BasicToolBarUI)BasicToolBarUI.this).getHandler().origin = this.origin;
            BasicToolBarUI.this.getHandler().mouseDragged(mouseEvent);
            this.isDragging = ((BasicToolBarUI)BasicToolBarUI.this).getHandler().isDragging;
            this.origin = ((BasicToolBarUI)BasicToolBarUI.this).getHandler().origin;
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
            BasicToolBarUI.this.getHandler().mouseMoved(mouseEvent);
        }
    }

    protected class PropertyListener
    implements PropertyChangeListener {
        protected PropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            BasicToolBarUI.this.getHandler().propertyChange(propertyChangeEvent);
        }
    }

    protected class ToolBarFocusListener
    implements FocusListener {
        protected ToolBarFocusListener() {
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            BasicToolBarUI.this.getHandler().focusGained(focusEvent);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
            BasicToolBarUI.this.getHandler().focusLost(focusEvent);
        }
    }

    protected class ToolBarContListener
    implements ContainerListener {
        protected ToolBarContListener() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            BasicToolBarUI.this.getHandler().componentAdded(containerEvent);
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            BasicToolBarUI.this.getHandler().componentRemoved(containerEvent);
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        protected FrameListener() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            if (BasicToolBarUI.this.toolBar.isFloatable()) {
                if (BasicToolBarUI.this.dragWindow != null) {
                    BasicToolBarUI.this.dragWindow.setVisible(false);
                }
                BasicToolBarUI.this.floating = false;
                if (BasicToolBarUI.this.floatingToolBar == null) {
                    BasicToolBarUI.this.floatingToolBar = BasicToolBarUI.this.createFloatingWindow(BasicToolBarUI.this.toolBar);
                }
                if (BasicToolBarUI.this.floatingToolBar instanceof Window) {
                    ((Window)((Object)BasicToolBarUI.this.floatingToolBar)).setVisible(false);
                }
                BasicToolBarUI.this.floatingToolBar.getContentPane().remove(BasicToolBarUI.this.toolBar);
                String string = BasicToolBarUI.this.constraintBeforeFloating;
                if (BasicToolBarUI.this.toolBar.getOrientation() == 0) {
                    if (string == "West" || string == "East") {
                        string = "North";
                    }
                } else if (string == "North" || string == "South") {
                    string = "West";
                }
                if (BasicToolBarUI.this.dockingSource == null) {
                    BasicToolBarUI.this.dockingSource = BasicToolBarUI.this.toolBar.getParent();
                }
                if (BasicToolBarUI.this.propertyListener != null) {
                    UIManager.removePropertyChangeListener(BasicToolBarUI.this.propertyListener);
                }
                BasicToolBarUI.this.dockingSource.add((Component)BasicToolBarUI.this.toolBar, string);
                BasicToolBarUI.this.dockingSource.invalidate();
                Container container = BasicToolBarUI.this.dockingSource.getParent();
                if (container != null) {
                    container.validate();
                }
                BasicToolBarUI.this.dockingSource.repaint();
            }
        }
    }

    private class Handler
    implements ContainerListener,
    FocusListener,
    MouseInputListener,
    PropertyChangeListener {
        JToolBar tb;
        boolean isDragging = false;
        Point origin = null;

        private Handler() {
        }

        @Override
        public void componentAdded(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (BasicToolBarUI.this.toolBarFocusListener != null) {
                component.addFocusListener(BasicToolBarUI.this.toolBarFocusListener);
            }
            if (BasicToolBarUI.this.isRolloverBorders()) {
                BasicToolBarUI.this.setBorderToRollover(component);
            } else {
                BasicToolBarUI.this.setBorderToNonRollover(component);
            }
        }

        @Override
        public void componentRemoved(ContainerEvent containerEvent) {
            Component component = containerEvent.getChild();
            if (BasicToolBarUI.this.toolBarFocusListener != null) {
                component.removeFocusListener(BasicToolBarUI.this.toolBarFocusListener);
            }
            BasicToolBarUI.this.setBorderToNormal(component);
        }

        @Override
        public void focusGained(FocusEvent focusEvent) {
            Component component = focusEvent.getComponent();
            BasicToolBarUI.this.focusedCompIndex = BasicToolBarUI.this.toolBar.getComponentIndex(component);
        }

        @Override
        public void focusLost(FocusEvent focusEvent) {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            if (!this.tb.isEnabled()) {
                return;
            }
            this.isDragging = false;
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            if (!this.tb.isEnabled()) {
                return;
            }
            if (this.isDragging) {
                Point point = mouseEvent.getPoint();
                if (this.origin == null) {
                    this.origin = mouseEvent.getComponent().getLocationOnScreen();
                }
                BasicToolBarUI.this.floatAt(point, this.origin);
            }
            this.origin = null;
            this.isDragging = false;
        }

        @Override
        public void mouseDragged(MouseEvent mouseEvent) {
            if (!this.tb.isEnabled()) {
                return;
            }
            this.isDragging = true;
            Point point = mouseEvent.getPoint();
            if (this.origin == null) {
                this.origin = mouseEvent.getComponent().getLocationOnScreen();
            }
            BasicToolBarUI.this.dragTo(point, this.origin);
        }

        @Override
        public void mouseClicked(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseEntered(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseExited(MouseEvent mouseEvent) {
        }

        @Override
        public void mouseMoved(MouseEvent mouseEvent) {
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == "lookAndFeel") {
                BasicToolBarUI.this.toolBar.updateUI();
            } else if (string == "orientation") {
                Component[] componentArray = BasicToolBarUI.this.toolBar.getComponents();
                int n = (Integer)propertyChangeEvent.getNewValue();
                for (int i = 0; i < componentArray.length; ++i) {
                    if (!(componentArray[i] instanceof JToolBar.Separator)) continue;
                    JToolBar.Separator separator = (JToolBar.Separator)componentArray[i];
                    if (n == 0) {
                        separator.setOrientation(1);
                    } else {
                        separator.setOrientation(0);
                    }
                    Dimension dimension = separator.getSeparatorSize();
                    if (dimension == null || dimension.width == dimension.height) continue;
                    Dimension dimension2 = new Dimension(dimension.height, dimension.width);
                    separator.setSeparatorSize(dimension2);
                }
            } else if (string == IS_ROLLOVER) {
                BasicToolBarUI.this.installNormalBorders(BasicToolBarUI.this.toolBar);
                BasicToolBarUI.this.setRolloverBorders((Boolean)propertyChangeEvent.getNewValue());
            }
        }
    }

    private static class Actions
    extends UIAction {
        private static final String NAVIGATE_RIGHT = "navigateRight";
        private static final String NAVIGATE_LEFT = "navigateLeft";
        private static final String NAVIGATE_UP = "navigateUp";
        private static final String NAVIGATE_DOWN = "navigateDown";

        public Actions(String string) {
            super(string);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.getName();
            JToolBar jToolBar = (JToolBar)actionEvent.getSource();
            BasicToolBarUI basicToolBarUI = (BasicToolBarUI)BasicLookAndFeel.getUIOfType(jToolBar.getUI(), BasicToolBarUI.class);
            if (NAVIGATE_RIGHT == string) {
                basicToolBarUI.navigateFocusedComp(3);
            } else if (NAVIGATE_LEFT == string) {
                basicToolBarUI.navigateFocusedComp(7);
            } else if (NAVIGATE_UP == string) {
                basicToolBarUI.navigateFocusedComp(1);
            } else if (NAVIGATE_DOWN == string) {
                basicToolBarUI.navigateFocusedComp(5);
            }
        }
    }
}

