/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.tree;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.basic.BasicGraphicsUtils;
import javax.swing.tree.TreeCellRenderer;
import sun.swing.DefaultLookup;

public class DefaultTreeCellRenderer
extends JLabel
implements TreeCellRenderer {
    private JTree tree;
    protected boolean selected;
    protected boolean hasFocus;
    private boolean drawsFocusBorderAroundIcon;
    private boolean drawDashedFocusIndicator;
    private Color treeBGColor;
    private Color focusBGColor;
    protected transient Icon closedIcon;
    protected transient Icon leafIcon;
    protected transient Icon openIcon;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;
    private boolean isDropCell;
    private boolean fillBackground = true;

    public DefaultTreeCellRenderer() {
        this.setLeafIcon(DefaultLookup.getIcon(this, this.ui, "Tree.leafIcon"));
        this.setClosedIcon(DefaultLookup.getIcon(this, this.ui, "Tree.closedIcon"));
        this.setOpenIcon(DefaultLookup.getIcon(this, this.ui, "Tree.openIcon"));
        this.setTextSelectionColor(DefaultLookup.getColor(this, this.ui, "Tree.selectionForeground"));
        this.setTextNonSelectionColor(DefaultLookup.getColor(this, this.ui, "Tree.textForeground"));
        this.setBackgroundSelectionColor(DefaultLookup.getColor(this, this.ui, "Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(DefaultLookup.getColor(this, this.ui, "Tree.textBackground"));
        this.setBorderSelectionColor(DefaultLookup.getColor(this, this.ui, "Tree.selectionBorderColor"));
        this.drawsFocusBorderAroundIcon = DefaultLookup.getBoolean(this, this.ui, "Tree.drawsFocusBorderAroundIcon", false);
        this.drawDashedFocusIndicator = DefaultLookup.getBoolean(this, this.ui, "Tree.drawDashedFocusIndicator", false);
        this.fillBackground = DefaultLookup.getBoolean(this, this.ui, "Tree.rendererFillBackground", true);
        Insets insets = DefaultLookup.getInsets(this, this.ui, "Tree.rendererMargins");
        if (insets != null) {
            this.setBorder(new EmptyBorder(insets.top, insets.left, insets.bottom, insets.right));
        }
        this.setName("Tree.cellRenderer");
    }

    public Icon getDefaultOpenIcon() {
        return DefaultLookup.getIcon(this, this.ui, "Tree.openIcon");
    }

    public Icon getDefaultClosedIcon() {
        return DefaultLookup.getIcon(this, this.ui, "Tree.closedIcon");
    }

    public Icon getDefaultLeafIcon() {
        return DefaultLookup.getIcon(this, this.ui, "Tree.leafIcon");
    }

    public void setOpenIcon(Icon icon) {
        this.openIcon = icon;
    }

    public Icon getOpenIcon() {
        return this.openIcon;
    }

    public void setClosedIcon(Icon icon) {
        this.closedIcon = icon;
    }

    public Icon getClosedIcon() {
        return this.closedIcon;
    }

    public void setLeafIcon(Icon icon) {
        this.leafIcon = icon;
    }

    public Icon getLeafIcon() {
        return this.leafIcon;
    }

    public void setTextSelectionColor(Color color) {
        this.textSelectionColor = color;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color color) {
        this.textNonSelectionColor = color;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color color) {
        this.backgroundSelectionColor = color;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color color) {
        this.backgroundNonSelectionColor = color;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color color) {
        this.borderSelectionColor = color;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    public void setFont(Font font) {
        if (font instanceof FontUIResource) {
            font = null;
        }
        super.setFont(font);
    }

    public Font getFont() {
        Font font = super.getFont();
        if (font == null && this.tree != null) {
            font = this.tree.getFont();
        }
        return font;
    }

    public void setBackground(Color color) {
        if (color instanceof ColorUIResource) {
            color = null;
        }
        super.setBackground(color);
    }

    public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
        Object object2;
        String string = jTree.convertValueToText(object, bl, bl2, bl3, n, bl4);
        this.tree = jTree;
        this.hasFocus = bl4;
        this.setText(string);
        Object object3 = null;
        this.isDropCell = false;
        JTree.DropLocation dropLocation = jTree.getDropLocation();
        if (dropLocation != null && dropLocation.getChildIndex() == -1 && jTree.getRowForPath(dropLocation.getPath()) == n) {
            object2 = DefaultLookup.getColor(this, this.ui, "Tree.dropCellForeground");
            object3 = object2 != null ? object2 : this.getTextSelectionColor();
            this.isDropCell = true;
        } else {
            object3 = bl ? this.getTextSelectionColor() : this.getTextNonSelectionColor();
        }
        this.setForeground((Color)object3);
        object2 = null;
        object2 = bl3 ? this.getLeafIcon() : (bl2 ? this.getOpenIcon() : this.getClosedIcon());
        if (!jTree.isEnabled()) {
            this.setEnabled(false);
            LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
            Icon icon = lookAndFeel.getDisabledIcon(jTree, (Icon)object2);
            if (icon != null) {
                object2 = icon;
            }
            this.setDisabledIcon((Icon)object2);
        } else {
            this.setEnabled(true);
            this.setIcon((Icon)object2);
        }
        this.setComponentOrientation(jTree.getComponentOrientation());
        this.selected = bl;
        return this;
    }

    public void paint(Graphics graphics) {
        Color color;
        if (this.isDropCell) {
            color = DefaultLookup.getColor(this, this.ui, "Tree.dropCellBackground");
            if (color == null) {
                color = this.getBackgroundSelectionColor();
            }
        } else if (this.selected) {
            color = this.getBackgroundSelectionColor();
        } else {
            color = this.getBackgroundNonSelectionColor();
            if (color == null) {
                color = this.getBackground();
            }
        }
        int n = -1;
        if (color != null && this.fillBackground) {
            n = this.getLabelStart();
            graphics.setColor(color);
            if (this.getComponentOrientation().isLeftToRight()) {
                graphics.fillRect(n, 0, this.getWidth() - n, this.getHeight());
            } else {
                graphics.fillRect(0, 0, this.getWidth() - n, this.getHeight());
            }
        }
        if (this.hasFocus) {
            if (this.drawsFocusBorderAroundIcon) {
                n = 0;
            } else if (n == -1) {
                n = this.getLabelStart();
            }
            if (this.getComponentOrientation().isLeftToRight()) {
                this.paintFocus(graphics, n, 0, this.getWidth() - n, this.getHeight(), color);
            } else {
                this.paintFocus(graphics, 0, 0, this.getWidth() - n, this.getHeight(), color);
            }
        }
        super.paint(graphics);
    }

    private void paintFocus(Graphics graphics, int n, int n2, int n3, int n4, Color color) {
        Color color2 = this.getBorderSelectionColor();
        if (color2 != null && (this.selected || !this.drawDashedFocusIndicator)) {
            graphics.setColor(color2);
            graphics.drawRect(n, n2, n3 - 1, n4 - 1);
        }
        if (this.drawDashedFocusIndicator && color != null) {
            if (this.treeBGColor != color) {
                this.treeBGColor = color;
                this.focusBGColor = new Color(~color.getRGB());
            }
            graphics.setColor(this.focusBGColor);
            BasicGraphicsUtils.drawDashedRect(graphics, n, n2, n3, n4);
        }
    }

    private int getLabelStart() {
        Icon icon = this.getIcon();
        if (icon != null && this.getText() != null) {
            return icon.getIconWidth() + Math.max(0, this.getIconTextGap() - 1);
        }
        return 0;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (dimension != null) {
            dimension = new Dimension(dimension.width + 3, dimension.height);
        }
        return dimension;
    }

    public void validate() {
    }

    public void invalidate() {
    }

    public void revalidate() {
    }

    public void repaint(long l, int n, int n2, int n3, int n4) {
    }

    public void repaint(Rectangle rectangle) {
    }

    public void repaint() {
    }

    protected void firePropertyChange(String string, Object object, Object object2) {
        if (string == "text" || (string == "font" || string == "foreground") && object != object2 && this.getClientProperty("html") != null) {
            super.firePropertyChange(string, object, object2);
        }
    }

    public void firePropertyChange(String string, byte by, byte by2) {
    }

    public void firePropertyChange(String string, char c, char c2) {
    }

    public void firePropertyChange(String string, short s, short s2) {
    }

    public void firePropertyChange(String string, int n, int n2) {
    }

    public void firePropertyChange(String string, long l, long l2) {
    }

    public void firePropertyChange(String string, float f, float f2) {
    }

    public void firePropertyChange(String string, double d, double d2) {
    }

    public void firePropertyChange(String string, boolean bl, boolean bl2) {
    }
}

