/*
 * Decompiled with CFR 0.152.
 */
package javax.xml.transform;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.CodeSigner;
import java.security.CodeSource;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.xml.transform.SourceLocator;

public class TransformerException
extends Exception {
    private static final long serialVersionUID = 975798773772956428L;
    SourceLocator locator;
    Throwable containedException;

    public SourceLocator getLocator() {
        return this.locator;
    }

    public void setLocator(SourceLocator location) {
        this.locator = location;
    }

    public Throwable getException() {
        return this.containedException;
    }

    public Throwable getCause() {
        return this.containedException == this ? null : this.containedException;
    }

    public synchronized Throwable initCause(Throwable cause) {
        if (this.containedException != null) {
            throw new IllegalStateException("Can't overwrite cause");
        }
        if (cause == this) {
            throw new IllegalArgumentException("Self-causation not permitted");
        }
        this.containedException = cause;
        return this;
    }

    public TransformerException(String message) {
        this(message, null, null);
    }

    public TransformerException(Throwable e) {
        this(null, null, e);
    }

    public TransformerException(String message, Throwable e) {
        this(message, null, e);
    }

    public TransformerException(String message, SourceLocator locator) {
        this(message, locator, null);
    }

    public TransformerException(String message, SourceLocator locator, Throwable e) {
        super(message == null || message.length() == 0 ? (e == null ? "" : e.toString()) : message);
        this.containedException = e;
        this.locator = locator;
    }

    public String getMessageAndLocation() {
        StringBuilder sbuffer = new StringBuilder();
        String message = super.getMessage();
        if (message == null) {
            message = "";
        }
        sbuffer.append(message);
        message = this.getLocationAsString();
        if (message == null) {
            message = "";
        }
        sbuffer.append(message);
        return sbuffer.toString();
    }

    public String getLocationAsString() {
        if (this.locator == null) {
            return null;
        }
        if (System.getSecurityManager() == null) {
            return this.getLocationString();
        }
        return AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return TransformerException.this.getLocationString();
            }
        }, new AccessControlContext(new ProtectionDomain[]{this.getNonPrivDomain()}));
    }

    private String getLocationString() {
        if (this.locator == null) {
            return null;
        }
        StringBuilder sbuffer = new StringBuilder();
        String systemID = this.locator.getSystemId();
        int line = this.locator.getLineNumber();
        int column = this.locator.getColumnNumber();
        if (null != systemID) {
            sbuffer.append("; SystemID: ");
            sbuffer.append(systemID);
        }
        if (0 != line) {
            sbuffer.append("; Line#: ");
            sbuffer.append(line);
        }
        if (0 != column) {
            sbuffer.append("; Column#: ");
            sbuffer.append(column);
        }
        return sbuffer.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(new PrintWriter(System.err, true));
    }

    public void printStackTrace(PrintStream s) {
        this.printStackTrace(new PrintWriter(s));
    }

    public void printStackTrace(PrintWriter s) {
        if (s == null) {
            s = new PrintWriter(System.err, true);
        }
        try {
            String locInfo = this.getLocationAsString();
            if (null != locInfo) {
                s.println(locInfo);
            }
            super.printStackTrace(s);
        }
        catch (Throwable e) {
            // empty catch block
        }
        Throwable exception = this.getException();
        for (int i = 0; i < 10 && null != exception; ++i) {
            s.println("---------");
            try {
                String locInfo;
                if (exception instanceof TransformerException && null != (locInfo = ((TransformerException)exception).getLocationAsString())) {
                    s.println(locInfo);
                }
                exception.printStackTrace(s);
            }
            catch (Throwable e) {
                s.println("Could not print stack trace...");
            }
            try {
                Method meth = exception.getClass().getMethod("getException", null);
                if (null != meth) {
                    Throwable prev = exception;
                    if (prev != (exception = (Throwable)meth.invoke(exception, null))) continue;
                    break;
                }
                exception = null;
                continue;
            }
            catch (InvocationTargetException e) {
                exception = null;
                continue;
            }
            catch (IllegalAccessException e) {
                exception = null;
                continue;
            }
            catch (NoSuchMethodException e) {
                exception = null;
            }
        }
        s.flush();
    }

    private ProtectionDomain getNonPrivDomain() {
        CodeSource nullSource = new CodeSource(null, (CodeSigner[])null);
        Permissions noPermission = new Permissions();
        return new ProtectionDomain(nullSource, noPermission);
    }
}

