/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMCryptoContext;
import javax.xml.crypto.dsig.SignatureProperty;
import org.jcp.xml.dsig.internal.dom.DOMStructure;
import org.jcp.xml.dsig.internal.dom.DOMUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class DOMSignatureProperty
extends DOMStructure
implements SignatureProperty {
    private final String id;
    private final String target;
    private final List content;

    public DOMSignatureProperty(List list, String string, String string2) {
        if (string == null) {
            throw new NullPointerException("target cannot be null");
        }
        if (list == null) {
            throw new NullPointerException("content cannot be null");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("content cannot be empty");
        }
        ArrayList arrayList = new ArrayList(list);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            if (arrayList.get(i) instanceof XMLStructure) continue;
            throw new ClassCastException("content[" + i + "] is not a valid type");
        }
        this.content = Collections.unmodifiableList(arrayList);
        this.target = string;
        this.id = string2;
    }

    public DOMSignatureProperty(Element element) throws MarshalException {
        this.target = DOMUtils.getAttributeValue(element, "Target");
        if (this.target == null) {
            throw new MarshalException("target cannot be null");
        }
        Attr attr = element.getAttributeNodeNS(null, "Id");
        if (attr != null) {
            this.id = attr.getValue();
            element.setIdAttributeNode(attr, true);
        } else {
            this.id = null;
        }
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        ArrayList<javax.xml.crypto.dom.DOMStructure> arrayList = new ArrayList<javax.xml.crypto.dom.DOMStructure>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(new javax.xml.crypto.dom.DOMStructure(nodeList.item(i)));
        }
        if (arrayList.isEmpty()) {
            throw new MarshalException("content cannot be empty");
        }
        this.content = Collections.unmodifiableList(arrayList);
    }

    public List getContent() {
        return this.content;
    }

    public String getId() {
        return this.id;
    }

    public String getTarget() {
        return this.target;
    }

    public void marshal(Node node, String string, DOMCryptoContext dOMCryptoContext) throws MarshalException {
        Document document = DOMUtils.getOwnerDocument(node);
        Element element = DOMUtils.createElement(document, "SignatureProperty", "http://www.w3.org/2000/09/xmldsig#", string);
        DOMUtils.setAttributeID(element, "Id", this.id);
        DOMUtils.setAttribute(element, "Target", this.target);
        int n = this.content.size();
        for (int i = 0; i < n; ++i) {
            javax.xml.crypto.dom.DOMStructure dOMStructure = (javax.xml.crypto.dom.DOMStructure)this.content.get(i);
            DOMUtils.appendChild(element, dOMStructure.getNode());
        }
        node.appendChild(element);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof SignatureProperty)) {
            return false;
        }
        SignatureProperty signatureProperty = (SignatureProperty)object;
        boolean bl = this.id == null ? signatureProperty.getId() == null : this.id.equals(signatureProperty.getId());
        return this.equalsContent(signatureProperty.getContent()) && this.target.equals(signatureProperty.getTarget()) && bl;
    }

    private boolean equalsContent(List list) {
        int n = list.size();
        if (this.content.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            XMLStructure xMLStructure = (XMLStructure)list.get(i);
            XMLStructure xMLStructure2 = (XMLStructure)this.content.get(i);
            if (xMLStructure instanceof javax.xml.crypto.dom.DOMStructure) {
                if (!(xMLStructure2 instanceof javax.xml.crypto.dom.DOMStructure)) {
                    return false;
                }
                Node node = ((javax.xml.crypto.dom.DOMStructure)xMLStructure).getNode();
                Node node2 = ((javax.xml.crypto.dom.DOMStructure)xMLStructure2).getNode();
                if (DOMUtils.nodesEqual(node2, node)) continue;
                return false;
            }
            if (xMLStructure2.equals(xMLStructure)) continue;
            return false;
        }
        return true;
    }
}

