/*
 * Decompiled with CFR 0.152.
 */
package org.jcp.xml.dsig.internal.dom;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Policy {
    private static Set<URI> disallowedAlgs = new HashSet<URI>();
    private static int maxTrans = Integer.MAX_VALUE;
    private static int maxRefs = Integer.MAX_VALUE;
    private static Set<String> disallowedRefUriSchemes = new HashSet<String>();
    private static Map<String, Integer> minKeyMap = new HashMap<String, Integer>();
    private static boolean noDuplicateIds = false;
    private static boolean noRMLoops = false;

    private Policy() {
    }

    private static void initialize() {
        String[] stringArray;
        String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty("jdk.xml.dsig.secureValidationPolicy");
            }
        });
        if (string == null || string.isEmpty()) {
            return;
        }
        for (String string2 : stringArray = string.split(",")) {
            String[] stringArray2 = string2.split("\\s");
            String string3 = stringArray2[0];
            if (string3.equals("disallowAlg")) {
                if (stringArray2.length != 2) {
                    Policy.error(string2);
                }
                disallowedAlgs.add(URI.create(stringArray2[1]));
                continue;
            }
            if (string3.equals("maxTransforms")) {
                if (stringArray2.length != 2) {
                    Policy.error(string2);
                }
                if ((maxTrans = Integer.parseInt(stringArray2[1])) >= 0) continue;
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", stringArray2[1]));
            }
            if (string3.equals("maxReferences")) {
                if (stringArray2.length != 2) {
                    Policy.error(string2);
                }
                if ((maxRefs = Integer.parseInt(stringArray2[1])) >= 0) continue;
                throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", stringArray2[1]));
            }
            if (string3.equals("disallowReferenceUriSchemes")) {
                if (stringArray2.length == 1) {
                    Policy.error(string2);
                }
                for (int i = 1; i < stringArray2.length; ++i) {
                    String string4 = stringArray2[i];
                    disallowedRefUriSchemes.add(string4.toLowerCase(Locale.ROOT));
                }
                continue;
            }
            if (string3.equals("minKeySize")) {
                Integer n;
                if (stringArray2.length != 3) {
                    Policy.error(string2);
                }
                if ((n = Integer.valueOf(Integer.parseInt(stringArray2[2]))) < 0) {
                    throw new NumberFormatException(String.format("Illegal leading minus sign on unsigned string %s.", stringArray2[2]));
                }
                minKeyMap.put(stringArray2[1], n);
                continue;
            }
            if (string3.equals("noDuplicateIds")) {
                if (stringArray2.length != 1) {
                    Policy.error(string2);
                }
                noDuplicateIds = true;
                continue;
            }
            if (string3.equals("noRetrievalMethodLoops")) {
                if (stringArray2.length != 1) {
                    Policy.error(string2);
                }
                noRMLoops = true;
                continue;
            }
            Policy.error(string2);
        }
    }

    public static boolean restrictAlg(String string) {
        try {
            URI uRI = new URI(string);
            return disallowedAlgs.contains(uRI);
        }
        catch (URISyntaxException uRISyntaxException) {
            return false;
        }
    }

    public static boolean restrictNumTransforms(int n) {
        return n > maxTrans;
    }

    public static boolean restrictNumReferences(int n) {
        return n > maxRefs;
    }

    public static boolean restrictReferenceUriScheme(String string) {
        String string2;
        if (string != null && (string2 = URI.create(string).getScheme()) != null) {
            return disallowedRefUriSchemes.contains(string2.toLowerCase(Locale.ROOT));
        }
        return false;
    }

    public static boolean restrictKey(String string, int n) {
        return n < Policy.getMinKeyOrDefault(string, 0);
    }

    private static Integer getMinKeyOrDefault(Object object, Integer n) {
        Integer n2 = minKeyMap.get(object);
        return n2 != null || minKeyMap.containsKey(object) ? n2 : n;
    }

    public static boolean restrictDuplicateIds() {
        return noDuplicateIds;
    }

    public static boolean restrictRetrievalMethodLoops() {
        return noRMLoops;
    }

    public static Set<URI> disabledAlgs() {
        return Collections.unmodifiableSet(disallowedAlgs);
    }

    public static int maxTransforms() {
        return maxTrans;
    }

    public static int maxReferences() {
        return maxRefs;
    }

    public static Set<String> disabledReferenceUriSchemes() {
        return Collections.unmodifiableSet(disallowedRefUriSchemes);
    }

    public static int minKeySize(String string) {
        return Policy.getMinKeyOrDefault(string, 0);
    }

    private static void error(String string) {
        throw new IllegalArgumentException("Invalid jdk.xml.dsig.secureValidationPolicy entry: " + string);
    }

    static {
        try {
            Policy.initialize();
        }
        catch (Exception exception) {
            throw new SecurityException("Cannot initialize the secure validation policy", exception);
        }
    }
}

