/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.X11;

import java.awt.AWTEvent;
import java.awt.AWTKeyStroke;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.KeyEventPostProcessor;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.InputEvent;
import java.awt.event.InvocationEvent;
import java.awt.event.KeyEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.security.AccessController;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TooManyListenersException;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.awt.AWTAccessor;
import sun.awt.AppContext;
import sun.awt.CausedFocusEvent;
import sun.awt.ModalityEvent;
import sun.awt.ModalityListener;
import sun.awt.SunToolkit;
import sun.awt.WindowIDProvider;
import sun.awt.X11.Native;
import sun.awt.X11.XCanvasPeer;
import sun.awt.X11.XClientMessageEvent;
import sun.awt.X11.XConfigureEvent;
import sun.awt.X11.XCreateWindowEvent;
import sun.awt.X11.XCreateWindowParams;
import sun.awt.X11.XDestroyWindowEvent;
import sun.awt.X11.XDnDConstants;
import sun.awt.X11.XDropTargetContextPeer;
import sun.awt.X11.XDropTargetRegistry;
import sun.awt.X11.XEmbedHelper;
import sun.awt.X11.XEmbeddedFramePeer;
import sun.awt.X11.XErrorHandler;
import sun.awt.X11.XEvent;
import sun.awt.X11.XEventDispatcher;
import sun.awt.X11.XKeyEvent;
import sun.awt.X11.XPropertyEvent;
import sun.awt.X11.XReparentEvent;
import sun.awt.X11.XSizeHints;
import sun.awt.X11.XToolkit;
import sun.awt.X11.XWindow;
import sun.awt.X11.XWindowAttributes;
import sun.awt.X11.XWindowPeer;
import sun.awt.X11.XlibUtil;
import sun.awt.X11.XlibWrapper;
import sun.security.action.GetBooleanAction;

public class XEmbedCanvasPeer
extends XCanvasPeer
implements WindowFocusListener,
KeyEventPostProcessor,
ModalityListener,
WindowIDProvider {
    private static final Logger xembedLog = Logger.getLogger("sun.awt.X11.xembed.XEmbedCanvasPeer");
    boolean applicationActive;
    XEmbedServer xembed = new XEmbedServer();
    Map<Long, AWTKeyStroke> accelerators = new HashMap<Long, AWTKeyStroke>();
    Map<AWTKeyStroke, Long> accel_lookup = new HashMap<AWTKeyStroke, Long>();
    Set<GrabbedKey> grabbed_keys = new HashSet<GrabbedKey>();
    Object ACCEL_LOCK = this.accelerators;
    Object GRAB_LOCK = this.grabbed_keys;

    XEmbedCanvasPeer() {
    }

    XEmbedCanvasPeer(XCreateWindowParams xCreateWindowParams) {
        super(xCreateWindowParams);
    }

    XEmbedCanvasPeer(Component component) {
        super(component);
    }

    protected void postInit(XCreateWindowParams xCreateWindowParams) {
        super.postInit(xCreateWindowParams);
        this.installActivateListener();
        this.installAcceleratorListener();
        this.installModalityListener();
        this.target.setFocusTraversalKeysEnabled(false);
    }

    protected void preInit(XCreateWindowParams xCreateWindowParams) {
        super.preInit(xCreateWindowParams);
        xCreateWindowParams.put("event mask", 2793599L);
    }

    void installModalityListener() {
        ((SunToolkit)Toolkit.getDefaultToolkit()).addModalityListener(this);
    }

    void deinstallModalityListener() {
        ((SunToolkit)Toolkit.getDefaultToolkit()).removeModalityListener(this);
    }

    void installAcceleratorListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().addKeyEventPostProcessor(this);
    }

    void deinstallAcceleratorListener() {
        KeyboardFocusManager.getCurrentKeyboardFocusManager().removeKeyEventPostProcessor(this);
    }

    void installActivateListener() {
        Window window = this.getTopLevel(this.target);
        if (window != null) {
            window.addWindowFocusListener(this);
            this.applicationActive = window.isFocused();
        }
    }

    void deinstallActivateListener() {
        Window window = this.getTopLevel(this.target);
        if (window != null) {
            window.removeWindowFocusListener(this);
        }
    }

    boolean isXEmbedActive() {
        return this.xembed.handle != 0L;
    }

    boolean isApplicationActive() {
        return this.applicationActive;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initDispatching() {
        if (xembedLog.isLoggable(Level.FINE)) {
            xembedLog.fine("Init embedding for " + Long.toHexString(this.xembed.handle));
        }
        XToolkit.awtLock();
        try {
            XToolkit.addEventDispatcher(this.xembed.handle, this.xembed);
            XlibWrapper.XSelectInput(XToolkit.getDisplay(), this.xembed.handle, 0x420000L);
            XDropTargetRegistry.getRegistry().registerXEmbedClient(this.getWindow(), this.xembed.handle);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        this.xembed.processXEmbedInfo();
        this.notifyChildEmbedded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void endDispatching() {
        if (xembedLog.isLoggable(Level.FINE)) {
            xembedLog.fine("End dispatching for " + Long.toHexString(this.xembed.handle));
        }
        XToolkit.awtLock();
        try {
            XDropTargetRegistry.getRegistry().unregisterXEmbedClient(this.getWindow(), this.xembed.handle);
            XToolkit.removeEventDispatcher(this.xembed.handle, this.xembed);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
    }

    void embedChild(long l) {
        if (this.xembed.handle != 0L) {
            this.detachChild();
        }
        this.xembed.handle = l;
        this.initDispatching();
    }

    void childDestroyed() {
        if (xembedLog.isLoggable(Level.FINE)) {
            xembedLog.fine("Child " + Long.toHexString(this.xembed.handle) + " has self-destroyed.");
        }
        this.endDispatching();
        this.xembed.handle = 0L;
    }

    public void handleEvent(AWTEvent aWTEvent) {
        super.handleEvent(aWTEvent);
        if (this.isXEmbedActive()) {
            switch (aWTEvent.getID()) {
                case 1004: {
                    this.canvasFocusGained((FocusEvent)aWTEvent);
                    break;
                }
                case 1005: {
                    this.canvasFocusLost((FocusEvent)aWTEvent);
                    break;
                }
                case 401: 
                case 402: {
                    if (((InputEvent)aWTEvent).isConsumed()) break;
                    this.forwardKeyEvent((KeyEvent)aWTEvent);
                }
            }
        }
    }

    public void dispatchEvent(XEvent xEvent) {
        super.dispatchEvent(xEvent);
        switch (xEvent.get_type()) {
            case 16: {
                XCreateWindowEvent xCreateWindowEvent = xEvent.get_xcreatewindow();
                if (xembedLog.isLoggable(Level.FINEST)) {
                    xembedLog.finest("Message on embedder: " + xCreateWindowEvent);
                }
                if (xembedLog.isLoggable(Level.FINER)) {
                    xembedLog.finer("Create notify for parent " + Long.toHexString(xCreateWindowEvent.get_parent()) + ", window " + Long.toHexString(xCreateWindowEvent.get_window()));
                }
                this.embedChild(xCreateWindowEvent.get_window());
                break;
            }
            case 17: {
                XDestroyWindowEvent xDestroyWindowEvent = xEvent.get_xdestroywindow();
                if (xembedLog.isLoggable(Level.FINEST)) {
                    xembedLog.finest("Message on embedder: " + xDestroyWindowEvent);
                }
                if (xembedLog.isLoggable(Level.FINER)) {
                    xembedLog.finer("Destroy notify for parent: " + xDestroyWindowEvent);
                }
                this.childDestroyed();
                break;
            }
            case 21: {
                XReparentEvent xReparentEvent = xEvent.get_xreparent();
                if (xembedLog.isLoggable(Level.FINEST)) {
                    xembedLog.finest("Message on embedder: " + xReparentEvent);
                }
                if (xembedLog.isLoggable(Level.FINER)) {
                    xembedLog.finer("Reparent notify for parent " + Long.toHexString(xReparentEvent.get_parent()) + ", window " + Long.toHexString(xReparentEvent.get_window()) + ", event " + Long.toHexString(xReparentEvent.get_event()));
                }
                if (xReparentEvent.get_parent() == this.getWindow()) {
                    this.embedChild(xReparentEvent.get_window());
                    break;
                }
                this.childDestroyed();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getPreferredSize() {
        if (this.isXEmbedActive()) {
            Dimension dimension;
            XToolkit.awtLock();
            try {
                long l = XlibWrapper.XAllocSizeHints();
                XSizeHints xSizeHints = new XSizeHints(l);
                XlibWrapper.XGetWMNormalHints(XToolkit.getDisplay(), this.xembed.handle, l, XlibWrapper.larg1);
                Dimension dimension2 = new Dimension(xSizeHints.get_width(), xSizeHints.get_height());
                XlibWrapper.XFree(l);
                dimension = dimension2;
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            return dimension;
        }
        return super.getPreferredSize();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Dimension getMinimumSize() {
        if (this.isXEmbedActive()) {
            Dimension dimension;
            XToolkit.awtLock();
            try {
                long l = XlibWrapper.XAllocSizeHints();
                XSizeHints xSizeHints = new XSizeHints(l);
                XlibWrapper.XGetWMNormalHints(XToolkit.getDisplay(), this.xembed.handle, l, XlibWrapper.larg1);
                Dimension dimension2 = new Dimension(xSizeHints.get_min_width(), xSizeHints.get_min_height());
                XlibWrapper.XFree(l);
                dimension = dimension2;
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            return dimension;
        }
        return super.getMinimumSize();
    }

    public void dispose() {
        if (this.isXEmbedActive()) {
            this.detachChild();
        }
        this.deinstallActivateListener();
        this.deinstallModalityListener();
        this.deinstallAcceleratorListener();
        super.dispose();
    }

    public boolean isFocusable() {
        return true;
    }

    Window getTopLevel(Component component) {
        while (component != null && !(component instanceof Window)) {
            component = component.getParent();
        }
        return (Window)component;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    Rectangle getClientBounds() {
        XToolkit.awtLock();
        try {
            XWindowAttributes xWindowAttributes;
            block5: {
                Rectangle rectangle;
                xWindowAttributes = new XWindowAttributes();
                try {
                    XToolkit.WITH_XERROR_HANDLER(XErrorHandler.IgnoreBadWindowHandler.getInstance());
                    int n = XlibWrapper.XGetWindowAttributes(XToolkit.getDisplay(), this.xembed.handle, xWindowAttributes.pData);
                    XToolkit.RESTORE_XERROR_HANDLER();
                    if (n != 0 && (XToolkit.saved_error == null || XToolkit.saved_error.get_error_code() == 0)) break block5;
                    rectangle = null;
                    Object var5_5 = null;
                    xWindowAttributes.dispose();
                }
                catch (Throwable throwable) {
                    Object var5_7 = null;
                    xWindowAttributes.dispose();
                    throw throwable;
                }
                Object var7_8 = null;
                XToolkit.awtUnlock();
                return rectangle;
            }
            Rectangle rectangle = new Rectangle(xWindowAttributes.get_x(), xWindowAttributes.get_y(), xWindowAttributes.get_width(), xWindowAttributes.get_height());
            Object var5_6 = null;
            xWindowAttributes.dispose();
            Object var7_9 = null;
            XToolkit.awtUnlock();
            return rectangle;
        }
        catch (Throwable throwable) {
            Object var7_10 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
    }

    void childResized() {
        if (xembedLog.isLoggable(Level.FINER)) {
            Rectangle rectangle = this.getClientBounds();
            if (xembedLog.isLoggable(Level.FINER)) {
                xembedLog.finer("Child resized: " + rectangle);
            }
        }
        XToolkit.postEvent(XToolkit.targetToAppContext(this.target), new ComponentEvent(this.target, 101));
    }

    void focusNext() {
        if (this.isXEmbedActive()) {
            xembedLog.fine("Requesting focus for the next component after embedder");
            this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

                public void run() {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent(XEmbedCanvasPeer.this.target);
                }
            }));
        } else {
            xembedLog.fine("XEmbed is not active - denying focus next");
        }
    }

    void focusPrev() {
        if (this.isXEmbedActive()) {
            xembedLog.fine("Requesting focus for the next component after embedder");
            this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

                public void run() {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusPreviousComponent(XEmbedCanvasPeer.this.target);
                }
            }));
        } else {
            xembedLog.fine("XEmbed is not active - denying focus prev");
        }
    }

    void requestXEmbedFocus() {
        if (this.isXEmbedActive()) {
            xembedLog.fine("Requesting focus for client");
            this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

                public void run() {
                    XEmbedCanvasPeer.this.target.requestFocus();
                }
            }));
        } else {
            xembedLog.fine("XEmbed is not active - denying request focus");
        }
    }

    void notifyChildEmbedded() {
        this.xembed.sendMessage(this.xembed.handle, 0, this.getWindow(), Math.min(this.xembed.version, 0L), 0L);
        if (this.isApplicationActive()) {
            xembedLog.fine("Sending WINDOW_ACTIVATE during initialization");
            this.xembed.sendMessage(this.xembed.handle, 1);
            if (this.hasFocus()) {
                xembedLog.fine("Sending FOCUS_GAINED during initialization");
                this.xembed.sendMessage(this.xembed.handle, 4, 0L, 0L, 0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void detachChild() {
        if (xembedLog.isLoggable(Level.FINE)) {
            xembedLog.fine("Detaching child " + Long.toHexString(this.xembed.handle));
        }
        XToolkit.awtLock();
        try {
            XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.xembed.handle);
            XlibWrapper.XReparentWindow(XToolkit.getDisplay(), this.xembed.handle, XToolkit.getDefaultRootWindow(), 0, 0);
            Object var2_1 = null;
        }
        catch (Throwable throwable) {
            Object var2_2 = null;
            XToolkit.awtUnlock();
            throw throwable;
        }
        XToolkit.awtUnlock();
        this.endDispatching();
        this.xembed.handle = 0L;
    }

    public void windowGainedFocus(WindowEvent windowEvent) {
        this.applicationActive = true;
        if (this.isXEmbedActive()) {
            xembedLog.fine("Sending WINDOW_ACTIVATE");
            this.xembed.sendMessage(this.xembed.handle, 1);
        }
    }

    public void windowLostFocus(WindowEvent windowEvent) {
        this.applicationActive = false;
        if (this.isXEmbedActive()) {
            xembedLog.fine("Sending WINDOW_DEACTIVATE");
            this.xembed.sendMessage(this.xembed.handle, 2);
        }
    }

    void canvasFocusGained(FocusEvent focusEvent) {
        if (this.isXEmbedActive()) {
            xembedLog.fine("Forwarding FOCUS_GAINED");
            int n = 0;
            if (focusEvent instanceof CausedFocusEvent) {
                CausedFocusEvent causedFocusEvent = (CausedFocusEvent)focusEvent;
                if (causedFocusEvent.getCause() == CausedFocusEvent.Cause.TRAVERSAL_FORWARD) {
                    n = 1;
                } else if (causedFocusEvent.getCause() == CausedFocusEvent.Cause.TRAVERSAL_BACKWARD) {
                    n = 2;
                }
            }
            this.xembed.sendMessage(this.xembed.handle, 4, n, 0L, 0L);
        }
    }

    void canvasFocusLost(FocusEvent focusEvent) {
        if (this.isXEmbedActive() && !focusEvent.isTemporary()) {
            xembedLog.fine("Forwarding FOCUS_LOST");
            int n = 0;
            if (AccessController.doPrivileged(new GetBooleanAction("sun.awt.xembed.testing")).booleanValue()) {
                Component component = focusEvent.getOppositeComponent();
                try {
                    n = Integer.parseInt(component.getName());
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.xembed.sendMessage(this.xembed.handle, 5, n, 0L, 0L);
        }
    }

    static byte[] getBData(KeyEvent keyEvent) {
        return AWTAccessor.getAWTEventAccessor().getBData(keyEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forwardKeyEvent(KeyEvent keyEvent) {
        xembedLog.fine("Try to forward key event");
        byte[] byArray = XEmbedCanvasPeer.getBData(keyEvent);
        long l = Native.toData(byArray);
        if (l == 0L) {
            return;
        }
        try {
            XKeyEvent xKeyEvent = new XKeyEvent(l);
            xKeyEvent.set_window(this.xembed.handle);
            if (xembedLog.isLoggable(Level.FINE)) {
                xembedLog.fine("Forwarding native key event: " + xKeyEvent);
            }
            XToolkit.awtLock();
            try {
                XlibWrapper.XSendEvent(XToolkit.getDisplay(), this.xembed.handle, false, 0L, l);
                Object var7_5 = null;
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                XToolkit.awtUnlock();
                throw throwable;
            }
            XToolkit.awtUnlock();
            Object var9_8 = null;
            XlibWrapper.unsafe.freeMemory(l);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            XlibWrapper.unsafe.freeMemory(l);
            throw throwable;
        }
    }

    void grabKey(final long l, final long l2) {
        this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GrabbedKey grabbedKey = new GrabbedKey(l, l2);
                if (xembedLog.isLoggable(Level.FINE)) {
                    xembedLog.fine("Grabbing key: " + grabbedKey);
                }
                Object object = XEmbedCanvasPeer.this.GRAB_LOCK;
                synchronized (object) {
                    XEmbedCanvasPeer.this.grabbed_keys.add(grabbedKey);
                }
            }
        }));
    }

    void ungrabKey(final long l, final long l2) {
        this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                GrabbedKey grabbedKey = new GrabbedKey(l, l2);
                if (xembedLog.isLoggable(Level.FINE)) {
                    xembedLog.fine("UnGrabbing key: " + grabbedKey);
                }
                Object object = XEmbedCanvasPeer.this.GRAB_LOCK;
                synchronized (object) {
                    XEmbedCanvasPeer.this.grabbed_keys.remove(grabbedKey);
                }
            }
        }));
    }

    void registerAccelerator(final long l, final long l2, final long l3) {
        this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AWTKeyStroke aWTKeyStroke = XEmbedCanvasPeer.this.xembed.getKeyStrokeForKeySym(l2, l3);
                if (aWTKeyStroke != null) {
                    if (xembedLog.isLoggable(Level.FINE)) {
                        xembedLog.fine("Registering accelerator " + l + " for " + aWTKeyStroke);
                    }
                    Object object = XEmbedCanvasPeer.this.ACCEL_LOCK;
                    synchronized (object) {
                        XEmbedCanvasPeer.this.accelerators.put(l, aWTKeyStroke);
                        XEmbedCanvasPeer.this.accel_lookup.put(aWTKeyStroke, l);
                    }
                }
                XEmbedCanvasPeer.this.propogateRegisterAccelerator(aWTKeyStroke);
            }
        }));
    }

    void unregisterAccelerator(final long l) {
        this.postEvent(new InvocationEvent((Object)this.target, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AWTKeyStroke aWTKeyStroke = null;
                Object object = XEmbedCanvasPeer.this.ACCEL_LOCK;
                synchronized (object) {
                    aWTKeyStroke = XEmbedCanvasPeer.this.accelerators.get(l);
                    if (aWTKeyStroke != null) {
                        if (xembedLog.isLoggable(Level.FINE)) {
                            xembedLog.fine("Unregistering accelerator: " + l);
                        }
                        XEmbedCanvasPeer.this.accelerators.remove(l);
                        XEmbedCanvasPeer.this.accel_lookup.remove(aWTKeyStroke);
                    }
                }
                XEmbedCanvasPeer.this.propogateUnRegisterAccelerator(aWTKeyStroke);
            }
        }));
    }

    void propogateRegisterAccelerator(AWTKeyStroke aWTKeyStroke) {
        XWindowPeer xWindowPeer = this.getToplevelXWindow();
        if (xWindowPeer != null && xWindowPeer instanceof XEmbeddedFramePeer) {
            XEmbeddedFramePeer xEmbeddedFramePeer = (XEmbeddedFramePeer)xWindowPeer;
            xEmbeddedFramePeer.registerAccelerator(aWTKeyStroke);
        }
    }

    void propogateUnRegisterAccelerator(AWTKeyStroke aWTKeyStroke) {
        XWindowPeer xWindowPeer = this.getToplevelXWindow();
        if (xWindowPeer != null && xWindowPeer instanceof XEmbeddedFramePeer) {
            XEmbeddedFramePeer xEmbeddedFramePeer = (XEmbeddedFramePeer)xWindowPeer;
            xEmbeddedFramePeer.unregisterAccelerator(aWTKeyStroke);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postProcessKeyEvent(KeyEvent keyEvent) {
        XWindowPeer xWindowPeer = this.getToplevelXWindow();
        if (xWindowPeer == null || !((Window)xWindowPeer.getTarget()).isFocused() || this.target.isFocusOwner()) {
            return false;
        }
        boolean bl = false;
        if (xembedLog.isLoggable(Level.FINER)) {
            xembedLog.finer("Post-processing event " + keyEvent);
        }
        AWTKeyStroke aWTKeyStroke = AWTKeyStroke.getAWTKeyStrokeForEvent(keyEvent);
        long l = 0L;
        boolean bl2 = false;
        Object object = this.ACCEL_LOCK;
        synchronized (object) {
            bl2 = this.accel_lookup.containsKey(aWTKeyStroke);
            if (bl2) {
                l = this.accel_lookup.get(aWTKeyStroke);
            }
        }
        if (bl2) {
            if (xembedLog.isLoggable(Level.FINE)) {
                xembedLog.fine("Activating accelerator " + l);
            }
            this.xembed.sendMessage(this.xembed.handle, 14, l, 0L, 0L);
            bl = true;
        }
        bl2 = false;
        object = new GrabbedKey(keyEvent);
        Object object2 = this.GRAB_LOCK;
        synchronized (object2) {
            bl2 = this.grabbed_keys.contains(object);
        }
        if (bl2) {
            if (xembedLog.isLoggable(Level.FINE)) {
                xembedLog.fine("Forwarding grabbed key " + keyEvent);
            }
            this.forwardKeyEvent(keyEvent);
            bl = true;
        }
        return bl;
    }

    public void modalityPushed(ModalityEvent modalityEvent) {
        this.xembed.sendMessage(this.xembed.handle, 10);
    }

    public void modalityPopped(ModalityEvent modalityEvent) {
        this.xembed.sendMessage(this.xembed.handle, 11);
    }

    public void handleClientMessage(XEvent xEvent) {
        super.handleClientMessage(xEvent);
        XClientMessageEvent xClientMessageEvent = xEvent.get_xclient();
        if (xembedLog.isLoggable(Level.FINER)) {
            xembedLog.finer("Client message to embedder: " + xClientMessageEvent);
        }
        if (xClientMessageEvent.get_message_type() == XEmbedServer.XEmbed.getAtom() && xembedLog.isLoggable(Level.FINE)) {
            xembedLog.fine(XEmbedServer.XEmbedMessageToString(xClientMessageEvent));
        }
        if (this.isXEmbedActive()) {
            switch ((int)xClientMessageEvent.get_data(1)) {
                case 1119: {
                    this.xembed.processXEmbedInfo();
                    this.notifyChildEmbedded();
                    break;
                }
                case 3: {
                    this.requestXEmbedFocus();
                    break;
                }
                case 6: {
                    this.focusNext();
                    break;
                }
                case 7: {
                    this.focusPrev();
                    break;
                }
                case 12: {
                    this.registerAccelerator(xClientMessageEvent.get_data(2), xClientMessageEvent.get_data(3), xClientMessageEvent.get_data(4));
                    break;
                }
                case 13: {
                    this.unregisterAccelerator(xClientMessageEvent.get_data(2));
                    break;
                }
                case 108: {
                    this.grabKey(xClientMessageEvent.get_data(3), xClientMessageEvent.get_data(4));
                    break;
                }
                case 109: {
                    this.ungrabKey(xClientMessageEvent.get_data(3), xClientMessageEvent.get_data(4));
                }
            }
        } else {
            xembedLog.finer("But XEmbed is not Active!");
        }
    }

    public void setXEmbedDropTarget() {
        Runnable runnable = new Runnable(){

            public void run() {
                XEmbedCanvasPeer.this.target.setDropTarget(new XEmbedDropTarget());
            }
        };
        SunToolkit.executeOnEventHandlerThread(this.target, runnable);
    }

    public void removeXEmbedDropTarget() {
        Runnable runnable = new Runnable(){

            public void run() {
                if (XEmbedCanvasPeer.this.target.getDropTarget() instanceof XEmbedDropTarget) {
                    XEmbedCanvasPeer.this.target.setDropTarget(null);
                }
            }
        };
        SunToolkit.executeOnEventHandlerThread(this.target, runnable);
    }

    public boolean processXEmbedDnDEvent(long l, int n) {
        if (xembedLog.isLoggable(Level.FINEST)) {
            xembedLog.finest("     Drop target=" + this.target.getDropTarget());
        }
        if (this.target.getDropTarget() instanceof XEmbedDropTarget) {
            AppContext appContext = XToolkit.targetToAppContext(this.getTarget());
            XDropTargetContextPeer xDropTargetContextPeer = XDropTargetContextPeer.getPeer(appContext);
            xDropTargetContextPeer.forwardEventToEmbedded(this.xembed.handle, l, n);
            return true;
        }
        return false;
    }

    static class GrabbedKey {
        long keysym;
        long modifiers;

        GrabbedKey(long l, long l2) {
            this.keysym = l;
            this.modifiers = l2;
        }

        GrabbedKey(KeyEvent keyEvent) {
            this.init(keyEvent);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void init(KeyEvent keyEvent) {
            byte[] byArray = XEmbedCanvasPeer.getBData(keyEvent);
            long l = Native.toData(byArray);
            if (l == 0L) {
                return;
            }
            try {
                XToolkit.awtLock();
                try {
                    this.keysym = XWindow.getKeySymForAWTKeyCode(keyEvent.getKeyCode());
                    Object var6_4 = null;
                }
                catch (Throwable throwable) {
                    Object var6_5 = null;
                    XToolkit.awtUnlock();
                    throw throwable;
                }
                XToolkit.awtUnlock();
                XKeyEvent xKeyEvent = new XKeyEvent(l);
                this.modifiers = xKeyEvent.get_state() & 7;
                if (xembedLog.isLoggable(Level.FINEST)) {
                    xembedLog.finest("Mapped " + keyEvent + " to " + this);
                }
                Object var8_8 = null;
                XlibWrapper.unsafe.freeMemory(l);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                XlibWrapper.unsafe.freeMemory(l);
                throw throwable;
            }
        }

        public int hashCode() {
            return (int)this.keysym & 0xFFFFFFFF;
        }

        public boolean equals(Object object) {
            if (!(object instanceof GrabbedKey)) {
                return false;
            }
            GrabbedKey grabbedKey = (GrabbedKey)object;
            return this.keysym == grabbedKey.keysym && this.modifiers == grabbedKey.modifiers;
        }

        public String toString() {
            return "Key combination[keysym=" + this.keysym + ", mods=" + this.modifiers + "]";
        }
    }

    class XEmbedServer
    extends XEmbedHelper
    implements XEventDispatcher {
        long handle;
        long version;
        long flags;

        XEmbedServer() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean processXEmbedInfo() {
            long l;
            block12: {
                boolean bl;
                block11: {
                    l = Native.allocateLongArray(2);
                    try {
                        if (XEmbedInfo.getAtomData(this.handle, l, 2)) break block11;
                        xembedLog.finer("Unable to get XEMBED_INFO atom data");
                        boolean bl2 = false;
                        Object var10_4 = null;
                        XlibWrapper.unsafe.freeMemory(l);
                        return bl2;
                    }
                    catch (Throwable throwable) {
                        Object var10_6 = null;
                        XlibWrapper.unsafe.freeMemory(l);
                        throw throwable;
                    }
                }
                this.version = Native.getCard32(l, 0);
                this.flags = Native.getCard32(l, 1);
                boolean bl3 = (this.flags & 1L) != 0L;
                boolean bl4 = bl = XlibUtil.getWindowMapState(this.handle) != 0;
                if (bl3 != bl) {
                    if (xembedLog.isLoggable(Level.FINER)) {
                        xembedLog.fine("Mapping state of the client has changed, old state: " + bl + ", new state: " + bl3);
                    }
                    if (bl3) {
                        XToolkit.awtLock();
                        try {
                            XlibWrapper.XMapWindow(XToolkit.getDisplay(), this.handle);
                            Object var6_8 = null;
                        }
                        catch (Throwable throwable) {
                            Object var6_9 = null;
                            XToolkit.awtUnlock();
                            throw throwable;
                        }
                        XToolkit.awtUnlock();
                        {
                            break block12;
                        }
                    }
                    XToolkit.awtLock();
                    try {
                        XlibWrapper.XUnmapWindow(XToolkit.getDisplay(), this.handle);
                        Object var8_12 = null;
                    }
                    catch (Throwable throwable) {
                        Object var8_13 = null;
                        XToolkit.awtUnlock();
                        throw throwable;
                    }
                    XToolkit.awtUnlock();
                    {
                        break block12;
                    }
                }
                if (xembedLog.isLoggable(Level.FINER)) {
                    xembedLog.finer("Mapping state didn't change, mapped: " + bl);
                }
            }
            boolean bl = true;
            Object var10_5 = null;
            XlibWrapper.unsafe.freeMemory(l);
            return bl;
        }

        public void handlePropertyNotify(XEvent xEvent) {
            if (XEmbedCanvasPeer.this.isXEmbedActive()) {
                XPropertyEvent xPropertyEvent = xEvent.get_xproperty();
                if (xembedLog.isLoggable(Level.FINER)) {
                    xembedLog.finer("Property change on client: " + xPropertyEvent);
                }
                if (xPropertyEvent.get_atom() == 40L) {
                    XEmbedCanvasPeer.this.childResized();
                } else if (xPropertyEvent.get_atom() == XEmbedInfo.getAtom()) {
                    this.processXEmbedInfo();
                } else if (xPropertyEvent.get_atom() == XDnDConstants.XA_XdndAware.getAtom()) {
                    XDropTargetRegistry.getRegistry().unregisterXEmbedClient(XEmbedCanvasPeer.this.getWindow(), XEmbedCanvasPeer.this.xembed.handle);
                    if (xPropertyEvent.get_state() == 0) {
                        XDropTargetRegistry.getRegistry().registerXEmbedClient(XEmbedCanvasPeer.this.getWindow(), XEmbedCanvasPeer.this.xembed.handle);
                    }
                }
            } else {
                xembedLog.finer("XEmbed is not active");
            }
        }

        void handleConfigureNotify(XEvent xEvent) {
            if (XEmbedCanvasPeer.this.isXEmbedActive()) {
                XConfigureEvent xConfigureEvent = xEvent.get_xconfigure();
                if (xembedLog.isLoggable(Level.FINER)) {
                    xembedLog.finer("Bounds change on client: " + xConfigureEvent);
                }
                if (xEvent.get_xany().get_window() == this.handle) {
                    XEmbedCanvasPeer.this.childResized();
                }
            }
        }

        public void dispatchEvent(XEvent xEvent) {
            int n = xEvent.get_type();
            switch (n) {
                case 28: {
                    this.handlePropertyNotify(xEvent);
                    break;
                }
                case 22: {
                    this.handleConfigureNotify(xEvent);
                    break;
                }
                case 33: {
                    XEmbedCanvasPeer.this.handleClientMessage(xEvent);
                }
            }
        }
    }

    private static class XEmbedDropTarget
    extends DropTarget {
        private XEmbedDropTarget() {
        }

        public void addDropTargetListener(DropTargetListener dropTargetListener) throws TooManyListenersException {
            throw new TooManyListenersException();
        }
    }
}

