/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.motif;

import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.Window;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.peer.WindowPeer;
import java.security.AccessController;
import java.util.Vector;
import sun.awt.DisplayChangedListener;
import sun.awt.SunToolkit;
import sun.awt.UngrabEvent;
import sun.awt.X11GraphicsDevice;
import sun.awt.im.InputMethodManager;
import sun.awt.motif.MComponentPeer;
import sun.awt.motif.MFramePeer;
import sun.awt.motif.MInputMethod;
import sun.awt.motif.MInputMethodControl;
import sun.awt.motif.MMenuBarPeer;
import sun.awt.motif.MPanelPeer;
import sun.awt.motif.MToolkit;
import sun.awt.motif.MWindowAttributes;
import sun.security.action.GetIntegerAction;

class MWindowPeer
extends MPanelPeer
implements WindowPeer,
DisplayChangedListener {
    Insets insets = new Insets(0, 0, 0, 0);
    MWindowAttributes winAttr;
    static Vector allWindows = new Vector();
    int iconWidth = -1;
    int iconHeight = -1;
    int dropTargetCount = 0;
    boolean alwaysOnTop;
    private Vector imList = new Vector();
    private Vector tcList = new Vector();
    private volatile int sysX = 0;
    private volatile int sysY = 0;
    private volatile int sysW = 0;
    private volatile int sysH = 0;

    native void pCreate(MComponentPeer var1, String var2, boolean var3);

    native void pShow();

    native void pToFront();

    native void pShowModal(boolean var1);

    native void pHide();

    native void pReshape(int var1, int var2, int var3, int var4);

    native void pDispose();

    native void pSetTitle(String var1);

    public native void setState(int var1);

    public native int getState();

    public native void setResizable(boolean var1);

    native void addTextComponentNative(MComponentPeer var1);

    native void removeTextComponentNative();

    native void pSetIMMOption(String var1);

    native void pSetMenuBar(MMenuBarPeer var1);

    native void setSaveUnder(boolean var1);

    native void registerX11DropTarget(Component var1);

    native void unregisterX11DropTarget(Component var1);

    native void updateAlwaysOnTop(boolean var1);

    private static native void initIDs();

    private static int getInset(String string, int n) {
        Integer n2 = AccessController.doPrivileged(new GetIntegerAction(string, n));
        return n2;
    }

    MWindowPeer() {
        this.insets = new Insets(0, 0, 0, 0);
        this.winAttr = new MWindowAttributes();
    }

    MWindowPeer(Window window) {
        this();
        this.init(window);
        allWindows.addElement(this);
    }

    void create(MComponentPeer mComponentPeer) {
        this.pCreate(mComponentPeer, this.target.getClass().getName(), ((Window)this.target).isFocusableWindow());
    }

    void init(Window window) {
        Color color;
        if (this.winAttr.nativeDecor) {
            this.insets.top = MWindowPeer.getInset("awt.frame.topInset", -1);
            this.insets.left = MWindowPeer.getInset("awt.frame.leftInset", -1);
            this.insets.bottom = MWindowPeer.getInset("awt.frame.bottomInset", -1);
            this.insets.right = MWindowPeer.getInset("awt.frame.rightInset", -1);
        }
        Rectangle rectangle = window.getBounds();
        this.sysX = rectangle.x;
        this.sysY = rectangle.y;
        this.sysW = rectangle.width;
        this.sysH = rectangle.height;
        super.init(window);
        InputMethodManager inputMethodManager = InputMethodManager.getInstance();
        String string = inputMethodManager.getTriggerMenuString();
        if (string != null) {
            this.pSetIMMOption(string);
        }
        this.pSetTitle(this.winAttr.title);
        this.setResizable(this.winAttr.isResizable);
        this.setSaveUnder(true);
        Font font = window.getFont();
        if (font == null) {
            font = defaultFont;
            window.setFont(font);
            this.setFont(font);
        }
        if ((color = window.getBackground()) == null) {
            window.setBackground(SystemColor.window);
            this.setBackground(SystemColor.window);
        }
        if ((color = window.getForeground()) == null) {
            window.setForeground(SystemColor.windowText);
            this.setForeground(SystemColor.windowText);
        }
        this.alwaysOnTop = window.isAlwaysOnTop() && window.isAlwaysOnTopSupported();
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        ((X11GraphicsDevice)graphicsConfiguration.getDevice()).addDisplayChangedListener(this);
    }

    public void updateIconImages() {
        if (this instanceof MFramePeer) {
            ((MFramePeer)this).setIconImage(((Frame)this.target).getIconImage());
        }
    }

    public void updateMinimumSize() {
    }

    protected void disposeImpl() {
        allWindows.removeElement(this);
        super.disposeImpl();
    }

    public native void toBack();

    public void setAlwaysOnTop(boolean bl) {
        this.alwaysOnTop = bl;
        this.updateAlwaysOnTop(bl);
    }

    public void updateAlwaysOnTopState() {
        this.setAlwaysOnTop(((Window)this.target).isAlwaysOnTop());
    }

    public void toFront() {
        if (this.target.isVisible()) {
            this.updateFocusableWindowState();
            this.pToFront();
        }
    }

    public void updateFocusableWindowState() {
        this.setFocusableWindow(((Window)this.target).isFocusableWindow());
    }

    native void setFocusableWindow(boolean var1);

    public void setVisible(boolean bl) {
        if (bl) {
            this.updateFocusableWindowState();
        }
        super.setVisible(bl);
        this.updateAlwaysOnTop(this.alwaysOnTop);
    }

    public Insets getInsets() {
        return this.insets;
    }

    public void handleQuit() {
        this.postEvent(new WindowEvent((Window)this.target, 201));
    }

    public void handleDestroy() {
        final Window window = (Window)this.target;
        SunToolkit.executeOnEventHandlerThread(window, new Runnable(){

            public void run() {
                window.dispose();
            }
        });
    }

    public void handleIconify() {
        this.postEvent(new WindowEvent((Window)this.target, 203));
    }

    public void handleDeiconify() {
        this.postEvent(new WindowEvent((Window)this.target, 204));
    }

    public void handleStateChange(int n, int n2) {
        this.postEvent(new WindowEvent((Window)this.target, 209, n, n2));
    }

    public void handleResize(int n, int n2) {
        this.sysW = n;
        this.sysH = n2;
        if (!this.tcList.isEmpty() && !this.imList.isEmpty()) {
            for (int i = 0; i < this.imList.size(); ++i) {
                ((MInputMethod)this.imList.elementAt(i)).configureStatus();
            }
        }
        this.validateSurface(n, n2);
        this.postEvent(new ComponentEvent(this.target, 101));
    }

    public Insets insets() {
        return this.getInsets();
    }

    public void handleMoved(int n, int n2) {
        this.sysX = n;
        this.sysY = n2;
        this.postEvent(new ComponentEvent(this.target, 100));
    }

    private native AWTEvent wrapInSequenced(AWTEvent var1);

    public void handleWindowFocusIn() {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 207);
        this.postEvent(this.wrapInSequenced(windowEvent));
    }

    public void handleWindowFocusOut(Window window) {
        WindowEvent windowEvent = new WindowEvent((Window)this.target, 208, window);
        this.postEvent(this.wrapInSequenced(windowEvent));
    }

    void notifyIMMOptionChange() {
        InputMethodManager.getInstance().notifyChangeRequest(this.target);
    }

    public void addInputMethod(MInputMethod mInputMethod) {
        if (!this.imList.contains(mInputMethod)) {
            this.imList.addElement(mInputMethod);
        }
    }

    public void removeInputMethod(MInputMethod mInputMethod) {
        if (this.imList.contains(mInputMethod)) {
            this.imList.removeElement(mInputMethod);
        }
    }

    public void addTextComponent(MComponentPeer mComponentPeer) {
        if (this.tcList.contains(mComponentPeer)) {
            return;
        }
        if (this.tcList.isEmpty()) {
            this.addTextComponentNative(mComponentPeer);
            if (!this.imList.isEmpty()) {
                for (int i = 0; i < this.imList.size(); ++i) {
                    ((MInputMethod)this.imList.elementAt(i)).reconfigureXIC((MInputMethodControl)((Object)this));
                }
            }
            MToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Object object = MWindowPeer.this.target.getTreeLock();
                    synchronized (object) {
                        MWindowPeer.this.target.doLayout();
                    }
                }
            });
        }
        this.tcList.addElement(mComponentPeer);
    }

    public void removeTextComponent(MComponentPeer mComponentPeer) {
        if (!this.tcList.contains(mComponentPeer)) {
            return;
        }
        this.tcList.removeElement(mComponentPeer);
        if (this.tcList.isEmpty()) {
            this.removeTextComponentNative();
            if (!this.imList.isEmpty()) {
                for (int i = 0; i < this.imList.size(); ++i) {
                    ((MInputMethod)this.imList.elementAt(i)).reconfigureXIC((MInputMethodControl)((Object)this));
                }
            }
            this.target.doLayout();
        }
    }

    public MComponentPeer getTextComponent() {
        if (!this.tcList.isEmpty()) {
            return (MComponentPeer)this.tcList.firstElement();
        }
        return null;
    }

    boolean hasDecorations(int n) {
        boolean bl;
        if (!this.winAttr.nativeDecor) {
            return false;
        }
        int n2 = this.winAttr.decorations;
        boolean bl2 = bl = (n2 & n) == n;
        if ((n2 & MWindowAttributes.AWT_DECOR_ALL) != 0) {
            return !bl;
        }
        return bl;
    }

    public boolean checkNativePaintOnSetBounds(int n, int n2) {
        return n > this.oldWidth || n2 > this.oldHeight;
    }

    native void resetTargetGC(Component var1);

    public void draggedToNewScreen(int n) {
        final int n2 = n;
        SunToolkit.executeOnEventHandlerThread(this.target, new Runnable(){

            public void run() {
                MWindowPeer.this.displayChanged(n2);
            }
        });
    }

    public void displayChanged(int n) {
        this.resetLocalGC(n);
        this.resetTargetGC(this.target);
        super.displayChanged(n);
    }

    private void executeDisplayChangedOnEDT(int n) {
        final int n2 = n;
        Runnable runnable = new Runnable(){

            public void run() {
                MWindowPeer.this.displayChanged(n2);
            }
        };
        SunToolkit.executeOnEventHandlerThread(this.target, runnable);
    }

    public void displayChanged() {
        GraphicsConfiguration graphicsConfiguration = this.getGraphicsConfiguration();
        int n = ((X11GraphicsDevice)graphicsConfiguration.getDevice()).getScreen();
        this.executeDisplayChangedOnEDT(n);
    }

    public void paletteChanged() {
    }

    public synchronized void addDropTarget() {
        if (this.dropTargetCount == 0) {
            this.registerX11DropTarget(this.target);
        }
        ++this.dropTargetCount;
    }

    public synchronized void removeDropTarget() {
        --this.dropTargetCount;
        if (this.dropTargetCount == 0) {
            this.unregisterX11DropTarget(this.target);
        }
    }

    protected synchronized void updateDropTarget() {
        if (this.dropTargetCount > 0) {
            this.unregisterX11DropTarget(this.target);
            this.registerX11DropTarget(this.target);
        }
    }

    public boolean requestWindowFocus() {
        return false;
    }

    public void setModalBlocked(Dialog dialog, boolean bl) {
    }

    public void postUngrabEvent() {
        this.postEvent(new UngrabEvent((Window)this.target));
    }

    boolean isOwnerOf(MComponentPeer mComponentPeer) {
        if (mComponentPeer == null) {
            return false;
        }
        Component component = mComponentPeer.target;
        while (component != null && !(component instanceof Window)) {
            component = MWindowPeer.getParent_NoClientCode(component);
        }
        if (!(component instanceof Window)) {
            return false;
        }
        while (component != null && component != this.target && !(component instanceof Dialog)) {
            component = MWindowPeer.getParent_NoClientCode(component);
        }
        return component == this.target;
    }

    boolean processUngrabMouseEvent(MComponentPeer mComponentPeer, int n, int n2, int n3) {
        switch (n3) {
            case 4: {
                if (this.isOwnerOf(mComponentPeer)) break;
                this.postUngrabEvent();
                return true;
            }
        }
        return false;
    }

    private final boolean hasWarningWindow() {
        return ((Window)this.target).getWarningString() != null;
    }

    boolean isTargetUndecorated() {
        return true;
    }

    Rectangle constrainBounds(int n, int n2, int n3, int n4) {
        if (!this.hasWarningWindow()) {
            return new Rectangle(n, n2, n3, n4);
        }
        int n5 = n;
        int n6 = n2;
        int n7 = n3;
        int n8 = n4;
        GraphicsConfiguration graphicsConfiguration = ((Window)this.target).getGraphicsConfiguration();
        Rectangle rectangle = graphicsConfiguration.getBounds();
        Insets insets = ((Window)this.target).getToolkit().getScreenInsets(graphicsConfiguration);
        int n9 = rectangle.width - insets.left - insets.right;
        int n10 = rectangle.height - insets.top - insets.bottom;
        if (!this.target.isVisible() || this.isTargetUndecorated()) {
            int n11 = rectangle.x + insets.left;
            int n12 = rectangle.y + insets.top;
            if (n7 > n9) {
                n7 = n9;
            }
            if (n8 > n10) {
                n8 = n10;
            }
            if (n5 < n11) {
                n5 = n11;
            } else if (n5 + n7 > n11 + n9) {
                n5 = n11 + n9 - n7;
            }
            if (n6 < n12) {
                n6 = n12;
            } else if (n6 + n8 > n12 + n10) {
                n6 = n12 + n10 - n8;
            }
        } else {
            int n13 = Math.max(n9, this.sysW);
            int n14 = Math.max(n10, this.sysH);
            if (n7 > n13) {
                n7 = n13;
            }
            if (n8 > n14) {
                n8 = n14;
            }
        }
        return new Rectangle(n5, n6, n7, n8);
    }

    public void setBounds(int n, int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.constrainBounds(n, n2, n3, n4);
        super.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height, n5);
    }

    public void setOpacity(float f) {
    }

    public void setOpaque(boolean bl) {
    }

    public void updateWindow() {
    }

    public void repositionSecurityWarning() {
    }

    static {
        MWindowPeer.initIDs();
    }
}

