/*
 * Decompiled with CFR 0.152.
 */
package sun.launcher;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.nio.charset.Charset;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Locale;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import sun.misc.VM;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum LauncherHelper {
    INSTANCE;

    private static final String MAIN_CLASS = "Main-Class";
    private static StringBuilder outBuf;
    private static final String diagprop = "sun.java.launcher.diag";
    private static final String defaultBundleName = "sun.launcher.resources.launcher";
    private static final String INDENT = "    ";
    private static final String VM_SETTINGS = "VM settings:";
    private static final String PROP_SETTINGS = "Property settings:";
    private static final String LOCALE_SETTINGS = "Locale settings:";
    private static final long K = 1024L;
    private static final long M = 0x100000L;
    private static final long G = 0x40000000L;
    private static final long T = 0x10000000000L;
    private static final String encprop = "sun.jnu.encoding";
    private static String encoding;
    private static boolean isCharsetSupported;

    static void showSettings(boolean bl, String string, long l, long l2, boolean bl2) {
        String string2;
        PrintStream printStream = bl ? System.err : System.out;
        String[] stringArray = string.split(":");
        String string3 = string2 = stringArray.length > 1 && stringArray[1] != null ? stringArray[1].trim() : "all";
        if ("vm".equals(string2)) {
            LauncherHelper.printVmSettings(printStream, l, l2, bl2);
        } else if ("properties".equals(string2)) {
            LauncherHelper.printProperties(printStream);
        } else if ("locale".equals(string2)) {
            LauncherHelper.printLocale(printStream);
        } else {
            LauncherHelper.printVmSettings(printStream, l, l2, bl2);
            LauncherHelper.printProperties(printStream);
            LauncherHelper.printLocale(printStream);
        }
    }

    private static void printVmSettings(PrintStream printStream, long l, long l2, boolean bl) {
        printStream.println(VM_SETTINGS);
        if (l2 != 0L) {
            printStream.println("    Stack Size: " + LauncherHelper.scaleValue(l2));
        }
        if (l != 0L) {
            printStream.println("    Max. Heap Size: " + LauncherHelper.scaleValue(l));
        } else {
            printStream.println("    Max. Heap Size (Estimated): " + LauncherHelper.scaleValue(Runtime.getRuntime().maxMemory()));
        }
        printStream.println("    Ergonomics Machine Class: " + (bl ? "server" : "client"));
        printStream.println("    Using VM: " + System.getProperty("java.vm.name"));
        printStream.println();
    }

    private static String scaleValue(double d) {
        MathContext mathContext = new MathContext(3, RoundingMode.HALF_EVEN);
        if (d >= 1024.0 && d < 1048576.0) {
            return new BigDecimal(d / 1024.0, mathContext).toPlainString() + "K";
        }
        if (d >= 1048576.0 && d < 1.073741824E9) {
            return new BigDecimal(d / 1048576.0, mathContext).toPlainString() + "M";
        }
        if (d >= 1.073741824E9 && d < 1.099511627776E12) {
            return new BigDecimal(d / 1.073741824E9, mathContext).toPlainString() + "G";
        }
        if (d >= 1.099511627776E12) {
            return new BigDecimal(d / 1.099511627776E12, mathContext).toPlainString() + "T";
        }
        return String.format("%.0f", d);
    }

    private static void printProperties(PrintStream printStream) {
        Properties properties = System.getProperties();
        printStream.println(PROP_SETTINGS);
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.addAll(properties.stringPropertyNames());
        Collections.sort(arrayList);
        for (String string : arrayList) {
            LauncherHelper.printPropertyValue(printStream, string, properties.getProperty(string));
        }
        printStream.println();
    }

    private static boolean isPath(String string) {
        return string.endsWith(".dirs") || string.endsWith(".path");
    }

    private static void printPropertyValue(PrintStream printStream, String string, String string2) {
        printStream.print(INDENT + string + " = ");
        if (string.equals("line.separator")) {
            byte[] byArray;
            block4: for (byte by : byArray = string2.getBytes()) {
                switch (by) {
                    case 13: {
                        printStream.print("CR ");
                        continue block4;
                    }
                    case 10: {
                        printStream.print("LF ");
                        continue block4;
                    }
                    default: {
                        printStream.printf("0x%02X", by & 0xFF);
                    }
                }
            }
            printStream.println();
            return;
        }
        if (!LauncherHelper.isPath(string)) {
            printStream.println(string2);
            return;
        }
        String[] stringArray = string2.split(System.getProperty("path.separator"));
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            if (i == 0) {
                printStream.println(stringArray[i]);
                continue;
            }
            printStream.print("        ");
            printStream.println(stringArray[i]);
        }
    }

    private static void printLocale(PrintStream printStream) {
        Locale locale = Locale.getDefault();
        printStream.println(LOCALE_SETTINGS);
        printStream.println("    default locale = " + locale.getDisplayLanguage());
        LauncherHelper.printLocales(printStream);
        printStream.println();
    }

    private static void printLocales(PrintStream printStream) {
        int n;
        Locale[] localeArray = Locale.getAvailableLocales();
        int n2 = n = localeArray == null ? 0 : localeArray.length;
        if (n < 1) {
            return;
        }
        printStream.print("    available locales = ");
        int n3 = n - 1;
        for (int i = 0; i < n3; ++i) {
            printStream.print(localeArray[i]);
            if (i != n3) {
                printStream.print(", ");
            }
            if ((i + 1) % 8 != 0) continue;
            printStream.println();
            printStream.print("        ");
        }
        printStream.println(localeArray[n3]);
    }

    private static String getLocalizedMessage(String string, Object ... objectArray) {
        String string2 = ResourceBundleHolder.RB.getString(string);
        return objectArray != null ? MessageFormat.format(string2, objectArray) : string2;
    }

    static void initHelpMessage(String string) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.header", string == null ? "java" : string));
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.datamodel", 32));
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.datamodel", 64));
    }

    static void appendVmSelectMessage(String string, String string2) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.vmselect", string, string2));
    }

    static void appendVmSynonymMessage(String string, String string2) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.hotspot", string, string2));
    }

    static void appendVmErgoMessage(boolean bl, String string) {
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.ergo.message1", string));
        outBuf = bl ? outBuf.append(",\n" + LauncherHelper.getLocalizedMessage("java.launcher.ergo.message2", new Object[0]) + "\n\n") : outBuf.append(".\n\n");
    }

    static void printHelpMessage(boolean bl) {
        PrintStream printStream = bl ? System.err : System.out;
        outBuf = outBuf.append(LauncherHelper.getLocalizedMessage("java.launcher.opt.footer", File.pathSeparator));
        printStream.println(outBuf.toString());
    }

    static void printXUsageMessage(boolean bl) {
        PrintStream printStream = bl ? System.err : System.out;
        printStream.println(LauncherHelper.getLocalizedMessage("java.launcher.X.usage", File.pathSeparator));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String getMainClassFromJar(PrintStream printStream, String string) {
        String string2;
        block8: {
            JarFile jarFile = null;
            try {
                Attributes attributes;
                jarFile = new JarFile(string);
                Manifest manifest = jarFile.getManifest();
                if (manifest == null) {
                    LauncherHelper.abort(printStream, null, "java.launcher.jar.error2", string);
                }
                if ((attributes = manifest.getMainAttributes()) == null) {
                    LauncherHelper.abort(printStream, null, "java.launcher.jar.error3", string);
                }
                string2 = attributes.getValue(MAIN_CLASS).trim();
                if (jarFile == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jarFile != null) {
                        jarFile.close();
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    LauncherHelper.abort(printStream, iOException, "java.launcher.jar.error1", string);
                    return null;
                }
            }
            jarFile.close();
        }
        return string2;
    }

    static void abort(PrintStream printStream, Throwable throwable, String string, Object ... objectArray) {
        if (string != null) {
            printStream.println(LauncherHelper.getLocalizedMessage(string, objectArray));
        }
        if (VM.getSavedProperty(diagprop) != null) {
            if (throwable != null) {
                throwable.printStackTrace();
            } else {
                Thread.currentThread();
                Thread.dumpStack();
            }
        }
        System.exit(1);
    }

    public static Object checkAndLoadMain(boolean bl, boolean bl2, String string) throws IOException {
        Class<?> clazz = null;
        PrintStream printStream = bl ? System.err : System.out;
        String string2 = bl2 ? LauncherHelper.getMainClassFromJar(printStream, string) : string;
        string2 = string2.replace('/', '.');
        ClassLoader classLoader = ClassLoader.getSystemClassLoader();
        try {
            clazz = classLoader.loadClass(string2);
        }
        catch (ClassNotFoundException classNotFoundException) {
            LauncherHelper.abort(printStream, classNotFoundException, "java.launcher.cls.error1", string2);
        }
        LauncherHelper.getMainMethod(printStream, clazz);
        return clazz;
    }

    static Method getMainMethod(PrintStream printStream, Class<?> clazz) {
        String string = clazz.getName();
        Method method = null;
        try {
            method = clazz.getMethod("main", String[].class);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            LauncherHelper.abort(printStream, null, "java.launcher.cls.error4", string);
        }
        int n = method.getModifiers();
        if (!Modifier.isStatic(n)) {
            LauncherHelper.abort(printStream, null, "java.launcher.cls.error2", "static", string);
        }
        if (method.getReturnType() != Void.TYPE) {
            LauncherHelper.abort(printStream, null, "java.launcher.cls.error3", string);
        }
        return method;
    }

    static String makePlatformString(boolean bl, byte[] byArray) {
        PrintStream printStream;
        PrintStream printStream2 = printStream = bl ? System.err : System.out;
        if (encoding == null) {
            encoding = System.getProperty(encprop);
            isCharsetSupported = Charset.isSupported(encoding);
        }
        try {
            String string = isCharsetSupported ? new String(byArray, encoding) : new String(byArray);
            return string;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            LauncherHelper.abort(printStream, unsupportedEncodingException, null, new Object[0]);
            return null;
        }
    }

    static {
        outBuf = new StringBuilder();
        encoding = null;
        isCharsetSupported = false;
    }

    private static class ResourceBundleHolder {
        private static final ResourceBundle RB = ResourceBundle.getBundle("sun.launcher.resources.launcher");

        private ResourceBundleHolder() {
        }
    }
}

