/*
 * Decompiled with CFR 0.152.
 */
package sun.management;

import com.sun.management.VMOption;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class Flag {
    private String name;
    private Object value;
    private VMOption.Origin origin;
    private boolean writeable;
    private boolean external;

    Flag(String string, Object object, boolean bl, boolean bl2, VMOption.Origin origin) {
        this.name = string;
        this.value = object;
        this.origin = origin;
        this.writeable = bl;
        this.external = bl2;
    }

    Object getValue() {
        return this.value;
    }

    boolean isWriteable() {
        return this.writeable;
    }

    boolean isExternal() {
        return this.external;
    }

    VMOption getVMOption() {
        return new VMOption(this.name, this.value.toString(), this.writeable, this.origin);
    }

    static Flag getFlag(String string) {
        String[] stringArray = new String[]{string};
        List<Flag> list = Flag.getFlags(stringArray, 1);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(0);
    }

    static List<Flag> getAllFlags() {
        int n = Flag.getInternalFlagCount();
        return Flag.getFlags(null, n);
    }

    private static List<Flag> getFlags(String[] stringArray, int n) {
        Flag[] flagArray = new Flag[n];
        int n2 = Flag.getFlags(stringArray, flagArray, n);
        ArrayList<Flag> arrayList = new ArrayList<Flag>();
        for (Flag flag : flagArray) {
            if (flag == null) continue;
            arrayList.add(flag);
        }
        return arrayList;
    }

    private static native String[] getAllFlagNames();

    private static native int getFlags(String[] var0, Flag[] var1, int var2);

    private static native int getInternalFlagCount();

    static synchronized native void setLongValue(String var0, long var1);

    static synchronized native void setBooleanValue(String var0, boolean var1);

    static synchronized native void setStringValue(String var0, String var1);

    private static native void initialize();

    static {
        Flag.initialize();
    }
}

