/*
 * Decompiled with CFR 0.152.
 */
package sun.misc;

import java.io.ObjectInputStream;
import java.io.SerializablePermission;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.SharedSecrets;

public interface ObjectInputFilter {
    public Status checkInput(FilterInfo var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class Config {
        private static final Object serialFilterLock = new Object();
        private static final Logger configLog;
        private static final String SERIAL_FILTER_PROPNAME = "jdk.serialFilter";
        private static final ObjectInputFilter configuredFilter;
        private static ObjectInputFilter serialFilter;

        private Config() {
        }

        static void filterLog(Level level, String string, Object ... objectArray) {
            if (configLog != null) {
                if (Level.INFO.equals(level)) {
                    configLog.log(Level.INFO, string, objectArray);
                } else if (Level.WARNING.equals(level)) {
                    configLog.log(Level.WARNING, string, objectArray);
                } else {
                    configLog.log(Level.SEVERE, string, objectArray);
                }
            }
        }

        public static ObjectInputFilter getObjectInputFilter(ObjectInputStream objectInputStream) {
            Config.objectsRequireNonNull(objectInputStream, "inputStream");
            return SharedSecrets.getJavaOISAccess().getObjectInputFilter(objectInputStream);
        }

        private static <T> T objectsRequireNonNull(T t, String string) {
            if (t == null) {
                throw new NullPointerException(string);
            }
            return t;
        }

        public static void setObjectInputFilter(ObjectInputStream objectInputStream, ObjectInputFilter objectInputFilter) {
            Config.objectsRequireNonNull(objectInputStream, "inputStream");
            SharedSecrets.getJavaOISAccess().setObjectInputFilter(objectInputStream, objectInputFilter);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static ObjectInputFilter getSerialFilter() {
            Object object = serialFilterLock;
            synchronized (object) {
                return serialFilter;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setSerialFilter(ObjectInputFilter objectInputFilter) {
            Config.objectsRequireNonNull(objectInputFilter, "filter");
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new SerializablePermission("serialFilter"));
            }
            Object object = serialFilterLock;
            synchronized (object) {
                if (serialFilter != null) {
                    throw new IllegalStateException("Serial filter can only be set once");
                }
                serialFilter = objectInputFilter;
            }
        }

        public static ObjectInputFilter createFilter(String string) {
            Config.objectsRequireNonNull(string, "pattern");
            return Global.createFilter(string);
        }

        static {
            configuredFilter = AccessController.doPrivileged(new PrivilegedAction<ObjectInputFilter>(){

                @Override
                public ObjectInputFilter run() {
                    String string = System.getProperty(Config.SERIAL_FILTER_PROPNAME);
                    if (string == null) {
                        string = Security.getProperty(Config.SERIAL_FILTER_PROPNAME);
                    }
                    if (string != null) {
                        Logger logger = Logger.getLogger("java.io.serialization");
                        logger.log(Level.INFO, "Creating serialization filter from {0}", string);
                        try {
                            return Config.createFilter(string);
                        }
                        catch (RuntimeException runtimeException) {
                            logger.log(Level.WARNING, "Error configuring filter: {0}", runtimeException);
                        }
                    }
                    return null;
                }
            });
            configLog = configuredFilter != null ? Logger.getLogger("java.io.serialization") : null;
            serialFilter = configuredFilter;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class Global
        implements ObjectInputFilter {
            private final String pattern;
            private final List<GlobalFilter> filters;
            private long maxStreamBytes;
            private long maxDepth;
            private long maxReferences;
            private long maxArrayLength;

            static ObjectInputFilter createFilter(String string) {
                Global global = new Global(string);
                return global.isEmpty() ? null : global;
            }

            private Global(String string) {
                this.pattern = string;
                this.maxArrayLength = Long.MAX_VALUE;
                this.maxDepth = Long.MAX_VALUE;
                this.maxReferences = Long.MAX_VALUE;
                this.maxStreamBytes = Long.MAX_VALUE;
                String[] stringArray = string.split(";");
                this.filters = new ArrayList<GlobalFilter>(stringArray.length);
                for (int i = 0; i < stringArray.length; ++i) {
                    String string2;
                    boolean bl;
                    String string3 = stringArray[i];
                    int n = string3.length();
                    if (n == 0 || this.parseLimit(string3)) continue;
                    boolean bl2 = bl = string3.charAt(0) == '!';
                    if (string3.indexOf(47) >= 0) {
                        throw new IllegalArgumentException("invalid character \"/\" in: \"" + string + "\"");
                    }
                    if (string3.endsWith("*")) {
                        if (string3.endsWith(".*")) {
                            string2 = string3.substring(bl ? 1 : 0, n - 1);
                            if (string2.length() < 2) {
                                throw new IllegalArgumentException("package missing in: \"" + string + "\"");
                            }
                            if (bl) {
                                this.filters.add(new GlobalFilter(){

                                    public Status apply(Class clazz) {
                                        if (Global.matchesPackage(clazz, string2)) {
                                            return Status.REJECTED;
                                        }
                                        return Status.UNDECIDED;
                                    }
                                });
                                continue;
                            }
                            this.filters.add(new GlobalFilter(){

                                public Status apply(Class clazz) {
                                    if (Global.matchesPackage(clazz, string2)) {
                                        return Status.ALLOWED;
                                    }
                                    return Status.UNDECIDED;
                                }
                            });
                            continue;
                        }
                        if (string3.endsWith(".**")) {
                            string2 = string3.substring(bl ? 1 : 0, n - 2);
                            if (string2.length() < 2) {
                                throw new IllegalArgumentException("package missing in: \"" + string + "\"");
                            }
                            if (bl) {
                                this.filters.add(new GlobalFilter(){

                                    public Status apply(Class clazz) {
                                        if (clazz.getName().startsWith(string2)) {
                                            return Status.REJECTED;
                                        }
                                        return Status.UNDECIDED;
                                    }
                                });
                                continue;
                            }
                            this.filters.add(new GlobalFilter(){

                                public Status apply(Class clazz) {
                                    if (clazz.getName().startsWith(string2)) {
                                        return Status.ALLOWED;
                                    }
                                    return Status.UNDECIDED;
                                }
                            });
                            continue;
                        }
                        string2 = string3.substring(bl ? 1 : 0, n - 1);
                        if (bl) {
                            this.filters.add(new GlobalFilter(){

                                public Status apply(Class clazz) {
                                    if (clazz.getName().startsWith(string2)) {
                                        return Status.REJECTED;
                                    }
                                    return Status.UNDECIDED;
                                }
                            });
                            continue;
                        }
                        this.filters.add(new GlobalFilter(){

                            public Status apply(Class clazz) {
                                if (clazz.getName().startsWith(string2)) {
                                    return Status.ALLOWED;
                                }
                                return Status.UNDECIDED;
                            }
                        });
                        continue;
                    }
                    string2 = string3.substring(bl ? 1 : 0);
                    if (string2.isEmpty()) {
                        throw new IllegalArgumentException("class or package missing in: \"" + string + "\"");
                    }
                    if (bl) {
                        this.filters.add(new GlobalFilter(){

                            public Status apply(Class clazz) {
                                if (clazz.getName().equals(string2)) {
                                    return Status.REJECTED;
                                }
                                return Status.UNDECIDED;
                            }
                        });
                        continue;
                    }
                    this.filters.add(new GlobalFilter(){

                        public Status apply(Class clazz) {
                            if (clazz.getName().equals(string2)) {
                                return Status.ALLOWED;
                            }
                            return Status.UNDECIDED;
                        }
                    });
                }
            }

            private boolean isEmpty() {
                return this.filters.isEmpty() && this.maxArrayLength == Long.MAX_VALUE && this.maxDepth == Long.MAX_VALUE && this.maxReferences == Long.MAX_VALUE && this.maxStreamBytes == Long.MAX_VALUE;
            }

            private boolean parseLimit(String string) {
                int n = string.indexOf(61);
                if (n < 0) {
                    return false;
                }
                String string2 = string.substring(n + 1);
                if (string.startsWith("maxdepth=")) {
                    this.maxDepth = Global.parseValue(string2);
                } else if (string.startsWith("maxarray=")) {
                    this.maxArrayLength = Global.parseValue(string2);
                } else if (string.startsWith("maxrefs=")) {
                    this.maxReferences = Global.parseValue(string2);
                } else if (string.startsWith("maxbytes=")) {
                    this.maxStreamBytes = Global.parseValue(string2);
                } else {
                    throw new IllegalArgumentException("unknown limit: " + string.substring(0, n));
                }
                return true;
            }

            private static long parseValue(String string) throws IllegalArgumentException {
                long l = Long.parseLong(string);
                if (l < 0L) {
                    throw new IllegalArgumentException("negative limit: " + string);
                }
                return l;
            }

            @Override
            public Status checkInput(FilterInfo filterInfo) {
                if (filterInfo.references() < 0L || filterInfo.depth() < 0L || filterInfo.streamBytes() < 0L || filterInfo.references() > this.maxReferences || filterInfo.depth() > this.maxDepth || filterInfo.streamBytes() > this.maxStreamBytes) {
                    return Status.REJECTED;
                }
                Class<?> clazz = filterInfo.serialClass();
                if (clazz != null) {
                    if (clazz.isArray()) {
                        if (filterInfo.arrayLength() >= 0L && filterInfo.arrayLength() > this.maxArrayLength) {
                            return Status.REJECTED;
                        }
                        while ((clazz = clazz.getComponentType()).isArray()) {
                        }
                    }
                    if (clazz.isPrimitive()) {
                        return Status.UNDECIDED;
                    }
                    Class<?> clazz2 = clazz;
                    for (GlobalFilter globalFilter : this.filters) {
                        Status status = globalFilter.apply(clazz2);
                        if (status != Status.REJECTED && status != Status.ALLOWED) continue;
                        return status;
                    }
                    return Status.UNDECIDED;
                }
                return Status.UNDECIDED;
            }

            private static boolean matchesPackage(Class<?> clazz, String string) {
                String string2 = clazz.getName();
                return string2.startsWith(string) && string2.lastIndexOf(46) == string.length() - 1;
            }

            public String toString() {
                return this.pattern;
            }
        }

        static interface GlobalFilter {
            public Status apply(Class var1);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Status {
        UNDECIDED,
        ALLOWED,
        REJECTED;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface FilterInfo {
        public Class<?> serialClass();

        public long arrayLength();

        public long depth();

        public long references();

        public long streamBytes();
    }
}

