/*
 * Decompiled with CFR 0.152.
 */
package sun.net.dns;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.LinkedList;
import java.util.List;
import java.util.StringTokenizer;
import sun.net.dns.OptionsImpl;
import sun.net.dns.ResolverConfiguration;
import sun.security.action.LoadLibraryAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResolverConfigurationImpl
extends ResolverConfiguration {
    private static Object lock = new Object();
    private static long lastRefresh = -1L;
    private static final int TIMEOUT = 300000;
    private final ResolverConfiguration.Options opts = new OptionsImpl();
    private LinkedList<String> searchlist;
    private LinkedList<String> nameservers;

    private LinkedList<String> resolvconf(String string, int n, int n2) {
        LinkedList<String> linkedList = new LinkedList<String>();
        try {
            String string2;
            BufferedReader bufferedReader = new BufferedReader(new FileReader("/etc/resolv.conf"));
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                String string4;
                int n3 = n;
                if (string2.length() == 0 || string2.charAt(0) == '#' || string2.charAt(0) == ';' || !string2.startsWith(string) || (string4 = string2.substring(string.length())).length() == 0 || string4.charAt(0) != ' ' && string4.charAt(0) != '\t') continue;
                StringTokenizer stringTokenizer = new StringTokenizer(string4, " \t");
                while (stringTokenizer.hasMoreTokens() && (string3 = stringTokenizer.nextToken()).charAt(0) != '#' && string3.charAt(0) != ';') {
                    linkedList.add(string3);
                    if (--n3 != 0) continue;
                    break;
                }
                if (--n2 != 0) continue;
                break;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return linkedList;
    }

    private void loadConfig() {
        long l;
        assert (Thread.holdsLock(lock));
        if (lastRefresh >= 0L && (l = System.currentTimeMillis()) - lastRefresh < 300000L) {
            return;
        }
        this.nameservers = AccessController.doPrivileged(new PrivilegedAction<LinkedList<String>>(){

            @Override
            public LinkedList<String> run() {
                return ResolverConfigurationImpl.this.resolvconf("nameserver", 1, 5);
            }
        });
        this.searchlist = this.getSearchList();
        lastRefresh = System.currentTimeMillis();
    }

    private LinkedList<String> getSearchList() {
        LinkedList<String> linkedList = AccessController.doPrivileged(new PrivilegedAction<LinkedList<String>>(){

            @Override
            public LinkedList<String> run() {
                LinkedList linkedList = ResolverConfigurationImpl.this.resolvconf("search", 6, 1);
                if (linkedList.size() > 0) {
                    return linkedList;
                }
                return null;
            }
        });
        if (linkedList != null) {
            return linkedList;
        }
        String string = ResolverConfigurationImpl.localDomain0();
        if (string != null && string.length() > 0) {
            linkedList = new LinkedList();
            linkedList.add(string);
            return linkedList;
        }
        linkedList = AccessController.doPrivileged(new PrivilegedAction<LinkedList<String>>(){

            @Override
            public LinkedList<String> run() {
                LinkedList linkedList = ResolverConfigurationImpl.this.resolvconf("domain", 1, 1);
                if (linkedList.size() > 0) {
                    return linkedList;
                }
                return null;
            }
        });
        if (linkedList != null) {
            return linkedList;
        }
        linkedList = new LinkedList();
        String string2 = ResolverConfigurationImpl.fallbackDomain0();
        if (string2 != null && string2.length() > 0) {
            linkedList.add(string2);
        }
        return linkedList;
    }

    ResolverConfigurationImpl() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> searchlist() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)this.searchlist.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> nameservers() {
        Object object = lock;
        synchronized (object) {
            this.loadConfig();
            return (List)this.nameservers.clone();
        }
    }

    @Override
    public ResolverConfiguration.Options options() {
        return this.opts;
    }

    static native String localDomain0();

    static native String fallbackDomain0();

    static {
        AccessController.doPrivileged(new LoadLibraryAction("net"));
    }
}

