/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www;

import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import sun.net.www.MessageHeader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class URLConnection
extends java.net.URLConnection {
    private String contentType;
    private int contentLength = -1;
    protected MessageHeader properties = new MessageHeader();
    private static Map proxiedHosts = new HashMap();

    public URLConnection(URL uRL) {
        super(uRL);
    }

    public MessageHeader getProperties() {
        return this.properties;
    }

    public void setProperties(MessageHeader messageHeader) {
        this.properties = messageHeader;
    }

    @Override
    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalAccessError("Already connected");
        }
        if (string == null) {
            throw new NullPointerException("key cannot be null");
        }
        this.properties.set(string, string2);
    }

    @Override
    public void addRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        if (string == null) {
            throw new NullPointerException("key is null");
        }
    }

    @Override
    public String getRequestProperty(String string) {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return null;
    }

    @Override
    public Map<String, List<String>> getRequestProperties() {
        if (this.connected) {
            throw new IllegalStateException("Already connected");
        }
        return Collections.emptyMap();
    }

    @Override
    public String getHeaderField(String string) {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
        return this.properties == null ? null : this.properties.findValue(string);
    }

    @Override
    public String getHeaderFieldKey(int n) {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
        MessageHeader messageHeader = this.properties;
        return messageHeader == null ? null : messageHeader.getKey(n);
    }

    @Override
    public String getHeaderField(int n) {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return null;
        }
        MessageHeader messageHeader = this.properties;
        return messageHeader == null ? null : messageHeader.getValue(n);
    }

    @Override
    public String getContentType() {
        if (this.contentType == null) {
            this.contentType = this.getHeaderField("content-type");
        }
        if (this.contentType == null) {
            String string = null;
            try {
                string = URLConnection.guessContentTypeFromStream(this.getInputStream());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            String string2 = this.properties.findValue("content-encoding");
            if (string == null && (string = this.properties.findValue("content-type")) == null) {
                string = this.url.getFile().endsWith("/") ? "text/html" : URLConnection.guessContentTypeFromName(this.url.getFile());
            }
            if (string == null || string2 != null && !string2.equalsIgnoreCase("7bit") && !string2.equalsIgnoreCase("8bit") && !string2.equalsIgnoreCase("binary")) {
                string = "content/unknown";
            }
            this.setContentType(string);
        }
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
        this.properties.set("content-type", string);
    }

    @Override
    public int getContentLength() {
        try {
            this.getInputStream();
        }
        catch (Exception exception) {
            return -1;
        }
        int n = this.contentLength;
        if (n < 0) {
            try {
                n = Integer.parseInt(this.properties.findValue("content-length"));
                this.setContentLength(n);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n;
    }

    protected void setContentLength(int n) {
        this.contentLength = n;
        this.properties.set("content-length", String.valueOf(n));
    }

    public boolean canCache() {
        return this.url.getFile().indexOf(63) < 0;
    }

    public void close() {
        this.url = null;
    }

    public static synchronized void setProxiedHost(String string) {
        proxiedHosts.put(string.toLowerCase(), null);
    }

    public static synchronized boolean isProxiedHost(String string) {
        return proxiedHosts.containsKey(string.toLowerCase());
    }
}

