/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.http;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import sun.net.NetProperties;

public class HttpCapture {
    private File file = null;
    private boolean incoming = true;
    private BufferedWriter out = null;
    private static boolean initialized;
    private static volatile ArrayList<Pattern> patterns;
    private static volatile ArrayList<String> capFiles;
    private static Object logger;
    private static boolean logging;

    public static void fine(String string) {
        if (logging) {
            ((Logger)logger).fine(string);
        }
    }

    public static void finer(String string) {
        if (logging) {
            ((Logger)logger).finer(string);
        }
    }

    public static void finest(String string) {
        if (logging) {
            ((Logger)logger).finest(string);
        }
    }

    public static void severe(String string) {
        if (logging) {
            ((Logger)logger).finest(string);
        }
    }

    public static void info(String string) {
        if (logging) {
            ((Logger)logger).info(string);
        }
    }

    public static void warning(String string) {
        if (logging) {
            ((Logger)logger).warning(string);
        }
    }

    public static boolean isLoggable(String string) {
        if (!logging) {
            return false;
        }
        return ((Logger)logger).isLoggable(Level.parse(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private static synchronized void init() {
        block14: {
            initialized = true;
            String string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    return NetProperties.get("sun.net.http.captureRules");
                }
            });
            if (string != null && !string.isEmpty()) {
                BufferedReader bufferedReader;
                try {
                    bufferedReader = new BufferedReader(new FileReader(string));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    return;
                }
                String string2 = bufferedReader.readLine();
                while (string2 != null) {
                    String[] stringArray;
                    if (!(string2 = string2.trim()).startsWith("#") && (stringArray = string2.split(",")).length == 2) {
                        if (patterns == null) {
                            patterns = new ArrayList();
                            capFiles = new ArrayList();
                        }
                        patterns.add(Pattern.compile(stringArray[0].trim()));
                        capFiles.add(stringArray[1].trim());
                    }
                    string2 = bufferedReader.readLine();
                }
                Object var5_6 = null;
                try {
                    bufferedReader.close();
                }
                catch (IOException iOException) {}
                break block14;
                {
                    catch (IOException iOException) {
                        Object var5_7 = null;
                        try {
                            bufferedReader.close();
                        }
                        catch (IOException iOException2) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var5_8 = null;
                    try {
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }

    private static synchronized boolean isInitialized() {
        return initialized;
    }

    private HttpCapture(File file, URL uRL) {
        this.file = file;
        try {
            this.out = new BufferedWriter(new FileWriter(this.file, true));
            this.out.write("URL: " + uRL + "\n");
        }
        catch (IOException iOException) {
            Logger.getLogger(HttpCapture.class.getName()).log(Level.SEVERE, null, iOException);
        }
    }

    public synchronized void sent(int n) throws IOException {
        if (this.incoming) {
            this.out.write("\n------>\n");
            this.incoming = false;
            this.out.flush();
        }
        this.out.write(n);
    }

    public synchronized void received(int n) throws IOException {
        if (!this.incoming) {
            this.out.write("\n<------\n");
            this.incoming = true;
            this.out.flush();
        }
        this.out.write(n);
    }

    public synchronized void flush() throws IOException {
        this.out.flush();
    }

    public static HttpCapture getCapture(URL uRL) {
        if (!HttpCapture.isInitialized()) {
            HttpCapture.init();
        }
        if (patterns == null || patterns.isEmpty()) {
            return null;
        }
        String string = uRL.toString();
        for (int i = 0; i < patterns.size(); ++i) {
            File file;
            Pattern pattern = patterns.get(i);
            if (!pattern.matcher(string).find()) continue;
            String string2 = capFiles.get(i);
            if (string2.indexOf("%d") >= 0) {
                String string3;
                Random random = new Random();
                while ((file = new File(string3 = string2.replace("%d", Integer.toString(random.nextInt())))).exists()) {
                }
            } else {
                file = new File(string2);
            }
            return new HttpCapture(file, uRL);
        }
        return null;
    }

    static {
        Class<?> clazz;
        initialized = false;
        patterns = null;
        capFiles = null;
        logger = null;
        logging = false;
        try {
            clazz = Class.forName("java.util.logging.Logger");
        }
        catch (ClassNotFoundException classNotFoundException) {
            clazz = null;
        }
        if (clazz != null) {
            try {
                Method method = clazz.getMethod("getLogger", String.class);
                logger = method.invoke(null, "sun.net.www.protocol.http.HttpURLConnection");
                logging = true;
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException securityException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
    }
}

