/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.security.AccessController;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import sun.net.www.HeaderParser;
import sun.net.www.MessageHeader;
import sun.net.www.protocol.http.HttpCallerInfo;
import sun.net.www.protocol.http.NegotiateAuthentication;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationHeader {
    MessageHeader rsp;
    HeaderParser preferred;
    String preferred_r;
    private final HttpCallerInfo hci;
    static String authPref = null;
    String hdrname;
    HashMap<String, SchemeMapValue> schemes;

    public String toString() {
        return "AuthenticationHeader: prefer " + this.preferred_r;
    }

    public AuthenticationHeader(String string, MessageHeader messageHeader, HttpCallerInfo httpCallerInfo) {
        this(string, messageHeader, httpCallerInfo, Collections.emptySet());
    }

    public AuthenticationHeader(String string, MessageHeader messageHeader, HttpCallerInfo httpCallerInfo, Set<String> set) {
        this.hci = httpCallerInfo;
        this.rsp = messageHeader;
        this.hdrname = string;
        this.schemes = new HashMap();
        this.parse(set);
    }

    public HttpCallerInfo getHttpCallerInfo() {
        return this.hci;
    }

    private void parse(Set<String> set) {
        Object object;
        Object object2;
        Iterator<String> iterator = this.rsp.multiValueIterator(this.hdrname);
        while (iterator.hasNext()) {
            HeaderParser headerParser;
            String string;
            object2 = iterator.next();
            object = new HeaderParser((String)object2);
            Iterator<String> iterator2 = ((HeaderParser)object).keys();
            int n = 0;
            int n2 = -1;
            while (iterator2.hasNext()) {
                iterator2.next();
                if (((HeaderParser)object).findValue(n) == null) {
                    if (n2 != -1 && !set.contains(string = (headerParser = ((HeaderParser)object).subsequence(n2, n)).findKey(0))) {
                        this.schemes.put(string, new SchemeMapValue(headerParser, (String)object2));
                    }
                    n2 = n;
                }
                ++n;
            }
            if (n <= n2 || set.contains(string = (headerParser = ((HeaderParser)object).subsequence(n2, n)).findKey(0))) continue;
            this.schemes.put(string, new SchemeMapValue(headerParser, (String)object2));
        }
        object2 = null;
        if (authPref == null || (object2 = this.schemes.get(authPref)) == null) {
            if (object2 == null && (object = this.schemes.get("negotiate")) != null) {
                if (this.hci == null || !NegotiateAuthentication.isSupported(new HttpCallerInfo(this.hci, "Negotiate"))) {
                    object = null;
                }
                object2 = object;
            }
            if (object2 == null && (object = this.schemes.get("kerberos")) != null) {
                if (this.hci == null || !NegotiateAuthentication.isSupported(new HttpCallerInfo(this.hci, "Kerberos"))) {
                    object = null;
                }
                object2 = object;
            }
            if (object2 == null && (object2 = this.schemes.get("digest")) == null && (object2 = this.schemes.get("ntlm")) == null) {
                object2 = this.schemes.get("basic");
            }
        }
        if (object2 != null) {
            this.preferred = ((SchemeMapValue)object2).parser;
            this.preferred_r = ((SchemeMapValue)object2).raw;
        }
    }

    public HeaderParser headerParser() {
        return this.preferred;
    }

    public String scheme() {
        if (this.preferred != null) {
            return this.preferred.findKey(0);
        }
        return null;
    }

    public String raw() {
        return this.preferred_r;
    }

    public boolean isPresent() {
        return this.preferred != null;
    }

    static {
        authPref = AccessController.doPrivileged(new GetPropertyAction("http.auth.preference"));
        if (authPref != null && ((authPref = authPref.toLowerCase()).equals("spnego") || authPref.equals("kerberos"))) {
            authPref = "negotiate";
        }
    }

    static class SchemeMapValue {
        String raw;
        HeaderParser parser;

        SchemeMapValue(HeaderParser headerParser, String string) {
            this.raw = string;
            this.parser = headerParser;
        }
    }
}

