/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.PasswordAuthentication;
import java.net.URL;
import sun.net.www.http.HttpCapture;
import sun.net.www.protocol.http.AuthenticationInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NTLMAuthenticationProxy {
    private static Method supportsTA;
    private static final String clazzStr = "sun.net.www.protocol.http.NTLMAuthentication";
    private static final String supportsTAStr = "supportsTransparentAuth";
    static final NTLMAuthenticationProxy proxy;
    static final boolean supported;
    static final boolean supportsTransparentAuth;
    private final Constructor<? extends AuthenticationInfo> threeArgCtr;
    private final Constructor<? extends AuthenticationInfo> fiveArgCtr;

    private NTLMAuthenticationProxy(Constructor<? extends AuthenticationInfo> constructor, Constructor<? extends AuthenticationInfo> constructor2) {
        this.threeArgCtr = constructor;
        this.fiveArgCtr = constructor2;
    }

    AuthenticationInfo create(boolean bl, URL uRL, PasswordAuthentication passwordAuthentication) {
        try {
            return this.threeArgCtr.newInstance(bl, uRL, passwordAuthentication);
        }
        catch (InstantiationException instantiationException) {
            NTLMAuthenticationProxy.log(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            NTLMAuthenticationProxy.log(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            NTLMAuthenticationProxy.log(illegalAccessException);
        }
        return null;
    }

    AuthenticationInfo create(boolean bl, String string, int n, PasswordAuthentication passwordAuthentication) {
        try {
            return this.fiveArgCtr.newInstance(bl, string, n, passwordAuthentication);
        }
        catch (InstantiationException instantiationException) {
            NTLMAuthenticationProxy.log(instantiationException);
        }
        catch (InvocationTargetException invocationTargetException) {
            NTLMAuthenticationProxy.log(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            NTLMAuthenticationProxy.log(illegalAccessException);
        }
        return null;
    }

    private static boolean supportsTransparentAuth(Method method) {
        try {
            return (Boolean)method.invoke(null, new Object[0]);
        }
        catch (InvocationTargetException invocationTargetException) {
            NTLMAuthenticationProxy.log(invocationTargetException);
        }
        catch (IllegalAccessException illegalAccessException) {
            NTLMAuthenticationProxy.log(illegalAccessException);
        }
        return false;
    }

    private static NTLMAuthenticationProxy tryLoadNTLMAuthentication() {
        try {
            Class<?> clazz = Class.forName(clazzStr, true, null);
            if (clazz != null) {
                Constructor<?> constructor = clazz.getConstructor(Boolean.TYPE, URL.class, PasswordAuthentication.class);
                Constructor<?> constructor2 = clazz.getConstructor(Boolean.TYPE, String.class, Integer.TYPE, PasswordAuthentication.class);
                supportsTA = clazz.getDeclaredMethod(supportsTAStr, new Class[0]);
                return new NTLMAuthenticationProxy(constructor, constructor2);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            NTLMAuthenticationProxy.log(classNotFoundException);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            throw new AssertionError((Object)noSuchMethodException);
        }
        return null;
    }

    static void log(Exception exception) {
        if (HttpCapture.isLoggable("FINEST")) {
            HttpCapture.finest("NTLMAuthenticationProxy: " + exception);
        }
    }

    static {
        proxy = NTLMAuthenticationProxy.tryLoadNTLMAuthentication();
        supported = proxy != null;
        supportsTransparentAuth = supported ? NTLMAuthenticationProxy.supportsTransparentAuth(supportsTA) : false;
    }
}

