/*
 * Decompiled with CFR 0.152.
 */
package sun.net.www.protocol.http;

import java.io.IOException;
import java.net.Authenticator;
import java.net.URL;
import java.security.AccessController;
import java.util.HashMap;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;
import sun.net.www.HeaderParser;
import sun.net.www.protocol.http.AuthScheme;
import sun.net.www.protocol.http.AuthenticationInfo;
import sun.net.www.protocol.http.HttpCallerInfo;
import sun.net.www.protocol.http.HttpURLConnection;
import sun.net.www.protocol.http.Negotiator;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class NegotiateAuthentication
extends AuthenticationInfo {
    private static final long serialVersionUID = 100L;
    private final HttpCallerInfo hci;
    static HashMap<String, Boolean> supported = null;
    static ThreadLocal<HashMap<String, Negotiator>> cache = null;
    private static final boolean cacheSPNEGO;
    private Negotiator negotiator = null;

    public NegotiateAuthentication(HttpCallerInfo httpCallerInfo) {
        super(Authenticator.RequestorType.PROXY == httpCallerInfo.authType ? (char)'p' : 's', httpCallerInfo.scheme.equalsIgnoreCase("Negotiate") ? AuthScheme.NEGOTIATE : AuthScheme.KERBEROS, httpCallerInfo.url, "");
        this.hci = httpCallerInfo;
    }

    @Override
    boolean supportsPreemptiveAuthorization() {
        return false;
    }

    public static synchronized boolean isSupported(HttpCallerInfo httpCallerInfo) {
        if (supported == null) {
            supported = new HashMap();
        }
        String string = httpCallerInfo.host;
        if (supported.containsKey(string = string.toLowerCase())) {
            return supported.get(string);
        }
        try {
            Negotiator negotiator = Negotiator.getSupported(httpCallerInfo);
            supported.put(string, true);
            if (cache == null) {
                cache = new ThreadLocal<HashMap<String, Negotiator>>(){

                    @Override
                    protected HashMap<String, Negotiator> initialValue() {
                        return new HashMap<String, Negotiator>();
                    }
                };
            }
            cache.get().put(string, negotiator);
            return true;
        }
        catch (Exception exception) {
            supported.put(string, false);
            return false;
        }
    }

    @Override
    String getHeaderName() {
        if (this.type == 's') {
            return "Authorization";
        }
        return "Proxy-Authorization";
    }

    private static synchronized HashMap<String, Negotiator> getCache() {
        if (cache == null) {
            return null;
        }
        return cache.get();
    }

    @Override
    protected boolean useAuthCache() {
        return super.useAuthCache() && cacheSPNEGO;
    }

    @Override
    String getHeaderValue(URL uRL, String string) {
        throw new RuntimeException("getHeaderValue not supported");
    }

    @Override
    boolean isAuthorizationStale(String string) {
        return false;
    }

    @Override
    synchronized boolean setHeaders(HttpURLConnection httpURLConnection, HeaderParser headerParser, String string) {
        try {
            byte[] byArray = null;
            String[] stringArray = string.split("\\s+");
            if (stringArray.length > 1) {
                byArray = new BASE64Decoder().decodeBuffer(stringArray[1]);
            }
            String string2 = this.hci.scheme + " " + new B64Encoder().encode(byArray == null ? this.firstToken() : this.nextToken(byArray));
            httpURLConnection.setAuthenticationProperty(this.getHeaderName(), string2);
            return true;
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private byte[] firstToken() throws IOException {
        this.negotiator = null;
        HashMap<String, Negotiator> hashMap = NegotiateAuthentication.getCache();
        if (hashMap != null) {
            this.negotiator = hashMap.get(this.getHost());
            if (this.negotiator != null) {
                hashMap.remove(this.getHost());
            }
        }
        if (this.negotiator == null) {
            try {
                this.negotiator = Negotiator.getSupported(this.hci);
            }
            catch (Exception exception) {
                IOException iOException = new IOException("Cannot initialize Negotiator");
                iOException.initCause(exception);
                throw iOException;
            }
        }
        return this.negotiator.firstToken();
    }

    private byte[] nextToken(byte[] byArray) throws IOException {
        return this.negotiator.nextToken(byArray);
    }

    @Override
    public void checkResponse(String string, String string2, URL uRL) throws IOException {
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction("jdk.spnego.cache", "true"));
        cacheSPNEGO = Boolean.parseBoolean(string);
    }

    class B64Encoder
    extends BASE64Encoder {
        B64Encoder() {
        }

        protected int bytesPerLine() {
            return 100000;
        }
    }
}

