/*
 * Decompiled with CFR 0.152.
 */
package sun.print;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import sun.print.PrinterGraphicsDevice;

public class PrinterGraphicsConfig
extends GraphicsConfiguration {
    static ColorModel theModel;
    GraphicsDevice gd;
    int pageWidth;
    int pageHeight;
    AffineTransform deviceTransform;

    public PrinterGraphicsConfig(String string, AffineTransform affineTransform, int n, int n2) {
        this.pageWidth = n;
        this.pageHeight = n2;
        this.deviceTransform = affineTransform;
        this.gd = new PrinterGraphicsDevice(this, string);
    }

    public GraphicsDevice getDevice() {
        return this.gd;
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        ColorModel colorModel = this.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public ColorModel getColorModel() {
        if (theModel == null) {
            BufferedImage bufferedImage = new BufferedImage(1, 1, 5);
            theModel = bufferedImage.getColorModel();
        }
        return theModel;
    }

    public ColorModel getColorModel(int n) {
        switch (n) {
            case 1: {
                return this.getColorModel();
            }
            case 2: {
                return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
            }
            case 3: {
                return ColorModel.getRGBdefault();
            }
        }
        return null;
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform(this.deviceTransform);
    }

    public AffineTransform getNormalizingTransform() {
        return new AffineTransform();
    }

    public Rectangle getBounds() {
        return new Rectangle(0, 0, this.pageWidth, this.pageHeight);
    }
}

