/*
 * Decompiled with CFR 0.152.
 */
package sun.reflect.generics.reflectiveObjects;

import java.lang.reflect.Constructor;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import sun.reflect.generics.factory.GenericsFactory;
import sun.reflect.generics.reflectiveObjects.LazyReflectiveObjectGenerator;
import sun.reflect.generics.tree.FieldTypeSignature;
import sun.reflect.generics.visitor.Reifier;
import sun.reflect.misc.ReflectUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TypeVariableImpl<D extends GenericDeclaration>
extends LazyReflectiveObjectGenerator
implements TypeVariable<D> {
    D genericDeclaration;
    private String name;
    private Type[] bounds;
    private FieldTypeSignature[] boundASTs;

    private TypeVariableImpl(D d, String string, FieldTypeSignature[] fieldTypeSignatureArray, GenericsFactory genericsFactory) {
        super(genericsFactory);
        this.genericDeclaration = d;
        this.name = string;
        this.boundASTs = fieldTypeSignatureArray;
    }

    private FieldTypeSignature[] getBoundASTs() {
        assert (this.bounds == null);
        return this.boundASTs;
    }

    public static <T extends GenericDeclaration> TypeVariableImpl<T> make(T t, String string, FieldTypeSignature[] fieldTypeSignatureArray, GenericsFactory genericsFactory) {
        if (!(t instanceof Class || t instanceof Method || t instanceof Constructor)) {
            throw new AssertionError((Object)("Unexpected kind of GenericDeclaration" + t.getClass().toString()));
        }
        return new TypeVariableImpl<T>(t, string, fieldTypeSignatureArray, genericsFactory);
    }

    @Override
    public Type[] getBounds() {
        if (this.bounds == null) {
            FieldTypeSignature[] fieldTypeSignatureArray = this.getBoundASTs();
            Type[] typeArray = new Type[fieldTypeSignatureArray.length];
            for (int i = 0; i < fieldTypeSignatureArray.length; ++i) {
                Reifier reifier = this.getReifier();
                fieldTypeSignatureArray[i].accept(reifier);
                typeArray[i] = reifier.getResult();
            }
            this.bounds = typeArray;
        }
        return (Type[])this.bounds.clone();
    }

    @Override
    public D getGenericDeclaration() {
        if (this.genericDeclaration instanceof Class) {
            ReflectUtil.checkPackageAccess((Class)this.genericDeclaration);
        } else if (this.genericDeclaration instanceof Method || this.genericDeclaration instanceof Constructor) {
            ReflectUtil.conservativeCheckMemberAccess((Member)this.genericDeclaration);
        } else {
            throw new AssertionError((Object)"Unexpected kind of GenericDeclaration");
        }
        return this.genericDeclaration;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.getName();
    }

    public boolean equals(Object object) {
        if (object instanceof TypeVariable && object.getClass() == TypeVariableImpl.class) {
            TypeVariable typeVariable = (TypeVariable)object;
            Object d = typeVariable.getGenericDeclaration();
            String string = typeVariable.getName();
            return (this.genericDeclaration == null ? d == null : this.genericDeclaration.equals(d)) && (this.name == null ? string == null : this.name.equals(string));
        }
        return false;
    }

    public int hashCode() {
        return this.genericDeclaration.hashCode() ^ this.name.hashCode();
    }
}

