/*
 * Decompiled with CFR 0.152.
 */
package sun.rmi.transport.tcp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.rmi.RemoteException;
import java.rmi.server.ExportException;
import java.rmi.server.LogStream;
import java.rmi.server.RMIFailureHandler;
import java.rmi.server.RMISocketFactory;
import java.rmi.server.ServerNotActiveException;
import java.rmi.server.UID;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import sun.rmi.runtime.Log;
import sun.rmi.runtime.NewThreadAction;
import sun.rmi.transport.Connection;
import sun.rmi.transport.DGCAckHandler;
import sun.rmi.transport.Endpoint;
import sun.rmi.transport.StreamRemoteCall;
import sun.rmi.transport.Target;
import sun.rmi.transport.Transport;
import sun.rmi.transport.proxy.HttpReceiveSocket;
import sun.rmi.transport.tcp.ConnectionMultiplexer;
import sun.rmi.transport.tcp.TCPChannel;
import sun.rmi.transport.tcp.TCPConnection;
import sun.rmi.transport.tcp.TCPEndpoint;
import sun.security.action.GetIntegerAction;
import sun.security.action.GetLongAction;
import sun.security.action.GetPropertyAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TCPTransport
extends Transport {
    static final Log tcpLog = Log.getLog("sun.rmi.transport.tcp", "tcp", LogStream.parseLevel(AccessController.doPrivileged(new GetPropertyAction("sun.rmi.transport.tcp.logLevel"))));
    private static final int maxConnectionThreads = AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.maxConnectionThreads", Integer.MAX_VALUE));
    private static final long threadKeepAliveTime = AccessController.doPrivileged(new GetLongAction("sun.rmi.transport.tcp.threadKeepAliveTime", 60000L));
    private static final ExecutorService connectionThreadPool = new ThreadPoolExecutor(0, maxConnectionThreads, threadKeepAliveTime, TimeUnit.MILLISECONDS, new SynchronousQueue<Runnable>(), new ThreadFactory(){

        public Thread newThread(Runnable runnable) {
            return AccessController.doPrivileged(new NewThreadAction(runnable, "TCP Connection(idle)", true, true));
        }
    });
    private static final boolean disableIncomingHttp = AccessController.doPrivileged(new GetPropertyAction("sun.rmi.server.disableIncomingHttp", "true")).equalsIgnoreCase("true");
    private static final AtomicInteger connectionCount = new AtomicInteger(0);
    private static final ThreadLocal<ConnectionHandler> threadConnectionHandler = new ThreadLocal();
    private static final AccessControlContext NOPERMS_ACC;
    private final LinkedList<TCPEndpoint> epList;
    private int exportCount = 0;
    private ServerSocket server = null;
    private final Map<TCPEndpoint, Reference<TCPChannel>> channelTable = new WeakHashMap<TCPEndpoint, Reference<TCPChannel>>();
    static final RMISocketFactory defaultSocketFactory;
    private static final int connectionReadTimeout;

    TCPTransport(LinkedList<TCPEndpoint> linkedList) {
        this.epList = linkedList;
        if (tcpLog.isLoggable(Log.BRIEF)) {
            tcpLog.log(Log.BRIEF, "Version = 2, ep = " + this.getEndpoint());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shedConnectionCaches() {
        ArrayList<TCPChannel> arrayList;
        Map<TCPEndpoint, Reference<TCPChannel>> map = this.channelTable;
        synchronized (map) {
            arrayList = new ArrayList<TCPChannel>(this.channelTable.values().size());
            for (Reference<TCPChannel> reference : this.channelTable.values()) {
                TCPChannel tCPChannel = reference.get();
                if (tCPChannel == null) continue;
                arrayList.add(tCPChannel);
            }
        }
        for (TCPChannel tCPChannel : arrayList) {
            tCPChannel.shedCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TCPChannel getChannel(Endpoint endpoint) {
        TCPChannel tCPChannel = null;
        if (endpoint instanceof TCPEndpoint) {
            Map<TCPEndpoint, Reference<TCPChannel>> map = this.channelTable;
            synchronized (map) {
                Reference<TCPChannel> reference = this.channelTable.get(endpoint);
                if (reference != null) {
                    tCPChannel = reference.get();
                }
                if (tCPChannel == null) {
                    TCPEndpoint tCPEndpoint = (TCPEndpoint)endpoint;
                    tCPChannel = new TCPChannel(this, tCPEndpoint);
                    this.channelTable.put(tCPEndpoint, new WeakReference<TCPChannel>(tCPChannel));
                }
            }
        }
        return tCPChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void free(Endpoint endpoint) {
        if (endpoint instanceof TCPEndpoint) {
            Map<TCPEndpoint, Reference<TCPChannel>> map = this.channelTable;
            synchronized (map) {
                TCPChannel tCPChannel;
                Reference<TCPChannel> reference = this.channelTable.remove(endpoint);
                if (reference != null && (tCPChannel = reference.get()) != null) {
                    tCPChannel.shedCache();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exportObject(Target target) throws RemoteException {
        TCPTransport tCPTransport = this;
        synchronized (tCPTransport) {
            this.listen();
            ++this.exportCount;
        }
        boolean bl = false;
        try {
            super.exportObject(target);
            bl = true;
        }
        finally {
            if (!bl) {
                TCPTransport tCPTransport2 = this;
                synchronized (tCPTransport2) {
                    this.decrementExportCount();
                }
            }
        }
    }

    @Override
    protected synchronized void targetUnexported() {
        this.decrementExportCount();
    }

    private void decrementExportCount() {
        assert (Thread.holdsLock(this));
        --this.exportCount;
        if (this.exportCount == 0 && this.getEndpoint().getListenPort() != 0) {
            ServerSocket serverSocket = this.server;
            this.server = null;
            try {
                serverSocket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    protected void checkAcceptPermission(AccessControlContext accessControlContext) {
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager == null) {
            return;
        }
        ConnectionHandler connectionHandler = threadConnectionHandler.get();
        if (connectionHandler == null) {
            throw new Error("checkAcceptPermission not in ConnectionHandler thread");
        }
        connectionHandler.checkAcceptPermission(securityManager, accessControlContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TCPEndpoint getEndpoint() {
        LinkedList<TCPEndpoint> linkedList = this.epList;
        synchronized (linkedList) {
            return this.epList.getLast();
        }
    }

    private void listen() throws RemoteException {
        assert (Thread.holdsLock(this));
        TCPEndpoint tCPEndpoint = this.getEndpoint();
        int n = tCPEndpoint.getPort();
        if (this.server == null) {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "(port " + n + ") create server socket");
            }
            try {
                this.server = tCPEndpoint.newServerSocket();
                Thread thread = AccessController.doPrivileged(new NewThreadAction(new AcceptLoop(this.server), "TCP Accept-" + n, true));
                thread.start();
            }
            catch (BindException bindException) {
                throw new ExportException("Port already in use: " + n, bindException);
            }
            catch (IOException iOException) {
                throw new ExportException("Listen failed on port: " + n, iOException);
            }
        } else {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkListen(n);
            }
        }
    }

    private static void closeSocket(Socket socket) {
        try {
            socket.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleMessages(Connection connection, boolean bl) {
        int n = this.getEndpoint().getPort();
        try {
            DataInputStream dataInputStream = new DataInputStream(connection.getInputStream());
            block19: do {
                int n2;
                if ((n2 = dataInputStream.read()) == -1) {
                    if (tcpLog.isLoggable(Log.BRIEF)) {
                        tcpLog.log(Log.BRIEF, "(port " + n + ") connection closed");
                    }
                    break;
                }
                if (tcpLog.isLoggable(Log.BRIEF)) {
                    tcpLog.log(Log.BRIEF, "(port " + n + ") op = " + n2);
                }
                switch (n2) {
                    case 80: {
                        StreamRemoteCall streamRemoteCall = new StreamRemoteCall(connection);
                        if (this.serviceCall(streamRemoteCall)) continue block19;
                        return;
                    }
                    case 82: {
                        DataOutputStream dataOutputStream = new DataOutputStream(connection.getOutputStream());
                        dataOutputStream.writeByte(83);
                        connection.releaseOutputStream();
                        break;
                    }
                    case 84: {
                        DGCAckHandler.received(UID.read(dataInputStream));
                        break;
                    }
                    default: {
                        throw new IOException("unknown transport op " + n2);
                    }
                }
            } while (bl);
        }
        catch (IOException iOException) {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "(port " + n + ") exception: ", iOException);
            }
        }
        finally {
            try {
                connection.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static String getClientHost() throws ServerNotActiveException {
        ConnectionHandler connectionHandler = threadConnectionHandler.get();
        if (connectionHandler != null) {
            return connectionHandler.getClientHost();
        }
        throw new ServerNotActiveException("not in a remote call");
    }

    static {
        Permissions permissions = new Permissions();
        ProtectionDomain[] protectionDomainArray = new ProtectionDomain[]{new ProtectionDomain(null, permissions)};
        NOPERMS_ACC = new AccessControlContext(protectionDomainArray);
        defaultSocketFactory = RMISocketFactory.getDefaultSocketFactory();
        connectionReadTimeout = AccessController.doPrivileged(new GetIntegerAction("sun.rmi.transport.tcp.readTimeout", 0x6DDD00));
    }

    private class ConnectionHandler
    implements Runnable {
        private static final int POST = 1347375956;
        private AccessControlContext okContext;
        private Map<AccessControlContext, Reference<AccessControlContext>> authCache;
        private SecurityManager cacheSecurityManager = null;
        private Socket socket;
        private String remoteHost;

        ConnectionHandler(Socket socket, String string) {
            this.socket = socket;
            this.remoteHost = string;
        }

        String getClientHost() {
            return this.remoteHost;
        }

        void checkAcceptPermission(SecurityManager securityManager, AccessControlContext accessControlContext) {
            if (securityManager != this.cacheSecurityManager) {
                this.okContext = null;
                this.authCache = new WeakHashMap<AccessControlContext, Reference<AccessControlContext>>();
                this.cacheSecurityManager = securityManager;
            }
            if (accessControlContext.equals(this.okContext) || this.authCache.containsKey(accessControlContext)) {
                return;
            }
            InetAddress inetAddress = this.socket.getInetAddress();
            String string = inetAddress != null ? inetAddress.getHostAddress() : "*";
            securityManager.checkAccept(string, this.socket.getPort());
            this.authCache.put(accessControlContext, new SoftReference<AccessControlContext>(accessControlContext));
            this.okContext = accessControlContext;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Thread thread = Thread.currentThread();
            String string = thread.getName();
            try {
                thread.setName("RMI TCP Connection(" + connectionCount.incrementAndGet() + ")-" + this.remoteHost);
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ConnectionHandler.this.run0();
                        return null;
                    }
                }, NOPERMS_ACC);
            }
            finally {
                thread.setName(string);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void run0() {
            TCPEndpoint tCPEndpoint = TCPTransport.this.getEndpoint();
            int n = tCPEndpoint.getPort();
            threadConnectionHandler.set(this);
            try {
                this.socket.setTcpNoDelay(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (connectionReadTimeout > 0) {
                    this.socket.setSoTimeout(connectionReadTimeout);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                InputStream inputStream = this.socket.getInputStream();
                InputStream inputStream2 = inputStream.markSupported() ? inputStream : new BufferedInputStream(inputStream);
                inputStream2.mark(4);
                DataInputStream dataInputStream = new DataInputStream(inputStream2);
                int n2 = dataInputStream.readInt();
                if (n2 == 1347375956) {
                    System.err.println("DISABLED: " + disableIncomingHttp);
                    if (disableIncomingHttp) {
                        throw new RemoteException("RMI over HTTP is disabled");
                    }
                    tcpLog.log(Log.BRIEF, "decoding HTTP-wrapped call");
                    inputStream2.reset();
                    try {
                        this.socket = new HttpReceiveSocket(this.socket, inputStream2, null);
                        this.remoteHost = "0.0.0.0";
                        inputStream = this.socket.getInputStream();
                        inputStream2 = new BufferedInputStream(inputStream);
                        dataInputStream = new DataInputStream(inputStream2);
                        n2 = dataInputStream.readInt();
                    }
                    catch (IOException iOException) {
                        throw new RemoteException("Error HTTP-unwrapping call", iOException);
                    }
                }
                short s = dataInputStream.readShort();
                if (n2 != 1246907721 || s != 2) {
                    TCPTransport.closeSocket(this.socket);
                    return;
                }
                OutputStream outputStream = this.socket.getOutputStream();
                BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(outputStream);
                DataOutputStream dataOutputStream = new DataOutputStream(bufferedOutputStream);
                int n3 = this.socket.getPort();
                if (tcpLog.isLoggable(Log.BRIEF)) {
                    tcpLog.log(Log.BRIEF, "accepted socket from [" + this.remoteHost + ":" + n3 + "]");
                }
                byte by = dataInputStream.readByte();
                switch (by) {
                    case 76: {
                        TCPEndpoint tCPEndpoint2 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), tCPEndpoint.getClientSocketFactory(), tCPEndpoint.getServerSocketFactory());
                        TCPChannel tCPChannel = new TCPChannel(TCPTransport.this, tCPEndpoint2);
                        TCPConnection tCPConnection = new TCPConnection(tCPChannel, this.socket, inputStream2, bufferedOutputStream);
                        TCPTransport.this.handleMessages(tCPConnection, false);
                        return;
                    }
                    case 75: {
                        dataOutputStream.writeByte(78);
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") " + "suggesting " + this.remoteHost + ":" + n3);
                        }
                        dataOutputStream.writeUTF(this.remoteHost);
                        dataOutputStream.writeInt(n3);
                        dataOutputStream.flush();
                        String string = dataInputStream.readUTF();
                        int n4 = dataInputStream.readInt();
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") client using " + string + ":" + n4);
                        }
                        TCPEndpoint tCPEndpoint3 = new TCPEndpoint(this.remoteHost, this.socket.getLocalPort(), tCPEndpoint.getClientSocketFactory(), tCPEndpoint.getServerSocketFactory());
                        TCPChannel tCPChannel = new TCPChannel(TCPTransport.this, tCPEndpoint3);
                        TCPConnection tCPConnection = new TCPConnection(tCPChannel, this.socket, inputStream2, bufferedOutputStream);
                        TCPTransport.this.handleMessages(tCPConnection, true);
                        return;
                    }
                    case 77: {
                        ConnectionMultiplexer connectionMultiplexer;
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") accepting multiplex protocol");
                        }
                        dataOutputStream.writeByte(78);
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") suggesting " + this.remoteHost + ":" + n3);
                        }
                        dataOutputStream.writeUTF(this.remoteHost);
                        dataOutputStream.writeInt(n3);
                        dataOutputStream.flush();
                        TCPEndpoint tCPEndpoint4 = new TCPEndpoint(dataInputStream.readUTF(), dataInputStream.readInt(), tCPEndpoint.getClientSocketFactory(), tCPEndpoint.getServerSocketFactory());
                        if (tcpLog.isLoggable(Log.VERBOSE)) {
                            tcpLog.log(Log.VERBOSE, "(port " + n + ") client using " + tCPEndpoint4.getHost() + ":" + tCPEndpoint4.getPort());
                        }
                        Map map = TCPTransport.this.channelTable;
                        synchronized (map) {
                            TCPChannel tCPChannel = TCPTransport.this.getChannel(tCPEndpoint4);
                            connectionMultiplexer = new ConnectionMultiplexer(tCPChannel, inputStream2, outputStream, false);
                            tCPChannel.useMultiplexer(connectionMultiplexer);
                        }
                        connectionMultiplexer.run();
                        return;
                    }
                    default: {
                        dataOutputStream.writeByte(79);
                        dataOutputStream.flush();
                        return;
                    }
                }
            }
            catch (IOException iOException) {
                tcpLog.log(Log.BRIEF, "terminated with exception:", iOException);
                return;
            }
            finally {
                TCPTransport.closeSocket(this.socket);
            }
        }
    }

    private class AcceptLoop
    implements Runnable {
        private final ServerSocket serverSocket;
        private long lastExceptionTime = 0L;
        private int recentExceptionCount;

        AcceptLoop(ServerSocket serverSocket) {
            this.serverSocket = serverSocket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.executeAcceptLoop();
            }
            finally {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {}
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void executeAcceptLoop() {
            if (tcpLog.isLoggable(Log.BRIEF)) {
                tcpLog.log(Log.BRIEF, "listening on port " + TCPTransport.this.getEndpoint().getPort());
            }
            while (true) {
                Socket socket = null;
                try {
                    socket = this.serverSocket.accept();
                    InetAddress inetAddress = socket.getInetAddress();
                    String string = inetAddress != null ? inetAddress.getHostAddress() : "0.0.0.0";
                    try {
                        connectionThreadPool.execute(new ConnectionHandler(socket, string));
                    }
                    catch (RejectedExecutionException rejectedExecutionException) {
                        TCPTransport.closeSocket(socket);
                        tcpLog.log(Log.BRIEF, "rejected connection from " + string);
                    }
                    continue;
                }
                catch (Throwable throwable) {
                    try {
                        if (this.serverSocket.isClosed()) return;
                        try {
                            if (tcpLog.isLoggable(Level.WARNING)) {
                                tcpLog.log(Level.WARNING, "accept loop for " + this.serverSocket + " throws", throwable);
                            }
                        }
                        catch (Throwable throwable2) {
                            // empty catch block
                        }
                    }
                    finally {
                        if (socket != null) {
                            TCPTransport.closeSocket(socket);
                        }
                    }
                    if (!(throwable instanceof SecurityException)) {
                        try {
                            TCPEndpoint.shedConnectionCaches();
                        }
                        catch (Throwable throwable3) {
                            // empty catch block
                        }
                    }
                    if (!(throwable instanceof Exception) && !(throwable instanceof OutOfMemoryError) && !(throwable instanceof NoClassDefFoundError)) throw (Error)throwable;
                    if (!this.continueAfterAcceptFailure(throwable)) return;
                    continue;
                }
                break;
            }
        }

        private boolean continueAfterAcceptFailure(Throwable throwable) {
            RMIFailureHandler rMIFailureHandler = RMISocketFactory.getFailureHandler();
            if (rMIFailureHandler != null) {
                return rMIFailureHandler.failure(throwable instanceof Exception ? (Exception)throwable : new InvocationTargetException(throwable));
            }
            this.throttleLoopOnException();
            return true;
        }

        private void throttleLoopOnException() {
            long l = System.currentTimeMillis();
            if (this.lastExceptionTime == 0L || l - this.lastExceptionTime > 5000L) {
                this.lastExceptionTime = l;
                this.recentExceptionCount = 0;
            } else if (++this.recentExceptionCount >= 10) {
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }
}

