/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.security.action.GetPropertyAction;
import sun.security.krb5.Credentials;
import sun.security.krb5.KdcComm;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.Krb5;
import sun.security.krb5.internal.crypto.EType;
import sun.security.krb5.internal.ktab.KeyTab;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Config {
    private static Config singleton = null;
    private Hashtable<String, Object> stanzaTable;
    private static boolean DEBUG = Krb5.DEBUG;
    private static final int BASE16_0 = 1;
    private static final int BASE16_1 = 16;
    private static final int BASE16_2 = 256;
    private static final int BASE16_3 = 4096;
    private final String defaultRealm;
    private final String defaultKDC;

    private static native String getWindowsDirectory();

    public static synchronized Config getInstance() throws KrbException {
        if (singleton == null) {
            singleton = new Config();
        }
        return singleton;
    }

    public static synchronized void refresh() throws KrbException {
        singleton = new Config();
        KeyTab.refresh();
        KdcComm.initStatic();
    }

    private Config() throws KrbException {
        String string = AccessController.doPrivileged(new GetPropertyAction("java.security.krb5.kdc"));
        this.defaultKDC = string != null ? string.replace(':', ' ') : null;
        this.defaultRealm = AccessController.doPrivileged(new GetPropertyAction("java.security.krb5.realm"));
        if (this.defaultKDC == null && this.defaultRealm != null || this.defaultRealm == null && this.defaultKDC != null) {
            throw new KrbException("System property java.security.krb5.kdc and java.security.krb5.realm both must be set or neither must be set.");
        }
        try {
            Vector<String> vector = this.loadConfigFile();
            this.stanzaTable = this.parseStanzaTable(vector);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public int getDefaultIntValue(String string) {
        String string2 = null;
        int n = Integer.MIN_VALUE;
        string2 = this.getDefault(string);
        if (string2 != null) {
            try {
                n = this.parseIntValue(string2);
            }
            catch (NumberFormatException numberFormatException) {
                if (DEBUG) {
                    System.out.println("Exception in getting value of " + string + " " + numberFormatException.getMessage());
                    System.out.println("Setting " + string + " to minimum value");
                }
                n = Integer.MIN_VALUE;
            }
        }
        return n;
    }

    public int getDefaultIntValue(String string, String string2) {
        String string3 = null;
        int n = Integer.MIN_VALUE;
        string3 = this.getDefault(string, string2);
        if (string3 != null) {
            try {
                n = this.parseIntValue(string3);
            }
            catch (NumberFormatException numberFormatException) {
                if (DEBUG) {
                    System.out.println("Exception in getting value of " + string + " in section " + string2 + " " + numberFormatException.getMessage());
                    System.out.println("Setting " + string + " to minimum value");
                }
                n = Integer.MIN_VALUE;
            }
        }
        return n;
    }

    public String getDefault(String string) {
        if (this.stanzaTable == null) {
            return null;
        }
        return this.getDefault(string, this.stanzaTable);
    }

    private String getDefault(String string, Hashtable<String, Object> hashtable) {
        String string2 = null;
        if (this.stanzaTable != null) {
            Enumeration<String> enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string3 = enumeration.nextElement();
                Object object = hashtable.get(string3);
                if (object instanceof Hashtable) {
                    Hashtable hashtable2 = (Hashtable)object;
                    string2 = this.getDefault(string, hashtable2);
                    if (string2 == null) continue;
                    return string2;
                }
                if (!string3.equalsIgnoreCase(string)) continue;
                if (object instanceof String) {
                    return (String)hashtable.get(string3);
                }
                if (!(object instanceof Vector)) continue;
                string2 = "";
                int n = ((Vector)object).size();
                for (int i = 0; i < n; ++i) {
                    string2 = i == n - 1 ? string2 + (String)((Vector)object).elementAt(i) : string2 + (String)((Vector)object).elementAt(i) + " ";
                }
                return string2;
            }
        }
        return string2;
    }

    public String getDefault(String string, String string2) {
        String string3 = null;
        if (this.stanzaTable != null) {
            Enumeration<String> enumeration = this.stanzaTable.keys();
            while (enumeration.hasMoreElements()) {
                Hashtable hashtable;
                Object v;
                String string4 = enumeration.nextElement();
                Hashtable hashtable2 = (Hashtable)this.stanzaTable.get(string4);
                if (string4.equalsIgnoreCase(string2)) {
                    if (!hashtable2.containsKey(string)) continue;
                    return (String)hashtable2.get(string);
                }
                if (!hashtable2.containsKey(string2) || !((v = hashtable2.get(string2)) instanceof Hashtable) || !(hashtable = (Hashtable)v).containsKey(string)) continue;
                Object v2 = hashtable.get(string);
                if (v2 instanceof Vector) {
                    string3 = "";
                    int n = ((Vector)v2).size();
                    for (int i = 0; i < n; ++i) {
                        string3 = i == n - 1 ? string3 + (String)((Vector)v2).elementAt(i) : string3 + (String)((Vector)v2).elementAt(i) + " ";
                    }
                    continue;
                }
                string3 = (String)v2;
            }
        }
        return string3;
    }

    public boolean getDefaultBooleanValue(String string) {
        String string2 = null;
        string2 = this.stanzaTable == null ? null : this.getDefault(string, this.stanzaTable);
        return string2 != null && string2.equalsIgnoreCase("true");
    }

    public boolean getDefaultBooleanValue(String string, String string2) {
        String string3 = this.getDefault(string, string2);
        return string3 != null && string3.equalsIgnoreCase("true");
    }

    private int parseIntValue(String string) throws NumberFormatException {
        int n = 0;
        if (string.startsWith("+")) {
            String string2 = string.substring(1);
            return Integer.parseInt(string2);
        }
        if (string.startsWith("0x")) {
            String string3 = string.substring(2);
            char[] cArray = string3.toCharArray();
            if (cArray.length > 8) {
                throw new NumberFormatException();
            }
            block18: for (int i = 0; i < cArray.length; ++i) {
                int n2 = cArray.length - i - 1;
                switch (cArray[i]) {
                    case '0': {
                        n += 0;
                        continue block18;
                    }
                    case '1': {
                        n += 1 * this.getBase(n2);
                        continue block18;
                    }
                    case '2': {
                        n += 2 * this.getBase(n2);
                        continue block18;
                    }
                    case '3': {
                        n += 3 * this.getBase(n2);
                        continue block18;
                    }
                    case '4': {
                        n += 4 * this.getBase(n2);
                        continue block18;
                    }
                    case '5': {
                        n += 5 * this.getBase(n2);
                        continue block18;
                    }
                    case '6': {
                        n += 6 * this.getBase(n2);
                        continue block18;
                    }
                    case '7': {
                        n += 7 * this.getBase(n2);
                        continue block18;
                    }
                    case '8': {
                        n += 8 * this.getBase(n2);
                        continue block18;
                    }
                    case '9': {
                        n += 9 * this.getBase(n2);
                        continue block18;
                    }
                    case 'A': 
                    case 'a': {
                        n += 10 * this.getBase(n2);
                        continue block18;
                    }
                    case 'B': 
                    case 'b': {
                        n += 11 * this.getBase(n2);
                        continue block18;
                    }
                    case 'C': 
                    case 'c': {
                        n += 12 * this.getBase(n2);
                        continue block18;
                    }
                    case 'D': 
                    case 'd': {
                        n += 13 * this.getBase(n2);
                        continue block18;
                    }
                    case 'E': 
                    case 'e': {
                        n += 14 * this.getBase(n2);
                        continue block18;
                    }
                    case 'F': 
                    case 'f': {
                        n += 15 * this.getBase(n2);
                        continue block18;
                    }
                    default: {
                        throw new NumberFormatException("Invalid numerical format");
                    }
                }
            }
            if (n < 0) {
                throw new NumberFormatException("Data overflow.");
            }
        } else {
            n = Integer.parseInt(string);
        }
        return n;
    }

    private int getBase(int n) {
        int n2 = 16;
        switch (n) {
            case 0: {
                n2 = 1;
                break;
            }
            case 1: {
                n2 = 16;
                break;
            }
            case 2: {
                n2 = 256;
                break;
            }
            case 3: {
                n2 = 4096;
                break;
            }
            default: {
                for (int i = 1; i < n; ++i) {
                    n2 *= 16;
                }
            }
        }
        return n2;
    }

    private String find(String string, String string2) {
        String string3;
        if (this.stanzaTable != null && (string3 = (String)((Hashtable)this.stanzaTable.get(string)).get(string2)) != null) {
            return string3;
        }
        return "";
    }

    private Vector<String> loadConfigFile() throws IOException {
        try {
            final String string = this.getFileName();
            if (!string.equals("")) {
                String string2;
                BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(AccessController.doPrivileged(new PrivilegedExceptionAction<FileInputStream>(){

                    @Override
                    public FileInputStream run() throws IOException {
                        return new FileInputStream(string);
                    }
                })));
                Vector<String> vector = new Vector<String>();
                String string3 = null;
                while ((string2 = bufferedReader.readLine()) != null) {
                    if (string2.startsWith("#") || string2.trim().isEmpty()) continue;
                    String string4 = string2.trim();
                    if (string4.equals("{")) {
                        if (string3 == null) {
                            throw new IOException("Config file should not start with \"{\"");
                        }
                        string3 = string3 + " " + string4;
                        continue;
                    }
                    if (string3 != null) {
                        vector.addElement(string3);
                    }
                    string3 = string4;
                }
                if (string3 != null) {
                    vector.addElement(string3);
                }
                bufferedReader.close();
                return vector;
            }
            return null;
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw (IOException)privilegedActionException.getException();
        }
    }

    private Hashtable<String, Object> parseStanzaTable(Vector<String> vector) throws KrbException {
        if (vector == null) {
            throw new KrbException("I/O error while reading configuration file.");
        }
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        block0: for (int i = 0; i < vector.size(); ++i) {
            String string = vector.elementAt(i).trim();
            if (string.equalsIgnoreCase("[realms]")) {
                for (int j = i + 1; j < vector.size() + 1; ++j) {
                    if (j != vector.size() && !vector.elementAt(j).startsWith("[")) continue;
                    Hashtable<Object, Object> hashtable2 = new Hashtable();
                    hashtable2 = this.parseRealmField(vector, i + 1, j);
                    hashtable.put("realms", hashtable2);
                    i = j - 1;
                    continue block0;
                }
                continue;
            }
            if (string.equalsIgnoreCase("[capaths]")) {
                for (int j = i + 1; j < vector.size() + 1; ++j) {
                    if (j != vector.size() && !vector.elementAt(j).startsWith("[")) continue;
                    Hashtable<Object, Object> hashtable3 = new Hashtable();
                    hashtable3 = this.parseRealmField(vector, i + 1, j);
                    hashtable.put("capaths", hashtable3);
                    i = j - 1;
                    continue block0;
                }
                continue;
            }
            if (!string.startsWith("[") || !string.endsWith("]")) continue;
            String string2 = string.substring(1, string.length() - 1);
            for (int j = i + 1; j < vector.size() + 1; ++j) {
                if (j != vector.size() && !vector.elementAt(j).startsWith("[")) continue;
                Hashtable<String, String> hashtable4 = this.parseField(vector, i + 1, j);
                hashtable.put(string2, hashtable4);
                i = j - 1;
                continue block0;
            }
        }
        return hashtable;
    }

    private String getFileName() {
        String string = AccessController.doPrivileged(new GetPropertyAction("java.security.krb5.conf"));
        if (string != null) {
            boolean bl = AccessController.doPrivileged(new FileExistsAction(string));
            if (bl) {
                return string;
            }
        } else {
            string = AccessController.doPrivileged(new GetPropertyAction("java.home")) + File.separator + "lib" + File.separator + "security" + File.separator + "krb5.conf";
            boolean bl = AccessController.doPrivileged(new FileExistsAction(string));
            if (bl) {
                return string;
            }
            String string2 = AccessController.doPrivileged(new GetPropertyAction("os.name"));
            if (string2.startsWith("Windows")) {
                try {
                    Credentials.ensureLoaded();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string = Credentials.alreadyLoaded ? ((string = Config.getWindowsDirectory()) == null ? "c:\\winnt\\krb5.ini" : (string.endsWith("\\") ? string + "krb5.ini" : string + "\\krb5.ini")) : "c:\\winnt\\krb5.ini";
            } else if (string2.startsWith("SunOS")) {
                string = "/etc/krb5/krb5.conf";
            } else if (string2.startsWith("Linux")) {
                string = "/etc/krb5.conf";
            }
        }
        if (DEBUG) {
            System.out.println("Config name: " + string);
        }
        return string;
    }

    private Hashtable<String, String> parseField(Vector<String> vector, int n, int n2) {
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        block0: for (int i = n; i < n2; ++i) {
            String string = vector.elementAt(i);
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) != '=') continue;
                String string2 = string.substring(0, j).trim();
                String string3 = string.substring(j + 1).trim();
                hashtable.put(string2, string3);
                continue block0;
            }
        }
        return hashtable;
    }

    private Hashtable<String, Hashtable<String, Vector<String>>> parseRealmField(Vector<String> vector, int n, int n2) {
        Hashtable<String, Hashtable<String, Vector<String>>> hashtable = new Hashtable<String, Hashtable<String, Vector<String>>>();
        block0: for (int i = n; i < n2; ++i) {
            int n3;
            String string = vector.elementAt(i).trim();
            if (!string.endsWith("{")) continue;
            String string2 = "";
            for (n3 = 0; n3 < string.length(); ++n3) {
                if (string.charAt(n3) != '=') continue;
                string2 = string.substring(0, n3).trim();
                break;
            }
            for (n3 = i + 1; n3 < n2; ++n3) {
                boolean bl = false;
                string = vector.elementAt(n3).trim();
                for (int j = 0; j < string.length(); ++j) {
                    if (string.charAt(j) != '}') continue;
                    bl = true;
                    break;
                }
                if (!bl) continue;
                Hashtable<String, Vector<String>> hashtable2 = this.parseRealmFieldEx(vector, i + 1, n3);
                hashtable.put(string2, hashtable2);
                i = n3;
                bl = false;
                continue block0;
            }
        }
        return hashtable;
    }

    private Hashtable<String, Vector<String>> parseRealmFieldEx(Vector<String> vector, int n, int n2) {
        Hashtable<String, Vector<String>> hashtable = new Hashtable<String, Vector<String>>();
        Vector<String> vector2 = new Vector<String>();
        Vector<Object> vector3 = new Vector();
        String string = "";
        block0: for (int i = n; i < n2; ++i) {
            string = vector.elementAt(i);
            for (int j = 0; j < string.length(); ++j) {
                if (string.charAt(j) != '=') continue;
                String string2 = string.substring(0, j - 1).trim();
                if (!this.exists(string2, vector2)) {
                    vector2.addElement(string2);
                    vector3 = new Vector();
                } else {
                    vector3 = hashtable.get(string2);
                }
                vector3.addElement(string.substring(j + 1).trim());
                hashtable.put(string2, vector3);
                continue block0;
            }
        }
        return hashtable;
    }

    private boolean exists(String string, Vector<String> vector) {
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            if (!vector.elementAt(i).equals(string)) continue;
            bl = true;
        }
        return bl;
    }

    public void listTable() {
        this.listTable(this.stanzaTable);
    }

    private void listTable(Hashtable<String, Object> hashtable) {
        Vector vector = new Vector();
        if (this.stanzaTable != null) {
            Enumeration<String> enumeration = hashtable.keys();
            while (enumeration.hasMoreElements()) {
                String string = enumeration.nextElement();
                Object object = hashtable.get(string);
                if (hashtable == this.stanzaTable) {
                    System.out.println("[" + string + "]");
                }
                if (object instanceof Hashtable) {
                    if (hashtable != this.stanzaTable) {
                        System.out.println("\t" + string + " = {");
                    }
                    this.listTable((Hashtable)object);
                    if (hashtable == this.stanzaTable) continue;
                    System.out.println("\t}");
                    continue;
                }
                if (object instanceof String) {
                    System.out.println("\t" + string + " = " + (String)hashtable.get(string));
                    continue;
                }
                if (!(object instanceof Vector)) continue;
                vector = (Vector)object;
                for (int i = 0; i < vector.size(); ++i) {
                    System.out.println("\t" + string + " = " + (String)vector.elementAt(i));
                }
            }
        } else {
            System.out.println("Configuration file not found.");
        }
    }

    public int[] defaultEtype(String string) {
        int n;
        int[] nArray;
        String string2 = this.getDefault(string, "libdefaults");
        String string3 = " ";
        if (string2 == null) {
            if (DEBUG) {
                System.out.println("Using builtin default etypes for " + string);
            }
            nArray = EType.getBuiltInDefaults();
        } else {
            int n2;
            for (n = 0; n < string2.length(); ++n) {
                if (!string2.substring(n, n + 1).equals(",")) continue;
                string3 = ",";
                break;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, string3);
            n = stringTokenizer.countTokens();
            ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
            for (n2 = 0; n2 < n; ++n2) {
                int n3 = this.getType(stringTokenizer.nextToken());
                if (n3 == -1 || !EType.isSupported(n3)) continue;
                arrayList.add(n3);
            }
            if (arrayList.isEmpty()) {
                if (DEBUG) {
                    System.out.println("no supported default etypes for " + string);
                }
                return null;
            }
            nArray = new int[arrayList.size()];
            for (n2 = 0; n2 < nArray.length; ++n2) {
                nArray[n2] = (Integer)arrayList.get(n2);
            }
        }
        if (DEBUG) {
            System.out.print("default etypes for " + string + ":");
            for (n = 0; n < nArray.length; ++n) {
                System.out.print(" " + nArray[n]);
            }
            System.out.println(".");
        }
        return nArray;
    }

    public int getType(String string) {
        int n = -1;
        if (string == null) {
            return n;
        }
        if (string.startsWith("d") || string.startsWith("D")) {
            if (string.equalsIgnoreCase("des-cbc-crc")) {
                n = 1;
            } else if (string.equalsIgnoreCase("des-cbc-md5")) {
                n = 3;
            } else if (string.equalsIgnoreCase("des-mac")) {
                n = 4;
            } else if (string.equalsIgnoreCase("des-mac-k")) {
                n = 5;
            } else if (string.equalsIgnoreCase("des-cbc-md4")) {
                n = 2;
            } else if (string.equalsIgnoreCase("des3-cbc-sha1") || string.equalsIgnoreCase("des3-hmac-sha1") || string.equalsIgnoreCase("des3-cbc-sha1-kd") || string.equalsIgnoreCase("des3-cbc-hmac-sha1-kd")) {
                n = 16;
            }
        } else if (string.startsWith("a") || string.startsWith("A")) {
            if (string.equalsIgnoreCase("aes128-cts") || string.equalsIgnoreCase("aes128-cts-hmac-sha1-96")) {
                n = 17;
            } else if (string.equalsIgnoreCase("aes256-cts") || string.equalsIgnoreCase("aes256-cts-hmac-sha1-96")) {
                n = 18;
            } else if (string.equalsIgnoreCase("arcfour-hmac") || string.equalsIgnoreCase("arcfour-hmac-md5")) {
                n = 23;
            }
        } else if (string.equalsIgnoreCase("rc4-hmac")) {
            n = 23;
        } else if (string.equalsIgnoreCase("CRC32")) {
            n = 1;
        } else if (string.startsWith("r") || string.startsWith("R")) {
            if (string.equalsIgnoreCase("rsa-md5")) {
                n = 7;
            } else if (string.equalsIgnoreCase("rsa-md5-des")) {
                n = 8;
            }
        } else if (string.equalsIgnoreCase("hmac-sha1-des3-kd")) {
            n = 12;
        } else if (string.equalsIgnoreCase("hmac-sha1-96-aes128")) {
            n = 15;
        } else if (string.equalsIgnoreCase("hmac-sha1-96-aes256")) {
            n = 16;
        } else if (string.equalsIgnoreCase("hmac-md5-rc4") || string.equalsIgnoreCase("hmac-md5-arcfour") || string.equalsIgnoreCase("hmac-md5-enc")) {
            n = -138;
        } else if (string.equalsIgnoreCase("NULL")) {
            n = 0;
        }
        return n;
    }

    public void resetDefaultRealm(String string) {
        if (DEBUG) {
            System.out.println(">>> Config try resetting default kdc " + string);
        }
    }

    public boolean useAddresses() {
        boolean bl = false;
        String string = this.getDefault("no_addresses", "libdefaults");
        boolean bl2 = bl = string != null && string.equalsIgnoreCase("false");
        if (!bl) {
            string = this.getDefault("noaddresses", "libdefaults");
            bl = string != null && string.equalsIgnoreCase("false");
        }
        return bl;
    }

    public String getDefaultRealm() throws KrbException {
        if (this.defaultRealm != null) {
            return this.defaultRealm;
        }
        Throwable throwable = null;
        String string = this.getDefault("default_realm", "libdefaults");
        if (string == null) {
            string = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String string = System.getProperty("os.name");
                    if (string.startsWith("Windows")) {
                        return System.getenv("USERDNSDOMAIN");
                    }
                    return null;
                }
            });
        }
        if (string == null) {
            KrbException krbException = new KrbException("Cannot locate default realm");
            if (throwable != null) {
                krbException.initCause(throwable);
            }
            throw krbException;
        }
        return string;
    }

    public String getKDCList(String string) throws KrbException {
        if (string == null) {
            string = this.getDefaultRealm();
        }
        if (string.equalsIgnoreCase(this.defaultRealm)) {
            return this.defaultKDC;
        }
        Throwable throwable = null;
        String string2 = this.getDefault("kdc", string);
        if (string2 == null) {
            string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

                @Override
                public String run() {
                    String string = System.getProperty("os.name");
                    if (string.startsWith("Windows")) {
                        String string2 = System.getenv("LOGONSERVER");
                        if (string2 != null && string2.startsWith("\\\\")) {
                            string2 = string2.substring(2);
                        }
                        return string2;
                    }
                    return null;
                }
            });
        }
        if (string2 == null) {
            if (this.defaultKDC != null) {
                return this.defaultKDC;
            }
            KrbException krbException = new KrbException("Cannot locate KDC");
            if (throwable != null) {
                krbException.initCause(throwable);
            }
            throw krbException;
        }
        return string2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FileExistsAction
    implements PrivilegedAction<Boolean> {
        private String fileName;

        public FileExistsAction(String string) {
            this.fileName = string;
        }

        @Override
        public Boolean run() {
            return new File(this.fileName).exists();
        }
    }
}

