/*
 * Decompiled with CFR 0.152.
 */
package sun.security.krb5.internal;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import sun.security.krb5.Asn1Exception;
import sun.security.krb5.Config;
import sun.security.krb5.KrbException;
import sun.security.krb5.internal.Krb5;
import sun.security.util.DerInputStream;
import sun.security.util.DerOutputStream;
import sun.security.util.DerValue;

public class KerberosTime
implements Cloneable {
    private long kerberosTime;
    private static long syncTime;
    private static boolean DEBUG;
    public static final boolean NOW = true;
    public static final boolean UNADJUSTED_NOW = false;

    public KerberosTime(long l) {
        this.kerberosTime = l;
    }

    public Object clone() {
        return new KerberosTime(this.kerberosTime);
    }

    public KerberosTime(String string) throws Asn1Exception {
        this.kerberosTime = KerberosTime.toKerberosTime(string);
    }

    public KerberosTime(DerValue derValue) throws Asn1Exception, IOException {
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        Date date = derValue.getGeneralizedTime();
        this.kerberosTime = date.getTime();
    }

    private static long toKerberosTime(String string) throws Asn1Exception {
        if (string.length() != 15) {
            throw new Asn1Exception(900);
        }
        if (string.charAt(14) != 'Z') {
            throw new Asn1Exception(900);
        }
        int n = Integer.parseInt(string.substring(0, 4));
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.set(n, Integer.parseInt(string.substring(4, 6)) - 1, Integer.parseInt(string.substring(6, 8)), Integer.parseInt(string.substring(8, 10)), Integer.parseInt(string.substring(10, 12)), Integer.parseInt(string.substring(12, 14)));
        return calendar.getTime().getTime();
    }

    public static String zeroPad(String string, int n) {
        StringBuffer stringBuffer = new StringBuffer(string);
        while (stringBuffer.length() < n) {
            stringBuffer.insert(0, '0');
        }
        return stringBuffer.toString();
    }

    public KerberosTime(Date date) {
        this.kerberosTime = date.getTime();
    }

    public KerberosTime(boolean bl) {
        if (bl) {
            Date date = new Date();
            this.setTime(date);
        } else {
            this.kerberosTime = 0L;
        }
    }

    public String toGeneralizedTimeString() {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        calendar.clear();
        calendar.setTimeInMillis(this.kerberosTime);
        return KerberosTime.zeroPad(Integer.toString(calendar.get(1)), 4) + KerberosTime.zeroPad(Integer.toString(calendar.get(2) + 1), 2) + KerberosTime.zeroPad(Integer.toString(calendar.get(5)), 2) + KerberosTime.zeroPad(Integer.toString(calendar.get(11)), 2) + KerberosTime.zeroPad(Integer.toString(calendar.get(12)), 2) + KerberosTime.zeroPad(Integer.toString(calendar.get(13)), 2) + 'Z';
    }

    public byte[] asn1Encode() throws Asn1Exception, IOException {
        DerOutputStream derOutputStream = new DerOutputStream();
        derOutputStream.putGeneralizedTime(this.toDate());
        return derOutputStream.toByteArray();
    }

    public long getTime() {
        return this.kerberosTime;
    }

    public void setTime(Date date) {
        this.kerberosTime = date.getTime();
    }

    public void setTime(long l) {
        this.kerberosTime = l;
    }

    public Date toDate() {
        Date date = new Date(this.kerberosTime);
        date.setTime(date.getTime());
        return date;
    }

    public void setNow() {
        Date date = new Date();
        this.setTime(date);
    }

    public int getMicroSeconds() {
        Long l = new Long(this.kerberosTime % 1000L * 1000L);
        return l.intValue();
    }

    public void setMicroSeconds(int n) {
        Integer n2 = new Integer(n);
        long l = n2.longValue() / 1000L;
        this.kerberosTime = this.kerberosTime - this.kerberosTime % 1000L + l;
    }

    public void setMicroSeconds(Integer n) {
        if (n != null) {
            long l = n.longValue() / 1000L;
            this.kerberosTime = this.kerberosTime - this.kerberosTime % 1000L + l;
        }
    }

    public boolean inClockSkew(int n) {
        KerberosTime kerberosTime = new KerberosTime(true);
        return Math.abs(this.kerberosTime - kerberosTime.kerberosTime) <= (long)n * 1000L;
    }

    public boolean inClockSkew() {
        return this.inClockSkew(KerberosTime.getDefaultSkew());
    }

    public boolean inClockSkew(int n, KerberosTime kerberosTime) {
        return Math.abs(this.kerberosTime - kerberosTime.kerberosTime) <= (long)n * 1000L;
    }

    public boolean inClockSkew(KerberosTime kerberosTime) {
        return this.inClockSkew(KerberosTime.getDefaultSkew(), kerberosTime);
    }

    public boolean greaterThanWRTClockSkew(KerberosTime kerberosTime, int n) {
        return this.kerberosTime - kerberosTime.kerberosTime > (long)n * 1000L;
    }

    public boolean greaterThanWRTClockSkew(KerberosTime kerberosTime) {
        return this.greaterThanWRTClockSkew(kerberosTime, KerberosTime.getDefaultSkew());
    }

    public boolean greaterThan(KerberosTime kerberosTime) {
        return this.kerberosTime > kerberosTime.kerberosTime;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof KerberosTime)) {
            return false;
        }
        return this.kerberosTime == ((KerberosTime)object).kerberosTime;
    }

    public int hashCode() {
        return 629 + (int)(this.kerberosTime ^ this.kerberosTime >>> 32);
    }

    public boolean isZero() {
        return this.kerberosTime == 0L;
    }

    public int getSeconds() {
        Long l = new Long(this.kerberosTime / 1000L);
        return l.intValue();
    }

    public void setSeconds(int n) {
        Integer n2 = new Integer(n);
        this.kerberosTime = n2.longValue() * 1000L;
    }

    public static KerberosTime parse(DerInputStream derInputStream, byte by, boolean bl) throws Asn1Exception, IOException {
        if (bl && ((byte)derInputStream.peekByte() & 0x1F) != by) {
            return null;
        }
        DerValue derValue = derInputStream.getDerValue();
        if (by != (derValue.getTag() & 0x1F)) {
            throw new Asn1Exception(906);
        }
        DerValue derValue2 = derValue.getData().getDerValue();
        return new KerberosTime(derValue2);
    }

    public static int getDefaultSkew() {
        int n;
        block3: {
            n = 300;
            try {
                Config config = Config.getInstance();
                n = config.getDefaultIntValue("clockskew", "libdefaults");
                if (n == Integer.MIN_VALUE) {
                    n = 300;
                }
            }
            catch (KrbException krbException) {
                if (!DEBUG) break block3;
                System.out.println("Exception in getting clockskew from Configuration using default value " + krbException.getMessage());
            }
        }
        return n;
    }

    public String toString() {
        return this.toGeneralizedTimeString();
    }

    static {
        DEBUG = Krb5.DEBUG;
    }
}

