/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.Date;
import sun.security.util.DerOutputStream;
import sun.security.x509.AuthorityKeyIdentifierExtension;
import sun.security.x509.KeyIdentifier;
import sun.security.x509.SerialNumber;

class AdaptableX509CertSelector
extends X509CertSelector {
    private Date startDate = null;
    private Date endDate = null;

    AdaptableX509CertSelector() {
    }

    void setValidityPeriod(Date date, Date date2) {
        this.startDate = date;
        this.endDate = date2;
    }

    void parseAuthorityKeyIdentifierExtension(AuthorityKeyIdentifierExtension authorityKeyIdentifierExtension) throws IOException {
        if (authorityKeyIdentifierExtension != null) {
            Object object;
            KeyIdentifier keyIdentifier = (KeyIdentifier)authorityKeyIdentifierExtension.get("key_id");
            if (keyIdentifier != null) {
                object = new DerOutputStream();
                ((DerOutputStream)object).putOctetString(keyIdentifier.getIdentifier());
                super.setSubjectKeyIdentifier(((ByteArrayOutputStream)object).toByteArray());
            }
            if ((object = (SerialNumber)authorityKeyIdentifierExtension.get("serial_number")) != null) {
                super.setSerialNumber(((SerialNumber)object).getNumber());
            }
        }
    }

    public boolean match(Certificate certificate) {
        if (!(certificate instanceof X509Certificate)) {
            return false;
        }
        X509Certificate x509Certificate = (X509Certificate)certificate;
        int n = x509Certificate.getVersion();
        if (n < 3) {
            if (this.startDate != null) {
                try {
                    x509Certificate.checkValidity(this.startDate);
                }
                catch (CertificateException certificateException) {
                    return false;
                }
            }
            if (this.endDate != null) {
                try {
                    x509Certificate.checkValidity(this.endDate);
                }
                catch (CertificateException certificateException) {
                    return false;
                }
            }
        }
        if (n < 3 || x509Certificate.getExtensionValue("2.5.29.14") == null) {
            this.setSubjectKeyIdentifier(null);
        }
        return super.match(certificate);
    }

    public Object clone() {
        AdaptableX509CertSelector adaptableX509CertSelector = (AdaptableX509CertSelector)super.clone();
        if (this.startDate != null) {
            adaptableX509CertSelector.startDate = (Date)this.startDate.clone();
        }
        if (this.endDate != null) {
            adaptableX509CertSelector.endDate = (Date)this.endDate.clone();
        }
        return adaptableX509CertSelector;
    }
}

