/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.AccessController;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateParsingException;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.security.auth.x500.X500Principal;
import sun.security.action.GetIntegerAction;
import sun.security.provider.certpath.AlgorithmChecker;
import sun.security.provider.certpath.CertId;
import sun.security.provider.certpath.OCSP;
import sun.security.provider.certpath.ResponderId;
import sun.security.util.Debug;
import sun.security.util.DerInputStream;
import sun.security.util.DerValue;
import sun.security.util.ObjectIdentifier;
import sun.security.x509.AlgorithmId;
import sun.security.x509.Extension;
import sun.security.x509.PKIXExtensions;
import sun.security.x509.X509CertImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class OCSPResponse {
    private static final ResponseStatus[] rsvalues = ResponseStatus.values();
    private static final Debug DEBUG = Debug.getInstance("certpath");
    private static final boolean dump = false;
    private static final ObjectIdentifier OCSP_BASIC_RESPONSE_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 1});
    private static final ObjectIdentifier OCSP_NONCE_EXTENSION_OID = ObjectIdentifier.newInternal(new int[]{1, 3, 6, 1, 5, 5, 7, 48, 1, 2});
    private static final int CERT_STATUS_GOOD = 0;
    private static final int CERT_STATUS_REVOKED = 1;
    private static final int CERT_STATUS_UNKNOWN = 2;
    private static final int NAME_TAG = 1;
    private static final int KEY_TAG = 2;
    private static final String KP_OCSP_SIGNING_OID = "1.3.6.1.5.5.7.3.9";
    private final ResponseStatus responseStatus;
    private final Map<CertId, SingleResponse> singleResponseMap;
    private static final int DEFAULT_MAX_CLOCK_SKEW = 900000;
    private static final int MAX_CLOCK_SKEW = OCSPResponse.initializeClockSkew();
    private final byte[] responseNonce;
    private final ResponderId respId;
    private Date producedAtDate = null;
    private final Map<String, Extension> responseExtensions;

    private static int initializeClockSkew() {
        Integer n = AccessController.doPrivileged(new GetIntegerAction("com.sun.security.ocsp.clockSkew"));
        if (n == null || n < 0) {
            return 900000;
        }
        return n * 1000;
    }

    OCSPResponse(byte[] byArray, Date date, X509Certificate object, String string) throws IOException, CertPathValidatorException {
        Object certificateParsingException;
        Object object2;
        X509CertImpl[] x509CertImplArray;
        DerValue derValue = new DerValue(byArray);
        if (derValue.tag != 48) {
            throw new IOException("Bad encoding in OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derInputStream = derValue.getData();
        int n = derInputStream.getEnumerated();
        if (n < 0 || n >= rsvalues.length) {
            throw new IOException("Unknown OCSPResponse status: " + n);
        }
        this.responseStatus = rsvalues[n];
        if (DEBUG != null) {
            DEBUG.println("OCSP response status: " + (Object)((Object)this.responseStatus));
        }
        if (this.responseStatus != ResponseStatus.SUCCESSFUL) {
            this.singleResponseMap = Collections.emptyMap();
            this.responseNonce = null;
            this.responseExtensions = Collections.emptyMap();
            this.respId = null;
            return;
        }
        derValue = derInputStream.getDerValue();
        if (!derValue.isContextSpecific((byte)0)) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 context specific tag 0.");
        }
        DerValue derValue2 = derValue.data.getDerValue();
        if (derValue2.tag != 48) {
            throw new IOException("Bad encoding in responseBytes element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        derInputStream = derValue2.data;
        ObjectIdentifier objectIdentifier = derInputStream.getOID();
        if (objectIdentifier.equals(OCSP_BASIC_RESPONSE_OID)) {
            if (DEBUG != null) {
                DEBUG.println("OCSP response type: basic");
            }
        } else {
            if (DEBUG != null) {
                DEBUG.println("OCSP response type: " + objectIdentifier);
            }
            throw new IOException("Unsupported OCSP response type: " + objectIdentifier);
        }
        DerInputStream derInputStream2 = new DerInputStream(derInputStream.getOctetString());
        DerValue[] derValueArray = derInputStream2.getSequence(2);
        if (derValueArray.length < 3) {
            throw new IOException("Unexpected BasicOCSPResponse value");
        }
        DerValue derValue3 = derValueArray[0];
        byte[] byArray2 = derValueArray[0].toByteArray();
        if (derValue3.tag != 48) {
            throw new IOException("Bad encoding in tbsResponseData element of OCSP response: expected ASN.1 SEQUENCE tag.");
        }
        DerInputStream derInputStream3 = derValue3.data;
        DerValue derValue4 = derInputStream3.getDerValue();
        if (derValue4.isContextSpecific((byte)0) && derValue4.isConstructed() && derValue4.isContextSpecific()) {
            derValue4 = derValue4.data.getDerValue();
            int n2 = derValue4.getInteger();
            if (derValue4.data.available() != 0) {
                throw new IOException("Bad encoding in version  element of OCSP response: bad format");
            }
            derValue4 = derInputStream3.getDerValue();
        }
        this.respId = new ResponderId(derValue4.toByteArray());
        if (DEBUG != null) {
            DEBUG.println("Responder ID: " + this.respId);
        }
        derValue4 = derInputStream3.getDerValue();
        this.producedAtDate = derValue4.getGeneralizedTime();
        if (DEBUG != null) {
            DEBUG.println("OCSP response produced at: " + this.producedAtDate);
        }
        DerValue[] derValueArray2 = derInputStream3.getSequence(1);
        this.singleResponseMap = new HashMap<CertId, SingleResponse>(derValueArray2.length);
        if (DEBUG != null) {
            DEBUG.println("OCSP number of SingleResponses: " + derValueArray2.length);
        }
        for (DerValue object42 : derValueArray2) {
            x509CertImplArray = new SingleResponse(object42);
            this.singleResponseMap.put(((SingleResponse)x509CertImplArray).getCertId(), (SingleResponse)x509CertImplArray);
        }
        Object object5 = new HashMap();
        if (derInputStream3.available() > 0 && (derValue4 = derInputStream3.getDerValue()).isContextSpecific((byte)1)) {
            object5 = OCSPResponse.parseExtensions(derValue4);
        }
        this.responseExtensions = object5;
        Extension extension = (Extension)object5.get(PKIXExtensions.OCSPNonce_Id.toString());
        byte[] byArray3 = this.responseNonce = extension != null ? extension.getExtensionValue() : null;
        if (DEBUG != null && this.responseNonce != null) {
            DEBUG.println("Response nonce: " + Arrays.toString(this.responseNonce));
        }
        AlgorithmId algorithmId = AlgorithmId.parse(derValueArray[1]);
        byte[] byArray4 = derValueArray[2].getBitString();
        x509CertImplArray = null;
        if (derValueArray.length > 3) {
            object2 = derValueArray[3];
            if (!((DerValue)object2).isContextSpecific((byte)0)) {
                throw new IOException("Bad encoding in certs element of OCSP response: expected ASN.1 context specific tag 0.");
            }
            certificateParsingException = ((DerValue)object2).getData().getSequence(3);
            x509CertImplArray = new X509CertImpl[((DerValue[])certificateParsingException).length];
            try {
                for (int certificateException = 0; certificateException < ((DerValue[])certificateParsingException).length; ++certificateException) {
                    x509CertImplArray[certificateException] = new X509CertImpl(((DerValue)certificateParsingException[certificateException]).toByteArray());
                }
            }
            catch (CertificateException generalSecurityException) {
                throw new IOException("Bad encoding in X509 Certificate", generalSecurityException);
            }
        }
        if (x509CertImplArray != null && x509CertImplArray[0] != null && !((Certificate)(object2 = x509CertImplArray[0])).equals(object) && ((X509Certificate)object2).getIssuerX500Principal().equals(((X509Certificate)object).getSubjectX500Principal())) {
            try {
                certificateParsingException = ((X509Certificate)object2).getExtendedKeyUsage();
                if (certificateParsingException == null || !certificateParsingException.contains(KP_OCSP_SIGNING_OID)) {
                    throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses");
                }
            }
            catch (CertificateParsingException certificateParsingException2) {
                throw new CertPathValidatorException("Responder's certificate not valid for signing OCSP responses", certificateParsingException2);
            }
            certificateParsingException = new AlgorithmChecker(new TrustAnchor((X509Certificate)object, null), string);
            ((AlgorithmChecker)certificateParsingException).init(false);
            ((AlgorithmChecker)certificateParsingException).check((Certificate)object2, Collections.<String>emptySet());
            try {
                ((Certificate)object2).verify(((Certificate)object).getPublicKey());
                object = object2;
            }
            catch (GeneralSecurityException generalSecurityException) {
                object = null;
            }
        }
        if (object != null) {
            AlgorithmChecker.check(((Certificate)object).getPublicKey(), algorithmId, string);
            if (!this.verifyResponse(byArray2, (X509Certificate)object, algorithmId, byArray4)) {
                throw new CertPathValidatorException("Error verifying OCSP Responder's signature");
            }
        } else {
            throw new CertPathValidatorException("Unable to verify OCSP Responder's signature");
        }
    }

    public ResponseStatus getResponseStatus() {
        return this.responseStatus;
    }

    private boolean verifyResponse(byte[] byArray, X509Certificate x509Certificate, AlgorithmId algorithmId, byte[] byArray2) throws CertPathValidatorException {
        try {
            Signature signature = Signature.getInstance(algorithmId.getName());
            signature.initVerify(x509Certificate);
            signature.update(byArray);
            if (signature.verify(byArray2)) {
                if (DEBUG != null) {
                    DEBUG.println("Verified signature of OCSP Responder");
                }
                return true;
            }
            if (DEBUG != null) {
                DEBUG.println("Error verifying signature of OCSP Responder");
            }
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            throw new CertPathValidatorException(invalidKeyException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new CertPathValidatorException(noSuchAlgorithmException);
        }
        catch (SignatureException signatureException) {
            throw new CertPathValidatorException(signatureException);
        }
    }

    public SingleResponse getSingleResponse(CertId certId) {
        return this.singleResponseMap.get(certId);
    }

    public Set<CertId> getCertIds() {
        return Collections.unmodifiableSet(this.singleResponseMap.keySet());
    }

    public ResponderId getResponderId() {
        return this.respId;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("OCSP Response:\n");
        stringBuilder.append("Response Status: ").append((Object)this.responseStatus).append("\n");
        stringBuilder.append("Responder ID: ").append(this.respId).append("\n");
        stringBuilder.append("Produced at: ").append(this.producedAtDate).append("\n");
        int n = this.singleResponseMap.size();
        stringBuilder.append(n).append(n == 1 ? " response:\n" : " responses:\n");
        for (SingleResponse object : this.singleResponseMap.values()) {
            stringBuilder.append(object).append("\n");
        }
        if (this.responseExtensions != null && this.responseExtensions.size() > 0) {
            n = this.responseExtensions.size();
            stringBuilder.append(n).append(n == 1 ? " extension:\n" : " extensions:\n");
            for (String string : this.responseExtensions.keySet()) {
                stringBuilder.append(this.responseExtensions.get(string)).append("\n");
            }
        }
        return stringBuilder.toString();
    }

    private static Map<String, Extension> parseExtensions(DerValue derValue) throws IOException {
        DerValue[] derValueArray = derValue.data.getSequence(3);
        HashMap<String, Extension> hashMap = new HashMap<String, Extension>(derValueArray.length);
        for (DerValue derValue2 : derValueArray) {
            Extension extension = new Extension(derValue2);
            if (DEBUG != null) {
                DEBUG.println("Extension: " + extension);
            }
            if (extension.isCritical()) {
                throw new IOException("Unsupported OCSP critical extension: " + extension.getExtensionId());
            }
            hashMap.put(extension.toString(), extension);
        }
        return hashMap;
    }

    static final class IssuerInfo {
        private final TrustAnchor anchor;
        private final X509Certificate certificate;
        private final X500Principal name;
        private final PublicKey pubKey;

        IssuerInfo(TrustAnchor trustAnchor) {
            this(trustAnchor, trustAnchor != null ? trustAnchor.getTrustedCert() : null);
        }

        IssuerInfo(X509Certificate x509Certificate) {
            this(null, x509Certificate);
        }

        IssuerInfo(TrustAnchor trustAnchor, X509Certificate x509Certificate) {
            if (trustAnchor == null && x509Certificate == null) {
                throw new NullPointerException("TrustAnchor and issuerCert cannot be null");
            }
            this.anchor = trustAnchor;
            if (x509Certificate != null) {
                this.name = x509Certificate.getSubjectX500Principal();
                this.pubKey = x509Certificate.getPublicKey();
                this.certificate = x509Certificate;
            } else {
                this.name = trustAnchor.getCA();
                this.pubKey = trustAnchor.getCAPublicKey();
                this.certificate = trustAnchor.getTrustedCert();
            }
        }

        X509Certificate getCertificate() {
            return this.certificate;
        }

        X500Principal getName() {
            return this.name;
        }

        PublicKey getPublicKey() {
            return this.pubKey;
        }

        TrustAnchor getAnchor() {
            return this.anchor;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Issuer Info:\n");
            stringBuilder.append("Name: ").append(this.name.toString()).append("\n");
            stringBuilder.append("Public Key:\n").append(this.pubKey.toString()).append("\n");
            return stringBuilder.toString();
        }
    }

    public static final class SingleResponse
    implements OCSP.RevocationStatus {
        private final CertId certId;
        private final OCSP.RevocationStatus.CertStatus certStatus;
        private final Date thisUpdate;
        private final Date nextUpdate;
        private final Date revocationTime;
        private static OCSP.RevocationStatus.Reason[] values = OCSP.RevocationStatus.Reason.values();
        private final OCSP.RevocationStatus.Reason revocationReason;

        private SingleResponse(DerValue derValue) throws IOException {
            Object object;
            int n;
            DerValue[] derValueArray;
            if (derValue.tag != 48) {
                throw new IOException("Bad ASN.1 encoding in SingleResponse");
            }
            DerInputStream derInputStream = derValue.data;
            this.certId = new CertId(derInputStream.getDerValue().data);
            DerValue derValue2 = derInputStream.getDerValue();
            short s = (byte)(derValue2.tag & 0x1F);
            if (s == 1) {
                this.certStatus = OCSP.RevocationStatus.CertStatus.REVOKED;
                this.revocationTime = derValue2.data.getGeneralizedTime();
                if (derValue2.data.available() != 0) {
                    derValueArray = derValue2.data.getDerValue();
                    s = (byte)(derValueArray.tag & 0x1F);
                    this.revocationReason = s == 0 ? ((n = derValueArray.data.getEnumerated()) >= 0 && n < values.length ? values[n] : OCSP.RevocationStatus.Reason.UNSPECIFIED) : OCSP.RevocationStatus.Reason.UNSPECIFIED;
                } else {
                    this.revocationReason = OCSP.RevocationStatus.Reason.UNSPECIFIED;
                }
                if (DEBUG != null) {
                    DEBUG.println("Revocation time: " + this.revocationTime);
                    DEBUG.println("Revocation reason: " + (Object)((Object)this.revocationReason));
                }
            } else {
                this.revocationTime = null;
                this.revocationReason = null;
                if (s == 0) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.GOOD;
                } else if (s == 2) {
                    this.certStatus = OCSP.RevocationStatus.CertStatus.UNKNOWN;
                } else {
                    throw new IOException("Invalid certificate status");
                }
            }
            this.thisUpdate = derInputStream.getGeneralizedTime();
            if (derInputStream.available() == 0) {
                this.nextUpdate = null;
            } else {
                derValue2 = derInputStream.getDerValue();
                s = (byte)(derValue2.tag & 0x1F);
                this.nextUpdate = s == 0 ? derValue2.data.getGeneralizedTime() : null;
            }
            if (derInputStream.available() > 0 && (derValue2 = derInputStream.getDerValue()).isContextSpecific((byte)1)) {
                derValueArray = derValue2.data.getSequence(3);
                for (n = 0; n < derValueArray.length; ++n) {
                    object = new Extension(derValueArray[n]);
                    if (DEBUG != null) {
                        DEBUG.println("OCSP single extension: " + object);
                    }
                    if (!((Extension)object).isCritical()) continue;
                    throw new IOException("Unsupported OCSP critical extension: " + ((Extension)object).getExtensionId());
                }
            }
            long l = System.currentTimeMillis();
            object = new Date(l + (long)MAX_CLOCK_SKEW);
            Date date = new Date(l - (long)MAX_CLOCK_SKEW);
            if (DEBUG != null) {
                String string = "";
                if (this.nextUpdate != null) {
                    string = " until " + this.nextUpdate;
                }
                DEBUG.println("OCSP response validity interval is from " + this.thisUpdate + string);
                DEBUG.println("Checking validity of OCSP response on: " + new Date(l));
            }
            if (((Date)object).before(this.thisUpdate) || date.after(this.nextUpdate != null ? this.nextUpdate : this.thisUpdate)) {
                if (DEBUG != null) {
                    DEBUG.println("Response is unreliable: its validity interval is out-of-date");
                }
                throw new IOException("Response is unreliable: its validity interval is out-of-date");
            }
        }

        public OCSP.RevocationStatus.CertStatus getCertStatus() {
            return this.certStatus;
        }

        private CertId getCertId() {
            return this.certId;
        }

        public Date getRevocationTime() {
            return (Date)this.revocationTime.clone();
        }

        public OCSP.RevocationStatus.Reason getRevocationReason() {
            return this.revocationReason;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("SingleResponse:\n");
            stringBuilder.append(this.certId);
            stringBuilder.append("\nCertStatus: ").append((Object)this.certStatus).append("\n");
            if (this.certStatus == OCSP.RevocationStatus.CertStatus.REVOKED) {
                stringBuilder.append("revocationTime is ");
                stringBuilder.append(this.revocationTime).append("\n");
                stringBuilder.append("revocationReason is ");
                stringBuilder.append((Object)this.revocationReason).append("\n");
            }
            stringBuilder.append("thisUpdate is ").append(this.thisUpdate).append("\n");
            if (this.nextUpdate != null) {
                stringBuilder.append("nextUpdate is ").append(this.nextUpdate).append("\n");
            }
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ResponseStatus {
        SUCCESSFUL,
        MALFORMED_REQUEST,
        INTERNAL_ERROR,
        TRY_LATER,
        UNUSED,
        SIG_REQUIRED,
        UNAUTHORIZED;

    }
}

