/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath;

import java.io.IOException;
import java.security.PublicKey;
import java.util.Arrays;
import javax.security.auth.x500.X500Principal;
import sun.security.util.DerValue;
import sun.security.x509.KeyIdentifier;

public final class ResponderId {
    private Type type;
    private X500Principal responderName;
    private KeyIdentifier responderKeyId;
    private byte[] encodedRid;

    public ResponderId(X500Principal x500Principal) throws IOException {
        this.responderName = x500Principal;
        this.responderKeyId = null;
        this.encodedRid = this.principalToBytes();
        this.type = Type.BY_NAME;
    }

    public ResponderId(PublicKey publicKey) throws IOException {
        this.responderKeyId = new KeyIdentifier(publicKey);
        this.responderName = null;
        this.encodedRid = this.keyIdToBytes();
        this.type = Type.BY_KEY;
    }

    public ResponderId(byte[] byArray) throws IOException {
        DerValue derValue = new DerValue(byArray);
        if (derValue.isContextSpecific((byte)Type.BY_NAME.value()) && derValue.isConstructed()) {
            this.responderName = new X500Principal(derValue.getDataBytes());
            this.encodedRid = this.principalToBytes();
            this.type = Type.BY_NAME;
        } else if (derValue.isContextSpecific((byte)Type.BY_KEY.value()) && derValue.isConstructed()) {
            this.responderKeyId = new KeyIdentifier(new DerValue(derValue.getDataBytes()));
            this.encodedRid = this.keyIdToBytes();
            this.type = Type.BY_KEY;
        } else {
            throw new IOException("Invalid ResponderId content");
        }
    }

    public byte[] getEncoded() {
        return (byte[])this.encodedRid.clone();
    }

    public Type getType() {
        return this.type;
    }

    public int length() {
        return this.encodedRid.length;
    }

    public X500Principal getResponderName() {
        return this.responderName;
    }

    public KeyIdentifier getKeyIdentifier() {
        return this.responderKeyId;
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this == object) {
            return true;
        }
        if (object instanceof ResponderId) {
            ResponderId responderId = (ResponderId)object;
            return Arrays.equals(this.encodedRid, responderId.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.encodedRid);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        switch (this.type) {
            case BY_NAME: {
                stringBuilder.append((Object)this.type).append(": ").append(this.responderName);
                break;
            }
            case BY_KEY: {
                stringBuilder.append((Object)this.type).append(": ");
                for (byte by : this.responderKeyId.getIdentifier()) {
                    stringBuilder.append(String.format("%02X", by));
                }
                break;
            }
            default: {
                stringBuilder.append("Unknown ResponderId Type: ").append((Object)this.type);
            }
        }
        return stringBuilder.toString();
    }

    private byte[] principalToBytes() throws IOException {
        DerValue derValue = new DerValue(DerValue.createTag((byte)-128, true, (byte)Type.BY_NAME.value()), this.responderName.getEncoded());
        return derValue.toByteArray();
    }

    private byte[] keyIdToBytes() throws IOException {
        DerValue derValue = new DerValue(4, this.responderKeyId.getIdentifier());
        DerValue derValue2 = new DerValue(DerValue.createTag((byte)-128, true, (byte)Type.BY_KEY.value()), derValue.toByteArray());
        return derValue2.toByteArray();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        BY_NAME(1, "byName"),
        BY_KEY(2, "byKey");

        private final int tagNumber;
        private final String ridTypeName;

        private Type(int n2, String string2) {
            this.tagNumber = n2;
            this.ridTypeName = string2;
        }

        public int value() {
            return this.tagNumber;
        }

        public String toString() {
            return this.ridTypeName;
        }
    }
}

