/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath.ldap;

import com.sun.jndi.ldap.LdapReferralException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.net.URI;
import java.security.AccessController;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.LDAPCertStoreParameters;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLSelector;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.naming.CompositeName;
import javax.naming.InvalidNameException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.ldap.LdapContext;
import javax.security.auth.x500.X500Principal;
import sun.misc.HexDumpEncoder;
import sun.security.action.GetPropertyAction;
import sun.security.provider.certpath.X509CertificatePair;
import sun.security.util.Cache;
import sun.security.util.Debug;
import sun.security.x509.X500Name;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class LDAPCertStore
extends CertStoreSpi {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final boolean DEBUG = false;
    private static final String USER_CERT = "userCertificate;binary";
    private static final String CA_CERT = "cACertificate;binary";
    private static final String CROSS_CERT = "crossCertificatePair;binary";
    private static final String CRL = "certificateRevocationList;binary";
    private static final String ARL = "authorityRevocationList;binary";
    private static final String DELTA_CRL = "deltaRevocationList;binary";
    private static final String[] STRING0 = new String[0];
    private static final byte[][] BB0 = new byte[0][];
    private static final Attributes EMPTY_ATTRIBUTES = new BasicAttributes();
    private static final int DEFAULT_CACHE_SIZE = 750;
    private static final int DEFAULT_CACHE_LIFETIME = 30;
    private static final int LIFETIME;
    private static final String PROP_LIFETIME = "sun.security.certpath.ldap.cache.lifetime";
    private CertificateFactory cf;
    private DirContext ctx;
    private boolean prefetchCRLs = false;
    private final Cache valueCache;
    private int cacheHits = 0;
    private int cacheMisses = 0;
    private int requests = 0;
    private static final Cache certStoreCache;

    public LDAPCertStore(CertStoreParameters certStoreParameters) throws InvalidAlgorithmParameterException {
        super(certStoreParameters);
        if (!(certStoreParameters instanceof LDAPCertStoreParameters)) {
            throw new InvalidAlgorithmParameterException("parameters must be LDAPCertStoreParameters");
        }
        LDAPCertStoreParameters lDAPCertStoreParameters = (LDAPCertStoreParameters)certStoreParameters;
        this.createInitialDirContext(lDAPCertStoreParameters.getServerName(), lDAPCertStoreParameters.getPort());
        try {
            this.cf = CertificateFactory.getInstance("X.509");
        }
        catch (CertificateException certificateException) {
            throw new InvalidAlgorithmParameterException("unable to create CertificateFactory for X.509");
        }
        this.valueCache = LIFETIME == 0 ? Cache.newNullCache() : (LIFETIME < 0 ? Cache.newSoftMemoryCache(750) : Cache.newSoftMemoryCache(750, LIFETIME));
    }

    static synchronized CertStore getInstance(LDAPCertStoreParameters lDAPCertStoreParameters) throws NoSuchAlgorithmException, InvalidAlgorithmParameterException {
        CertStore certStore;
        SecurityManager securityManager = System.getSecurityManager();
        if (securityManager != null) {
            securityManager.checkConnect(lDAPCertStoreParameters.getServerName(), lDAPCertStoreParameters.getPort());
        }
        if ((certStore = (CertStore)certStoreCache.get(lDAPCertStoreParameters)) == null) {
            certStore = CertStore.getInstance("LDAP", lDAPCertStoreParameters);
            certStoreCache.put(lDAPCertStoreParameters, certStore);
        } else if (debug != null) {
            debug.println("LDAPCertStore.getInstance: cache hit");
        }
        return certStore;
    }

    private void createInitialDirContext(String string, int n) throws InvalidAlgorithmParameterException {
        String string2 = "ldap://" + string + ":" + n;
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        hashtable.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        hashtable.put("java.naming.provider.url", string2);
        try {
            this.ctx = new InitialDirContext(hashtable);
            Hashtable<?, ?> hashtable2 = this.ctx.getEnvironment();
            if (hashtable2.get("java.naming.referral") == null) {
                this.ctx.addToEnvironment("java.naming.referral", "throw");
            }
        }
        catch (NamingException namingException) {
            if (debug != null) {
                debug.println("LDAPCertStore.engineInit about to throw InvalidAlgorithmParameterException");
                namingException.printStackTrace();
            }
            InvalidAlgorithmParameterException invalidAlgorithmParameterException = new InvalidAlgorithmParameterException("unable to create InitialDirContext using supplied parameters");
            invalidAlgorithmParameterException.initCause(namingException);
            throw invalidAlgorithmParameterException;
        }
    }

    private Collection<X509Certificate> getCertificates(LDAPRequest lDAPRequest, String string, X509CertSelector x509CertSelector) throws CertStoreException {
        byte[][] byArray;
        try {
            byArray = lDAPRequest.getValues(string);
        }
        catch (NamingException namingException) {
            throw new CertStoreException(namingException);
        }
        int n = byArray.length;
        if (n == 0) {
            return Collections.emptySet();
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(n);
        for (int i = 0; i < n; ++i) {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray[i]);
            try {
                Certificate certificate = this.cf.generateCertificate(byteArrayInputStream);
                if (!x509CertSelector.match(certificate)) continue;
                arrayList.add((X509Certificate)certificate);
                continue;
            }
            catch (CertificateException certificateException) {
                if (debug == null) continue;
                debug.println("LDAPCertStore.getCertificates() encountered exception while parsing cert, skipping the bad data: ");
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                debug.println("[ " + hexDumpEncoder.encodeBuffer(byArray[i]) + " ]");
            }
        }
        return arrayList;
    }

    private Collection<X509CertificatePair> getCertPairs(LDAPRequest lDAPRequest, String string) throws CertStoreException {
        byte[][] byArray;
        try {
            byArray = lDAPRequest.getValues(string);
        }
        catch (NamingException namingException) {
            throw new CertStoreException(namingException);
        }
        int n = byArray.length;
        if (n == 0) {
            return Collections.emptySet();
        }
        ArrayList<X509CertificatePair> arrayList = new ArrayList<X509CertificatePair>(n);
        for (int i = 0; i < n; ++i) {
            try {
                X509CertificatePair x509CertificatePair = X509CertificatePair.generateCertificatePair(byArray[i]);
                arrayList.add(x509CertificatePair);
                continue;
            }
            catch (CertificateException certificateException) {
                if (debug == null) continue;
                debug.println("LDAPCertStore.getCertPairs() encountered exception while parsing cert, skipping the bad data: ");
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                debug.println("[ " + hexDumpEncoder.encodeBuffer(byArray[i]) + " ]");
            }
        }
        return arrayList;
    }

    private Collection<X509Certificate> getMatchingCrossCerts(LDAPRequest lDAPRequest, X509CertSelector x509CertSelector, X509CertSelector x509CertSelector2) throws CertStoreException {
        Collection<X509CertificatePair> collection = this.getCertPairs(lDAPRequest, CROSS_CERT);
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>();
        for (X509CertificatePair x509CertificatePair : collection) {
            X509Certificate x509Certificate;
            if (x509CertSelector != null && (x509Certificate = x509CertificatePair.getForward()) != null && x509CertSelector.match(x509Certificate)) {
                arrayList.add(x509Certificate);
            }
            if (x509CertSelector2 == null || (x509Certificate = x509CertificatePair.getReverse()) == null || !x509CertSelector2.match(x509Certificate)) continue;
            arrayList.add(x509Certificate);
        }
        return arrayList;
    }

    public synchronized Collection<X509Certificate> engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        LDAPRequest lDAPRequest;
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() selector: " + String.valueOf(certSelector));
        }
        if (certSelector == null) {
            certSelector = new X509CertSelector();
        }
        if (!(certSelector instanceof X509CertSelector)) {
            throw new CertStoreException("LDAPCertStore needs an X509CertSelector to find certs");
        }
        X509CertSelector x509CertSelector = (X509CertSelector)certSelector;
        int n = x509CertSelector.getBasicConstraints();
        String string = x509CertSelector.getSubjectAsString();
        String string2 = x509CertSelector.getIssuerAsString();
        HashSet<X509Certificate> hashSet = new HashSet<X509Certificate>();
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() basicConstraints: " + n);
        }
        if (string != null) {
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() subject is not null");
            }
            lDAPRequest = new LDAPRequest(string);
            if (n > -2) {
                lDAPRequest.addRequestedAttribute(CROSS_CERT);
                lDAPRequest.addRequestedAttribute(CA_CERT);
                lDAPRequest.addRequestedAttribute(ARL);
                if (this.prefetchCRLs) {
                    lDAPRequest.addRequestedAttribute(CRL);
                }
            }
            if (n < 0) {
                lDAPRequest.addRequestedAttribute(USER_CERT);
            }
            if (n > -2) {
                hashSet.addAll(this.getMatchingCrossCerts(lDAPRequest, x509CertSelector, null));
                if (debug != null) {
                    debug.println("LDAPCertStore.engineGetCertificates() after getMatchingCrossCerts(subject,xsel,null),certs.size(): " + hashSet.size());
                }
                hashSet.addAll(this.getCertificates(lDAPRequest, CA_CERT, x509CertSelector));
                if (debug != null) {
                    debug.println("LDAPCertStore.engineGetCertificates() after getCertificates(subject,CA_CERT,xsel),certs.size(): " + hashSet.size());
                }
            }
            if (n < 0) {
                hashSet.addAll(this.getCertificates(lDAPRequest, USER_CERT, x509CertSelector));
                if (debug != null) {
                    debug.println("LDAPCertStore.engineGetCertificates() after getCertificates(subject,USER_CERT, xsel),certs.size(): " + hashSet.size());
                }
            }
        } else {
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() subject is null");
            }
            if (n == -2) {
                throw new CertStoreException("need subject to find EE certs");
            }
            if (string2 == null) {
                throw new CertStoreException("need subject or issuer to find certs");
            }
        }
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() about to getMatchingCrossCerts...");
        }
        if (string2 != null && n > -2) {
            lDAPRequest = new LDAPRequest(string2);
            lDAPRequest.addRequestedAttribute(CROSS_CERT);
            lDAPRequest.addRequestedAttribute(CA_CERT);
            lDAPRequest.addRequestedAttribute(ARL);
            if (this.prefetchCRLs) {
                lDAPRequest.addRequestedAttribute(CRL);
            }
            hashSet.addAll(this.getMatchingCrossCerts(lDAPRequest, null, x509CertSelector));
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() after getMatchingCrossCerts(issuer,null,xsel),certs.size(): " + hashSet.size());
            }
            hashSet.addAll(this.getCertificates(lDAPRequest, CA_CERT, x509CertSelector));
            if (debug != null) {
                debug.println("LDAPCertStore.engineGetCertificates() after getCertificates(issuer,CA_CERT,xsel),certs.size(): " + hashSet.size());
            }
        }
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCertificates() returning certs");
        }
        return hashSet;
    }

    private Collection<X509CRL> getCRLs(LDAPRequest lDAPRequest, String string, X509CRLSelector x509CRLSelector) throws CertStoreException {
        byte[][] byArray;
        try {
            byArray = lDAPRequest.getValues(string);
        }
        catch (NamingException namingException) {
            throw new CertStoreException(namingException);
        }
        int n = byArray.length;
        if (n == 0) {
            return Collections.emptySet();
        }
        ArrayList<X509CRL> arrayList = new ArrayList<X509CRL>(n);
        for (int i = 0; i < n; ++i) {
            try {
                CRL cRL = this.cf.generateCRL(new ByteArrayInputStream(byArray[i]));
                if (!x509CRLSelector.match(cRL)) continue;
                arrayList.add((X509CRL)cRL);
                continue;
            }
            catch (CRLException cRLException) {
                if (debug == null) continue;
                debug.println("LDAPCertStore.getCRLs() encountered exception while parsing CRL, skipping the bad data: ");
                HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
                debug.println("[ " + hexDumpEncoder.encodeBuffer(byArray[i]) + " ]");
            }
        }
        return arrayList;
    }

    public synchronized Collection<X509CRL> engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        Collection<Object> collection;
        if (debug != null) {
            debug.println("LDAPCertStore.engineGetCRLs() selector: " + cRLSelector);
        }
        if (cRLSelector == null) {
            cRLSelector = new X509CRLSelector();
        }
        if (!(cRLSelector instanceof X509CRLSelector)) {
            throw new CertStoreException("need X509CRLSelector to find CRLs");
        }
        X509CRLSelector x509CRLSelector = (X509CRLSelector)cRLSelector;
        HashSet<X509CRL> hashSet = new HashSet<X509CRL>();
        X509Certificate x509Certificate = x509CRLSelector.getCertificateChecking();
        if (x509Certificate != null) {
            collection = new HashSet<Object>();
            X500Principal x500Principal = x509Certificate.getIssuerX500Principal();
            collection.add(x500Principal.getName("RFC2253"));
        } else {
            collection = x509CRLSelector.getIssuerNames();
            if (collection == null) {
                throw new CertStoreException("need issuerNames or certChecking to find CRLs");
            }
        }
        for (Object e : collection) {
            LDAPRequest lDAPRequest;
            String string;
            Collection<X509CRL> collection2;
            block17: {
                block16: {
                    if (e instanceof byte[]) {
                        try {
                            collection2 = new X500Principal((byte[])e);
                            string = ((X500Principal)((Object)collection2)).getName("RFC2253");
                            break block16;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            continue;
                        }
                    }
                    string = (String)e;
                }
                collection2 = Collections.emptySet();
                if (x509Certificate == null || x509Certificate.getBasicConstraints() != -1) {
                    lDAPRequest = new LDAPRequest(string);
                    lDAPRequest.addRequestedAttribute(CROSS_CERT);
                    lDAPRequest.addRequestedAttribute(CA_CERT);
                    lDAPRequest.addRequestedAttribute(ARL);
                    if (this.prefetchCRLs) {
                        lDAPRequest.addRequestedAttribute(CRL);
                    }
                    try {
                        collection2 = this.getCRLs(lDAPRequest, ARL, x509CRLSelector);
                        if (collection2.isEmpty()) {
                            this.prefetchCRLs = true;
                        } else {
                            hashSet.addAll(collection2);
                        }
                    }
                    catch (CertStoreException certStoreException) {
                        if (debug == null) break block17;
                        debug.println("LDAPCertStore.engineGetCRLs non-fatal error retrieving ARLs:" + certStoreException);
                        certStoreException.printStackTrace();
                    }
                }
            }
            if (!collection2.isEmpty() && x509Certificate != null) continue;
            lDAPRequest = new LDAPRequest(string);
            lDAPRequest.addRequestedAttribute(CRL);
            collection2 = this.getCRLs(lDAPRequest, CRL, x509CRLSelector);
            hashSet.addAll(collection2);
        }
        return hashSet;
    }

    static LDAPCertStoreParameters getParameters(URI uRI) {
        String string = uRI.getHost();
        if (string == null) {
            return new SunLDAPCertStoreParameters();
        }
        int n = uRI.getPort();
        return n == -1 ? new SunLDAPCertStoreParameters(string) : new SunLDAPCertStoreParameters(string, n);
    }

    static {
        String string = AccessController.doPrivileged(new GetPropertyAction(PROP_LIFETIME));
        LIFETIME = string != null ? Integer.parseInt(string) : 30;
        certStoreCache = Cache.newSoftMemoryCache(185);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LDAPCRLSelector
    extends X509CRLSelector {
        private X509CRLSelector selector;
        private Collection<X500Principal> certIssuers;
        private Collection<X500Principal> issuers;
        private HashSet<Object> issuerNames;

        LDAPCRLSelector(X509CRLSelector x509CRLSelector, Collection<X500Principal> collection, String string) throws IOException {
            this.selector = x509CRLSelector == null ? new X509CRLSelector() : x509CRLSelector;
            this.certIssuers = collection;
            this.issuerNames = new HashSet();
            this.issuerNames.add(string);
            this.issuers = new HashSet<X500Principal>();
            this.issuers.add(new X500Name(string).asX500Principal());
        }

        @Override
        public Collection<X500Principal> getIssuers() {
            return Collections.unmodifiableCollection(this.issuers);
        }

        @Override
        public Collection<Object> getIssuerNames() {
            return Collections.unmodifiableCollection(this.issuerNames);
        }

        @Override
        public BigInteger getMinCRL() {
            return this.selector.getMinCRL();
        }

        @Override
        public BigInteger getMaxCRL() {
            return this.selector.getMaxCRL();
        }

        @Override
        public Date getDateAndTime() {
            return this.selector.getDateAndTime();
        }

        @Override
        public X509Certificate getCertificateChecking() {
            return this.selector.getCertificateChecking();
        }

        @Override
        public boolean match(CRL cRL) {
            this.selector.setIssuers(this.certIssuers);
            boolean bl = this.selector.match(cRL);
            this.selector.setIssuers(this.issuers);
            return bl;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class LDAPCertSelector
    extends X509CertSelector {
        private X500Principal certSubject;
        private X509CertSelector selector;
        private X500Principal subject;

        LDAPCertSelector(X509CertSelector x509CertSelector, X500Principal x500Principal, String string) throws IOException {
            this.selector = x509CertSelector == null ? new X509CertSelector() : x509CertSelector;
            this.certSubject = x500Principal;
            this.subject = new X500Name(string).asX500Principal();
        }

        @Override
        public X509Certificate getCertificate() {
            return this.selector.getCertificate();
        }

        @Override
        public BigInteger getSerialNumber() {
            return this.selector.getSerialNumber();
        }

        @Override
        public X500Principal getIssuer() {
            return this.selector.getIssuer();
        }

        @Override
        public String getIssuerAsString() {
            return this.selector.getIssuerAsString();
        }

        @Override
        public byte[] getIssuerAsBytes() throws IOException {
            return this.selector.getIssuerAsBytes();
        }

        @Override
        public X500Principal getSubject() {
            return this.subject;
        }

        @Override
        public String getSubjectAsString() {
            return this.subject.getName();
        }

        @Override
        public byte[] getSubjectAsBytes() throws IOException {
            return this.subject.getEncoded();
        }

        @Override
        public byte[] getSubjectKeyIdentifier() {
            return this.selector.getSubjectKeyIdentifier();
        }

        @Override
        public byte[] getAuthorityKeyIdentifier() {
            return this.selector.getAuthorityKeyIdentifier();
        }

        @Override
        public Date getCertificateValid() {
            return this.selector.getCertificateValid();
        }

        @Override
        public Date getPrivateKeyValid() {
            return this.selector.getPrivateKeyValid();
        }

        @Override
        public String getSubjectPublicKeyAlgID() {
            return this.selector.getSubjectPublicKeyAlgID();
        }

        @Override
        public PublicKey getSubjectPublicKey() {
            return this.selector.getSubjectPublicKey();
        }

        @Override
        public boolean[] getKeyUsage() {
            return this.selector.getKeyUsage();
        }

        @Override
        public Set<String> getExtendedKeyUsage() {
            return this.selector.getExtendedKeyUsage();
        }

        @Override
        public boolean getMatchAllSubjectAltNames() {
            return this.selector.getMatchAllSubjectAltNames();
        }

        @Override
        public Collection<List<?>> getSubjectAlternativeNames() {
            return this.selector.getSubjectAlternativeNames();
        }

        @Override
        public byte[] getNameConstraints() {
            return this.selector.getNameConstraints();
        }

        @Override
        public int getBasicConstraints() {
            return this.selector.getBasicConstraints();
        }

        @Override
        public Set<String> getPolicy() {
            return this.selector.getPolicy();
        }

        @Override
        public Collection<List<?>> getPathToNames() {
            return this.selector.getPathToNames();
        }

        @Override
        public boolean match(Certificate certificate) {
            this.selector.setSubject(this.certSubject);
            boolean bl = this.selector.match(certificate);
            this.selector.setSubject(this.subject);
            return bl;
        }
    }

    private static class SunLDAPCertStoreParameters
    extends LDAPCertStoreParameters {
        private volatile int hashCode = 0;

        SunLDAPCertStoreParameters(String string, int n) {
            super(string, n);
        }

        SunLDAPCertStoreParameters(String string) {
            super(string);
        }

        SunLDAPCertStoreParameters() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof LDAPCertStoreParameters)) {
                return false;
            }
            LDAPCertStoreParameters lDAPCertStoreParameters = (LDAPCertStoreParameters)object;
            return this.getPort() == lDAPCertStoreParameters.getPort() && this.getServerName().equalsIgnoreCase(lDAPCertStoreParameters.getServerName());
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int n = 17;
                n = 37 * n + this.getPort();
                this.hashCode = n = 37 * n + this.getServerName().toLowerCase().hashCode();
            }
            return this.hashCode;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LDAPRequest {
        private final String name;
        private Map<String, byte[][]> valueMap;
        private final List<String> requestedAttributes;

        LDAPRequest(String string) throws CertStoreException {
            this.name = this.checkName(string);
            this.requestedAttributes = new ArrayList<String>(5);
        }

        private String checkName(String string) throws CertStoreException {
            if (string == null) {
                throw new CertStoreException("Name absent");
            }
            try {
                if (new CompositeName(string).size() > 1) {
                    throw new CertStoreException("Invalid name: " + string);
                }
            }
            catch (InvalidNameException invalidNameException) {
                throw new CertStoreException("Invalid name: " + string, invalidNameException);
            }
            return string;
        }

        String getName() {
            return this.name;
        }

        void addRequestedAttribute(String string) {
            if (this.valueMap != null) {
                throw new IllegalStateException("Request already sent");
            }
            this.requestedAttributes.add(string);
        }

        byte[][] getValues(String string) throws NamingException {
            String string2 = this.name + "|" + string;
            byte[][] byArray = (byte[][])LDAPCertStore.this.valueCache.get(string2);
            if (byArray != null) {
                LDAPCertStore.this.cacheHits++;
                return byArray;
            }
            LDAPCertStore.this.cacheMisses++;
            Map<String, byte[][]> map = this.getValueMap();
            byArray = map.get(string);
            return byArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Map<String, byte[][]> getValueMap() throws NamingException {
            Object object;
            Serializable serializable;
            Attributes attributes;
            if (this.valueMap != null) {
                return this.valueMap;
            }
            this.valueMap = new HashMap<String, byte[][]>(8);
            String[] stringArray = this.requestedAttributes.toArray(STRING0);
            try {
                attributes = LDAPCertStore.this.ctx.getAttributes(this.name, stringArray);
            }
            catch (LdapReferralException ldapReferralException) {
                while (true) {
                    LdapReferralException ldapReferralException2;
                    try {
                        String exception = (String)ldapReferralException2.getReferralInfo();
                        serializable = new URI(exception);
                        if (!serializable.getScheme().equalsIgnoreCase("ldap")) {
                            throw new IllegalArgumentException("Not LDAP");
                        }
                        object = serializable.getPath();
                        if (object != null && ((String)object).charAt(0) == '/') {
                            object = ((String)object).substring(1);
                        }
                        this.checkName((String)object);
                    }
                    catch (Exception exception) {
                        throw new NamingException("Cannot follow referral to " + ldapReferralException2.getReferralInfo());
                    }
                    LdapContext object2 = (LdapContext)ldapReferralException2.getReferralContext();
                    try {
                        attributes = object2.getAttributes(this.name, stringArray);
                    }
                    catch (LdapReferralException ldapReferralException3) {
                        ldapReferralException2 = ldapReferralException3;
                        continue;
                    }
                    finally {
                        object2.close();
                        continue;
                    }
                    break;
                }
            }
            catch (NameNotFoundException nameNotFoundException) {
                attributes = EMPTY_ATTRIBUTES;
            }
            for (String string : this.requestedAttributes) {
                serializable = attributes.get(string);
                object = this.getAttributeValues((Attribute)serializable);
                this.cacheAttribute(string, (byte[][])object);
                this.valueMap.put(string, (byte[][])object);
            }
            return this.valueMap;
        }

        private void cacheAttribute(String string, byte[][] byArray) {
            String string2 = this.name + "|" + string;
            LDAPCertStore.this.valueCache.put(string2, byArray);
        }

        private byte[][] getAttributeValues(Attribute attribute) throws NamingException {
            Object object;
            if (attribute == null) {
                object = BB0;
            } else {
                object = new byte[attribute.size()][];
                int n = 0;
                NamingEnumeration<?> namingEnumeration = attribute.getAll();
                while (namingEnumeration.hasMore()) {
                    Object obj = namingEnumeration.next();
                    if (debug != null && obj instanceof String) {
                        debug.println("LDAPCertStore.getAttrValues() enum.next is a string!: " + obj);
                    }
                    byte[] byArray = (byte[])obj;
                    object[n++] = byArray;
                }
            }
            return object;
        }
    }
}

