/*
 * Decompiled with CFR 0.152.
 */
package sun.security.provider.certpath.ssl;

import java.io.IOException;
import java.net.URI;
import java.net.URLConnection;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.Provider;
import java.security.cert.CRLSelector;
import java.security.cert.CertSelector;
import java.security.cert.CertStore;
import java.security.cert.CertStoreException;
import java.security.cert.CertStoreParameters;
import java.security.cert.CertStoreSpi;
import java.security.cert.CertificateException;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SSLServerCertStore
extends CertStoreSpi {
    private final URI uri;
    private static final GetChainTrustManager trustManager;
    private static final SSLSocketFactory socketFactory;
    private static final HostnameVerifier hostnameVerifier;

    SSLServerCertStore(URI uRI) throws InvalidAlgorithmParameterException {
        super(null);
        this.uri = uRI;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Collection<X509Certificate> engineGetCertificates(CertSelector certSelector) throws CertStoreException {
        try {
            URLConnection uRLConnection = this.uri.toURL().openConnection();
            if (!(uRLConnection instanceof HttpsURLConnection)) return Collections.emptySet();
            if (socketFactory == null) {
                throw new CertStoreException("No initialized SSLSocketFactory");
            }
            HttpsURLConnection httpsURLConnection = (HttpsURLConnection)uRLConnection;
            httpsURLConnection.setSSLSocketFactory(socketFactory);
            httpsURLConnection.setHostnameVerifier(hostnameVerifier);
            GetChainTrustManager getChainTrustManager = trustManager;
            synchronized (getChainTrustManager) {
                try {
                    httpsURLConnection.connect();
                    List<X509Certificate> list = SSLServerCertStore.getMatchingCerts(trustManager.serverChain, certSelector);
                    return list;
                }
                catch (IOException iOException) {
                    if (!trustManager.exchangedServerCerts) throw iOException;
                    List<X509Certificate> list2 = SSLServerCertStore.getMatchingCerts(trustManager.serverChain, certSelector);
                    return list2;
                }
                finally {
                    trustManager.cleanup();
                }
            }
        }
        catch (IOException iOException2) {
            throw new CertStoreException(iOException2);
        }
    }

    private static List<X509Certificate> getMatchingCerts(List<X509Certificate> list, CertSelector certSelector) {
        if (certSelector == null) {
            return list;
        }
        ArrayList<X509Certificate> arrayList = new ArrayList<X509Certificate>(list.size());
        for (X509Certificate x509Certificate : list) {
            if (!certSelector.match(x509Certificate)) continue;
            arrayList.add(x509Certificate);
        }
        return arrayList;
    }

    public Collection<X509CRL> engineGetCRLs(CRLSelector cRLSelector) throws CertStoreException {
        throw new UnsupportedOperationException();
    }

    static CertStore getInstance(URI uRI) throws InvalidAlgorithmParameterException {
        return new CS(new SSLServerCertStore(uRI), null, "SSLServer", null);
    }

    static {
        SSLSocketFactory sSLSocketFactory;
        trustManager = new GetChainTrustManager();
        hostnameVerifier = new HostnameVerifier(){

            public boolean verify(String string, SSLSession sSLSession) {
                return true;
            }
        };
        try {
            SSLContext sSLContext = SSLContext.getInstance("SSL");
            sSLContext.init(null, new TrustManager[]{trustManager}, null);
            sSLSocketFactory = sSLContext.getSocketFactory();
        }
        catch (GeneralSecurityException generalSecurityException) {
            sSLSocketFactory = null;
        }
        socketFactory = sSLSocketFactory;
    }

    private static class CS
    extends CertStore {
        protected CS(CertStoreSpi certStoreSpi, Provider provider, String string, CertStoreParameters certStoreParameters) {
            super(certStoreSpi, provider, string, certStoreParameters);
        }
    }

    private static class GetChainTrustManager
    implements X509TrustManager {
        private List<X509Certificate> serverChain = Collections.emptyList();
        private boolean exchangedServerCerts = false;

        private GetChainTrustManager() {
        }

        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        public void checkClientTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            throw new UnsupportedOperationException();
        }

        public void checkServerTrusted(X509Certificate[] x509CertificateArray, String string) throws CertificateException {
            this.exchangedServerCerts = true;
            this.serverChain = x509CertificateArray == null ? Collections.emptyList() : Arrays.asList(x509CertificateArray);
        }

        void cleanup() {
            this.exchangedServerCerts = false;
            this.serverChain = Collections.emptyList();
        }
    }
}

