/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.KeyStore;
import java.text.Collator;
import java.util.ResourceBundle;

public class KeyStoreUtil {
    private static final String JKS = "jks";
    private static final Collator collator = Collator.getInstance();

    private KeyStoreUtil() {
    }

    public static boolean isWindowsKeyStore(String string) {
        return string.equalsIgnoreCase("Windows-MY") || string.equalsIgnoreCase("Windows-ROOT");
    }

    public static String niceStoreTypeName(String string) {
        if (string.equalsIgnoreCase("Windows-MY")) {
            return "Windows-MY";
        }
        if (string.equalsIgnoreCase("Windows-ROOT")) {
            return "Windows-ROOT";
        }
        return string.toUpperCase();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getCacertsKeyStore() throws Exception {
        String string = File.separator;
        File file = new File(System.getProperty("java.home") + string + "lib" + string + "security" + string + "cacerts");
        if (!file.exists()) {
            return null;
        }
        FileInputStream fileInputStream = null;
        KeyStore keyStore = null;
        try {
            fileInputStream = new FileInputStream(file);
            keyStore = KeyStore.getInstance(JKS);
            keyStore.load(fileInputStream, null);
        }
        finally {
            if (fileInputStream != null) {
                fileInputStream.close();
            }
        }
        return keyStore;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static char[] getPassWithModifier(String string, String string2, ResourceBundle resourceBundle) {
        if (string == null) {
            return string2.toCharArray();
        }
        if (collator.compare(string, "env") == 0) {
            String string3 = System.getenv(string2);
            if (string3 != null) return string3.toCharArray();
            System.err.println(resourceBundle.getString("Cannot.find.environment.variable.") + string2);
            return null;
        }
        if (collator.compare(string, "file") != 0) {
            System.err.println(resourceBundle.getString("Unknown.password.type.") + string);
            return null;
        }
        try {
            Object object;
            URL uRL = null;
            try {
                uRL = new URL(string2);
            }
            catch (MalformedURLException malformedURLException) {
                object = new File(string2);
                if (!((File)object).exists()) {
                    System.err.println(resourceBundle.getString("Cannot.find.file.") + string2);
                    return null;
                }
                uRL = ((File)object).toURI().toURL();
            }
            BufferedReader bufferedReader = null;
            try {
                bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
                object = bufferedReader.readLine();
                if (object == null) {
                    char[] cArray2 = new char[]{};
                    return cArray2;
                }
                char[] cArray = ((String)object).toCharArray();
                return cArray;
            }
            finally {
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return null;
        }
    }

    static {
        collator.setStrength(0);
    }
}

