/*
 * Decompiled with CFR 0.152.
 */
package sun.security.tools.policytool;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagLayout;
import java.awt.Label;
import java.awt.List;
import java.awt.Panel;
import java.awt.Point;
import java.awt.TextField;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.security.InvalidParameterException;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.Vector;
import sun.security.provider.PolicyParser;
import sun.security.tools.policytool.AWTPerm;
import sun.security.tools.policytool.AddEntryDoneButtonListener;
import sun.security.tools.policytool.AddPermButtonListener;
import sun.security.tools.policytool.AddPrinButtonListener;
import sun.security.tools.policytool.AllPerm;
import sun.security.tools.policytool.AudioPerm;
import sun.security.tools.policytool.AuthPerm;
import sun.security.tools.policytool.CancelButtonListener;
import sun.security.tools.policytool.ChangeKeyStoreOKButtonListener;
import sun.security.tools.policytool.ChildWindowListener;
import sun.security.tools.policytool.ConfirmRemovePolicyEntryOKButtonListener;
import sun.security.tools.policytool.DelegationPerm;
import sun.security.tools.policytool.EditPermButtonListener;
import sun.security.tools.policytool.EditPrinButtonListener;
import sun.security.tools.policytool.FilePerm;
import sun.security.tools.policytool.InqSecContextPerm;
import sun.security.tools.policytool.KrbPrin;
import sun.security.tools.policytool.LogPerm;
import sun.security.tools.policytool.MBeanPerm;
import sun.security.tools.policytool.MBeanSvrPerm;
import sun.security.tools.policytool.MBeanTrustPerm;
import sun.security.tools.policytool.MgmtPerm;
import sun.security.tools.policytool.NetPerm;
import sun.security.tools.policytool.NewPolicyPermOKButtonListener;
import sun.security.tools.policytool.NewPolicyPrinOKButtonListener;
import sun.security.tools.policytool.NoDisplayException;
import sun.security.tools.policytool.OverWriteFileOKButtonListener;
import sun.security.tools.policytool.Perm;
import sun.security.tools.policytool.PermissionActionsMenuListener;
import sun.security.tools.policytool.PermissionMenuListener;
import sun.security.tools.policytool.PermissionNameMenuListener;
import sun.security.tools.policytool.PolicyEntry;
import sun.security.tools.policytool.PolicyListListener;
import sun.security.tools.policytool.PolicyTool;
import sun.security.tools.policytool.Prin;
import sun.security.tools.policytool.PrincipalTypeMenuListener;
import sun.security.tools.policytool.PrivCredPerm;
import sun.security.tools.policytool.PropPerm;
import sun.security.tools.policytool.ReflectPerm;
import sun.security.tools.policytool.RemovePermButtonListener;
import sun.security.tools.policytool.RemovePrinButtonListener;
import sun.security.tools.policytool.RuntimePerm;
import sun.security.tools.policytool.SQLPerm;
import sun.security.tools.policytool.SSLPerm;
import sun.security.tools.policytool.SecurityPerm;
import sun.security.tools.policytool.SerialPerm;
import sun.security.tools.policytool.ServicePerm;
import sun.security.tools.policytool.SocketPerm;
import sun.security.tools.policytool.SubjDelegPerm;
import sun.security.tools.policytool.TaggedList;
import sun.security.tools.policytool.ToolWindow;
import sun.security.tools.policytool.UserSaveCancelButtonListener;
import sun.security.tools.policytool.UserSaveNoButtonListener;
import sun.security.tools.policytool.UserSaveYesButtonListener;
import sun.security.tools.policytool.X500Prin;

class ToolDialog
extends Dialog {
    private static final long serialVersionUID = -372244357011301190L;
    public static final int NOACTION = 0;
    public static final int QUIT = 1;
    public static final int NEW = 2;
    public static final int OPEN = 3;
    public static final String ALL_PERM_CLASS = "java.security.AllPermission";
    public static final String FILE_PERM_CLASS = "java.io.FilePermission";
    public static final String X500_PRIN_CLASS = "javax.security.auth.x500.X500Principal";
    public static final String PERM = PolicyTool.rb.getString("Permission.");
    public static final String PRIN_TYPE = PolicyTool.rb.getString("Principal.Type.");
    public static final String PRIN_NAME = PolicyTool.rb.getString("Principal.Name.");
    public static final String PERM_NAME = PolicyTool.rb.getString("Target.Name.");
    public static final String PERM_ACTIONS = PolicyTool.rb.getString("Actions.");
    public static final int OW_LABEL = 0;
    public static final int OW_OK_BUTTON = 1;
    public static final int OW_CANCEL_BUTTON = 2;
    public static final int PE_CODEBASE_LABEL = 0;
    public static final int PE_CODEBASE_TEXTFIELD = 1;
    public static final int PE_SIGNEDBY_LABEL = 2;
    public static final int PE_SIGNEDBY_TEXTFIELD = 3;
    public static final int PE_PANEL0 = 4;
    public static final int PE_ADD_PRIN_BUTTON = 0;
    public static final int PE_EDIT_PRIN_BUTTON = 1;
    public static final int PE_REMOVE_PRIN_BUTTON = 2;
    public static final int PE_PRIN_LABEL = 5;
    public static final int PE_PRIN_LIST = 6;
    public static final int PE_PANEL1 = 7;
    public static final int PE_ADD_PERM_BUTTON = 0;
    public static final int PE_EDIT_PERM_BUTTON = 1;
    public static final int PE_REMOVE_PERM_BUTTON = 2;
    public static final int PE_PERM_LIST = 8;
    public static final int PE_PANEL2 = 9;
    public static final int PE_CANCEL_BUTTON = 1;
    public static final int PE_DONE_BUTTON = 0;
    public static final int PRD_DESC_LABEL = 0;
    public static final int PRD_PRIN_CHOICE = 1;
    public static final int PRD_PRIN_TEXTFIELD = 2;
    public static final int PRD_NAME_LABEL = 3;
    public static final int PRD_NAME_TEXTFIELD = 4;
    public static final int PRD_CANCEL_BUTTON = 6;
    public static final int PRD_OK_BUTTON = 5;
    public static final int PD_DESC_LABEL = 0;
    public static final int PD_PERM_CHOICE = 1;
    public static final int PD_PERM_TEXTFIELD = 2;
    public static final int PD_NAME_CHOICE = 3;
    public static final int PD_NAME_TEXTFIELD = 4;
    public static final int PD_ACTIONS_CHOICE = 5;
    public static final int PD_ACTIONS_TEXTFIELD = 6;
    public static final int PD_SIGNEDBY_LABEL = 7;
    public static final int PD_SIGNEDBY_TEXTFIELD = 8;
    public static final int PD_CANCEL_BUTTON = 10;
    public static final int PD_OK_BUTTON = 9;
    public static final int EDIT_KEYSTORE = 0;
    public static final int KSD_NAME_LABEL = 0;
    public static final int KSD_NAME_TEXTFIELD = 1;
    public static final int KSD_TYPE_LABEL = 2;
    public static final int KSD_TYPE_TEXTFIELD = 3;
    public static final int KSD_PROVIDER_LABEL = 4;
    public static final int KSD_PROVIDER_TEXTFIELD = 5;
    public static final int KSD_PWD_URL_LABEL = 6;
    public static final int KSD_PWD_URL_TEXTFIELD = 7;
    public static final int KSD_CANCEL_BUTTON = 9;
    public static final int KSD_OK_BUTTON = 8;
    public static final int USC_LABEL = 0;
    public static final int USC_PANEL = 1;
    public static final int USC_YES_BUTTON = 0;
    public static final int USC_NO_BUTTON = 1;
    public static final int USC_CANCEL_BUTTON = 2;
    public static final int CRPE_LABEL1 = 0;
    public static final int CRPE_LABEL2 = 1;
    public static final int CRPE_PANEL = 2;
    public static final int CRPE_PANEL_OK = 0;
    public static final int CRPE_PANEL_CANCEL = 1;
    private static final int PERMISSION = 0;
    private static final int PERMISSION_NAME = 1;
    private static final int PERMISSION_ACTIONS = 2;
    private static final int PERMISSION_SIGNEDBY = 3;
    private static final int PRINCIPAL_TYPE = 4;
    private static final int PRINCIPAL_NAME = 5;
    public static ArrayList<Perm> PERM_ARRAY = new ArrayList();
    public static ArrayList<Prin> PRIN_ARRAY;
    PolicyTool tool;
    ToolWindow tw;

    ToolDialog(String string, PolicyTool policyTool, ToolWindow toolWindow, boolean bl) {
        super((Frame)toolWindow, bl);
        this.setTitle(string);
        this.tool = policyTool;
        this.tw = toolWindow;
        this.addWindowListener(new ChildWindowListener(this));
    }

    static Perm getPerm(String string, boolean bl) {
        for (int i = 0; i < PERM_ARRAY.size(); ++i) {
            Perm perm = PERM_ARRAY.get(i);
            if (!(bl ? perm.FULL_CLASS.equals(string) : perm.CLASS.equals(string))) continue;
            return perm;
        }
        return null;
    }

    static Prin getPrin(String string, boolean bl) {
        for (int i = 0; i < PRIN_ARRAY.size(); ++i) {
            Prin prin = PRIN_ARRAY.get(i);
            if (!(bl ? prin.FULL_CLASS.equals(string) : prin.CLASS.equals(string))) continue;
            return prin;
        }
        return null;
    }

    void displayOverWriteFileDialog(String string, int n) {
        Point point = this.tw.getLocationOnScreen();
        this.setBounds(point.x + 75, point.y + 100, 400, 150);
        this.setLayout(new GridBagLayout());
        MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("OK.to.overwrite.existing.file.filename."));
        Object[] objectArray = new Object[]{string};
        Label label = new Label(messageFormat.format(objectArray));
        this.tw.addNewComponent(this, label, 0, 0, 0, 2, 1, 0.0, 0.0, 1, ToolWindow.TOP_PADDING);
        Button button = new Button(PolicyTool.rb.getString("OK"));
        button.addActionListener(new OverWriteFileOKButtonListener(this.tool, this.tw, this, string, n));
        this.tw.addNewComponent(this, button, 1, 0, 1, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        button = new Button(PolicyTool.rb.getString("Cancel"));
        button.addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent(this, button, 2, 1, 1, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_PADDING);
        this.setVisible(true);
    }

    void displayPolicyEntryDialog(boolean bl) {
        Serializable serializable;
        Serializable serializable2;
        Component component;
        int n = 0;
        PolicyEntry[] policyEntryArray = null;
        TaggedList taggedList = new TaggedList(3, false);
        taggedList.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("Principal.List"));
        taggedList.addActionListener(new EditPrinButtonListener(this.tool, this.tw, this, bl));
        TaggedList taggedList2 = new TaggedList(10, false);
        taggedList2.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("Permission.List"));
        taggedList2.addActionListener(new EditPermButtonListener(this.tool, this.tw, this, bl));
        Point point = this.tw.getLocationOnScreen();
        this.setBounds(point.x + 75, point.y + 200, 650, 500);
        this.setLayout(new GridBagLayout());
        this.setResizable(true);
        if (bl) {
            PolicyParser.PrincipalEntry principalEntry;
            policyEntryArray = this.tool.getEntry();
            component = (List)this.tw.getComponent(3);
            n = ((List)component).getSelectedIndex();
            serializable2 = policyEntryArray[n].getGrantEntry().principals;
            for (int i = 0; i < ((LinkedList)serializable2).size(); ++i) {
                Object var10_11 = null;
                principalEntry = (PolicyParser.PrincipalEntry)((LinkedList)serializable2).get(i);
                taggedList.addTaggedItem(ToolDialog.PrincipalEntryToUserFriendlyString(principalEntry), principalEntry);
            }
            serializable = policyEntryArray[n].getGrantEntry().permissionEntries;
            for (int i = 0; i < ((Vector)serializable).size(); ++i) {
                principalEntry = null;
                PolicyParser.PermissionEntry permissionEntry = ((Vector)serializable).elementAt(i);
                taggedList2.addTaggedItem(ToolDialog.PermissionEntryToUserFriendlyString(permissionEntry), permissionEntry);
            }
        }
        component = new Label(PolicyTool.rb.getString("CodeBase."));
        this.tw.addNewComponent(this, component, 0, 0, 0, 1, 1, 0.0, 0.0, 1);
        serializable2 = bl ? new TextField(policyEntryArray[n].getGrantEntry().codeBase, 60) : new TextField(60);
        ((TextField)serializable2).getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("Code.Base"));
        this.tw.addNewComponent(this, (Component)serializable2, 1, 1, 0, 1, 1, 0.0, 0.0, 1);
        component = new Label(PolicyTool.rb.getString("SignedBy."));
        this.tw.addNewComponent(this, component, 2, 0, 1, 1, 1, 0.0, 0.0, 1);
        serializable2 = bl ? new TextField(policyEntryArray[n].getGrantEntry().signedBy, 60) : new TextField(60);
        ((TextField)serializable2).getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("Signed.By."));
        this.tw.addNewComponent(this, (Component)serializable2, 3, 1, 1, 1, 1, 0.0, 0.0, 1);
        serializable = new Panel();
        ((Container)serializable).setLayout(new GridBagLayout());
        Button button = new Button(PolicyTool.rb.getString("Add.Principal"));
        button.addActionListener(new AddPrinButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, button, 0, 0, 0, 1, 1, 100.0, 0.0, 2);
        button = new Button(PolicyTool.rb.getString("Edit.Principal"));
        button.addActionListener(new EditPrinButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, button, 1, 1, 0, 1, 1, 100.0, 0.0, 2);
        button = new Button(PolicyTool.rb.getString("Remove.Principal"));
        button.addActionListener(new RemovePrinButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, button, 2, 2, 0, 1, 1, 100.0, 0.0, 2);
        this.tw.addNewComponent(this, (Component)serializable, 4, 1, 2, 1, 1, 0.0, 0.0, 2);
        component = new Label(PolicyTool.rb.getString("Principals."));
        this.tw.addNewComponent(this, component, 5, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        this.tw.addNewComponent(this, taggedList, 6, 1, 3, 3, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        serializable = new Panel();
        ((Container)serializable).setLayout(new GridBagLayout());
        button = new Button(PolicyTool.rb.getString(".Add.Permission"));
        button.addActionListener(new AddPermButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, button, 0, 0, 0, 1, 1, 100.0, 0.0, 2);
        button = new Button(PolicyTool.rb.getString(".Edit.Permission"));
        button.addActionListener(new EditPermButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, button, 1, 1, 0, 1, 1, 100.0, 0.0, 2);
        button = new Button(PolicyTool.rb.getString("Remove.Permission"));
        button.addActionListener(new RemovePermButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, button, 2, 2, 0, 1, 1, 100.0, 0.0, 2);
        this.tw.addNewComponent(this, (Component)serializable, 7, 0, 4, 2, 1, 0.0, 0.0, 2, ToolWindow.LITE_BOTTOM_PADDING);
        this.tw.addNewComponent(this, taggedList2, 8, 0, 5, 3, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        serializable = new Panel();
        ((Container)serializable).setLayout(new GridBagLayout());
        button = new Button(PolicyTool.rb.getString("Done"));
        button.addActionListener(new AddEntryDoneButtonListener(this.tool, this.tw, this, bl));
        this.tw.addNewComponent((Container)serializable, button, 0, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        button = new Button(PolicyTool.rb.getString("Cancel"));
        button.addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent((Container)serializable, button, 1, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(this, (Component)serializable, 9, 0, 6, 2, 1, 0.0, 0.0, 3);
        this.setVisible(true);
    }

    PolicyEntry getPolicyEntryFromDialog() throws InvalidParameterException, MalformedURLException, NoSuchMethodException, ClassNotFoundException, InstantiationException, IllegalAccessException, InvocationTargetException, CertificateException, IOException, Exception {
        TextField textField = (TextField)this.getComponent(1);
        String string = null;
        if (!textField.getText().trim().equals("")) {
            string = new String(textField.getText().trim());
        }
        textField = (TextField)this.getComponent(3);
        String string2 = null;
        if (!textField.getText().trim().equals("")) {
            string2 = new String(textField.getText().trim());
        }
        PolicyParser.GrantEntry grantEntry = new PolicyParser.GrantEntry(string2, string);
        LinkedList<PolicyParser.PrincipalEntry> linkedList = new LinkedList<PolicyParser.PrincipalEntry>();
        TaggedList taggedList = (TaggedList)this.getComponent(6);
        for (int i = 0; i < taggedList.getItemCount(); ++i) {
            linkedList.add((PolicyParser.PrincipalEntry)taggedList.getObject(i));
        }
        grantEntry.principals = linkedList;
        Vector<PolicyParser.PermissionEntry> vector = new Vector<PolicyParser.PermissionEntry>();
        TaggedList taggedList2 = (TaggedList)this.getComponent(8);
        for (int i = 0; i < taggedList2.getItemCount(); ++i) {
            vector.addElement((PolicyParser.PermissionEntry)taggedList2.getObject(i));
        }
        grantEntry.permissionEntries = vector;
        PolicyEntry policyEntry = new PolicyEntry(this.tool, grantEntry);
        return policyEntry;
    }

    void keyStoreDialog(int n) {
        Point point = this.tw.getLocationOnScreen();
        this.setBounds(point.x + 25, point.y + 100, 500, 300);
        this.setLayout(new GridBagLayout());
        if (n == 0) {
            Label label = new Label(PolicyTool.rb.getString("KeyStore.URL."));
            this.tw.addNewComponent(this, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            TextField textField = new TextField(this.tool.getKeyStoreName(), 30);
            textField.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("KeyStore.U.R.L."));
            this.tw.addNewComponent(this, textField, 1, 1, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            label = new Label(PolicyTool.rb.getString("KeyStore.Type."));
            this.tw.addNewComponent(this, label, 2, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            textField = new TextField(this.tool.getKeyStoreType(), 30);
            textField.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("KeyStore.Type."));
            this.tw.addNewComponent(this, textField, 3, 1, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            label = new Label(PolicyTool.rb.getString("KeyStore.Provider."));
            this.tw.addNewComponent(this, label, 4, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            textField = new TextField(this.tool.getKeyStoreProvider(), 30);
            textField.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("KeyStore.Provider."));
            this.tw.addNewComponent(this, textField, 5, 1, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            label = new Label(PolicyTool.rb.getString("KeyStore.Password.URL."));
            this.tw.addNewComponent(this, label, 6, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            textField = new TextField(this.tool.getKeyStorePwdURL(), 30);
            textField.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("KeyStore.Password.U.R.L."));
            this.tw.addNewComponent(this, textField, 7, 1, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
            Button button = new Button(PolicyTool.rb.getString("OK"));
            button.addActionListener(new ChangeKeyStoreOKButtonListener(this.tool, this.tw, this));
            this.tw.addNewComponent(this, button, 8, 0, 4, 1, 1, 0.0, 0.0, 3);
            Button button2 = new Button(PolicyTool.rb.getString("Cancel"));
            button2.addActionListener(new CancelButtonListener(this));
            this.tw.addNewComponent(this, button2, 9, 1, 4, 1, 1, 0.0, 0.0, 3);
        }
        this.setVisible(true);
    }

    void displayPrincipalDialog(boolean bl, boolean bl2) {
        Object object;
        PolicyParser.PrincipalEntry principalEntry = null;
        TaggedList taggedList = (TaggedList)this.getComponent(6);
        int n = taggedList.getSelectedIndex();
        if (bl2) {
            principalEntry = (PolicyParser.PrincipalEntry)taggedList.getObject(n);
        }
        ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Principals"), this.tool, this.tw, true);
        toolDialog.addWindowListener(new ChildWindowListener(toolDialog));
        Point point = this.getLocationOnScreen();
        toolDialog.setBounds(point.x + 50, point.y + 100, 650, 190);
        toolDialog.setLayout(new GridBagLayout());
        toolDialog.setResizable(true);
        Label label = bl2 ? new Label(PolicyTool.rb.getString(".Edit.Principal.")) : new Label(PolicyTool.rb.getString(".Add.New.Principal."));
        this.tw.addNewComponent(toolDialog, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.TOP_BOTTOM_PADDING);
        Choice choice = new Choice();
        choice.add(PRIN_TYPE);
        choice.getAccessibleContext().setAccessibleName(PRIN_TYPE);
        for (int i = 0; i < PRIN_ARRAY.size(); ++i) {
            object = PRIN_ARRAY.get(i);
            choice.add(((Prin)object).CLASS);
        }
        choice.addItemListener(new PrincipalTypeMenuListener(toolDialog));
        if (bl2) {
            if ("WILDCARD_PRINCIPAL_CLASS".equals(principalEntry.getPrincipalClass())) {
                choice.select(PRIN_TYPE);
            } else {
                Prin prin = ToolDialog.getPrin(principalEntry.getPrincipalClass(), true);
                if (prin != null) {
                    choice.select(prin.CLASS);
                }
            }
        }
        this.tw.addNewComponent(toolDialog, choice, 1, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        TextField textField = bl2 ? new TextField(principalEntry.getDisplayClass(), 30) : new TextField(30);
        textField.getAccessibleContext().setAccessibleName(PRIN_TYPE);
        this.tw.addNewComponent(toolDialog, textField, 2, 1, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        label = new Label(PRIN_NAME);
        textField = bl2 ? new TextField(principalEntry.getDisplayName(), 40) : new TextField(40);
        textField.getAccessibleContext().setAccessibleName(PRIN_NAME);
        this.tw.addNewComponent(toolDialog, label, 3, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(toolDialog, textField, 4, 1, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        object = new Button(PolicyTool.rb.getString("OK"));
        ((Button)object).addActionListener(new NewPolicyPrinOKButtonListener(this.tool, this.tw, this, toolDialog, bl2));
        this.tw.addNewComponent(toolDialog, (Component)object, 5, 0, 3, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        Button button = new Button(PolicyTool.rb.getString("Cancel"));
        button.addActionListener(new CancelButtonListener(toolDialog));
        this.tw.addNewComponent(toolDialog, button, 6, 1, 3, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        toolDialog.setVisible(true);
    }

    void displayPermissionDialog(boolean bl, boolean bl2) {
        Object object;
        PolicyParser.PermissionEntry permissionEntry = null;
        TaggedList taggedList = (TaggedList)this.getComponent(8);
        int n = taggedList.getSelectedIndex();
        if (bl2) {
            permissionEntry = (PolicyParser.PermissionEntry)taggedList.getObject(n);
        }
        ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Permissions"), this.tool, this.tw, true);
        toolDialog.addWindowListener(new ChildWindowListener(toolDialog));
        Point point = this.getLocationOnScreen();
        toolDialog.setBounds(point.x + 50, point.y + 100, 700, 250);
        toolDialog.setLayout(new GridBagLayout());
        toolDialog.setResizable(true);
        Label label = bl2 ? new Label(PolicyTool.rb.getString(".Edit.Permission.")) : new Label(PolicyTool.rb.getString(".Add.New.Permission."));
        this.tw.addNewComponent(toolDialog, label, 0, 0, 0, 1, 1, 0.0, 0.0, 1, ToolWindow.TOP_BOTTOM_PADDING);
        Choice choice = new Choice();
        choice.add(PERM);
        choice.getAccessibleContext().setAccessibleName(PERM);
        for (int i = 0; i < PERM_ARRAY.size(); ++i) {
            object = PERM_ARRAY.get(i);
            choice.add(((Perm)object).CLASS);
        }
        choice.addItemListener(new PermissionMenuListener(toolDialog));
        this.tw.addNewComponent(toolDialog, choice, 1, 0, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        TextField textField = bl2 ? new TextField(permissionEntry.permission, 30) : new TextField(30);
        textField.getAccessibleContext().setAccessibleName(PERM);
        if (bl2 && (object = ToolDialog.getPerm(permissionEntry.permission, true)) != null) {
            choice.select(((Perm)object).CLASS);
        }
        this.tw.addNewComponent(toolDialog, textField, 2, 1, 1, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        choice = new Choice();
        choice.add(PERM_NAME);
        choice.getAccessibleContext().setAccessibleName(PERM_NAME);
        choice.addItemListener(new PermissionNameMenuListener(toolDialog));
        textField = bl2 ? new TextField(permissionEntry.name, 40) : new TextField(40);
        textField.getAccessibleContext().setAccessibleName(PERM_NAME);
        if (bl2) {
            this.setPermissionNames(ToolDialog.getPerm(permissionEntry.permission, true), choice, textField);
        }
        this.tw.addNewComponent(toolDialog, choice, 3, 0, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(toolDialog, textField, 4, 1, 2, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        choice = new Choice();
        choice.add(PERM_ACTIONS);
        choice.getAccessibleContext().setAccessibleName(PERM_ACTIONS);
        choice.addItemListener(new PermissionActionsMenuListener(toolDialog));
        textField = bl2 ? new TextField(permissionEntry.action, 40) : new TextField(40);
        textField.getAccessibleContext().setAccessibleName(PERM_ACTIONS);
        if (bl2) {
            this.setPermissionActions(ToolDialog.getPerm(permissionEntry.permission, true), choice, textField);
        }
        this.tw.addNewComponent(toolDialog, choice, 5, 0, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(toolDialog, textField, 6, 1, 3, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        label = new Label(PolicyTool.rb.getString("Signed.By."));
        this.tw.addNewComponent(toolDialog, label, 7, 0, 4, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        textField = bl2 ? new TextField(permissionEntry.signedBy, 40) : new TextField(40);
        textField.getAccessibleContext().setAccessibleName(PolicyTool.rb.getString("Signed.By."));
        this.tw.addNewComponent(toolDialog, textField, 8, 1, 4, 1, 1, 0.0, 0.0, 1, ToolWindow.LR_PADDING);
        object = new Button(PolicyTool.rb.getString("OK"));
        ((Button)object).addActionListener(new NewPolicyPermOKButtonListener(this.tool, this.tw, this, toolDialog, bl2));
        this.tw.addNewComponent(toolDialog, (Component)object, 9, 0, 5, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        Button button = new Button(PolicyTool.rb.getString("Cancel"));
        button.addActionListener(new CancelButtonListener(toolDialog));
        this.tw.addNewComponent(toolDialog, button, 10, 1, 5, 1, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        toolDialog.setVisible(true);
    }

    PolicyParser.PrincipalEntry getPrinFromDialog() throws Exception {
        TextField textField = (TextField)this.getComponent(2);
        String string = new String(textField.getText().trim());
        textField = (TextField)this.getComponent(4);
        String string2 = new String(textField.getText().trim());
        if (string.equals("*")) {
            string = "WILDCARD_PRINCIPAL_CLASS";
        }
        if (string2.equals("*")) {
            string2 = "WILDCARD_PRINCIPAL_NAME";
        }
        Object var4_4 = null;
        if (string.equals("WILDCARD_PRINCIPAL_CLASS") && !string2.equals("WILDCARD_PRINCIPAL_NAME")) {
            throw new Exception(PolicyTool.rb.getString("Cannot.Specify.Principal.with.a.Wildcard.Class.without.a.Wildcard.Name"));
        }
        if (string2.equals("")) {
            throw new Exception(PolicyTool.rb.getString("Cannot.Specify.Principal.without.a.Name"));
        }
        if (string.equals("")) {
            string = "PolicyParser.REPLACE_NAME";
            this.tool.warnings.addElement("Warning: Principal name '" + string2 + "' specified without a Principal class.\n" + "\t'" + string2 + "' will be interpreted " + "as a key store alias.\n" + "\tThe final principal class will be " + X500_PRIN_CLASS + ".\n" + "\tThe final principal name will be " + "determined by the following:\n" + "\n" + "\tIf the key store entry identified by '" + string2 + "'\n" + "\tis a key entry, then the principal name will be\n" + "\tthe subject distinguished name from the first\n" + "\tcertificate in the entry's certificate chain.\n" + "\n" + "\tIf the key store entry identified by '" + string2 + "'\n" + "\tis a trusted certificate entry, then the\n" + "\tprincipal name will be the subject distinguished\n" + "\tname from the trusted public key certificate.");
            this.tw.displayStatusDialog(this, "'" + string2 + "' will be interpreted as a key " + "store alias.  View Warning Log for details.");
        }
        return new PolicyParser.PrincipalEntry(string, string2);
    }

    PolicyParser.PermissionEntry getPermFromDialog() {
        char c;
        TextField textField = (TextField)this.getComponent(2);
        String string = new String(textField.getText().trim());
        textField = (TextField)this.getComponent(4);
        String string2 = null;
        if (!textField.getText().trim().equals("")) {
            string2 = new String(textField.getText().trim());
        }
        if (string.equals("") || !string.equals(ALL_PERM_CLASS) && string2 == null) {
            throw new InvalidParameterException(PolicyTool.rb.getString("Permission.and.Target.Name.must.have.a.value"));
        }
        if (string.equals(FILE_PERM_CLASS) && string2.lastIndexOf("\\\\") > 0 && (c = this.tw.displayYesNoDialog(this, PolicyTool.rb.getString("Warning"), PolicyTool.rb.getString("Warning.File.name.may.include.escaped.backslash.characters.It.is.not.necessary.to.escape.backslash.characters.the.tool.escapes"), PolicyTool.rb.getString("Retain"), PolicyTool.rb.getString("Edit"))) != 'Y') {
            throw new NoDisplayException();
        }
        textField = (TextField)this.getComponent(6);
        String string3 = null;
        if (!textField.getText().trim().equals("")) {
            string3 = new String(textField.getText().trim());
        }
        textField = (TextField)this.getComponent(8);
        String string4 = null;
        if (!textField.getText().trim().equals("")) {
            string4 = new String(textField.getText().trim());
        }
        PolicyParser.PermissionEntry permissionEntry = new PolicyParser.PermissionEntry(string, string2, string3);
        permissionEntry.signedBy = string4;
        if (string4 != null) {
            String[] stringArray = this.tool.parseSigners(permissionEntry.signedBy);
            for (int i = 0; i < stringArray.length; ++i) {
                try {
                    PublicKey publicKey = this.tool.getPublicKeyAlias(stringArray[i]);
                    if (publicKey != null) continue;
                    MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Warning.A.public.key.for.alias.signers.i.does.not.exist.Make.sure.a.KeyStore.is.properly.configured."));
                    Object[] objectArray = new Object[]{stringArray[i]};
                    this.tool.warnings.addElement(messageFormat.format(objectArray));
                    this.tw.displayStatusDialog(this, messageFormat.format(objectArray));
                    continue;
                }
                catch (Exception exception) {
                    this.tw.displayErrorDialog((Window)this, exception);
                }
            }
        }
        return permissionEntry;
    }

    void displayConfirmRemovePolicyEntry() {
        Object object;
        Object object2;
        List list = (List)this.tw.getComponent(3);
        int n = list.getSelectedIndex();
        PolicyEntry[] policyEntryArray = this.tool.getEntry();
        Point point = this.tw.getLocationOnScreen();
        this.setBounds(point.x + 25, point.y + 100, 600, 400);
        this.setLayout(new GridBagLayout());
        Label label = new Label(PolicyTool.rb.getString("Remove.this.Policy.Entry."));
        this.tw.addNewComponent(this, label, 0, 0, 0, 2, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
        label = new Label(policyEntryArray[n].codebaseToString());
        this.tw.addNewComponent(this, label, 1, 0, 1, 2, 1, 0.0, 0.0, 1);
        label = new Label(policyEntryArray[n].principalsToString().trim());
        this.tw.addNewComponent(this, label, 2, 0, 2, 2, 1, 0.0, 0.0, 1);
        Vector<PolicyParser.PermissionEntry> vector = policyEntryArray[n].getGrantEntry().permissionEntries;
        for (int i = 0; i < vector.size(); ++i) {
            object2 = vector.elementAt(i);
            object = ToolDialog.PermissionEntryToUserFriendlyString((PolicyParser.PermissionEntry)object2);
            label = new Label("    " + (String)object);
            if (i == vector.size() - 1) {
                this.tw.addNewComponent(this, label, 3 + i, 1, 3 + i, 1, 1, 0.0, 0.0, 1, ToolWindow.BOTTOM_PADDING);
                continue;
            }
            this.tw.addNewComponent(this, label, 3 + i, 1, 3 + i, 1, 1, 0.0, 0.0, 1);
        }
        Panel panel = new Panel();
        panel.setLayout(new GridBagLayout());
        object2 = new Button(PolicyTool.rb.getString("OK"));
        ((Button)object2).addActionListener(new ConfirmRemovePolicyEntryOKButtonListener(this.tool, this.tw, this));
        this.tw.addNewComponent(panel, (Component)object2, 0, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        object = new Button(PolicyTool.rb.getString("Cancel"));
        ((Button)object).addActionListener(new CancelButtonListener(this));
        this.tw.addNewComponent(panel, (Component)object, 1, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_PADDING);
        this.tw.addNewComponent(this, panel, 3 + vector.size(), 0, 3 + vector.size(), 2, 1, 0.0, 0.0, 3, ToolWindow.TOP_BOTTOM_PADDING);
        this.pack();
        this.setVisible(true);
    }

    void displaySaveAsDialog(int n) {
        FileDialog fileDialog = new FileDialog((Frame)this.tw, PolicyTool.rb.getString("Save.As"), 1);
        fileDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                windowEvent.getWindow().setVisible(false);
            }
        });
        fileDialog.setVisible(true);
        if (fileDialog.getFile() == null || fileDialog.getFile().equals("")) {
            return;
        }
        String string = new String(fileDialog.getDirectory() + fileDialog.getFile());
        fileDialog.dispose();
        File file = new File(string);
        if (file.exists()) {
            ToolDialog toolDialog = new ToolDialog(PolicyTool.rb.getString("Overwrite.File"), this.tool, this.tw, true);
            toolDialog.displayOverWriteFileDialog(string, n);
        } else {
            try {
                this.tool.savePolicy(string);
                MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Policy.successfully.written.to.filename"));
                Object[] objectArray = new Object[]{string};
                this.tw.displayStatusDialog(null, messageFormat.format(objectArray));
                TextField textField = (TextField)this.tw.getComponent(1);
                textField.setText(string);
                this.tw.setVisible(true);
                this.userSaveContinue(this.tool, this.tw, this, n);
            }
            catch (FileNotFoundException fileNotFoundException) {
                if (string == null || string.equals("")) {
                    this.tw.displayErrorDialog(null, new FileNotFoundException(PolicyTool.rb.getString("null.filename")));
                } else {
                    this.tw.displayErrorDialog(null, fileNotFoundException);
                }
            }
            catch (Exception exception) {
                this.tw.displayErrorDialog(null, exception);
            }
        }
    }

    void displayUserSave(int n) {
        if (this.tool.modified) {
            Point point = this.tw.getLocationOnScreen();
            this.setBounds(point.x + 75, point.y + 100, 400, 150);
            this.setLayout(new GridBagLayout());
            Label label = new Label(PolicyTool.rb.getString("Save.changes."));
            this.tw.addNewComponent(this, label, 0, 0, 0, 3, 1, 0.0, 0.0, 1, ToolWindow.L_TOP_BOTTOM_PADDING);
            Panel panel = new Panel();
            panel.setLayout(new GridBagLayout());
            Button button = new Button(PolicyTool.rb.getString("Yes"));
            button.addActionListener(new UserSaveYesButtonListener(this, this.tool, this.tw, n));
            this.tw.addNewComponent(panel, button, 0, 0, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_BOTTOM_PADDING);
            Button button2 = new Button(PolicyTool.rb.getString("No"));
            button2.addActionListener(new UserSaveNoButtonListener(this, this.tool, this.tw, n));
            this.tw.addNewComponent(panel, button2, 1, 1, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_BOTTOM_PADDING);
            Button button3 = new Button(PolicyTool.rb.getString("Cancel"));
            button3.addActionListener(new UserSaveCancelButtonListener(this));
            this.tw.addNewComponent(panel, button3, 2, 2, 0, 1, 1, 0.0, 0.0, 3, ToolWindow.LR_BOTTOM_PADDING);
            this.tw.addNewComponent(this, panel, 1, 0, 1, 1, 1, 0.0, 0.0, 1);
            this.pack();
            this.setVisible(true);
        } else {
            this.userSaveContinue(this.tool, this.tw, this, n);
        }
    }

    void userSaveContinue(PolicyTool policyTool, ToolWindow toolWindow, ToolDialog toolDialog, int n) {
        switch (n) {
            case 1: {
                toolWindow.setVisible(false);
                toolWindow.dispose();
                System.exit(0);
            }
            case 2: {
                try {
                    policyTool.openPolicy(null);
                }
                catch (Exception exception) {
                    policyTool.modified = false;
                    toolWindow.displayErrorDialog(null, exception);
                }
                List list = new List(40, false);
                list.addActionListener(new PolicyListListener(policyTool, toolWindow));
                toolWindow.replacePolicyList(list);
                TextField textField = (TextField)toolWindow.getComponent(1);
                textField.setText("");
                toolWindow.setVisible(true);
                break;
            }
            case 3: {
                FileDialog fileDialog = new FileDialog((Frame)toolWindow, PolicyTool.rb.getString("Open"), 0);
                fileDialog.addWindowListener(new WindowAdapter(){

                    public void windowClosing(WindowEvent windowEvent) {
                        windowEvent.getWindow().setVisible(false);
                    }
                });
                fileDialog.setVisible(true);
                if (fileDialog.getFile() == null || fileDialog.getFile().equals("")) {
                    return;
                }
                String string = new String(fileDialog.getDirectory() + fileDialog.getFile());
                try {
                    policyTool.openPolicy(string);
                    List list = new List(40, false);
                    list.addActionListener(new PolicyListListener(policyTool, toolWindow));
                    PolicyEntry[] policyEntryArray = policyTool.getEntry();
                    if (policyEntryArray != null) {
                        for (int i = 0; i < policyEntryArray.length; ++i) {
                            list.add(policyEntryArray[i].headerToString());
                        }
                    }
                    toolWindow.replacePolicyList(list);
                    policyTool.modified = false;
                    TextField textField = (TextField)toolWindow.getComponent(1);
                    textField.setText(string);
                    toolWindow.setVisible(true);
                    if (!policyTool.newWarning) break;
                    toolWindow.displayStatusDialog(null, PolicyTool.rb.getString("Errors.have.occurred.while.opening.the.policy.configuration.View.the.Warning.Log.for.more.information."));
                    break;
                }
                catch (Exception exception) {
                    List list = new List(40, false);
                    list.addActionListener(new PolicyListListener(policyTool, toolWindow));
                    toolWindow.replacePolicyList(list);
                    policyTool.setPolicyFileName(null);
                    policyTool.modified = false;
                    TextField textField = (TextField)toolWindow.getComponent(1);
                    textField.setText("");
                    toolWindow.setVisible(true);
                    MessageFormat messageFormat = new MessageFormat(PolicyTool.rb.getString("Could.not.open.policy.file.policyFile.e.toString."));
                    Object[] objectArray = new Object[]{string, exception.toString()};
                    toolWindow.displayErrorDialog(null, messageFormat.format(objectArray));
                }
            }
        }
    }

    void setPermissionNames(Perm perm, Choice choice, TextField textField) {
        choice.removeAll();
        choice.add(PERM_NAME);
        if (perm == null) {
            textField.setEditable(true);
        } else if (perm.TARGETS == null) {
            textField.setEditable(false);
        } else {
            textField.setEditable(true);
            for (int i = 0; i < perm.TARGETS.length; ++i) {
                choice.add(perm.TARGETS[i]);
            }
        }
    }

    void setPermissionActions(Perm perm, Choice choice, TextField textField) {
        choice.removeAll();
        choice.add(PERM_ACTIONS);
        if (perm == null) {
            textField.setEditable(true);
        } else if (perm.ACTIONS == null) {
            textField.setEditable(false);
        } else {
            textField.setEditable(true);
            for (int i = 0; i < perm.ACTIONS.length; ++i) {
                choice.add(perm.ACTIONS[i]);
            }
        }
    }

    static String PermissionEntryToUserFriendlyString(PolicyParser.PermissionEntry permissionEntry) {
        String string = permissionEntry.permission;
        if (permissionEntry.name != null) {
            string = string + " " + permissionEntry.name;
        }
        if (permissionEntry.action != null) {
            string = string + ", \"" + permissionEntry.action + "\"";
        }
        if (permissionEntry.signedBy != null) {
            string = string + ", signedBy " + permissionEntry.signedBy;
        }
        return string;
    }

    static String PrincipalEntryToUserFriendlyString(PolicyParser.PrincipalEntry principalEntry) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        principalEntry.write(printWriter);
        return stringWriter.toString();
    }

    static {
        PERM_ARRAY.add(new AllPerm());
        PERM_ARRAY.add(new AudioPerm());
        PERM_ARRAY.add(new AuthPerm());
        PERM_ARRAY.add(new AWTPerm());
        PERM_ARRAY.add(new DelegationPerm());
        PERM_ARRAY.add(new FilePerm());
        PERM_ARRAY.add(new InqSecContextPerm());
        PERM_ARRAY.add(new LogPerm());
        PERM_ARRAY.add(new MgmtPerm());
        PERM_ARRAY.add(new MBeanPerm());
        PERM_ARRAY.add(new MBeanSvrPerm());
        PERM_ARRAY.add(new MBeanTrustPerm());
        PERM_ARRAY.add(new NetPerm());
        PERM_ARRAY.add(new PrivCredPerm());
        PERM_ARRAY.add(new PropPerm());
        PERM_ARRAY.add(new ReflectPerm());
        PERM_ARRAY.add(new RuntimePerm());
        PERM_ARRAY.add(new SecurityPerm());
        PERM_ARRAY.add(new SerialPerm());
        PERM_ARRAY.add(new ServicePerm());
        PERM_ARRAY.add(new SocketPerm());
        PERM_ARRAY.add(new SQLPerm());
        PERM_ARRAY.add(new SSLPerm());
        PERM_ARRAY.add(new SubjDelegPerm());
        PRIN_ARRAY = new ArrayList();
        PRIN_ARRAY.add(new KrbPrin());
        PRIN_ARRAY.add(new X500Prin());
    }
}

