/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.Security;
import java.util.Set;
import sun.security.util.AlgorithmConstraints;
import sun.security.util.AlgorithmDecomposer;

public abstract class AbstractAlgorithmConstraints
implements AlgorithmConstraints {
    protected final AlgorithmDecomposer decomposer;

    protected AbstractAlgorithmConstraints(AlgorithmDecomposer algorithmDecomposer) {
        this.decomposer = algorithmDecomposer;
    }

    static String[] getAlgorithms(final String string) {
        String string2 = AccessController.doPrivileged(new PrivilegedAction<String>(){

            @Override
            public String run() {
                return Security.getProperty(string);
            }
        });
        String[] stringArray = null;
        if (string2 != null && !string2.isEmpty()) {
            if (string2.length() >= 2 && string2.charAt(0) == '\"' && string2.charAt(string2.length() - 1) == '\"') {
                string2 = string2.substring(1, string2.length() - 1);
            }
            stringArray = string2.split(",");
            for (int i = 0; i < stringArray.length; ++i) {
                stringArray[i] = stringArray[i].trim();
            }
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        return stringArray;
    }

    static boolean checkAlgorithm(String[] stringArray, String string, AlgorithmDecomposer algorithmDecomposer) {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("No algorithm name specified");
        }
        Set<String> set = null;
        for (String string2 : stringArray) {
            if (string2 == null || string2.isEmpty()) continue;
            if (string2.equalsIgnoreCase(string)) {
                return false;
            }
            if (set == null) {
                set = algorithmDecomposer.decompose(string);
            }
            for (String string3 : set) {
                if (!string2.equalsIgnoreCase(string3)) continue;
                return false;
            }
        }
        return true;
    }
}

