/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlgorithmDecomposer {
    private static final Pattern transPattern = Pattern.compile("/");
    private static final Pattern pattern = Pattern.compile("with|and", 2);

    private static Set<String> decomposeImpl(String string) {
        String[] stringArray = transPattern.split(string);
        HashSet<String> hashSet = new HashSet<String>();
        for (String string2 : stringArray) {
            String[] stringArray2;
            if (string2 == null || string2.length() == 0) continue;
            for (String string3 : stringArray2 = pattern.split(string2)) {
                if (string3 == null || string3.length() == 0) continue;
                hashSet.add(string3);
            }
        }
        return hashSet;
    }

    public Set<String> decompose(String string) {
        if (string == null || string.length() == 0) {
            return new HashSet<String>();
        }
        Set<String> set = AlgorithmDecomposer.decomposeImpl(string);
        if (set.contains("SHA1") && !set.contains("SHA-1")) {
            set.add("SHA-1");
        }
        if (set.contains("SHA-1") && !set.contains("SHA1")) {
            set.add("SHA1");
        }
        if (set.contains("SHA224") && !set.contains("SHA-224")) {
            set.add("SHA-224");
        }
        if (set.contains("SHA-224") && !set.contains("SHA224")) {
            set.add("SHA224");
        }
        if (set.contains("SHA256") && !set.contains("SHA-256")) {
            set.add("SHA-256");
        }
        if (set.contains("SHA-256") && !set.contains("SHA256")) {
            set.add("SHA256");
        }
        if (set.contains("SHA384") && !set.contains("SHA-384")) {
            set.add("SHA-384");
        }
        if (set.contains("SHA-384") && !set.contains("SHA384")) {
            set.add("SHA384");
        }
        if (set.contains("SHA512") && !set.contains("SHA-512")) {
            set.add("SHA-512");
        }
        if (set.contains("SHA-512") && !set.contains("SHA512")) {
            set.add("SHA512");
        }
        return set;
    }

    public static Collection<String> getAliases(String string) {
        String[] stringArray = string.equalsIgnoreCase("DH") || string.equalsIgnoreCase("DiffieHellman") ? new String[]{"DH", "DiffieHellman"} : new String[]{string};
        return Arrays.asList(stringArray);
    }

    private static void hasLoop(Set<String> set, String string, String string2) {
        if (set.contains(string)) {
            if (!set.contains(string2)) {
                set.add(string2);
            }
            set.remove(string);
        }
    }

    public static Set<String> decomposeOneHash(String string) {
        if (string == null || string.length() == 0) {
            return new HashSet<String>();
        }
        Set<String> set = AlgorithmDecomposer.decomposeImpl(string);
        AlgorithmDecomposer.hasLoop(set, "SHA-1", "SHA1");
        AlgorithmDecomposer.hasLoop(set, "SHA-224", "SHA224");
        AlgorithmDecomposer.hasLoop(set, "SHA-256", "SHA256");
        AlgorithmDecomposer.hasLoop(set, "SHA-384", "SHA384");
        AlgorithmDecomposer.hasLoop(set, "SHA-512", "SHA512");
        return set;
    }

    public static String hashName(String string) {
        return string.replace("-", "");
    }
}

