/*
 * Decompiled with CFR 0.152.
 */
package sun.security.util;

import java.io.File;
import java.io.FileInputStream;
import java.security.AccessController;
import java.security.KeyStore;
import java.security.PrivilegedAction;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import sun.security.util.Debug;
import sun.security.x509.X509CertImpl;

public class AnchorCertificates {
    private static final Debug debug = Debug.getInstance("certpath");
    private static final String HASH = "SHA-256";
    private static Set<String> certs = Collections.emptySet();

    public static boolean contains(X509Certificate x509Certificate) {
        String string = X509CertImpl.getFingerprint(HASH, x509Certificate);
        boolean bl = certs.contains(string);
        if (bl && debug != null) {
            debug.println("AnchorCertificate.contains: matched " + x509Certificate.getSubjectDN());
        }
        return bl;
    }

    private AnchorCertificates() {
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public Void run() {
                File file = new File(System.getProperty("java.home"), "lib/security/cacerts");
                try {
                    KeyStore keyStore = KeyStore.getInstance("JKS");
                    FileInputStream fileInputStream = new FileInputStream(file);
                    try {
                        keyStore.load(fileInputStream, null);
                        certs = new HashSet();
                        Enumeration<String> enumeration = keyStore.aliases();
                        while (enumeration.hasMoreElements()) {
                            String string = enumeration.nextElement();
                            if (!string.contains(" [jdk")) continue;
                            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
                            certs.add(X509CertImpl.getFingerprint(AnchorCertificates.HASH, x509Certificate));
                        }
                        Object var8_8 = null;
                        if (fileInputStream == null) return null;
                    }
                    catch (Throwable throwable) {
                        Object var8_9 = null;
                        if (fileInputStream == null) throw throwable;
                        fileInputStream.close();
                        throw throwable;
                    }
                    fileInputStream.close();
                    return null;
                }
                catch (Exception exception) {
                    if (debug != null) {
                        debug.println("Error parsing cacerts");
                    }
                    exception.printStackTrace();
                }
                return null;
            }
        });
    }
}

